/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.TitledBorder;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.functions.Logistic;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.gui.visualize.Messages;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ThresholdVisualizePanel
extends VisualizePanel {
    private static final long serialVersionUID = 3070002211779443890L;
    private String m_ROCString = "";
    private String m_savePanelBorderText;

    public ThresholdVisualizePanel() {
        TitledBorder tb = (TitledBorder)this.m_plotSurround.getBorder();
        this.m_savePanelBorderText = tb.getTitle();
    }

    public void setROCString(String str) {
        this.m_ROCString = str;
    }

    public String getROCString() {
        return this.m_ROCString;
    }

    @Override
    public void setUpComboBoxes(Instances inst) {
        super.setUpComboBoxes(inst);
        this.m_XCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.m_YCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.setBorderText();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBorderText() {
        String xs = this.m_XCombo.getSelectedItem().toString();
        String ys = this.m_YCombo.getSelectedItem().toString();
        Messages.getInstance();
        if (xs.equals(Messages.getString("ThresholdVisualizePanel_SetBorderText_Text_First"))) {
            Messages.getInstance();
            if (ys.equals(Messages.getString("ThresholdVisualizePanel_SetBorderText_Text_Second"))) {
                this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(String.valueOf(this.m_savePanelBorderText) + " " + this.m_ROCString));
                return;
            }
        }
        this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(this.m_savePanelBorderText));
    }

    @Override
    protected void openVisibleInstances(Instances insts) throws Exception {
        super.openVisibleInstances(insts);
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ThresholdVisualizePanel_OpenVisibleInstances_Text_First"))).append(Utils.doubleToString(ThresholdCurve.getROCArea(insts), 4));
        Messages.getInstance();
        this.setROCString(stringBuilder.append(Messages.getString("ThresholdVisualizePanel_OpenVisibleInstances_Text_Second")).toString());
        this.setBorderText();
    }

    public static void main(String[] args) {
        Instances inst = null;
        Classifier classifier = null;
        int runs = 2;
        int folds = 10;
        boolean compute = true;
        Instances result = null;
        SingleIndex classIndex = null;
        SingleIndex valueIndex = null;
        int seed = 1;
        try {
            if (Utils.getFlag('h', args)) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ThresholdVisualizePanel_Main_Text_First"))).append(ThresholdVisualizePanel.class.getName());
                Messages.getInstance();
                System.out.println(stringBuilder.append(Messages.getString("ThresholdVisualizePanel_Main_Text_Second")).toString());
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Third"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Fourth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Fifth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Sixth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Seventh"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Eighth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Nineth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Tenth"));
                Messages.getInstance();
                System.out.println(Messages.getString("ThresholdVisualizePanel_Main_Text_Eleventh"));
                return;
            }
            String tmpStr = Utils.getOption('l', args);
            if (tmpStr.length() != 0) {
                result = new Instances(new BufferedReader(new FileReader(tmpStr)));
                compute = false;
            }
            if (compute) {
                String[] options;
                tmpStr = Utils.getOption('r', args);
                runs = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
                tmpStr = Utils.getOption('x', args);
                folds = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
                tmpStr = Utils.getOption('S', args);
                seed = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
                tmpStr = Utils.getOption('t', args);
                if (tmpStr.length() != 0) {
                    inst = new Instances(new BufferedReader(new FileReader(tmpStr)));
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                if ((tmpStr = Utils.getOption('W', args)).length() != 0) {
                    options = Utils.partitionOptions(args);
                } else {
                    tmpStr = Logistic.class.getName();
                    options = new String[]{};
                }
                classifier = Classifier.forName(tmpStr, options);
                tmpStr = Utils.getOption('c', args);
                classIndex = tmpStr.length() != 0 ? new SingleIndex(tmpStr) : new SingleIndex("last");
                tmpStr = Utils.getOption('C', args);
                valueIndex = tmpStr.length() != 0 ? new SingleIndex(tmpStr) : new SingleIndex("first");
            }
            if (compute) {
                if (classIndex != null) {
                    classIndex.setUpper(inst.numAttributes() - 1);
                    inst.setClassIndex(classIndex.getIndex());
                } else {
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                if (valueIndex != null) {
                    valueIndex.setUpper(inst.classAttribute().numValues() - 1);
                }
                ThresholdCurve tc = new ThresholdCurve();
                EvaluationUtils eu = new EvaluationUtils();
                FastVector predictions = new FastVector();
                int i = 0;
                while (i < runs) {
                    eu.setSeed(seed + i);
                    predictions.appendElements(eu.getCVPredictions(classifier, inst, folds));
                    ++i;
                }
                result = valueIndex != null ? tc.getCurve(predictions, valueIndex.getIndex()) : tc.getCurve(predictions);
            }
            ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ThresholdVisualizePanel_OpenVisibleInstances_Text_Third"))).append(Utils.doubleToString(ThresholdCurve.getROCArea(result), 4));
            Messages.getInstance();
            vmc.setROCString(stringBuilder.append(Messages.getString("ThresholdVisualizePanel_OpenVisibleInstances_Text_Fourth")).toString());
            if (compute) {
                StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(result.relationName()));
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("ThresholdVisualizePanel_Main_Text_Twelveth")).append(inst.classAttribute().value(valueIndex.getIndex()));
                Messages.getInstance();
                vmc.setName(stringBuilder3.append(Messages.getString("ThresholdVisualizePanel_Main_Text_Thirteenth")).toString());
            } else {
                StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(result.relationName()));
                Messages.getInstance();
                vmc.setName(stringBuilder4.append(Messages.getString("ThresholdVisualizePanel_Main_Text_Fourteenth")).toString());
            }
            PlotData2D tempd = new PlotData2D(result);
            tempd.setPlotName(result.relationName());
            tempd.addInstanceNumberAttribute();
            vmc.addPlot(tempd);
            String plotName = vmc.getName();
            Messages.getInstance();
            final JFrame jf = new JFrame(String.valueOf(Messages.getString("ThresholdVisualizePanel_Main_JFrame_Text")) + plotName);
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)vmc, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

