/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.Messages;
import weka.gui.visualize.Plot2DCompanion;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizeUtils;

public class Plot2D
extends JPanel {
    private static final long serialVersionUID = -1673162410856660442L;
    public static final int MAX_SHAPES = 5;
    public static final int ERROR_SHAPE = 1000;
    public static final int MISSING_SHAPE = 2000;
    public static final int CONST_AUTOMATIC_SHAPE = -1;
    public static final int X_SHAPE = 0;
    public static final int PLUS_SHAPE = 1;
    public static final int DIAMOND_SHAPE = 2;
    public static final int TRIANGLEUP_SHAPE = 3;
    public static final int TRIANGLEDOWN_SHAPE = 4;
    public static final int DEFAULT_SHAPE_SIZE = 2;
    protected Color m_axisColour = Color.green;
    protected Color m_backgroundColour = Color.black;
    protected FastVector m_plots = new FastVector();
    protected PlotData2D m_masterPlot = null;
    protected String m_masterName;
    protected Instances m_plotInstances;
    protected Plot2DCompanion m_plotCompanion;
    protected JFrame m_InstanceInfo;
    protected JTextArea m_InstanceInfoText;
    protected FastVector m_colorList;
    protected Color[] m_DefaultColors;
    protected int m_xIndex;
    protected int m_yIndex;
    protected int m_cIndex;
    protected int m_sIndex;
    protected double m_maxX;
    protected double m_minX;
    protected double m_maxY;
    protected double m_minY;
    protected double m_maxC;
    protected double m_minC;
    protected final int m_axisPad = 5;
    protected final int m_tickSize = 5;
    protected int m_XaxisStart;
    protected int m_YaxisStart;
    protected int m_XaxisEnd;
    protected int m_YaxisEnd;
    protected boolean m_plotResize;
    protected boolean m_axisChanged;
    protected int[][] m_drawnPoints;
    protected Font m_labelFont;
    protected FontMetrics m_labelMetrics;
    protected int m_JitterVal;
    protected Random m_JRand;
    protected double[][] m_pointLookup;

    public Plot2D() {
        Messages.getInstance();
        this.m_masterName = Messages.getString("Plot2D_MasterName_Text");
        this.m_plotInstances = null;
        this.m_plotCompanion = null;
        this.m_InstanceInfo = null;
        this.m_InstanceInfoText = new JTextArea();
        this.m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
        this.m_sIndex = 0;
        this.m_axisPad = 5;
        this.m_tickSize = 5;
        this.m_XaxisStart = 0;
        this.m_YaxisStart = 0;
        this.m_XaxisEnd = 0;
        this.m_YaxisEnd = 0;
        this.m_plotResize = true;
        this.m_axisChanged = false;
        this.m_labelMetrics = null;
        this.m_JitterVal = 0;
        this.m_JRand = new Random(0L);
        this.m_pointLookup = null;
        this.setProperties();
        this.setBackground(this.m_backgroundColour);
        this.m_InstanceInfoText.setFont(new Font("Monospaced", 0, 12));
        this.m_InstanceInfoText.setEditable(false);
        this.m_drawnPoints = new int[this.getWidth()][this.getHeight()];
        this.m_colorList = new FastVector(10);
        int noa = this.m_colorList.size();
        while (noa < 10) {
            Color pc = this.m_DefaultColors[noa % 10];
            int ija = noa / 10;
            ija *= 2;
            int j = 0;
            while (j < ija) {
                pc = pc.darker();
                ++j;
            }
            this.m_colorList.addElement(pc);
            ++noa;
        }
    }

    private void setProperties() {
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null) {
            String backgroundColour;
            String thisClass = this.getClass().getName();
            String axisKey = String.valueOf(thisClass) + ".axisColour";
            String backgroundKey = String.valueOf(thisClass) + ".backgroundColour";
            String axisColour = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(axisKey);
            if (axisColour != null) {
                this.m_axisColour = VisualizeUtils.processColour(axisColour, this.m_axisColour);
            }
            if ((backgroundColour = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(backgroundKey)) != null) {
                this.m_backgroundColour = VisualizeUtils.processColour(backgroundColour, this.m_backgroundColour);
            }
        }
    }

    private boolean checkPoints(double x1, double y1) {
        return !(x1 < 0.0 || x1 > (double)this.getSize().width || y1 < 0.0) && !(y1 > (double)this.getSize().height);
    }

    public void setPlotCompanion(Plot2DCompanion p) {
        this.m_plotCompanion = p;
    }

    public void setJitter(int j) {
        if (this.m_plotInstances.numAttributes() > 0 && this.m_plotInstances.numInstances() > 0 && j >= 0) {
            this.m_JitterVal = j;
            this.m_JRand = new Random(this.m_JitterVal);
            this.m_drawnPoints = new int[this.m_XaxisEnd - this.m_XaxisStart + 1][this.m_YaxisEnd - this.m_YaxisStart + 1];
            this.updatePturb();
            this.repaint();
        }
    }

    public void setColours(FastVector cols) {
        this.m_colorList = cols;
    }

    public void setXindex(int x) {
        this.m_xIndex = x;
        int i = 0;
        while (i < this.m_plots.size()) {
            ((PlotData2D)this.m_plots.elementAt(i)).setXindex(this.m_xIndex);
            ++i;
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setYindex(int y) {
        this.m_yIndex = y;
        int i = 0;
        while (i < this.m_plots.size()) {
            ((PlotData2D)this.m_plots.elementAt(i)).setYindex(this.m_yIndex);
            ++i;
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setCindex(int c) {
        this.m_cIndex = c;
        int i = 0;
        while (i < this.m_plots.size()) {
            ((PlotData2D)this.m_plots.elementAt(i)).setCindex(this.m_cIndex);
            ++i;
        }
        this.determineBounds();
        this.m_axisChanged = true;
        this.repaint();
    }

    public FastVector getPlots() {
        return this.m_plots;
    }

    public PlotData2D getMasterPlot() {
        return this.m_masterPlot;
    }

    public double getMaxX() {
        return this.m_maxX;
    }

    public double getMaxY() {
        return this.m_maxY;
    }

    public double getMinX() {
        return this.m_minX;
    }

    public double getMinY() {
        return this.m_minY;
    }

    public double getMaxC() {
        return this.m_maxC;
    }

    public double getMinC() {
        return this.m_minC;
    }

    public void setInstances(Instances inst) throws Exception {
        PlotData2D tempPlot = new PlotData2D(inst);
        Messages.getInstance();
        tempPlot.setPlotName(Messages.getString("Plot2D_SetInstances_TempPlot_SetPlotName_Text"));
        this.setMasterPlot(tempPlot);
    }

    public void setMasterPlot(PlotData2D master) throws Exception {
        if (master.m_plotInstances == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("Plot2D_SetMasterPlot_Exception_Text"));
        }
        this.removeAllPlots();
        this.m_masterPlot = master;
        this.m_plots.addElement(this.m_masterPlot);
        this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
        this.determineBounds();
    }

    public void removeAllPlots() {
        this.m_masterPlot = null;
        this.m_plotInstances = null;
        this.m_plots = new FastVector();
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
    }

    public void addPlot(PlotData2D newPlot) throws Exception {
        if (newPlot.m_plotInstances == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("Plot2D_AddPlot_Exception_Text_First"));
        }
        if (this.m_masterPlot != null) {
            if (!this.m_masterPlot.m_plotInstances.equalHeaders(newPlot.m_plotInstances)) {
                Messages.getInstance();
                throw new Exception(Messages.getString("Plot2D_AddPlot_Exception_Text_Second"));
            }
        } else {
            this.m_masterPlot = newPlot;
            this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        }
        this.m_plots.addElement(newPlot);
        this.setXindex(this.m_xIndex);
        this.setYindex(this.m_yIndex);
        this.setCindex(this.m_cIndex);
    }

    private void setFonts(Graphics gx) {
        if (this.m_labelMetrics == null) {
            this.m_labelFont = new Font("Monospaced", 0, 12);
            this.m_labelMetrics = gx.getFontMetrics(this.m_labelFont);
        }
        gx.setFont(this.m_labelFont);
    }

    public void searchPoints(int x, int y, final boolean newFrame) {
        if (this.m_masterPlot.m_plotInstances != null) {
            int longest = 0;
            int j = 0;
            while (j < this.m_masterPlot.m_plotInstances.numAttributes()) {
                if (this.m_masterPlot.m_plotInstances.attribute(j).name().length() > longest) {
                    longest = this.m_masterPlot.m_plotInstances.attribute(j).name().length();
                }
                ++j;
            }
            StringBuffer insts = new StringBuffer();
            int jj = 0;
            while (jj < this.m_plots.size()) {
                PlotData2D temp_plot = (PlotData2D)this.m_plots.elementAt(jj);
                int i = 0;
                while (i < temp_plot.m_plotInstances.numInstances()) {
                    if (temp_plot.m_pointLookup[i][0] != Double.NEGATIVE_INFINITY) {
                        double px = temp_plot.m_pointLookup[i][0] + temp_plot.m_pointLookup[i][2];
                        double py = temp_plot.m_pointLookup[i][1] + temp_plot.m_pointLookup[i][3];
                        double size = temp_plot.m_shapeSize[i];
                        if ((double)x >= px - size && (double)x <= px + size && (double)y >= py - size && (double)y <= py + size) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Plot2D_SearchPoints_Text_First"))).append(temp_plot.m_plotName);
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Plot2D_SearchPoints_Text_Second")).append(i + 1);
                            Messages.getInstance();
                            insts.append(stringBuilder2.append(Messages.getString("Plot2D_SearchPoints_Text_Third")).toString());
                            int j2 = 0;
                            while (j2 < temp_plot.m_plotInstances.numAttributes()) {
                                int k = 0;
                                while (k < longest - temp_plot.m_plotInstances.attribute(j2).name().length()) {
                                    insts.append(" ");
                                    ++k;
                                }
                                insts.append(temp_plot.m_plotInstances.attribute(j2).name());
                                Messages.getInstance();
                                insts.append(Messages.getString("Plot2D_SearchPoints_Text_Fourth"));
                                if (temp_plot.m_plotInstances.instance(i).isMissing(j2)) {
                                    Messages.getInstance();
                                    insts.append(Messages.getString("Plot2D_SearchPoints_Text_Fifth"));
                                } else if (temp_plot.m_plotInstances.attribute(j2).isNominal()) {
                                    insts.append(temp_plot.m_plotInstances.attribute(j2).value((int)temp_plot.m_plotInstances.instance(i).value(j2)));
                                } else {
                                    insts.append(temp_plot.m_plotInstances.instance(i).value(j2));
                                }
                                Messages.getInstance();
                                insts.append(Messages.getString("Plot2D_SearchPoints_Text_Sixth"));
                                ++j2;
                            }
                        }
                    }
                    ++i;
                }
                ++jj;
            }
            if (insts.length() > 0) {
                if (newFrame || this.m_InstanceInfo == null) {
                    JTextArea jt = new JTextArea();
                    jt.setFont(new Font("Monospaced", 0, 12));
                    jt.setEditable(false);
                    jt.setText(insts.toString());
                    Messages.getInstance();
                    final JFrame jf = new JFrame(Messages.getString("Plot2D_SearchPoints_JFrame_Text"));
                    final JFrame testf = this.m_InstanceInfo;
                    jf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            if (!newFrame || testf == null) {
                                Plot2D.this.m_InstanceInfo = null;
                            }
                            jf.dispose();
                        }
                    });
                    jf.getContentPane().setLayout(new BorderLayout());
                    jf.getContentPane().add((Component)new JScrollPane(jt), "Center");
                    jf.pack();
                    jf.setSize(320, 400);
                    jf.setVisible(true);
                    if (this.m_InstanceInfo == null) {
                        this.m_InstanceInfo = jf;
                        this.m_InstanceInfoText = jt;
                    }
                } else {
                    this.m_InstanceInfoText.setText(insts.toString());
                }
            }
        }
    }

    public void determineBounds() {
        this.m_minX = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minX;
        this.m_maxX = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxX;
        this.m_minY = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minY;
        this.m_maxY = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxY;
        this.m_minC = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minC;
        this.m_maxC = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxC;
        int i = 1;
        while (i < this.m_plots.size()) {
            double value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minX;
            if (value < this.m_minX) {
                this.m_minX = value;
            }
            if ((value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxX) > this.m_maxX) {
                this.m_maxX = value;
            }
            if ((value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minY) < this.m_minY) {
                this.m_minY = value;
            }
            if ((value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxY) > this.m_maxY) {
                this.m_maxY = value;
            }
            if ((value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minC) < this.m_minC) {
                this.m_minC = value;
            }
            if ((value = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxC) > this.m_maxC) {
                this.m_maxC = value;
            }
            ++i;
        }
        this.fillLookup();
        this.repaint();
    }

    public double convertToAttribX(double scx) {
        double temp = this.m_XaxisEnd - this.m_XaxisStart;
        double temp2 = (scx - (double)this.m_XaxisStart) * (this.m_maxX - this.m_minX) / temp;
        return temp2 += this.m_minX;
    }

    public double convertToAttribY(double scy) {
        double temp = this.m_YaxisEnd - this.m_YaxisStart;
        double temp2 = (scy - (double)this.m_YaxisEnd) * (this.m_maxY - this.m_minY) / temp;
        temp2 = -(temp2 - this.m_minY);
        return temp2;
    }

    int pturbX(double xvalP, double xj) {
        int xpturb = 0;
        if (this.m_JitterVal > 0 && (xvalP + (double)(xpturb = (int)((double)this.m_JitterVal * (xj / 2.0))) < (double)this.m_XaxisStart || xvalP + (double)xpturb > (double)this.m_XaxisEnd)) {
            xpturb *= -1;
        }
        return xpturb;
    }

    public double convertToPanelX(double xval) {
        double temp = (xval - this.m_minX) / (this.m_maxX - this.m_minX);
        double temp2 = temp * (double)(this.m_XaxisEnd - this.m_XaxisStart);
        return temp2 += (double)this.m_XaxisStart;
    }

    int pturbY(double yvalP, double yj) {
        int ypturb = 0;
        if (this.m_JitterVal > 0 && (yvalP + (double)(ypturb = (int)((double)this.m_JitterVal * (yj / 2.0))) < (double)this.m_YaxisStart || yvalP + (double)ypturb > (double)this.m_YaxisEnd)) {
            ypturb *= -1;
        }
        return ypturb;
    }

    public double convertToPanelY(double yval) {
        double temp = (yval - this.m_minY) / (this.m_maxY - this.m_minY);
        double temp2 = temp * (double)(this.m_YaxisEnd - this.m_YaxisStart);
        temp2 = (double)this.m_YaxisEnd - temp2;
        return temp2;
    }

    private static void drawX(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)(y - (double)size), (int)(x + (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y - (double)size), (int)(x - (double)size), (int)(y + (double)size));
    }

    private static void drawPlus(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)y, (int)(x + (double)size), (int)y);
        gx.drawLine((int)x, (int)(y - (double)size), (int)x, (int)(y + (double)size));
    }

    private static void drawDiamond(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)y, (int)x, (int)(y - (double)size));
        gx.drawLine((int)x, (int)(y - (double)size), (int)(x + (double)size), (int)y);
        gx.drawLine((int)(x + (double)size), (int)y, (int)x, (int)(y + (double)size));
        gx.drawLine((int)x, (int)(y + (double)size), (int)(x - (double)size), (int)y);
    }

    private static void drawTriangleUp(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)x, (int)(y - (double)size), (int)(x - (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x - (double)size), (int)(y + (double)size), (int)(x + (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y + (double)size), (int)x, (int)(y - (double)size));
    }

    private static void drawTriangleDown(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)x, (int)(y + (double)size), (int)(x - (double)size), (int)(y - (double)size));
        gx.drawLine((int)(x - (double)size), (int)(y - (double)size), (int)(x + (double)size), (int)(y - (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y - (double)size), (int)x, (int)(y + (double)size));
    }

    protected static void drawDataPoint(double x, double y, double xprev, double yprev, int size, int shape, Graphics gx) {
        Plot2D.drawDataPoint(x, y, size, shape, gx);
        gx.drawLine((int)x, (int)y, (int)xprev, (int)yprev);
    }

    protected static void drawDataPoint(double x, double y, int size, int shape, Graphics gx) {
        Font lf = new Font("Monospaced", 0, 12);
        FontMetrics fm = gx.getFontMetrics(lf);
        if (size == 0) {
            size = 1;
        }
        if (shape != 1000 && shape != 2000) {
            shape %= 5;
        }
        switch (shape) {
            case 0: {
                Plot2D.drawX(gx, x, y, size);
                break;
            }
            case 1: {
                Plot2D.drawPlus(gx, x, y, size);
                break;
            }
            case 2: {
                Plot2D.drawDiamond(gx, x, y, size);
                break;
            }
            case 3: {
                Plot2D.drawTriangleUp(gx, x, y, size);
                break;
            }
            case 4: {
                Plot2D.drawTriangleDown(gx, x, y, size);
                break;
            }
            case 1000: {
                gx.drawRect((int)(x - (double)size), (int)(y - (double)size), size * 2, size * 2);
                break;
            }
            case 2000: {
                int hf = fm.getAscent();
                int width = fm.stringWidth("M");
                gx.drawString("M", (int)(x - (double)(width / 2)), (int)(y + (double)(hf / 2)));
            }
        }
    }

    private void updatePturb() {
        double xj = 0.0;
        double yj = 0.0;
        int j = 0;
        while (j < this.m_plots.size()) {
            PlotData2D temp_plot = (PlotData2D)this.m_plots.elementAt(j);
            int i = 0;
            while (i < temp_plot.m_plotInstances.numInstances()) {
                if (!temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) && !temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) {
                    if (this.m_JitterVal > 0) {
                        xj = this.m_JRand.nextGaussian();
                        yj = this.m_JRand.nextGaussian();
                    }
                    temp_plot.m_pointLookup[i][2] = this.pturbX(temp_plot.m_pointLookup[i][0], xj);
                    temp_plot.m_pointLookup[i][3] = this.pturbY(temp_plot.m_pointLookup[i][1], yj);
                }
                ++i;
            }
            ++j;
        }
    }

    private void fillLookup() {
        int j = 0;
        while (j < this.m_plots.size()) {
            PlotData2D temp_plot = (PlotData2D)this.m_plots.elementAt(j);
            if (temp_plot.m_plotInstances.numInstances() > 0 && temp_plot.m_plotInstances.numAttributes() > 0) {
                int i = 0;
                while (i < temp_plot.m_plotInstances.numInstances()) {
                    if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) || temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) {
                        temp_plot.m_pointLookup[i][0] = Double.NEGATIVE_INFINITY;
                        temp_plot.m_pointLookup[i][1] = Double.NEGATIVE_INFINITY;
                    } else {
                        double x = this.convertToPanelX(temp_plot.m_plotInstances.instance(i).value(this.m_xIndex));
                        double y = this.convertToPanelY(temp_plot.m_plotInstances.instance(i).value(this.m_yIndex));
                        temp_plot.m_pointLookup[i][0] = x;
                        temp_plot.m_pointLookup[i][1] = y;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private void paintData(Graphics gx) {
        int j = 0;
        while (j < this.m_plots.size()) {
            PlotData2D temp_plot = (PlotData2D)this.m_plots.elementAt(j);
            int i = 0;
            while (i < temp_plot.m_plotInstances.numInstances()) {
                if (!temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) && !temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) {
                    double x = temp_plot.m_pointLookup[i][0] + temp_plot.m_pointLookup[i][2];
                    double y = temp_plot.m_pointLookup[i][1] + temp_plot.m_pointLookup[i][3];
                    double prevx = 0.0;
                    double prevy = 0.0;
                    if (i > 0) {
                        prevx = temp_plot.m_pointLookup[i - 1][0] + temp_plot.m_pointLookup[i - 1][2];
                        prevy = temp_plot.m_pointLookup[i - 1][1] + temp_plot.m_pointLookup[i - 1][3];
                    }
                    int x_range = (int)x - this.m_XaxisStart;
                    int y_range = (int)y - this.m_YaxisStart;
                    if (x_range >= 0 && y_range >= 0 && (this.m_drawnPoints[x_range][y_range] == i || this.m_drawnPoints[x_range][y_range] == 0 || temp_plot.m_shapeSize[i] == temp_plot.m_alwaysDisplayPointsOfThisSize || temp_plot.m_displayAllPoints)) {
                        this.m_drawnPoints[x_range][y_range] = i;
                        if (temp_plot.m_plotInstances.attribute(this.m_cIndex).isNominal()) {
                            Color ci;
                            if (temp_plot.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size() && !temp_plot.m_useCustomColour) {
                                this.extendColourMap(temp_plot.m_plotInstances.attribute(this.m_cIndex).numValues());
                            }
                            if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                                ci = Color.gray;
                            } else {
                                int ind = (int)temp_plot.m_plotInstances.instance(i).value(this.m_cIndex);
                                ci = (Color)this.m_colorList.elementAt(ind);
                            }
                            if (!temp_plot.m_useCustomColour) {
                                gx.setColor(ci);
                            } else {
                                gx.setColor(temp_plot.m_customColour);
                            }
                            if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                                if (temp_plot.m_connectPoints[i]) {
                                    Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], 2000, gx);
                                } else {
                                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], 2000, gx);
                                }
                            } else if (temp_plot.m_shapeType[i] == -1) {
                                if (temp_plot.m_connectPoints[i]) {
                                    Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], j, gx);
                                } else {
                                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], j, gx);
                                }
                            } else if (temp_plot.m_connectPoints[i]) {
                                Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                            } else {
                                Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                            }
                        } else {
                            Color ci = null;
                            if (!temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                                double r = (temp_plot.m_plotInstances.instance(i).value(this.m_cIndex) - this.m_minC) / (this.m_maxC - this.m_minC);
                                r = r * 240.0 + 15.0;
                                ci = new Color((int)r, 150, (int)(255.0 - r));
                            } else {
                                ci = Color.gray;
                            }
                            if (!temp_plot.m_useCustomColour) {
                                gx.setColor(ci);
                            } else {
                                gx.setColor(temp_plot.m_customColour);
                            }
                            if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                                if (temp_plot.m_connectPoints[i]) {
                                    Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], 2000, gx);
                                } else {
                                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], 2000, gx);
                                }
                            } else if (temp_plot.m_shapeType[i] == -1) {
                                if (temp_plot.m_connectPoints[i]) {
                                    Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], j, gx);
                                } else {
                                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], j, gx);
                                }
                            } else if (temp_plot.m_connectPoints[i]) {
                                Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                            } else {
                                Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                            }
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private void paintAxis(Graphics gx) {
        int mye;
        int mys;
        int mxe;
        int mxs;
        block35: {
            int div;
            int sw;
            int hf;
            block34: {
                double mx;
                String maxString;
                double mid;
                String minStringY;
                String maxStringY;
                int precisionYmid;
                int nondecimal;
                double decimal;
                int whole;
                int mswy;
                int w;
                int h;
                block33: {
                    block32: {
                        this.setFonts(gx);
                        mxs = this.m_XaxisStart;
                        mxe = this.m_XaxisEnd;
                        mys = this.m_YaxisStart;
                        mye = this.m_YaxisEnd;
                        this.m_plotResize = false;
                        h = this.getHeight();
                        w = this.getWidth();
                        hf = this.m_labelMetrics.getAscent();
                        int mswx = 0;
                        mswy = 0;
                        int precisionXmax = 1;
                        int precisionXmin = 1;
                        int precisionXmid = 1;
                        whole = (int)Math.abs(this.m_maxX);
                        decimal = Math.abs(this.m_maxX) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n = precisionXmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmax > VisualizeUtils.MAX_PRECISION) {
                            precisionXmax = 1;
                        }
                        String maxStringX = Utils.doubleToString(this.m_maxX, nondecimal + 1 + precisionXmax, precisionXmax);
                        whole = (int)Math.abs(this.m_minX);
                        decimal = Math.abs(this.m_minX) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n2 = precisionXmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minX)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmin > VisualizeUtils.MAX_PRECISION) {
                            precisionXmin = 1;
                        }
                        String minStringX = Utils.doubleToString(this.m_minX, nondecimal + 1 + precisionXmin, precisionXmin);
                        mswx = this.m_labelMetrics.stringWidth(maxStringX);
                        int precisionYmax = 1;
                        int precisionYmin = 1;
                        precisionYmid = 1;
                        whole = (int)Math.abs(this.m_maxY);
                        decimal = Math.abs(this.m_maxY) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n3 = precisionYmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                        if (precisionYmax > VisualizeUtils.MAX_PRECISION) {
                            precisionYmax = 1;
                        }
                        maxStringY = Utils.doubleToString(this.m_maxY, nondecimal + 1 + precisionYmax, precisionYmax);
                        whole = (int)Math.abs(this.m_minY);
                        decimal = Math.abs(this.m_minY) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n4 = precisionYmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minY)) / Math.log(10.0)) + 2 : 1;
                        if (precisionYmin > VisualizeUtils.MAX_PRECISION) {
                            precisionYmin = 1;
                        }
                        minStringY = Utils.doubleToString(this.m_minY, nondecimal + 1 + precisionYmin, precisionYmin);
                        if (this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) {
                            mswy = this.m_labelMetrics.stringWidth(maxStringY) > this.m_labelMetrics.stringWidth(minStringY) ? this.m_labelMetrics.stringWidth(maxStringY) : this.m_labelMetrics.stringWidth(minStringY);
                            mswy += this.m_labelMetrics.stringWidth("M");
                        } else {
                            mswy = this.m_labelMetrics.stringWidth("MM");
                        }
                        this.m_YaxisStart = 5;
                        this.m_XaxisStart = 10 + mswy;
                        this.m_XaxisEnd = w - 5 - mswx / 2;
                        this.m_YaxisEnd = h - 5 - 2 * hf - 5;
                        gx.setColor(this.m_axisColour);
                        if (!this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block32;
                        if (w <= 2 * mswx) break block33;
                        gx.drawString(maxStringX, this.m_XaxisEnd - mswx / 2, this.m_YaxisEnd + hf + 5);
                        mswx = this.m_labelMetrics.stringWidth(minStringX);
                        gx.drawString(minStringX, this.m_XaxisStart - mswx / 2, this.m_YaxisEnd + hf + 5);
                        if (w <= 3 * mswx || !this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block33;
                        mid = this.m_minX + (this.m_maxX - this.m_minX) / 2.0;
                        whole = (int)Math.abs(mid);
                        decimal = Math.abs(mid) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n5 = precisionXmid = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(mid)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmid > VisualizeUtils.MAX_PRECISION) {
                            precisionXmid = 1;
                        }
                        maxString = Utils.doubleToString(mid, nondecimal + 1 + precisionXmid, precisionXmid);
                        sw = this.m_labelMetrics.stringWidth(maxString);
                        mx = (double)this.m_XaxisStart + (double)(this.m_XaxisEnd - this.m_XaxisStart) / 2.0;
                        gx.drawString(maxString, (int)(mx - (double)sw / 2.0), this.m_YaxisEnd + hf + 5);
                        gx.drawLine((int)mx, this.m_YaxisEnd, (int)mx, this.m_YaxisEnd + 5);
                        break block33;
                    }
                    int numValues = this.m_plotInstances.attribute(this.m_xIndex).numValues();
                    div = numValues % 2 > 0 ? numValues / 2 + 1 : numValues / 2;
                    int maxXStringWidth = (this.m_XaxisEnd - this.m_XaxisStart) / numValues;
                    int i = 0;
                    while (i < numValues) {
                        String val = this.m_plotInstances.attribute(this.m_xIndex).value(i);
                        int sw2 = this.m_labelMetrics.stringWidth(val);
                        if (sw2 > maxXStringWidth) {
                            int incr = sw2 / val.length();
                            int rm = (sw2 - maxXStringWidth) / incr;
                            if (rm == 0) {
                                rm = 1;
                            }
                            val = val.substring(0, val.length() - rm);
                            sw2 = this.m_labelMetrics.stringWidth(val);
                        }
                        if (i == 0) {
                            gx.drawString(val, (int)this.convertToPanelX(i), this.m_YaxisEnd + hf + 5);
                        } else if (i == numValues - 1) {
                            if (i % 2 == 0) {
                                gx.drawString(val, this.m_XaxisEnd - sw2, this.m_YaxisEnd + hf + 5);
                            } else {
                                gx.drawString(val, this.m_XaxisEnd - sw2, this.m_YaxisEnd + 2 * hf + 5);
                            }
                        } else if (i % 2 == 0) {
                            gx.drawString(val, (int)this.convertToPanelX(i) - sw2 / 2, this.m_YaxisEnd + hf + 5);
                        } else {
                            gx.drawString(val, (int)this.convertToPanelX(i) - sw2 / 2, this.m_YaxisEnd + 2 * hf + 5);
                        }
                        gx.drawLine((int)this.convertToPanelX(i), this.m_YaxisEnd, (int)this.convertToPanelX(i), this.m_YaxisEnd + 5);
                        ++i;
                    }
                }
                if (!this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block34;
                if (h <= 2 * hf) break block35;
                gx.drawString(maxStringY, this.m_XaxisStart - mswy - 5, this.m_YaxisStart + hf);
                gx.drawString(minStringY, this.m_XaxisStart - mswy - 5, this.m_YaxisEnd);
                if (w <= 3 * hf || !this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block35;
                mid = this.m_minY + (this.m_maxY - this.m_minY) / 2.0;
                whole = (int)Math.abs(mid);
                decimal = Math.abs(mid) - (double)whole;
                nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                int n = precisionYmid = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(mid)) / Math.log(10.0)) + 2 : 1;
                if (precisionYmid > VisualizeUtils.MAX_PRECISION) {
                    precisionYmid = 1;
                }
                maxString = Utils.doubleToString(mid, nondecimal + 1 + precisionYmid, precisionYmid);
                sw = this.m_labelMetrics.stringWidth(maxString);
                mx = (double)this.m_YaxisStart + (double)(this.m_YaxisEnd - this.m_YaxisStart) / 2.0;
                gx.drawString(maxString, this.m_XaxisStart - sw - 5 - 1, (int)(mx + (double)hf / 2.0));
                gx.drawLine(this.m_XaxisStart - 5, (int)mx, this.m_XaxisStart, (int)mx);
                break block35;
            }
            int numValues = this.m_plotInstances.attribute(this.m_yIndex).numValues();
            div = numValues % 2 == 0 ? numValues / 2 : numValues / 2 + 1;
            int maxYStringHeight = (this.m_YaxisEnd - this.m_XaxisStart) / div;
            sw = this.m_labelMetrics.stringWidth("M");
            int i = 0;
            while (i < numValues) {
                if (maxYStringHeight >= 2 * hf) {
                    String val = this.m_plotInstances.attribute(this.m_yIndex).value(i);
                    int numPrint = maxYStringHeight / hf > val.length() ? val.length() : maxYStringHeight / hf;
                    int j = 0;
                    while (j < numPrint) {
                        String ll = val.substring(j, j + 1);
                        if (val.charAt(j) == '_' || val.charAt(j) == '-') {
                            ll = "|";
                        }
                        if (i == 0) {
                            gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf + j * hf + hf / 2);
                        } else if (i == numValues - 1) {
                            if (i % 2 == 0) {
                                gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) + j * hf + hf / 2);
                            } else {
                                gx.drawString(ll, this.m_XaxisStart - 2 * sw - 5 - 1, (int)this.convertToPanelY(i) + j * hf + hf / 2);
                            }
                        } else if (i % 2 == 0) {
                            gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf / 2 + j * hf + hf / 2);
                        } else {
                            gx.drawString(ll, this.m_XaxisStart - 2 * sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf / 2 + j * hf + hf / 2);
                        }
                        ++j;
                    }
                }
                gx.drawLine(this.m_XaxisStart - 5, (int)this.convertToPanelY(i), this.m_XaxisStart, (int)this.convertToPanelY(i));
                ++i;
            }
        }
        gx.drawLine(this.m_XaxisStart, this.m_YaxisStart, this.m_XaxisStart, this.m_YaxisEnd);
        gx.drawLine(this.m_XaxisStart, this.m_YaxisEnd, this.m_XaxisEnd, this.m_YaxisEnd);
        if (this.m_XaxisStart != mxs || this.m_XaxisEnd != mxe || this.m_YaxisStart != mys || this.m_YaxisEnd != mye) {
            this.m_plotResize = true;
        }
    }

    private void extendColourMap(int highest) {
        int i = this.m_colorList.size();
        while (i < highest) {
            Color pc = this.m_DefaultColors[i % 10];
            int ija = i / 10;
            ija *= 2;
            int j = 0;
            while (j < ija) {
                pc = pc.brighter();
                ++j;
            }
            this.m_colorList.addElement(pc);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics gx) {
        super.paintComponent(gx);
        if (this.m_plotInstances != null && this.m_plotInstances.numInstances() > 0 && this.m_plotInstances.numAttributes() > 0) {
            if (this.m_plotCompanion != null) {
                this.m_plotCompanion.prePlot(gx);
            }
            this.m_JRand = new Random(this.m_JitterVal);
            this.paintAxis(gx);
            if (this.m_axisChanged || this.m_plotResize) {
                int x_range = this.m_XaxisEnd - this.m_XaxisStart;
                int y_range = this.m_YaxisEnd - this.m_YaxisStart;
                if (x_range < 10) {
                    x_range = 10;
                }
                if (y_range < 10) {
                    y_range = 10;
                }
                this.m_drawnPoints = new int[x_range + 1][y_range + 1];
                this.fillLookup();
                this.m_plotResize = false;
                this.m_axisChanged = false;
            }
            this.paintData(gx);
        }
    }

    protected static Color checkAgainstBackground(Color c, Color background) {
        if (background == null) {
            return c;
        }
        if (c.equals(background)) {
            int red = c.getRed();
            int blue = c.getBlue();
            int green = c.getGreen();
            c = new Color(red, green += green < 128 ? (255 - green) / 2 : -(green / 2), blue += blue < 128 ? (blue - (red += red < 128 ? (255 - red) / 2 : -(red / 2))) / 2 : -(blue / 2));
        }
        return c;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                Messages.getInstance();
                System.err.println(Messages.getString("Plot2D_Main_Error_Text_First"));
                System.exit(1);
            }
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("Plot2D_Main_JFrame_Text"));
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            Plot2D p2 = new Plot2D();
            jf.getContentPane().add((Component)p2, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            p2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if ((e.getModifiers() & 0x10) == 16) {
                        Plot2D.this.searchPoints(e.getX(), e.getY(), false);
                    } else {
                        Plot2D.this.searchPoints(e.getX(), e.getY(), true);
                    }
                }
            });
            jf.setVisible(true);
            if (args.length >= 1) {
                int j = 0;
                while (j < args.length) {
                    Messages.getInstance();
                    System.err.println(String.valueOf(Messages.getString("Plot2D_Main_Error_Text_Second")) + args[j]);
                    BufferedReader r = new BufferedReader(new FileReader(args[j]));
                    Instances i = new Instances(r);
                    i.setClassIndex(i.numAttributes() - 1);
                    PlotData2D pd1 = new PlotData2D(i);
                    if (j == 0) {
                        Messages.getInstance();
                        pd1.setPlotName(Messages.getString("Plot2D_Main_Pd1_SetPlotName_Text_First"));
                        p2.setMasterPlot(pd1);
                        p2.setXindex(2);
                        p2.setYindex(3);
                        p2.setCindex(i.classIndex());
                    } else {
                        Messages.getInstance();
                        pd1.setPlotName(String.valueOf(Messages.getString("Plot2D_Main_Pd1_SetPlotName_Text_Second")) + (j + 1));
                        pd1.m_useCustomColour = true;
                        pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                        p2.addPlot(pd1);
                    }
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

