/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.Messages;

public class PNGWriter
extends JComponentWriter {
    protected Color m_Background;

    public PNGWriter() {
    }

    public PNGWriter(JComponent c) {
        super(c);
    }

    public PNGWriter(JComponent c, File f) {
        super(c, f);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setScalingEnabled(false);
    }

    @Override
    public String getDescription() {
        Messages.getInstance();
        return Messages.getString("PNGWriter_GetDescription_Text");
    }

    @Override
    public String getExtension() {
        return ".png";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color c) {
        this.m_Background = c;
    }

    @Override
    public void generateOutput() throws Exception {
        BufferedImage bi = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.getXScale(), this.getYScale());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        ImageIO.write((RenderedImage)bi, "png", this.getFile());
    }

    public static void main(String[] args) throws Exception {
        Messages.getInstance();
        System.out.println(Messages.getString("PNGWriter_Main_Text_First"));
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Messages.getInstance();
        Node top = builder.create(new StringReader(Messages.getString("PNGWriter_Main_Text_Second")));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "test.png";
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("PNGWriter_Main_Text_Third"))).append(filename);
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("PNGWriter_Main_Text_Fourth")).toString());
        PNGWriter.toOutput(new PNGWriter(), tv, new File(filename));
        Messages.getInstance();
        System.out.println(Messages.getString("PNGWriter_Main_Text_Fifth"));
    }
}

