/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import weka.gui.treevisualizer.Colors;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Messages;
import weka.gui.treevisualizer.Node;

public class TreeBuild {
    private String m_graphName;
    private Vector m_aNodes;
    private Vector m_aEdges;
    private Vector m_nodes;
    private Vector m_edges;
    private InfoObject m_grObj;
    private InfoObject m_noObj;
    private InfoObject m_edObj;
    private boolean m_digraph;
    private StreamTokenizer m_st;
    private Hashtable m_colorTable = new Hashtable();

    public TreeBuild() {
        Colors ab = new Colors();
        int noa = 0;
        while (noa < ab.m_cols.length) {
            this.m_colorTable.put(ab.m_cols[noa].m_name, ab.m_cols[noa].m_col);
            ++noa;
        }
    }

    public Node create(Reader t) {
        this.m_nodes = new Vector(50, 50);
        this.m_edges = new Vector(50, 50);
        this.m_grObj = new InfoObject("graph");
        this.m_noObj = new InfoObject("node");
        this.m_edObj = new InfoObject("edge");
        this.m_digraph = false;
        this.m_st = new StreamTokenizer(new BufferedReader(t));
        this.setSyntax();
        this.graph();
        Node top = this.generateStructures();
        return top;
    }

    private Node generateStructures() {
        Color color;
        Color fontcolor;
        int fontsize;
        Integer style;
        Integer shape;
        String label;
        String id;
        InfoObject t;
        this.m_aNodes = new Vector(50, 50);
        this.m_aEdges = new Vector(50, 50);
        int noa = 0;
        while (noa < this.m_nodes.size()) {
            t = (InfoObject)this.m_nodes.elementAt(noa);
            id = t.m_id;
            label = t.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : t.m_label;
            shape = t.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(t.m_shape);
            if (shape == null) {
                shape = new Integer(2);
            }
            style = t.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(t.m_style);
            if (style == null) {
                style = new Integer(1);
            }
            fontsize = t.m_fontSize == null ? (this.m_noObj.m_fontSize == null ? 12 : Integer.valueOf(this.m_noObj.m_fontSize)) : Integer.valueOf(t.m_fontSize);
            fontcolor = t.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : (Color)this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : (Color)this.m_colorTable.get(t.m_fontColor.toLowerCase());
            if (fontcolor == null) {
                fontcolor = Color.black;
            }
            color = t.m_color == null ? (this.m_noObj.m_color == null ? Color.gray : (Color)this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : (Color)this.m_colorTable.get(t.m_color.toLowerCase());
            if (color == null) {
                color = Color.gray;
            }
            this.m_aNodes.addElement(new Node(label, id, style, shape, color, t.m_data));
            ++noa;
        }
        noa = 0;
        while (noa < this.m_edges.size()) {
            t = (InfoObject)this.m_edges.elementAt(noa);
            id = t.m_id;
            label = t.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : t.m_label;
            shape = t.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(t.m_shape);
            if (shape == null) {
                shape = new Integer(2);
            }
            style = t.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(t.m_style);
            if (style == null) {
                style = new Integer(1);
            }
            fontsize = t.m_fontSize == null ? (this.m_noObj.m_fontSize == null ? 12 : Integer.valueOf(this.m_noObj.m_fontSize)) : Integer.valueOf(t.m_fontSize);
            fontcolor = t.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : (Color)this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : (Color)this.m_colorTable.get(t.m_fontColor.toLowerCase());
            if (fontcolor == null) {
                fontcolor = Color.black;
            }
            color = t.m_color == null ? (this.m_noObj.m_color == null ? Color.white : (Color)this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : (Color)this.m_colorTable.get(t.m_color.toLowerCase());
            if (color == null) {
                color = Color.white;
            }
            this.m_aEdges.addElement(new Edge(label, t.m_source, t.m_target));
            ++noa;
        }
        Node sour = null;
        Node targ = null;
        int noa2 = 0;
        while (noa2 < this.m_aEdges.size()) {
            boolean f_set = false;
            boolean s_set = false;
            Edge y = (Edge)this.m_aEdges.elementAt(noa2);
            int nob = 0;
            while (nob < this.m_aNodes.size()) {
                Node x = (Node)this.m_aNodes.elementAt(nob);
                if (x.getRefer().equals(y.getRtarget())) {
                    f_set = true;
                    targ = x;
                }
                if (x.getRefer().equals(y.getRsource())) {
                    s_set = true;
                    sour = x;
                }
                if (f_set && s_set) break;
                ++nob;
            }
            if (targ != sour) {
                y.setTarget(targ);
                y.setSource(sour);
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_GenerateStructures_Error_Text"));
            }
            ++noa2;
        }
        noa2 = 0;
        while (noa2 < this.m_aNodes.size()) {
            if (((Node)this.m_aNodes.elementAt(noa2)).getParent(0) == null) {
                sour = (Node)this.m_aNodes.elementAt(noa2);
            }
            ++noa2;
        }
        return sour;
    }

    private Integer getShape(String sh) {
        block6: {
            block5: {
                Messages.getInstance();
                if (sh.equalsIgnoreCase(Messages.getString("TreeBuild_GetShape_Box_Text"))) break block5;
                Messages.getInstance();
                if (!sh.equalsIgnoreCase(Messages.getString("TreeBuild_GetShape_Rectangle_Text"))) break block6;
            }
            return new Integer(1);
        }
        Messages.getInstance();
        if (sh.equalsIgnoreCase(Messages.getString("TreeBuild_GetShape_Oval_Text"))) {
            return new Integer(2);
        }
        Messages.getInstance();
        if (sh.equalsIgnoreCase(Messages.getString("TreeBuild_GetShape_Diamond_Text"))) {
            return new Integer(3);
        }
        return null;
    }

    private Integer getStyle(String sty) {
        Messages.getInstance();
        if (sty.equalsIgnoreCase(Messages.getString("TreeBuild_GetStyle_Filled_Text"))) {
            return new Integer(1);
        }
        return null;
    }

    private void setSyntax() {
        this.m_st.resetSyntax();
        this.m_st.eolIsSignificant(false);
        this.m_st.slashStarComments(true);
        this.m_st.slashSlashComments(true);
        this.m_st.whitespaceChars(0, 32);
        this.m_st.wordChars(33, 255);
        this.m_st.ordinaryChar(91);
        this.m_st.ordinaryChar(93);
        this.m_st.ordinaryChar(123);
        this.m_st.ordinaryChar(125);
        this.m_st.ordinaryChar(45);
        this.m_st.ordinaryChar(62);
        this.m_st.ordinaryChar(47);
        this.m_st.ordinaryChar(42);
        this.m_st.quoteChar(34);
        this.m_st.whitespaceChars(59, 59);
        this.m_st.ordinaryChar(61);
    }

    private void alterSyntax() {
        this.m_st.resetSyntax();
        this.m_st.wordChars(0, 255);
        this.m_st.slashStarComments(false);
        this.m_st.slashSlashComments(false);
        this.m_st.ordinaryChar(10);
        this.m_st.ordinaryChar(13);
    }

    private void nextToken(String r) {
        int t = 0;
        try {
            t = this.m_st.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (t == -1) {
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("TreeBuild_NextToken_StTT_EOF_Text")) + r);
        } else if (t == -2) {
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("TreeBuild_NextToken_StTT_NUMBER_Text")) + r);
        }
    }

    private void graph() {
        boolean flag = true;
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_Graph_NextToken_Text_First"));
        String string = this.m_st.sval;
        Messages.getInstance();
        if (string.equalsIgnoreCase(Messages.getString("TreeBuild_Graph_StSval_Text"))) {
            this.m_digraph = true;
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_Graph_Error_Text_First"));
        }
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_Graph_NextToken_Text_Second"));
        if (this.m_st.sval != null) {
            this.m_graphName = this.m_st.sval;
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_Graph_Error_Text_Second"));
        }
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_Graph_NextToken_Text_Third"));
        if (this.m_st.ttype == 123) {
            this.stmtList();
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_Graph_Text"));
        }
    }

    private void stmtList() {
        boolean flag = true;
        while (flag) {
            block7: {
                block6: {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_StmtList_NextToken_Text"));
                    if (this.m_st.ttype == 125) {
                        flag = false;
                        continue;
                    }
                    String string = this.m_st.sval;
                    Messages.getInstance();
                    if (string.equalsIgnoreCase(Messages.getString("TreeBuild_StmtList_StSval_Graph_Text"))) break block6;
                    String string2 = this.m_st.sval;
                    Messages.getInstance();
                    if (string2.equalsIgnoreCase(Messages.getString("TreeBuild_StmtList_StSval_Node_Text"))) break block6;
                    String string3 = this.m_st.sval;
                    Messages.getInstance();
                    if (!string3.equalsIgnoreCase(Messages.getString("TreeBuild_StmtList_StSval_Edge_Text"))) break block7;
                }
                this.m_st.pushBack();
                this.attrStmt();
                continue;
            }
            if (this.m_st.sval != null) {
                this.nodeId(this.m_st.sval, 0);
                continue;
            }
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_StmtList_Text"));
        }
    }

    private void attrStmt() {
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_AttrStmt_NextToken_Text_First"));
        String string = this.m_st.sval;
        Messages.getInstance();
        if (string.equalsIgnoreCase(Messages.getString("TreeBuild_AttrStmt_StSval_Graph_Text"))) {
            Messages.getInstance();
            this.nextToken(Messages.getString("TreeBuild_AttrStmt_NextToken_Text_Second"));
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_grObj);
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrStmt_NextToken_Text_Second_Alpha"));
            }
        } else {
            String string2 = this.m_st.sval;
            Messages.getInstance();
            if (string2.equalsIgnoreCase(Messages.getString("TreeBuild_AttrStmt_StSval_Node_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrStmt_Text_First"));
                if (this.m_st.ttype == 91) {
                    this.attrList(this.m_noObj);
                } else {
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrStmt_Text_First_Alpha"));
                }
            } else {
                String string3 = this.m_st.sval;
                Messages.getInstance();
                if (string3.equalsIgnoreCase(Messages.getString("TreeBuild_AttrStmt_StSval_Edge_Text"))) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrStmt_NextToken_Text_Third"));
                    if (this.m_st.ttype == 91) {
                        this.attrList(this.m_edObj);
                    } else {
                        Messages.getInstance();
                        System.out.println(Messages.getString("TreeBuild_AttrStmt_Text_Second"));
                    }
                } else {
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrStmt_Text_Third"));
                }
            }
        }
    }

    private void nodeId(String s, int t) {
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_NodeId_NextToken_Text_First"));
        if (this.m_st.ttype == 125) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
            }
            this.m_st.pushBack();
        } else if (this.m_st.ttype == 45) {
            Messages.getInstance();
            this.nextToken(Messages.getString("TreeBuild_NodeId_NextToken_Text_Second"));
            if (this.m_st.ttype == 62) {
                this.edgeStmt(s);
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_NodeId_Text_First"));
            }
        } else if (this.m_st.ttype == 91) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
                this.attrList((InfoObject)this.m_nodes.lastElement());
            } else {
                this.attrList((InfoObject)this.m_edges.lastElement());
            }
        } else if (this.m_st.sval != null) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
            }
            this.m_st.pushBack();
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_NodeId_Text_Second"));
        }
    }

    private void edgeStmt(String i) {
        Messages.getInstance();
        this.nextToken(Messages.getString("TreeBuild_EdgeStmt_NextToken_Text_First"));
        if (this.m_st.sval != null) {
            Messages.getInstance();
            this.m_edges.addElement(new InfoObject(Messages.getString("TreeBuild_EdgeStmt_EdgesAddElement_Text_First")));
            ((InfoObject)this.m_edges.lastElement()).m_source = i;
            ((InfoObject)this.m_edges.lastElement()).m_target = this.m_st.sval;
            this.nodeId(this.m_st.sval, 1);
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_EdgeStmt_Text"));
        }
    }

    private void attrList(InfoObject a) {
        boolean flag = true;
        while (flag) {
            Messages.getInstance();
            this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_First"));
            if (this.m_st.ttype == 93) {
                flag = false;
                continue;
            }
            String string = this.m_st.sval;
            Messages.getInstance();
            if (string.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_Color_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Second"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Third"));
                    if (this.m_st.sval != null) {
                        a.m_color = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_First"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Second"));
                continue;
            }
            String string2 = this.m_st.sval;
            Messages.getInstance();
            if (string2.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_FontColor_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Fourth"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Fourth_Alpha"));
                    if (this.m_st.sval != null) {
                        a.m_fontColor = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Third"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Fourth"));
                continue;
            }
            String string3 = this.m_st.sval;
            Messages.getInstance();
            if (string3.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_FontSize_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Fifth"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Fifth_Alpha"));
                    if (this.m_st.sval != null) {
                        a.m_fontSize = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Fifth"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Sixth"));
                continue;
            }
            String string4 = this.m_st.sval;
            Messages.getInstance();
            if (string4.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_Label_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Sixth"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Seventh"));
                    if (this.m_st.sval != null) {
                        a.m_label = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Seventh"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Eighth"));
                continue;
            }
            String string5 = this.m_st.sval;
            Messages.getInstance();
            if (string5.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_Shape_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Eighth"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Nineth"));
                    if (this.m_st.sval != null) {
                        a.m_shape = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Nineth"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Tenth"));
                continue;
            }
            String string6 = this.m_st.sval;
            Messages.getInstance();
            if (string6.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_Style_Text"))) {
                Messages.getInstance();
                this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Tenth"));
                if (this.m_st.ttype == 61) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Eleventh"));
                    if (this.m_st.sval != null) {
                        a.m_style = this.m_st.sval;
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Eleventh"));
                    continue;
                }
                Messages.getInstance();
                System.out.println(Messages.getString("TreeBuild_AttrList_Text_Twelveth"));
                continue;
            }
            String string7 = this.m_st.sval;
            Messages.getInstance();
            if (!string7.equalsIgnoreCase(Messages.getString("TreeBuild_AttrList_StSval_Data_Text"))) continue;
            Messages.getInstance();
            this.nextToken(Messages.getString("TreeBuild_AttrList_NextToken_Text_Twelveth"));
            if (this.m_st.ttype == 61) {
                this.alterSyntax();
                a.m_data = new String("");
                while (true) {
                    Messages.getInstance();
                    this.nextToken(Messages.getString("TreeBuild_AttrList_Text_Thirteenth"));
                    if (this.m_st.sval != null && a.m_data != null && this.m_st.sval.equals(",")) break;
                    if (this.m_st.sval != null) {
                        a.m_data = a.m_data.concat(this.m_st.sval);
                        continue;
                    }
                    if (this.m_st.ttype == 13) {
                        a.m_data = a.m_data.concat("\r");
                        continue;
                    }
                    if (this.m_st.ttype == 10) {
                        a.m_data = a.m_data.concat("\n");
                        continue;
                    }
                    Messages.getInstance();
                    System.out.println(Messages.getString("TreeBuild_AttrList_Text_Thirteenth"));
                }
                this.setSyntax();
                continue;
            }
            Messages.getInstance();
            System.out.println(Messages.getString("TreeBuild_AttrList_Text_Fourteenth"));
        }
    }

    private class InfoObject {
        public String m_id;
        public String m_color;
        public String m_fontColor;
        public String m_fontSize;
        public String m_label;
        public String m_shape;
        public String m_style;
        public String m_source;
        public String m_target;
        public String m_data;

        public InfoObject(String i) {
            this.m_id = i;
            this.m_color = null;
            this.m_fontColor = null;
            this.m_fontSize = null;
            this.m_label = null;
            this.m_shape = null;
            this.m_style = null;
            this.m_source = null;
            this.m_target = null;
            this.m_data = null;
        }
    }
}

