/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.Messages;

public class InstanceSavePanel
extends Panel
implements InstanceListener {
    private static final long serialVersionUID = -6061005366989295026L;
    private Label count_Lab;
    private int m_Count;
    private TextField arffFile_Tex;
    private boolean b_Debug;
    private PrintWriter outputWriter;

    public void input(Instance instance) throws Exception {
        if (this.b_Debug) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("InstanceSavePanel_Input_Error_Text_First"))).append(instance);
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("InstanceSavePanel_Input_Error_Text_Second")).toString());
        }
        ++this.m_Count;
        StringBuilder stringBuilder = new StringBuilder().append(this.m_Count);
        Messages.getInstance();
        this.count_Lab.setText(stringBuilder.append(Messages.getString("InstanceSavePanel_Input_Count_Lab_SetText_Second")).toString());
        if (this.outputWriter != null) {
            this.outputWriter.println(instance.toString());
        }
    }

    public void inputFormat(Instances instanceInfo) {
        if (this.b_Debug) {
            Messages.getInstance();
            System.err.println(String.valueOf(Messages.getString("InstanceSavePanel::inputFormat()\n")) + instanceInfo.toString());
        }
        this.m_Count = 0;
        StringBuilder stringBuilder = new StringBuilder().append(this.m_Count);
        Messages.getInstance();
        this.count_Lab.setText(stringBuilder.append(Messages.getString("InstanceSavePanel_InputFormat_Count_Lab_SetText_Second")).toString());
        try {
            this.outputWriter = new PrintWriter(new FileOutputStream(this.arffFile_Tex.getText()));
            this.outputWriter.println(instanceInfo.toString());
            if (this.b_Debug) {
                Messages.getInstance();
                System.err.println(Messages.getString("InstanceSavePanel_InputFormat_Error_Text_Second"));
            }
        }
        catch (Exception ex) {
            this.outputWriter = null;
            Messages.getInstance();
            System.err.println(String.valueOf(Messages.getString("InstanceSavePanel_InputFormat_Error_Text_Third")) + ex.getMessage());
        }
    }

    public void batchFinished() {
        if (this.b_Debug) {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceSavePanel_BatchFinished_Error_Text_First"));
        }
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }

    public InstanceSavePanel() {
        this.setLayout(new BorderLayout());
        this.arffFile_Tex = new TextField("arffoutput.arff");
        this.add("Center", this.arffFile_Tex);
        Messages.getInstance();
        this.count_Lab = new Label(Messages.getString("InstanceSavePanel_Count_Lab_Label_Text"));
        Messages.getInstance();
        this.add(Messages.getString("InstanceSavePanel_Count_Lab_Label_Add_Text"), this.count_Lab);
        this.setBackground(Color.lightGray);
    }

    public void setDebug(boolean debug) {
        this.b_Debug = debug;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    public void setArffFile(String newArffFile) {
        this.arffFile_Tex.setText(newArffFile);
    }

    public String getArffFile() {
        return this.arffFile_Tex.getText();
    }

    @Override
    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        this.inputFormat(a.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        Messages.getInstance();
                        System.err.println(Messages.getString("InstanceSavePanel_InstanceProduced_InstanceProducerDEFAULT_Error_Text"));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceSavePanel_InstanceProduced_Error_Text"));
        }
    }
}

