/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import weka.core.FastVector;
import weka.core.logging.Logger;
import weka.gui.ExtensionFileFilter;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.BIFParser;
import weka.gui.graphvisualizer.DotParser;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.HierarchicalBCEngine;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.graphvisualizer.Messages;
import weka.gui.visualize.PrintablePanel;

public class GraphVisualizer
extends JPanel
implements GraphConstants,
LayoutCompleteEventListener {
    private static final long serialVersionUID = -2038911085935515624L;
    protected FastVector m_nodes = new FastVector();
    protected FastVector m_edges = new FastVector();
    protected LayoutEngine m_le;
    protected GraphPanel m_gp;
    protected String graphID;
    protected JButton m_jBtSave;
    private final String ICONPATH = "weka/gui/graphvisualizer/icons/";
    private FontMetrics fm = this.getFontMetrics(this.getFont());
    private double scale = 1.0;
    private int nodeHeight = 2 * this.fm.getHeight();
    private int nodeWidth = 24;
    private int paddedNodeWidth = 32;
    private final JTextField jTfNodeWidth = new JTextField(3);
    private final JTextField jTfNodeHeight = new JTextField(3);
    private final JButton jBtLayout;
    private int maxStringWidth = 0;
    private int[] zoomPercents = new int[]{10, 25, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300, 350, 400, 450, 500, 550, 600, 650, 700, 800, 900, 999};
    JScrollPane m_js;

    public GraphVisualizer() {
        this.m_gp = new GraphPanel();
        this.m_js = new JScrollPane(this.m_gp);
        this.m_le = new HierarchicalBCEngine(this.m_nodes, this.m_edges, this.paddedNodeWidth, this.nodeHeight);
        this.m_le.addLayoutCompleteEventListener(this);
        this.m_jBtSave = new JButton();
        URL tempURL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/save.gif");
        if (tempURL != null) {
            this.m_jBtSave.setIcon(new ImageIcon(tempURL));
        } else {
            StringBuilder stringBuilder = new StringBuilder("weka/gui/graphvisualizer/icons/");
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("GraphVisualizer_Error_Text_First")).toString());
        }
        Messages.getInstance();
        this.m_jBtSave.setToolTipText(Messages.getString("GraphVisualizer_JBtSave_SetToolTipText_Text"));
        this.m_jBtSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
                Messages.getInstance();
                ExtensionFileFilter ef1 = new ExtensionFileFilter(".dot", Messages.getString("GraphVisualizer_EF1_ExtensionFileFilter_Text"));
                Messages.getInstance();
                ExtensionFileFilter ef2 = new ExtensionFileFilter(".xml", Messages.getString("GraphVisualizer_EF2_ExtensionFileFilter_Text"));
                fc.addChoosableFileFilter(ef1);
                fc.addChoosableFileFilter(ef2);
                Messages.getInstance();
                fc.setDialogTitle(Messages.getString("GraphVisualizer_FC_SetDialogTitle_Text"));
                int rval = fc.showSaveDialog(GraphVisualizer.this);
                if (rval == 0) {
                    if (fc.getFileFilter() == ef2) {
                        String filename = fc.getSelectedFile().toString();
                        if (!filename.endsWith(".xml")) {
                            filename = filename.concat(".xml");
                        }
                        BIFParser.writeXMLBIF03(filename, GraphVisualizer.this.graphID, GraphVisualizer.this.m_nodes, GraphVisualizer.this.m_edges);
                    } else {
                        String filename = fc.getSelectedFile().toString();
                        if (!filename.endsWith(".dot")) {
                            filename = filename.concat(".dot");
                        }
                        DotParser.writeDOT(filename, GraphVisualizer.this.graphID, GraphVisualizer.this.m_nodes, GraphVisualizer.this.m_edges);
                    }
                }
            }
        });
        final JButton jBtZoomIn = new JButton();
        tempURL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/zoomin.gif");
        if (tempURL != null) {
            jBtZoomIn.setIcon(new ImageIcon(tempURL));
        } else {
            StringBuilder stringBuilder = new StringBuilder("weka/gui/graphvisualizer/icons/");
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("GraphVisualizer_Error_Text_Second")).toString());
        }
        Messages.getInstance();
        jBtZoomIn.setToolTipText(Messages.getString("GraphVisualizer_JBtZoomIn_SetToolTipText_Text"));
        final JButton jBtZoomOut = new JButton();
        tempURL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/zoomout.gif");
        if (tempURL != null) {
            jBtZoomOut.setIcon(new ImageIcon(tempURL));
        } else {
            StringBuilder stringBuilder = new StringBuilder("weka/gui/graphvisualizer/icons/");
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("GraphVisualizer_Error_Text_Third")).toString());
        }
        Messages.getInstance();
        jBtZoomOut.setToolTipText(Messages.getString("GraphVisualizer_JBtZoomOut_SetToolTipText_Text"));
        final JTextField jTfZoom = new JTextField("100%");
        jTfZoom.setMinimumSize(jTfZoom.getPreferredSize());
        jTfZoom.setHorizontalAlignment(0);
        Messages.getInstance();
        jTfZoom.setToolTipText(Messages.getString("GraphVisualizer_JBtZoom_SetToolTipText_Text"));
        jTfZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JTextField jt = (JTextField)ae.getSource();
                try {
                    int i = -1;
                    i = jt.getText().indexOf(37);
                    i = i == -1 ? Integer.parseInt(jt.getText()) : Integer.parseInt(jt.getText().substring(0, i));
                    if (i <= 999) {
                        GraphVisualizer.this.scale = (double)i / 100.0;
                    }
                    jt.setText(String.valueOf((int)(GraphVisualizer.this.scale * 100.0)) + "%");
                    if (GraphVisualizer.this.scale > 0.1) {
                        if (!jBtZoomOut.isEnabled()) {
                            jBtZoomOut.setEnabled(true);
                        }
                    } else {
                        jBtZoomOut.setEnabled(false);
                    }
                    if (GraphVisualizer.this.scale < 9.99) {
                        if (!jBtZoomIn.isEnabled()) {
                            jBtZoomIn.setEnabled(true);
                        }
                    } else {
                        jBtZoomIn.setEnabled(false);
                    }
                    GraphVisualizer.this.setAppropriateSize();
                    GraphVisualizer.this.m_gp.repaint();
                    GraphVisualizer.this.m_gp.invalidate();
                    GraphVisualizer.this.m_js.revalidate();
                }
                catch (NumberFormatException ne) {
                    Container container = GraphVisualizer.this.getParent();
                    Messages.getInstance();
                    String string = Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_First");
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(container, string, Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_Second"), 0);
                    jt.setText(String.valueOf(GraphVisualizer.this.scale * 100.0) + "%");
                }
            }
        });
        jBtZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = 0;
                int s = (int)(GraphVisualizer.this.scale * 100.0);
                i = s < 300 ? s / 25 : (s < 700 ? 6 + s / 50 : 13 + s / 100);
                if (s >= 999) {
                    JButton b = (JButton)ae.getSource();
                    b.setEnabled(false);
                    return;
                }
                if (s >= 10) {
                    if (i >= 22) {
                        JButton b = (JButton)ae.getSource();
                        b.setEnabled(false);
                    }
                    if (s == 10 && !jBtZoomOut.isEnabled()) {
                        jBtZoomOut.setEnabled(true);
                    }
                    jTfZoom.setText(String.valueOf(GraphVisualizer.this.zoomPercents[i + 1]) + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[i + 1] / 100.0;
                } else {
                    if (!jBtZoomOut.isEnabled()) {
                        jBtZoomOut.setEnabled(true);
                    }
                    jTfZoom.setText(String.valueOf(GraphVisualizer.this.zoomPercents[0]) + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[0] / 100.0;
                }
                GraphVisualizer.this.setAppropriateSize();
                GraphVisualizer.this.m_gp.repaint();
                GraphVisualizer.this.m_gp.invalidate();
                GraphVisualizer.this.m_js.revalidate();
            }
        });
        jBtZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = 0;
                int s = (int)(GraphVisualizer.this.scale * 100.0);
                i = s < 300 ? (int)Math.ceil((double)s / 25.0) : (s < 700 ? 6 + (int)Math.ceil((double)s / 50.0) : 13 + (int)Math.ceil((double)s / 100.0));
                if (s <= 10) {
                    JButton b = (JButton)ae.getSource();
                    b.setEnabled(false);
                } else if (s < 999) {
                    if (i <= 1) {
                        JButton b = (JButton)ae.getSource();
                        b.setEnabled(false);
                    }
                    jTfZoom.setText(String.valueOf(GraphVisualizer.this.zoomPercents[i - 1]) + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[i - 1] / 100.0;
                } else {
                    if (!jBtZoomIn.isEnabled()) {
                        jBtZoomIn.setEnabled(true);
                    }
                    jTfZoom.setText(String.valueOf(GraphVisualizer.this.zoomPercents[22]) + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[22] / 100.0;
                }
                GraphVisualizer.this.setAppropriateSize();
                GraphVisualizer.this.m_gp.repaint();
                GraphVisualizer.this.m_gp.invalidate();
                GraphVisualizer.this.m_js.revalidate();
            }
        });
        JButton jBtExtraControls = new JButton();
        tempURL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/extra.gif");
        if (tempURL != null) {
            jBtExtraControls.setIcon(new ImageIcon(tempURL));
        } else {
            StringBuilder stringBuilder = new StringBuilder("weka/gui/graphvisualizer/icons/");
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("GraphVisualizer_Error_Text_Fourth")).toString());
        }
        Messages.getInstance();
        jBtExtraControls.setToolTipText(Messages.getString("GraphVisualizer_JBtExtraControls_SetToolTipText_Text"));
        Messages.getInstance();
        final JCheckBox jCbCustomNodeSize = new JCheckBox(Messages.getString("GraphVisualizer_JCbCustomNodeSize_JCheckBox_Text"));
        Messages.getInstance();
        final JLabel jLbNodeWidth = new JLabel(Messages.getString("GraphVisualizer_JLbNodeWidth_JLabel_Text"));
        Messages.getInstance();
        final JLabel jLbNodeHeight = new JLabel(Messages.getString("GraphVisualizer_JLbNodeHeight_JLabel_Text"));
        this.jTfNodeWidth.setHorizontalAlignment(0);
        this.jTfNodeWidth.setText("" + this.nodeWidth);
        this.jTfNodeHeight.setHorizontalAlignment(0);
        this.jTfNodeHeight.setText("" + this.nodeHeight);
        jLbNodeWidth.setEnabled(false);
        this.jTfNodeWidth.setEnabled(false);
        jLbNodeHeight.setEnabled(false);
        this.jTfNodeHeight.setEnabled(false);
        jCbCustomNodeSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (((JCheckBox)ae.getSource()).isSelected()) {
                    jLbNodeWidth.setEnabled(true);
                    GraphVisualizer.this.jTfNodeWidth.setEnabled(true);
                    jLbNodeHeight.setEnabled(true);
                    GraphVisualizer.this.jTfNodeHeight.setEnabled(true);
                } else {
                    jLbNodeWidth.setEnabled(false);
                    GraphVisualizer.this.jTfNodeWidth.setEnabled(false);
                    jLbNodeHeight.setEnabled(false);
                    GraphVisualizer.this.jTfNodeHeight.setEnabled(false);
                    GraphVisualizer.this.setAppropriateNodeSize();
                }
            }
        });
        Messages.getInstance();
        this.jBtLayout = new JButton(Messages.getString("GraphVisualizer_JBtLayout_JButton_Text"));
        this.jBtLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (jCbCustomNodeSize.isSelected()) {
                    int tmpH;
                    int tmpW;
                    try {
                        tmpW = Integer.parseInt(GraphVisualizer.this.jTfNodeWidth.getText());
                    }
                    catch (NumberFormatException ne) {
                        Container container = GraphVisualizer.this.getParent();
                        Messages.getInstance();
                        String string = Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_First");
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(container, string, Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_Second"), 0);
                        tmpW = GraphVisualizer.this.nodeWidth;
                        GraphVisualizer.this.jTfNodeWidth.setText("" + GraphVisualizer.this.nodeWidth);
                    }
                    try {
                        tmpH = Integer.parseInt(GraphVisualizer.this.jTfNodeHeight.getText());
                    }
                    catch (NumberFormatException ne) {
                        Container container = GraphVisualizer.this.getParent();
                        Messages.getInstance();
                        String string = Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_Third");
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(container, string, Messages.getString("GraphVisualizer_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
                        tmpH = GraphVisualizer.this.nodeHeight;
                        GraphVisualizer.this.jTfNodeWidth.setText("" + GraphVisualizer.this.nodeHeight);
                    }
                    if (tmpW != GraphVisualizer.this.nodeWidth || tmpH != GraphVisualizer.this.nodeHeight) {
                        GraphVisualizer.this.nodeWidth = tmpW;
                        GraphVisualizer.this.paddedNodeWidth = GraphVisualizer.this.nodeWidth + 8;
                        GraphVisualizer.this.nodeHeight = tmpH;
                    }
                }
                JButton bt = (JButton)ae.getSource();
                bt.setEnabled(false);
                GraphVisualizer.this.m_le.setNodeSize(GraphVisualizer.this.paddedNodeWidth, GraphVisualizer.this.nodeHeight);
                GraphVisualizer.this.m_le.layoutGraph();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        final JPanel p = new JPanel(new GridBagLayout());
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        p.add((Component)this.m_le.getControlPanel(), gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(8, 0, 0, 0);
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        p.add((Component)jCbCustomNodeSize, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        Container c = new Container();
        c.setLayout(new GridBagLayout());
        gbc.gridwidth = -1;
        c.add((Component)jLbNodeWidth, gbc);
        gbc.gridwidth = 0;
        c.add((Component)this.jTfNodeWidth, gbc);
        gbc.gridwidth = -1;
        c.add((Component)jLbNodeHeight, gbc);
        gbc.gridwidth = 0;
        c.add((Component)this.jTfNodeHeight, gbc);
        gbc.fill = 2;
        p.add((Component)c, gbc);
        gbc.anchor = 18;
        gbc.insets = new Insets(8, 0, 0, 0);
        gbc.fill = 2;
        p.add((Component)this.jBtLayout, gbc);
        gbc.fill = 0;
        Messages.getInstance();
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("GraphVisualizer_P_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        p.setPreferredSize(new Dimension(0, 0));
        final JToolBar jTbTools = new JToolBar();
        jTbTools.setFloatable(false);
        jTbTools.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        jTbTools.add((Component)p, gbc);
        gbc.gridwidth = 1;
        jTbTools.add((Component)this.m_jBtSave, gbc);
        jTbTools.addSeparator(new Dimension(2, 2));
        jTbTools.add((Component)jBtZoomIn, gbc);
        gbc.fill = 3;
        gbc.weighty = 1.0;
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setPreferredSize(jTfZoom.getPreferredSize());
        p2.setMinimumSize(jTfZoom.getPreferredSize());
        p2.add((Component)jTfZoom, "Center");
        jTbTools.add((Component)p2, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 0;
        jTbTools.add((Component)jBtZoomOut, gbc);
        jTbTools.addSeparator(new Dimension(2, 2));
        jTbTools.add((Component)jBtExtraControls, gbc);
        jTbTools.addSeparator(new Dimension(4, 2));
        gbc.weightx = 1.0;
        gbc.fill = 1;
        jTbTools.add((Component)this.m_le.getProgressBar(), gbc);
        jBtExtraControls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Dimension d = p.getPreferredSize();
                if (d.width == 0 || d.height == 0) {
                    LayoutManager lm = p.getLayout();
                    Dimension d2 = lm.preferredLayoutSize(p);
                    p.setPreferredSize(d2);
                    jTbTools.revalidate();
                } else {
                    p.setPreferredSize(new Dimension(0, 0));
                    jTbTools.revalidate();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)jTbTools, "North");
        this.add((Component)this.m_js, "Center");
    }

    protected void setAppropriateNodeSize() {
        if (this.maxStringWidth == 0) {
            int i = 0;
            while (i < this.m_nodes.size()) {
                int strWidth = this.fm.stringWidth(((GraphNode)this.m_nodes.elementAt((int)i)).lbl);
                if (strWidth > this.maxStringWidth) {
                    this.maxStringWidth = strWidth;
                }
                ++i;
            }
        }
        this.nodeWidth = this.maxStringWidth + 4;
        this.paddedNodeWidth = this.nodeWidth + 8;
        this.jTfNodeWidth.setText("" + this.nodeWidth);
        this.nodeHeight = 2 * this.fm.getHeight();
        this.jTfNodeHeight.setText("" + this.nodeHeight);
    }

    protected void setAppropriateSize() {
        int maxX = 0;
        int maxY = 0;
        this.m_gp.setScale(this.scale, this.scale);
        int i = 0;
        while (i < this.m_nodes.size()) {
            GraphNode n = (GraphNode)this.m_nodes.elementAt(i);
            if (maxX < n.x) {
                maxX = n.x;
            }
            if (maxY < n.y) {
                maxY = n.y;
            }
            ++i;
        }
        this.m_gp.setPreferredSize(new Dimension((int)((double)(maxX + this.paddedNodeWidth + 2) * this.scale), (int)((double)(maxY + this.nodeHeight + 2) * this.scale)));
    }

    @Override
    public void layoutCompleted(LayoutCompleteEvent le) {
        this.setAppropriateSize();
        this.m_gp.invalidate();
        this.m_js.revalidate();
        this.m_gp.repaint();
        this.jBtLayout.setEnabled(true);
    }

    public void layoutGraph() {
        if (this.m_le != null) {
            this.m_le.layoutGraph();
        }
    }

    public void readBIF(String instring) throws BIFFormatException {
        BIFParser bp = new BIFParser(instring, this.m_nodes, this.m_edges);
        try {
            this.graphID = bp.parse();
        }
        catch (BIFFormatException bf) {
            Messages.getInstance();
            System.out.println(Messages.getString("GraphVisualizer_ReadBIF_Error_Text_First"));
            bf.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
        }
    }

    public void readBIF(InputStream instream) throws BIFFormatException {
        BIFParser bp = new BIFParser(instream, this.m_nodes, this.m_edges);
        try {
            this.graphID = bp.parse();
        }
        catch (BIFFormatException bf) {
            Messages.getInstance();
            System.out.println(Messages.getString("GraphVisualizer_ReadBIF_Error_Text_Second"));
            bf.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
        }
        this.setAppropriateSize();
    }

    public void readDOT(Reader input) {
        DotParser dp = new DotParser(input, this.m_nodes, this.m_edges);
        this.graphID = dp.parse();
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
            this.jBtLayout.setEnabled(false);
            this.layoutGraph();
        }
    }

    public static void main(String[] args) {
        Messages.getInstance();
        Logger.log(Logger.Level.INFO, Messages.getString("GraphVisualizer_Main_Logger_Text"));
        Messages.getInstance();
        JFrame jf = new JFrame(Messages.getString("GraphVisualizer_Main_JFrame_Text"));
        GraphVisualizer g = new GraphVisualizer();
        try {
            if (args[0].endsWith(".xml")) {
                g.readBIF(new FileInputStream(args[0]));
            } else {
                g.readDOT(new FileReader(args[0]));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (BIFFormatException bf) {
            bf.printStackTrace();
            System.exit(-1);
        }
        jf.getContentPane().add(g);
        jf.setDefaultCloseOperation(3);
        jf.setSize(800, 600);
        jf.setVisible(true);
    }

    private class GraphPanel
    extends PrintablePanel {
        private static final long serialVersionUID = -3562813603236753173L;

        public GraphPanel() {
            this.addMouseListener(new GraphVisualizerMouseListener());
            this.addMouseMotionListener(new GraphVisualizerMouseMotionListener());
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            Dimension d = GraphVisualizer.this.m_gp.getPreferredSize();
            int ny = 0;
            int nx = 0;
            int y = 0;
            int x = 0;
            if (d.width < GraphVisualizer.this.m_gp.getWidth()) {
                nx = (int)((double)(nx + GraphVisualizer.this.m_gp.getWidth() / 2 - d.width / 2) / GraphVisualizer.this.scale);
            }
            if (d.height < GraphVisualizer.this.m_gp.getHeight()) {
                ny = (int)((double)(ny + GraphVisualizer.this.m_gp.getHeight() / 2 - d.height / 2) / GraphVisualizer.this.scale);
            }
            Rectangle r = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            x += me.getX();
            y += me.getY();
            int i = 0;
            while (i < GraphVisualizer.this.m_nodes.size()) {
                GraphNode n = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                if (n.nodeType != 3) {
                    return null;
                }
                r.x = (int)((double)(nx + n.x) * GraphVisualizer.this.scale);
                r.y = (int)((double)(ny + n.y) * GraphVisualizer.this.scale);
                if (r.contains(x, y)) {
                    if (n.probs == null) {
                        return n.lbl;
                    }
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(n.lbl));
                    Messages.getInstance();
                    return stringBuilder.append(Messages.getString("GraphVisualizer_GetToolTipText_Text")).toString();
                }
                ++i;
            }
            return null;
        }

        @Override
        public void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setRenderingHints(rh);
            g.scale(GraphVisualizer.this.scale, GraphVisualizer.this.scale);
            Rectangle r = g.getClipBounds();
            g.clearRect(r.x, r.y, r.width, r.height);
            int x = 0;
            int y = 0;
            Dimension d = this.getPreferredSize();
            if (d.width < this.getWidth()) {
                x = (int)((double)(x + this.getWidth() / 2 - d.width / 2) / GraphVisualizer.this.scale);
            }
            if (d.height < this.getHeight()) {
                y = (int)((double)(y + this.getHeight() / 2 - d.height / 2) / GraphVisualizer.this.scale);
            }
            int index = 0;
            while (index < GraphVisualizer.this.m_nodes.size()) {
                GraphNode n = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(index);
                if (n.nodeType == 3) {
                    g.setColor(this.getBackground().darker().darker());
                    g.fillOval(x + n.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, y + n.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                    g.setColor(Color.white);
                    if (GraphVisualizer.this.fm.stringWidth(n.lbl) <= GraphVisualizer.this.nodeWidth) {
                        g.drawString(n.lbl, x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(n.lbl) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    } else if (GraphVisualizer.this.fm.stringWidth(n.ID) <= GraphVisualizer.this.nodeWidth) {
                        g.drawString(n.ID, x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(n.ID) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    } else if (GraphVisualizer.this.fm.stringWidth(Integer.toString(index)) <= GraphVisualizer.this.nodeWidth) {
                        g.drawString(Integer.toString(index), x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(Integer.toString(index)) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    }
                    g.setColor(Color.black);
                } else {
                    g.drawLine(x + n.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n.y, x + n.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n.y + GraphVisualizer.this.nodeHeight);
                }
                if (n.edges != null) {
                    int k = 0;
                    while (k < n.edges.length) {
                        if (n.edges[k][1] > 0) {
                            GraphNode n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.edges[k][0]);
                            int x1 = n.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            int y1 = n.y + GraphVisualizer.this.nodeHeight;
                            int x2 = n2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            int y2 = n2.y;
                            g.drawLine(x + x1, y + y1, x + x2, y + y2);
                            if (n.edges[k][1] == 1) {
                                if (n2.nodeType == 3) {
                                    this.drawArrow(g, x + x1, y + y1, x + x2, y + y2);
                                }
                            } else if (n.edges[k][1] == 2) {
                                if (n.nodeType == 3) {
                                    this.drawArrow(g, x + x2, y + y2, x + x1, y + y1);
                                }
                            } else if (n.edges[k][1] == 3) {
                                if (n.nodeType == 3) {
                                    this.drawArrow(g, x + x2, y + y2, x + x1, y + y1);
                                }
                                if (n2.nodeType == 3) {
                                    this.drawArrow(g, x + x1, y + y1, x + x2, y + y2);
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++index;
            }
        }

        protected void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
            if (x1 == x2) {
                if (y1 < y2) {
                    g.drawLine(x2, y2, x2 + 4, y2 - 8);
                    g.drawLine(x2, y2, x2 - 4, y2 - 8);
                } else {
                    g.drawLine(x2, y2, x2 + 4, y2 + 8);
                    g.drawLine(x2, y2, x2 - 4, y2 + 8);
                }
            } else {
                double theta;
                double hyp = 0.0;
                double base = 0.0;
                double perp = 0.0;
                int x3 = 0;
                int y3 = 0;
                if (x2 < x1) {
                    base = x1 - x2;
                    hyp = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    theta = Math.acos(base / hyp);
                } else {
                    base = x1 - x2;
                    hyp = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    theta = Math.acos(base / hyp);
                }
                double beta = 0.5235987755982988;
                hyp = 8.0;
                base = Math.cos(theta - beta) * hyp;
                perp = Math.sin(theta - beta) * hyp;
                x3 = (int)((double)x2 + base);
                y3 = y1 < y2 ? (int)((double)y2 - perp) : (int)((double)y2 + perp);
                g.drawLine(x2, y2, x3, y3);
                base = Math.cos(theta + beta) * hyp;
                perp = Math.sin(theta + beta) * hyp;
                x3 = (int)((double)x2 + base);
                y3 = y1 < y2 ? (int)((double)y2 - perp) : (int)((double)y2 + perp);
                g.drawLine(x2, y2, x3, y3);
            }
        }

        public void highLight(GraphNode n) {
            Graphics2D g = (Graphics2D)this.getGraphics();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setRenderingHints(rh);
            g.setPaintMode();
            g.scale(GraphVisualizer.this.scale, GraphVisualizer.this.scale);
            int x = 0;
            int y = 0;
            Dimension d = this.getPreferredSize();
            if (d.width < this.getWidth()) {
                x = (int)((double)(x + this.getWidth() / 2 - d.width / 2) / GraphVisualizer.this.scale);
            }
            if (d.height < this.getHeight()) {
                y = (int)((double)(y + this.getHeight() / 2 - d.height / 2) / GraphVisualizer.this.scale);
            }
            if (n.nodeType == 3) {
                g.setXORMode(Color.green);
                g.fillOval(x + n.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, y + n.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                g.setXORMode(Color.red);
                if (GraphVisualizer.this.fm.stringWidth(n.lbl) <= GraphVisualizer.this.nodeWidth) {
                    g.drawString(n.lbl, x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(n.lbl) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                } else if (GraphVisualizer.this.fm.stringWidth(n.ID) <= GraphVisualizer.this.nodeWidth) {
                    g.drawString(n.ID, x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(n.ID) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                } else if (GraphVisualizer.this.fm.stringWidth(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(n))) <= GraphVisualizer.this.nodeWidth) {
                    g.drawString(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(n)), x + n.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(n))) / 2, y + n.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                }
                g.setXORMode(Color.green);
                if (n.edges != null) {
                    int k = 0;
                    while (k < n.edges.length) {
                        int m;
                        int y2;
                        int x2;
                        int y1;
                        int x1;
                        GraphNode n2;
                        if (n.edges[k][1] == 1 || n.edges[k][1] == 3) {
                            n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.edges[k][0]);
                            x1 = n.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            y1 = n.y + GraphVisualizer.this.nodeHeight;
                            x2 = n2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            y2 = n2.y;
                            g.drawLine(x + x1, y + y1, x + x2, y + y2);
                            if (n.edges[k][1] == 1) {
                                if (n2.nodeType == 3) {
                                    this.drawArrow(g, x + x1, y + y1, x + x2, y + y2);
                                }
                            } else if (n.edges[k][1] == 3) {
                                if (n.nodeType == 3) {
                                    this.drawArrow(g, x + x2, y + y2, x + x1, y + y1);
                                }
                                if (n2.nodeType == 3) {
                                    this.drawArrow(g, x + x1, y + y1, x + x2, y + y2);
                                }
                            }
                            if (n2.nodeType == 3) {
                                g.fillOval(x + n2.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, y + n2.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                            }
                            Vector<GraphNode> t = new Vector<GraphNode>();
                            while (n2.nodeType != 3 || t.size() > 0) {
                                if (t.size() > 0) {
                                    n2 = (GraphNode)t.elementAt(0);
                                    t.removeElementAt(0);
                                }
                                if (n2.nodeType == 3) continue;
                                g.drawLine(x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y, x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y + GraphVisualizer.this.nodeHeight);
                                x1 = n2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                                y1 = n2.y + GraphVisualizer.this.nodeHeight;
                                m = 0;
                                while (m < n2.edges.length) {
                                    if (n2.edges[m][1] > 0) {
                                        GraphNode n3 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n2.edges[m][0]);
                                        g.drawLine(x + x1, y + y1, x + n3.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n3.y);
                                        if (n3.nodeType == 3) {
                                            g.fillOval(x + n3.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, y + n3.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                                            this.drawArrow(g, x + x1, y + y1, x + n3.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n3.y);
                                        }
                                        t.addElement(n3);
                                    }
                                    ++m;
                                }
                            }
                        } else if (n.edges[k][1] == -2 || n.edges[k][1] == -3) {
                            n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.edges[k][0]);
                            x1 = n.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            y1 = n.y;
                            x2 = n2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                            y2 = n2.y + GraphVisualizer.this.nodeHeight;
                            g.drawLine(x + x1, y + y1, x + x2, y + y2);
                            if (n.edges[k][1] == -3) {
                                this.drawArrow(g, x + x2, y + y2, x + x1, y + y1);
                                if (n2.nodeType != 1) {
                                    this.drawArrow(g, x + x1, y + y1, x + x2, y + y2);
                                }
                            }
                            int tmpIndex = k;
                            block3: while (n2.nodeType != 3) {
                                g.drawLine(x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y + GraphVisualizer.this.nodeHeight, x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y);
                                x1 = n2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                                y1 = n2.y;
                                m = 0;
                                while (m < n2.edges.length) {
                                    if (n2.edges[m][1] < 0) {
                                        n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n2.edges[m][0]);
                                        g.drawLine(x + x1, y + y1, x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y + GraphVisualizer.this.nodeHeight);
                                        tmpIndex = m;
                                        if (n2.nodeType == 1) continue block3;
                                        this.drawArrow(g, x + x1, y + y1, x + n2.x + GraphVisualizer.this.paddedNodeWidth / 2, y + n2.y + GraphVisualizer.this.nodeHeight);
                                        continue block3;
                                    }
                                    ++m;
                                }
                            }
                        }
                        ++k;
                    }
                }
            }
        }
    }

    private class GraphVisualizerMouseListener
    extends MouseAdapter {
        int x;
        int y;
        int nx;
        int ny;
        Rectangle r;

        private GraphVisualizerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Dimension d = GraphVisualizer.this.m_gp.getPreferredSize();
            this.ny = 0;
            this.nx = 0;
            this.y = 0;
            this.x = 0;
            if (d.width < GraphVisualizer.this.m_gp.getWidth()) {
                this.nx = (int)((double)(this.nx + GraphVisualizer.this.m_gp.getWidth() / 2 - d.width / 2) / GraphVisualizer.this.scale);
            }
            if (d.height < GraphVisualizer.this.m_gp.getHeight()) {
                this.ny = (int)((double)(this.ny + GraphVisualizer.this.m_gp.getHeight() / 2 - d.height / 2) / GraphVisualizer.this.scale);
            }
            this.r = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            this.x += me.getX();
            this.y += me.getY();
            int i = 0;
            while (i < GraphVisualizer.this.m_nodes.size()) {
                GraphNode n = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                this.r.x = (int)((double)(this.nx + n.x) * GraphVisualizer.this.scale);
                this.r.y = (int)((double)(this.ny + n.y) * GraphVisualizer.this.scale);
                if (this.r.contains(this.x, this.y)) {
                    if (n.probs == null) {
                        return;
                    }
                    int noOfPrntsOutcomes = 1;
                    if (n.prnts != null) {
                        int j = 0;
                        while (j < n.prnts.length) {
                            GraphNode n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.prnts[j]);
                            noOfPrntsOutcomes *= n2.outcomes.length;
                            ++j;
                        }
                        if (noOfPrntsOutcomes > 511) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GraphVisualizer_GraphVisualizerMouseListener_MouseClicked_Error_Text_First"))).append(noOfPrntsOutcomes);
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("GraphVisualizer_GraphVisualizerMouseListener_MouseClicked_Error_Text_Second")).toString());
                            return;
                        }
                    }
                    GraphVisualizerTableModel tm = new GraphVisualizerTableModel(n.probs, n.outcomes);
                    JTable jTblProbs = new JTable(tm);
                    JScrollPane js = new JScrollPane(jTblProbs);
                    if (n.prnts != null) {
                        GraphNode n2;
                        GridBagConstraints gbc = new GridBagConstraints();
                        JPanel jPlRowHeader = new JPanel(new GridBagLayout());
                        int[] idx = new int[n.prnts.length];
                        int[] lengths = new int[n.prnts.length];
                        gbc.anchor = 18;
                        gbc.fill = 2;
                        gbc.insets = new Insets(0, 1, 0, 0);
                        int addNum = 0;
                        int temp = 0;
                        boolean dark = false;
                        do {
                            gbc.gridwidth = 1;
                            int k = 0;
                            while (k < n.prnts.length) {
                                n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.prnts[k]);
                                JLabel lb = new JLabel(n2.outcomes[idx[k]]);
                                lb.setFont(new Font("Dialog", 0, 12));
                                lb.setOpaque(true);
                                lb.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                                lb.setHorizontalAlignment(0);
                                if (dark) {
                                    lb.setBackground(lb.getBackground().darker());
                                    lb.setForeground(Color.white);
                                } else {
                                    lb.setForeground(Color.black);
                                }
                                temp = lb.getPreferredSize().width;
                                lb.setPreferredSize(new Dimension(temp, jTblProbs.getRowHeight()));
                                if (lengths[k] < temp) {
                                    lengths[k] = temp;
                                }
                                temp = 0;
                                if (k == n.prnts.length - 1) {
                                    gbc.gridwidth = 0;
                                    dark = !dark;
                                }
                                jPlRowHeader.add((Component)lb, gbc);
                                ++addNum;
                                ++k;
                            }
                            k = n.prnts.length - 1;
                            while (k >= 0) {
                                n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.prnts[k]);
                                if (idx[k] != n2.outcomes.length - 1 || k == 0) {
                                    int n3 = k;
                                    idx[n3] = idx[n3] + 1;
                                    break;
                                }
                                idx[k] = 0;
                                --k;
                            }
                            n2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n.prnts[0]);
                        } while (idx[0] != n2.outcomes.length);
                        JLabel lb = (JLabel)jPlRowHeader.getComponent(addNum - 1);
                        jPlRowHeader.remove(addNum - 1);
                        lb.setPreferredSize(new Dimension(lb.getPreferredSize().width, jTblProbs.getRowHeight()));
                        gbc.gridwidth = 0;
                        gbc.weighty = 1.0;
                        jPlRowHeader.add((Component)lb, gbc);
                        gbc.weighty = 0.0;
                        gbc.gridwidth = 1;
                        JPanel jPlRowNames = new JPanel(new GridBagLayout());
                        int j = 0;
                        while (j < n.prnts.length) {
                            JLabel lb1 = new JLabel(((GraphNode)GraphVisualizer.this.m_nodes.elementAt((int)n.prnts[j])).lbl);
                            lb1.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                            Dimension tempd = lb1.getPreferredSize();
                            if (tempd.width < lengths[j]) {
                                lb1.setPreferredSize(new Dimension(lengths[j], tempd.height));
                                lb1.setHorizontalAlignment(0);
                                lb1.setMinimumSize(new Dimension(lengths[j], tempd.height));
                            } else if (tempd.width > lengths[j]) {
                                JLabel lb2 = (JLabel)jPlRowHeader.getComponent(j);
                                lb2.setPreferredSize(new Dimension(tempd.width, lb2.getPreferredSize().height));
                            }
                            jPlRowNames.add((Component)lb1, gbc);
                            ++j;
                        }
                        js.setRowHeaderView(jPlRowHeader);
                        js.setCorner("UPPER_LEFT_CORNER", jPlRowNames);
                    }
                    Frame frame = (Frame)GraphVisualizer.this.getTopLevelAncestor();
                    Messages.getInstance();
                    JDialog jd = new JDialog((Window)frame, String.valueOf(Messages.getString("GraphVisualizer_Main_Jd_JDialog_Text")) + n.lbl, Dialog.ModalityType.DOCUMENT_MODAL);
                    jd.setSize(500, 400);
                    jd.setLocation(GraphVisualizer.this.getLocation().x + GraphVisualizer.this.getWidth() / 2 - 250, GraphVisualizer.this.getLocation().y + GraphVisualizer.this.getHeight() / 2 - 200);
                    jd.getContentPane().setLayout(new BorderLayout());
                    jd.getContentPane().add((Component)js, "Center");
                    jd.setVisible(true);
                    return;
                }
                ++i;
            }
        }
    }

    private class GraphVisualizerMouseMotionListener
    extends MouseMotionAdapter {
        int x;
        int y;
        int nx;
        int ny;
        Rectangle r;
        GraphNode lastNode;

        private GraphVisualizerMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            Dimension d = GraphVisualizer.this.m_gp.getPreferredSize();
            this.ny = 0;
            this.nx = 0;
            this.y = 0;
            this.x = 0;
            if (d.width < GraphVisualizer.this.m_gp.getWidth()) {
                this.nx = (int)((double)(this.nx + GraphVisualizer.this.m_gp.getWidth() / 2 - d.width / 2) / GraphVisualizer.this.scale);
            }
            if (d.height < GraphVisualizer.this.m_gp.getHeight()) {
                this.ny = (int)((double)(this.ny + GraphVisualizer.this.m_gp.getHeight() / 2 - d.height / 2) / GraphVisualizer.this.scale);
            }
            this.r = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            this.x += me.getX();
            this.y += me.getY();
            int i = 0;
            while (i < GraphVisualizer.this.m_nodes.size()) {
                GraphNode n = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                this.r.x = (int)((double)(this.nx + n.x) * GraphVisualizer.this.scale);
                this.r.y = (int)((double)(this.ny + n.y) * GraphVisualizer.this.scale);
                if (this.r.contains(this.x, this.y)) {
                    if (n == this.lastNode) break;
                    GraphVisualizer.this.m_gp.highLight(n);
                    if (this.lastNode != null) {
                        GraphVisualizer.this.m_gp.highLight(this.lastNode);
                    }
                    this.lastNode = n;
                    break;
                }
                ++i;
            }
            if (i == GraphVisualizer.this.m_nodes.size() && this.lastNode != null) {
                GraphVisualizer.this.m_gp.repaint();
                this.lastNode = null;
            }
        }
    }

    private class GraphVisualizerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4789813491347366596L;
        final String[] columnNames;
        final double[][] data;

        public GraphVisualizerTableModel(double[][] d, String[] c) {
            this.data = d;
            this.columnNames = c;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return new Double(this.data[row][col]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

