/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.classifiers.meta.AttributeSelectedClassifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.Messages;
import weka.gui.visualize.MatrixPanel;

public class AttributeSelectionPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = 5627185966993476142L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_AttributeEvaluatorEditor = new GenericObjectEditor();
    protected GenericObjectEditor m_AttributeSearchEditor = new GenericObjectEditor();
    protected PropertyPanel m_AEEPanel = new PropertyPanel(this.m_AttributeEvaluatorEditor);
    protected PropertyPanel m_ASEPanel = new PropertyPanel(this.m_AttributeSearchEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JRadioButton m_CVBut;
    protected JRadioButton m_TrainBut;
    protected JLabel m_CVLab;
    protected JTextField m_CVText;
    protected JLabel m_SeedLab;
    protected JTextField m_SeedText;
    ActionListener m_RadioListener;
    protected JButton m_StartBut;
    protected JButton m_StopBut;
    private Dimension COMBO_SIZE;
    protected Instances m_Instances;
    protected Thread m_RunThread;

    static {
        GenericObjectEditor.registerEditors();
    }

    public AttributeSelectionPanel() {
        Messages.getInstance();
        this.m_CVBut = new JRadioButton(Messages.getString("AttributeSelectionPanel_CVBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_TrainBut = new JRadioButton(Messages.getString("AttributeSelectionPanel_TrainBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_CVLab = new JLabel(Messages.getString("AttributeSelectionPanel_CVLab_JLabel_Text"), 4);
        Messages.getInstance();
        this.m_CVText = new JTextField(Messages.getString("AttributeSelectionPanel_CVText_JTextField_Text"));
        Messages.getInstance();
        this.m_SeedLab = new JLabel(Messages.getString("AttributeSelectionPanel_SeedLab_JLabel_Text"), 4);
        Messages.getInstance();
        this.m_SeedText = new JTextField(Messages.getString("AttributeSelectionPanel_SeedText_JTextField_Text"));
        this.m_RadioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.updateRadioLinks();
            }
        };
        Messages.getInstance();
        this.m_StartBut = new JButton(Messages.getString("AttributeSelectionPanel_StartBut_JButton_Text"));
        Messages.getInstance();
        this.m_StopBut = new JButton(Messages.getString("AttributeSelectionPanel_StopBut_JButton_Text"));
        this.COMBO_SIZE = new Dimension(150, this.m_StartBut.getPreferredSize().height);
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AttributeSelectionPanel.this.m_OutText.selectAll();
                }
            }
        });
        Messages.getInstance();
        this.m_History.setBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSelectionPanel_History_BorderFactoryCreateTitledBorder_Text")));
        this.m_AttributeEvaluatorEditor.setClassType(ASEvaluation.class);
        this.m_AttributeEvaluatorEditor.setValue(ExplorerDefaults.getASEvaluator());
        this.m_AttributeEvaluatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int result;
                Object backup;
                if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    if (!(AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker)) {
                        backup = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                        Messages.getInstance();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_First"))).append(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName());
                        Messages.getInstance();
                        String string = stringBuilder.append(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Second")).toString();
                        Messages.getInstance();
                        result = JOptionPane.showConfirmDialog(null, string, Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Third"), 0);
                        if (result == 0) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new Ranker());
                        } else if (backup != null) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(backup);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    backup = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                    Messages.getInstance();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Fourth"))).append(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName());
                    Messages.getInstance();
                    String string = stringBuilder.append(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Fifth")).toString();
                    Messages.getInstance();
                    result = JOptionPane.showConfirmDialog(null, string, Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Sixth"), 0);
                    if (result == 0) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new GreedyStepwise());
                    } else if (backup != null) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(backup);
                    }
                }
                AttributeSelectionPanel.this.updateRadioLinks();
                AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getCapabilitiesFilter();
                ASEvaluation evaluator = (ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (evaluator != null && currentFilter != null && evaluator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = evaluator.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    AttributeSelectionPanel.this.m_StartBut.setEnabled(false);
                }
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_AttributeSearchEditor.setClassType(ASSearch.class);
        this.m_AttributeSearchEditor.setValue(ExplorerDefaults.getASSearch());
        this.m_AttributeSearchEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    if (!(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator)) {
                        Object backup = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                        Messages.getInstance();
                        String string = Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Seventh");
                        Messages.getInstance();
                        int result = JOptionPane.showConfirmDialog(null, string, Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Eigth"), 0);
                        if (result == 0) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new InfoGainAttributeEval());
                        } else if (backup != null) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(backup);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    Object backup = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                    Messages.getInstance();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Nineth"))).append(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName());
                    Messages.getInstance();
                    String string = stringBuilder.append(Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Tenth")).toString();
                    Messages.getInstance();
                    int result = JOptionPane.showConfirmDialog(null, string, Messages.getString("AttributeSelectionPanel_Result_JOptionPaneShowConfirmDialog_Text_Eleventh"), 0);
                    if (result == 0) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new CfsSubsetEval());
                    } else if (backup != null) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(backup);
                    }
                }
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.updateCapabilitiesFilter(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getCapabilitiesFilter());
            }
        });
        Messages.getInstance();
        this.m_ClassCombo.setToolTipText(Messages.getString("AttributeSelectionPanel_ClassCombo_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_TrainBut.setToolTipText(Messages.getString("AttributeSelectionPanel_TrainBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_CVBut.setToolTipText(Messages.getString("AttributeSelectionPanel_CVBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_StartBut.setToolTipText(Messages.getString("AttributeSelectionPanel_StartBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_StopBut.setToolTipText(Messages.getString("AttributeSelectionPanel_StopBut_SetToolTipText_Text"));
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_History.setPreferredSize(this.COMBO_SIZE);
        this.m_History.setMaximumSize(this.COMBO_SIZE);
        this.m_History.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_TrainBut.setSelected(ExplorerDefaults.getASTestMode() == 0);
        this.m_CVBut.setSelected(ExplorerDefaults.getASTestMode() == 1);
        this.updateRadioLinks();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_TrainBut);
        bg.add(this.m_CVBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_CVBut.addActionListener(this.m_RadioListener);
        this.m_CVText.setText("" + ExplorerDefaults.getASCrossvalidationFolds());
        this.m_SeedText.setText("" + ExplorerDefaults.getASRandomSeed());
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.startAttributeSelection();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.stopAttributeSelection();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AttributeSelectionPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = AttributeSelectionPanel.this.m_History.getNameAtIndex(index);
                        AttributeSelectionPanel.this.visualize(name, e.getX(), e.getY());
                    } else {
                        AttributeSelectionPanel.this.visualize(null, e.getX(), e.getY());
                    }
                }
            }
        });
        JPanel p1 = new JPanel();
        Messages.getInstance();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSelectionPanel_P1_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_AEEPanel, "North");
        JPanel p1_1 = new JPanel();
        Messages.getInstance();
        p1_1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSelectionPanel_P1_1_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1_1.setLayout(new BorderLayout());
        p1_1.add((Component)this.m_ASEPanel, "North");
        JPanel p_new = new JPanel();
        p_new.setLayout(new BorderLayout());
        p_new.add((Component)p1, "North");
        p_new.add((Component)p1_1, "Center");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        Messages.getInstance();
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSelectionPanel_P2_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TrainBut, gbC);
        p2.add(this.m_TrainBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 4;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_CVBut, gbC);
        p2.add(this.m_CVBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 4;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_CVLab, gbC);
        p2.add(this.m_CVLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 4;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_CVText, gbC);
        p2.add(this.m_CVText);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 6;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_SeedLab, gbC);
        p2.add(this.m_SeedLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 6;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_SeedText, gbC);
        p2.add(this.m_SeedText);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 2));
        buttons.add(this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        Messages.getInstance();
        p3.setBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSelectionPanel_P3_BorderFactoryCreateTitledBorder_Text")));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p_new, "North");
        this.add((Component)mondo, "Center");
    }

    protected void updateRadioLinks() {
        this.m_CVBut.setEnabled(true);
        this.m_CVText.setEnabled(this.m_CVBut.isSelected());
        this.m_CVLab.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedText.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedLab.setEnabled(this.m_CVBut.isSelected());
        if (this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeTransformer) {
            this.m_CVBut.setSelected(false);
            this.m_CVBut.setEnabled(false);
            this.m_CVText.setEnabled(false);
            this.m_CVLab.setEnabled(false);
            this.m_SeedText.setEnabled(false);
            this.m_SeedLab.setEnabled(false);
            this.m_TrainBut.setSelected(true);
        }
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes() + 1];
        attribNames[0] = "No class";
        int i = 0;
        while (i < inst.numAttributes()) {
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeNOMINAL_Type_Text");
                    break;
                }
                case 0: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeNUMERIC_Type_Text");
                    break;
                }
                case 2: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeSTRING_Type_Text");
                    break;
                }
                case 3: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeDATE_Type_Text");
                    break;
                }
                case 4: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeRELATIONAL_Type_Text");
                    break;
                }
                default: {
                    Messages.getInstance();
                    type = Messages.getString("AttributeSelectionPanel_SetInstances_AttributeDEFAULT_Type_Text");
                }
            }
            String attnm = this.m_Instances.attribute(i).name();
            attribNames[i + 1] = String.valueOf(type) + attnm;
            ++i;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (inst.classIndex() == -1) {
            this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
        } else {
            this.m_ClassCombo.setSelectedIndex(inst.classIndex());
        }
        this.m_ClassCombo.setEnabled(true);
    }

    protected void startAttributeSelection() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                @Override
                public void run() {
                    Logger logger = AttributeSelectionPanel.this.m_Log;
                    Messages.getInstance();
                    logger.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_First"));
                    Instances inst = new Instances(AttributeSelectionPanel.this.m_Instances);
                    int testMode = 0;
                    int numFolds = 10;
                    int seed = 1;
                    int classIndex = AttributeSelectionPanel.this.m_ClassCombo.getSelectedIndex() - 1;
                    ASEvaluation evaluator = (ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue();
                    ASSearch search = (ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue();
                    StringBuffer outBuff = new StringBuffer();
                    String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                    String sname = search.getClass().getName();
                    name = sname.startsWith("weka.attributeSelection.") ? String.valueOf(name) + sname.substring("weka.attributeSelection.".length()) : String.valueOf(name) + sname;
                    String ename = evaluator.getClass().getName();
                    name = ename.startsWith("weka.attributeSelection.") ? String.valueOf(name) + " + " + ename.substring("weka.attributeSelection.".length()) : String.valueOf(name) + " + " + ename;
                    Vector<String> list = new Vector<String>();
                    list.add("-s");
                    if (search instanceof OptionHandler) {
                        list.add(String.valueOf(sname) + " " + Utils.joinOptions(((OptionHandler)((Object)search)).getOptions()));
                    } else {
                        list.add(sname);
                    }
                    if (evaluator instanceof OptionHandler) {
                        String[] opt = ((OptionHandler)((Object)evaluator)).getOptions();
                        int i = 0;
                        while (i < opt.length) {
                            list.add(opt[i]);
                            ++i;
                        }
                    }
                    String cmd = String.valueOf(ename) + " " + Utils.joinOptions(list.toArray(new String[list.size()]));
                    AttributeSelection filter = new AttributeSelection();
                    filter.setEvaluator((ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue());
                    filter.setSearch((ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue());
                    String cmdFilter = String.valueOf(filter.getClass().getName()) + " " + Utils.joinOptions(filter.getOptions());
                    AttributeSelectedClassifier cls = new AttributeSelectedClassifier();
                    cls.setEvaluator((ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue());
                    cls.setSearch((ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue());
                    String cmdClassifier = String.valueOf(cls.getClass().getName()) + " " + Utils.joinOptions(cls.getOptions());
                    weka.attributeSelection.AttributeSelection eval = null;
                    try {
                        try {
                            String[] o;
                            if (AttributeSelectionPanel.this.m_CVBut.isSelected()) {
                                testMode = 1;
                                numFolds = Integer.parseInt(AttributeSelectionPanel.this.m_CVText.getText());
                                seed = Integer.parseInt(AttributeSelectionPanel.this.m_SeedText.getText());
                                if (numFolds <= 1) {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Exception_Text_First"));
                                }
                            }
                            if (classIndex >= 0) {
                                inst.setClassIndex(classIndex);
                            }
                            Logger logger2 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger2.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_First")) + ename);
                            Logger logger3 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger3.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Second")) + cmd);
                            Logger logger4 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger4.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Third")) + cmdFilter);
                            Logger logger5 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger5.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Fourth")) + cmdClassifier);
                            if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskStarted();
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_First"));
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Second")) + ename);
                            if (evaluator instanceof OptionHandler) {
                                o = ((OptionHandler)((Object)evaluator)).getOptions();
                                outBuff.append(" " + Utils.joinOptions(o));
                            }
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Third")) + sname);
                            if (search instanceof OptionHandler) {
                                o = ((OptionHandler)((Object)search)).getOptions();
                                outBuff.append(" " + Utils.joinOptions(o));
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Fourth"));
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Fifth")) + inst.relationName() + '\n');
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Sixth")) + inst.numInstances() + '\n');
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Seventh")) + inst.numAttributes() + '\n');
                            if (inst.numAttributes() < 100) {
                                int i = 0;
                                while (i < inst.numAttributes()) {
                                    outBuff.append("              " + inst.attribute(i).name() + '\n');
                                    ++i;
                                }
                            } else {
                                Messages.getInstance();
                                outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Eigth"));
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Nineth"));
                            switch (testMode) {
                                case 0: {
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Tenth"));
                                    break;
                                }
                                case 1: {
                                    StringBuilder stringBuilder = new StringBuilder().append(numFolds);
                                    Messages.getInstance();
                                    outBuff.append(stringBuilder.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Eleventh")).toString());
                                }
                            }
                            outBuff.append("\n");
                            AttributeSelectionPanel.this.m_History.addResult(name, outBuff);
                            AttributeSelectionPanel.this.m_History.setSingle(name);
                            Logger logger6 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger6.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text"));
                            AttributeSelectionPanel.this.m_History.updateResult(name);
                            eval = new weka.attributeSelection.AttributeSelection();
                            eval.setEvaluator(evaluator);
                            eval.setSearch(search);
                            eval.setFolds(numFolds);
                            eval.setSeed(seed);
                            if (testMode == 1) {
                                eval.setXval(true);
                            }
                            switch (testMode) {
                                case 0: {
                                    Logger logger7 = AttributeSelectionPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger7.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_First"));
                                    eval.SelectAttributes(inst);
                                    break;
                                }
                                case 1: {
                                    Logger logger8 = AttributeSelectionPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger8.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Second"));
                                    Random random = new Random(seed);
                                    inst.randomize(random);
                                    if (inst.attribute(classIndex).isNominal()) {
                                        Logger logger9 = AttributeSelectionPanel.this.m_Log;
                                        Messages.getInstance();
                                        logger9.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Third"));
                                        inst.stratify(numFolds);
                                    }
                                    int fold = 0;
                                    while (fold < numFolds) {
                                        Logger logger10 = AttributeSelectionPanel.this.m_Log;
                                        Messages.getInstance();
                                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Fourth"))).append(fold + 1);
                                        Messages.getInstance();
                                        logger10.statusMessage(stringBuilder.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Fifth")).toString());
                                        Instances train = inst.trainCV(numFolds, fold, random);
                                        Logger logger11 = AttributeSelectionPanel.this.m_Log;
                                        Messages.getInstance();
                                        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Sixth"))).append(fold + 1);
                                        Messages.getInstance();
                                        logger11.statusMessage(stringBuilder2.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Seventh")).toString());
                                        eval.selectAttributesCVSplit(train);
                                        ++fold;
                                    }
                                    break;
                                }
                                default: {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Exception_Text_Second"));
                                }
                            }
                            if (testMode == 0) {
                                outBuff.append(eval.toResultsString());
                            } else {
                                outBuff.append(eval.CVResultsString());
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_OutBuffer_Text_Thirteenth"));
                            AttributeSelectionPanel.this.m_History.updateResult(name);
                            Logger logger12 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger12.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Fifth")) + ename + " " + sname);
                            Logger logger13 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger13.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Eigth"));
                        }
                        catch (Exception ex) {
                            AttributeSelectionPanel.this.m_Log.logMessage(ex.getMessage());
                            Logger logger14 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger14.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Ninth"));
                            if (evaluator instanceof AttributeTransformer) {
                                try {
                                    Instances transformed = ((AttributeTransformer)((Object)evaluator)).transformedData(inst);
                                    Messages.getInstance();
                                    transformed.setRelationName(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Transformed_SetRelationName_Text")) + transformed.relationName());
                                    FastVector vv = new FastVector();
                                    vv.addElement(transformed);
                                    AttributeSelectionPanel.this.m_History.addObject(name, vv);
                                }
                                catch (Exception ex2) {
                                    System.err.println(ex2);
                                    ex2.printStackTrace();
                                }
                            } else if (testMode == 0) {
                                try {
                                    Instances reducedInst = eval.reduceDimensionality(inst);
                                    FastVector vv = new FastVector();
                                    vv.addElement(reducedInst);
                                    AttributeSelectionPanel.this.m_History.addObject(name, vv);
                                }
                                catch (Exception ex3) {
                                    ex3.printStackTrace();
                                }
                            }
                            if (this.isInterrupted()) {
                                Logger logger15 = AttributeSelectionPanel.this.m_Log;
                                Messages.getInstance();
                                logger15.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Sixth")) + ename + " " + sname);
                                Logger logger16 = AttributeSelectionPanel.this.m_Log;
                                Messages.getInstance();
                                logger16.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Tenth"));
                            }
                            AttributeSelectionPanel.this.m_RunThread = null;
                            AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                            AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                            if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    finally {
                        if (evaluator instanceof AttributeTransformer) {
                            try {
                                Instances transformed = ((AttributeTransformer)((Object)evaluator)).transformedData(inst);
                                Messages.getInstance();
                                transformed.setRelationName(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Transformed_SetRelationName_Text")) + transformed.relationName());
                                FastVector vv = new FastVector();
                                vv.addElement(transformed);
                                AttributeSelectionPanel.this.m_History.addObject(name, vv);
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                            }
                        } else if (testMode == 0) {
                            try {
                                Instances reducedInst = eval.reduceDimensionality(inst);
                                FastVector vv = new FastVector();
                                vv.addElement(reducedInst);
                                AttributeSelectionPanel.this.m_History.addObject(name, vv);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (this.isInterrupted()) {
                            Logger logger17 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger17.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_LogMessage_Text_Sixth")) + ename + " " + sname);
                            Logger logger18 = AttributeSelectionPanel.this.m_Log;
                            Messages.getInstance();
                            logger18.statusMessage(Messages.getString("AttributeSelectionPanel_StartAttributeSelection_Run_Log_StatusMessage_Text_Tenth"));
                        }
                        AttributeSelectionPanel.this.m_RunThread = null;
                        AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                        AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                        if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAttributeSelection() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            Messages.getInstance();
            this.m_Log.logMessage(Messages.getString("AttributeSelectionPanel_SaveBuffer_Log_LogMessage_Text"));
        }
    }

    protected void visualizeTransformedData(Instances ti) {
        if (ti != null) {
            MatrixPanel mp = new MatrixPanel();
            mp.setInstances(ti);
            String plotName = ti.relationName();
            Messages.getInstance();
            final JFrame jf = new JFrame(String.valueOf(Messages.getString("AttributeSelectionPanel_VisualizeTransformedData_JFrame_Text")) + plotName);
            jf.setSize(800, 600);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)mp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
    }

    protected void saveTransformedData(Instances ti) {
        JFileChooser fc = new JFileChooser();
        Messages.getInstance();
        ExtensionFileFilter filter = new ExtensionFileFilter(".arff", Messages.getString("AttributeSelectionPanel_SaveTransformedData_Filter_Text"));
        fc.setFileFilter(filter);
        int retVal = fc.showSaveDialog(this);
        if (retVal == 0) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(fc.getSelectedFile()));
                writer.write(ti.toString());
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                Messages.getInstance();
                this.m_Log.logMessage(String.valueOf(Messages.getString("AttributeSelectionPanel_SaveTransformedData_Log_LogMessage_Text")) + e.getMessage());
                Messages.getInstance();
                String string = String.valueOf(Messages.getString("AttributeSelectionPanel_SaveTransformedData_JOptionPaneShowMessageDialog_Text_First")) + e.getMessage();
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("AttributeSelectionPanel_SaveTransformedData_JOptionPaneShowMessageDialog_Text_Second"), 0);
            }
        }
    }

    protected void visualize(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        Messages.getInstance();
        JMenuItem visMainBuffer = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_VisMainBuffer_JMenuItem_Text"));
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        Messages.getInstance();
        JMenuItem visSepBuffer = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_VisSepBuffer_JMenuItem_Text"));
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        Messages.getInstance();
        JMenuItem saveOutput = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_SaveOutput_JMenuItem_Text"));
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        Messages.getInstance();
        JMenuItem deleteOutput = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_DeleteOutput_JMenuItem_Text"));
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        FastVector o = null;
        if (selectedName != null) {
            o = (FastVector)this.m_History.getNamedObject(selectedName);
        }
        Instances tempTransformed = null;
        if (o != null) {
            int i = 0;
            while (i < o.size()) {
                Object temp = o.elementAt(i);
                if (temp instanceof Instances) {
                    tempTransformed = (Instances)temp;
                }
                ++i;
            }
        }
        final Instances ti = tempTransformed;
        AbstractButton visTrans = null;
        if (ti != null) {
            String string = ti.relationName();
            Messages.getInstance();
            if (string.startsWith(Messages.getString("AttributeSelectionPanel_Visualize_RelationName_Text_First"))) {
                Messages.getInstance();
                visTrans = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_VisTrans_JMenuItem_Text_First"));
            } else {
                Messages.getInstance();
                visTrans = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_VisTrans_JMenuItem_Text_Second"));
            }
            resultListMenu.addSeparator();
        }
        if (ti != null && visTrans != null) {
            visTrans.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.visualizeTransformedData(ti);
                }
            });
        }
        if (visTrans != null) {
            resultListMenu.add((JMenuItem)visTrans);
        }
        AbstractButton saveTrans = null;
        if (ti != null) {
            String string = ti.relationName();
            Messages.getInstance();
            if (string.startsWith(Messages.getString("AttributeSelectionPanel_Visualize_RelationName_Text_Second"))) {
                Messages.getInstance();
                saveTrans = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_SaveTrans_JMenuItem_Text_First"));
            } else {
                Messages.getInstance();
                saveTrans = new JMenuItem(Messages.getString("AttributeSelectionPanel_Visualize_SaveTrans_JMenuItem_Text_Second"));
            }
        }
        if (saveTrans != null) {
            saveTrans.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.saveTransformedData(ti);
                }
            });
            resultListMenu.add((JMenuItem)saveTrans);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_AttributeEvaluatorEditor.setCapabilitiesFilter(new Capabilities(null));
            this.m_AttributeSearchEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        int clIndex = this.m_ClassCombo.getSelectedIndex() - 1;
        if (clIndex >= 0) {
            tempInst.setClassIndex(clIndex);
        }
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_AttributeEvaluatorEditor.setCapabilitiesFilter(filterClass);
        this.m_AttributeSearchEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_AttributeEvaluatorEditor.getCapabilitiesFilter();
        ASEvaluation evaluator = (ASEvaluation)this.m_AttributeEvaluatorEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (evaluator != null && currentFilter != null && evaluator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = evaluator.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        Messages.getInstance();
        return Messages.getString("AttributeSelectionPanel_GetTabTitle_Text");
    }

    @Override
    public String getTabTitleToolTip() {
        Messages.getInstance();
        return Messages.getString("AttributeSelectionPanel_GetTabTitleToolTip_Text");
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("AttributeSelectionPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            AttributeSelectionPanel sp = new AttributeSelectionPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("AttributeSelectionPanel_Main_Error_Text")) + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

