/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.associations.Associator;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.Messages;

public class AssociationsPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -6867871711865476971L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_AssociatorEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_AssociatorEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JButton m_StartBut;
    protected JButton m_StopBut;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected Thread m_RunThread;

    static {
        GenericObjectEditor.registerEditors();
    }

    public AssociationsPanel() {
        Messages.getInstance();
        this.m_StartBut = new JButton(Messages.getString("AssociationsPanel_StartBut_JButton_Text"));
        Messages.getInstance();
        this.m_StopBut = new JButton(Messages.getString("AssociationsPanel_StopBut_JButton_Text"));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AssociationsPanel.this.m_OutText.selectAll();
                }
            }
        });
        Messages.getInstance();
        this.m_History.setBorder(BorderFactory.createTitledBorder(Messages.getString("AssociationsPanel_MouseClicked_History_BorderFactoryCreateTitledBorder_Text")));
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AssociationsPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = AssociationsPanel.this.m_History.getNameAtIndex(index);
                        AssociationsPanel.this.historyRightClickPopup(name, e.getX(), e.getY());
                    } else {
                        AssociationsPanel.this.historyRightClickPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_AssociatorEditor.setClassType(Associator.class);
        this.m_AssociatorEditor.setValue(ExplorerDefaults.getAssociator());
        this.m_AssociatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AssociationsPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = AssociationsPanel.this.m_AssociatorEditor.getCapabilitiesFilter();
                Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    AssociationsPanel.this.m_StartBut.setEnabled(false);
                }
                AssociationsPanel.this.repaint();
            }
        });
        Messages.getInstance();
        this.m_StartBut.setToolTipText(Messages.getString("AssociationsPanel_StartBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_StopBut.setToolTipText(Messages.getString("AssociationsPanel_StopBut_SetToolTipText_Text"));
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationsPanel.this.startAssociator();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationsPanel.this.stopAssociator();
            }
        });
        JPanel p1 = new JPanel();
        Messages.getInstance();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("AssociationsPanel_P1_JPanel_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CEPanel, "North");
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        Messages.getInstance();
        p3.setBorder(BorderFactory.createTitledBorder(Messages.getString("AssociationsPanel_P3_JPanel_BorderFactoryCreateTitledBorder_Text")));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        GridBagLayout gbL = new GridBagLayout();
        GridBagConstraints gbC = new GridBagConstraints();
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        int i = 0;
        while (i < attribNames.length) {
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeNOMINAL_Text");
                    break;
                }
                case 0: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeNUMERIC_Text");
                    break;
                }
                case 2: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeSTRING_Text");
                    break;
                }
                case 3: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeDATE_Text");
                    break;
                }
                case 4: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeRELATIONAL_Text");
                    break;
                }
                default: {
                    Messages.getInstance();
                    type = Messages.getString("AssociationsPanel_SetInstances_AttributeDEFAULT_Text");
                }
            }
            attribNames[i] = String.valueOf(type) + this.m_Instances.attribute(i).name();
            ++i;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    protected void startAssociator() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                @Override
                public void run() {
                    Logger logger = AssociationsPanel.this.m_Log;
                    Messages.getInstance();
                    logger.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_First"));
                    Instances inst = new Instances(AssociationsPanel.this.m_Instances);
                    Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                    StringBuffer outBuff = new StringBuffer();
                    String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                    String cname = associator.getClass().getName();
                    name = cname.startsWith("weka.associations.") ? String.valueOf(name) + cname.substring("weka.associations.".length()) : String.valueOf(name) + cname;
                    String cmd = AssociationsPanel.this.m_AssociatorEditor.getValue().getClass().getName();
                    if (AssociationsPanel.this.m_AssociatorEditor.getValue() instanceof OptionHandler) {
                        cmd = String.valueOf(cmd) + " " + Utils.joinOptions(((OptionHandler)AssociationsPanel.this.m_AssociatorEditor.getValue()).getOptions());
                    }
                    try {
                        try {
                            Logger logger2 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger2.logMessage(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_LogMessage_Text_First")) + cname);
                            Logger logger3 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger3.logMessage(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_LogMessage_Text_Second")) + cmd);
                            if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskStarted();
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_First"));
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Second")) + cname);
                            if (associator instanceof OptionHandler) {
                                String[] o = ((OptionHandler)((Object)associator)).getOptions();
                                outBuff.append(" " + Utils.joinOptions(o));
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Third"));
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Fourth")) + inst.relationName() + '\n');
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Sixth")) + inst.numInstances() + '\n');
                            Messages.getInstance();
                            outBuff.append(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Seventh")) + inst.numAttributes() + '\n');
                            if (inst.numAttributes() < 100) {
                                int i = 0;
                                while (i < inst.numAttributes()) {
                                    outBuff.append("              " + inst.attribute(i).name() + '\n');
                                    ++i;
                                }
                            } else {
                                Messages.getInstance();
                                outBuff.append(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Eighth"));
                            }
                            AssociationsPanel.this.m_History.addResult(name, outBuff);
                            AssociationsPanel.this.m_History.setSingle(name);
                            Logger logger4 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger4.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_Second"));
                            associator.buildAssociations(inst);
                            Messages.getInstance();
                            outBuff.append(Messages.getString("AssociationsPanel_StartAssociator_Run_OutBuffer_Text_Nineth"));
                            outBuff.append(String.valueOf(associator.toString()) + '\n');
                            AssociationsPanel.this.m_History.updateResult(name);
                            Logger logger5 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger5.logMessage(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_LogMessage_Text_Third")) + cname);
                            Logger logger6 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger6.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_Third"));
                        }
                        catch (Exception ex) {
                            AssociationsPanel.this.m_Log.logMessage(ex.getMessage());
                            Logger logger7 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger7.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_Fourth"));
                            if (this.isInterrupted()) {
                                Logger logger8 = AssociationsPanel.this.m_Log;
                                Messages.getInstance();
                                logger8.logMessage(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_LogMessage_Text_Fourth")) + cname);
                                Logger logger9 = AssociationsPanel.this.m_Log;
                                Messages.getInstance();
                                logger9.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_Fifth"));
                            }
                            AssociationsPanel.this.m_RunThread = null;
                            AssociationsPanel.this.m_StartBut.setEnabled(true);
                            AssociationsPanel.this.m_StopBut.setEnabled(false);
                            if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    finally {
                        if (this.isInterrupted()) {
                            Logger logger10 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger10.logMessage(String.valueOf(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_LogMessage_Text_Fourth")) + cname);
                            Logger logger11 = AssociationsPanel.this.m_Log;
                            Messages.getInstance();
                            logger11.statusMessage(Messages.getString("AssociationsPanel_StartAssociator_Run_Log_StatusMessage_Text_Fifth"));
                        }
                        AssociationsPanel.this.m_RunThread = null;
                        AssociationsPanel.this.m_StartBut.setEnabled(true);
                        AssociationsPanel.this.m_StopBut.setEnabled(false);
                        if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAssociator() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            Messages.getInstance();
            this.m_Log.logMessage(Messages.getString("AssociationsPanel_SaveBuffer_Log_LogMessage_Text"));
        }
    }

    protected void historyRightClickPopup(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        Messages.getInstance();
        JMenuItem visMainBuffer = new JMenuItem(Messages.getString("AssociationsPanel_HistoryRightClickPopup_VisMainBuffer_JPopupMenu_Text"));
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        Messages.getInstance();
        JMenuItem visSepBuffer = new JMenuItem(Messages.getString("AssociationsPanel_HistoryRightClickPopup_VisSepBuffer_JMenuItem_Text"));
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        Messages.getInstance();
        JMenuItem saveOutput = new JMenuItem(Messages.getString("AssociationsPanel_HistoryRightClickPopup_SaveOutput_JMenuItem_Text"));
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        Messages.getInstance();
        JMenuItem deleteOutput = new JMenuItem(Messages.getString("AssociationsPanel_HistoryRightClickPopup_DeleteOutput_JMenuItem_Text"));
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_AssociatorEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(-1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_AssociatorEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_AssociatorEditor.getCapabilitiesFilter();
        Associator associator = (Associator)this.m_AssociatorEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        Messages.getInstance();
        return Messages.getString("AssociationsPanel_GetTabTitle_Text");
    }

    @Override
    public String getTabTitleToolTip() {
        Messages.getInstance();
        return Messages.getString("AssociationsPanel_GetTabTitleToolTip_Text");
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("AssociationsPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            AssociationsPanel sp = new AssociationsPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("AssociationsPanel_Main_Error_Text")) + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

