/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.HostListPanel;
import weka.gui.experiment.Messages;

public class DistributeExperimentPanel
extends JPanel {
    private static final long serialVersionUID = 5206721431754800278L;
    RemoteExperiment m_Exp = null;
    protected JCheckBox m_enableDistributedExperiment = new JCheckBox();
    protected JButton m_configureHostNames;
    protected HostListPanel m_hostList;
    protected JRadioButton m_splitByDataSet;
    protected JRadioButton m_splitByRun;
    ActionListener m_radioListener;

    public DistributeExperimentPanel() {
        Messages.getInstance();
        this.m_configureHostNames = new JButton(Messages.getString("DistributeExperimentPanel_ConfigureHostNames_JButton_Text"));
        this.m_hostList = new HostListPanel();
        Messages.getInstance();
        this.m_splitByDataSet = new JRadioButton(Messages.getString("DistributeExperimentPanel_SplitByDataSet_JRadioButton_Text"));
        Messages.getInstance();
        this.m_splitByRun = new JRadioButton(Messages.getString("DistributeExperimentPanel_SplitByRun_JRadioButton_Text"));
        this.m_radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributeExperimentPanel.this.updateRadioLinks();
            }
        };
        this.m_enableDistributedExperiment.setSelected(false);
        Messages.getInstance();
        this.m_enableDistributedExperiment.setToolTipText(Messages.getString("DistributeExperimentPanel_EnableDistributedExperiment_SetToolTipText_Text"));
        this.m_enableDistributedExperiment.setEnabled(false);
        this.m_configureHostNames.setEnabled(false);
        Messages.getInstance();
        this.m_configureHostNames.setToolTipText(Messages.getString("DistributeExperimentPanel_ConfigureHostNames_SetToolTipText_Text"));
        this.m_enableDistributedExperiment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributeExperimentPanel.this.m_configureHostNames.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByDataSet.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByRun.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
            }
        });
        this.m_configureHostNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributeExperimentPanel.this.popupHostPanel();
            }
        });
        Messages.getInstance();
        this.m_splitByDataSet.setToolTipText(Messages.getString("DistributeExperimentPanel_SetBorder_BorderFactoryCreateTitledBorder_Text"));
        Messages.getInstance();
        this.m_splitByRun.setToolTipText(Messages.getString("DistributeExperimentPanel_SplitByRun_SetToolTipText_Text"));
        this.m_splitByDataSet.setSelected(true);
        this.m_splitByDataSet.setEnabled(false);
        this.m_splitByRun.setEnabled(false);
        this.m_splitByDataSet.addActionListener(this.m_radioListener);
        this.m_splitByRun.addActionListener(this.m_radioListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_splitByDataSet);
        bg.add(this.m_splitByRun);
        JPanel rbuts = new JPanel();
        rbuts.setLayout(new GridLayout(1, 2));
        rbuts.add(this.m_splitByDataSet);
        rbuts.add(this.m_splitByRun);
        this.setLayout(new BorderLayout());
        Messages.getInstance();
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("DistributeExperimentPanel_SetBorder_BorderFactoryCreateTitledBorder_Text")));
        this.add((Component)this.m_enableDistributedExperiment, "West");
        this.add((Component)this.m_configureHostNames, "Center");
        this.add((Component)rbuts, "South");
    }

    public DistributeExperimentPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_enableDistributedExperiment.setEnabled(true);
        this.m_Exp = null;
        if (exp instanceof RemoteExperiment) {
            this.m_Exp = (RemoteExperiment)exp;
            this.m_enableDistributedExperiment.setSelected(true);
            this.m_configureHostNames.setEnabled(true);
            this.m_hostList.setExperiment(this.m_Exp);
            this.m_splitByDataSet.setEnabled(true);
            this.m_splitByRun.setEnabled(true);
            this.m_splitByDataSet.setSelected(this.m_Exp.getSplitByDataSet());
            this.m_splitByRun.setSelected(!this.m_Exp.getSplitByDataSet());
        }
    }

    private void popupHostPanel() {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("DistributeExperimentPanel_PopupHostPanel_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)this.m_hostList, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public boolean distributedExperimentSelected() {
        return this.m_enableDistributedExperiment.isSelected();
    }

    public void addCheckBoxActionListener(ActionListener al) {
        this.m_enableDistributedExperiment.addActionListener(al);
    }

    private void updateRadioLinks() {
        if (this.m_Exp != null) {
            this.m_Exp.setSplitByDataSet(this.m_splitByDataSet.isSelected());
        }
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("DistributeExperimentPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)new DistributeExperimentPanel(new Experiment()), "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

