/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Vector;
import weka.gui.beans.AbstractTrainingSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;

public class TrainingSetMaker
extends AbstractTrainingSetProducer
implements DataSourceListener,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -6152577265471535786L;
    protected boolean m_receivedStopNotification = false;

    public TrainingSetMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TrainingSetMaker.gif", "weka/gui/beans/icons/TrainingSetMaker_animated.gif");
        this.m_visual.setText("TrainingSetMaker");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("TrainingSetMaker_GlobalInfo_Text");
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_receivedStopNotification = false;
        Messages.getInstance();
        System.err.println(Messages.getString("TrainingSetMaker_AcceptDataSet_Error_Text"));
        TrainingSetEvent tse = new TrainingSetEvent(this, e.getDataSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTrainingSetProduced(tse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        TrainingSetMaker trainingSetMaker = this;
        synchronized (trainingSetMaker) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_receivedStopNotification) {
                    if (this.m_logger != null) {
                        Messages.getInstance();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("TrainingSetMaker_NotifyTrainingSetProduced_LogMessage_Text_First"))).append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_logger.logMessage(stringBuilder.append(Messages.getString("TrainingSetMaker_NotifyTrainingSetProduced_LogMessage_Text_Second")).toString());
                        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                        Messages.getInstance();
                        this.m_logger.statusMessage(stringBuilder2.append(Messages.getString("TrainingSetMaker_NotifyTrainingSetProduced_LogMessage_Text_Third")).toString());
                    }
                    this.m_receivedStopNotification = false;
                    break;
                }
                Messages.getInstance();
                System.err.println(Messages.getString("TrainingSetMaker_NotifyTrainingSetProduced_Error_Text"));
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
                ++i;
            }
        }
    }

    @Override
    public void stop() {
        this.m_receivedStopNotification = true;
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("dataSet");
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

