/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class CrossValidationFoldMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -6350179298851891512L;
    private int m_numFolds = 10;
    private int m_randomSeed = 1;
    private transient Thread m_foldThread = null;

    public CrossValidationFoldMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/CrossValidationFoldMaker.gif", "weka/gui/beans/icons/CrossValidationFoldMaker_animated.gif");
        this.m_visual.setText("CrossValidationFoldMaker");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("CrossValidationFoldMaker_GlobalInfo_Text");
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        if (e.isStructureOnly()) {
            TrainingSetEvent tse = new TrainingSetEvent(this, e.getDataSet());
            TestSetEvent tsee = new TestSetEvent(this, e.getDataSet());
            this.notifyTrainingSetProduced(tse);
            this.notifyTestSetProduced(tsee);
            return;
        }
        if (this.m_foldThread == null) {
            final Instances dataSet = new Instances(e.getDataSet());
            this.m_foldThread = new Thread(){

                @Override
                public void run() {
                    boolean errorOccurred = false;
                    try {
                        try {
                            Random random = new Random(CrossValidationFoldMaker.this.getSeed());
                            dataSet.randomize(random);
                            if (dataSet.classIndex() >= 0 && dataSet.attribute(dataSet.classIndex()).isNominal()) {
                                dataSet.stratify(CrossValidationFoldMaker.this.getFolds());
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    Messages.getInstance();
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_First"))).append(CrossValidationFoldMaker.this.getCustomName());
                                    Messages.getInstance();
                                    logger.logMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Second")).toString());
                                }
                            }
                            int i = 0;
                            while (i < CrossValidationFoldMaker.this.getFolds()) {
                                if (CrossValidationFoldMaker.this.m_foldThread == null) {
                                    if (CrossValidationFoldMaker.this.m_logger != null) {
                                        Logger logger = CrossValidationFoldMaker.this.m_logger;
                                        Messages.getInstance();
                                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Third"))).append(CrossValidationFoldMaker.this.getCustomName());
                                        Messages.getInstance();
                                        logger.logMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Fourth")).toString());
                                    }
                                    break;
                                }
                                Instances train = dataSet.trainCV(CrossValidationFoldMaker.this.getFolds(), i, random);
                                Instances test = dataSet.testCV(CrossValidationFoldMaker.this.getFolds(), i);
                                TrainingSetEvent tse = new TrainingSetEvent(this, train);
                                tse.m_setNumber = i + 1;
                                tse.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                String msg = String.valueOf(CrossValidationFoldMaker.this.getCustomName()) + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                                    Messages.getInstance();
                                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_First")).append(CrossValidationFoldMaker.this.getSeed());
                                    Messages.getInstance();
                                    StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Second")).append(CrossValidationFoldMaker.this.getFolds());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder3.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Third")).append(i + 1).toString());
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread != null) {
                                    CrossValidationFoldMaker.this.notifyTrainingSetProduced(tse);
                                }
                                TestSetEvent teste = new TestSetEvent(this, test);
                                teste.m_setNumber = i + 1;
                                teste.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                                    Messages.getInstance();
                                    StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Fourth")).append(CrossValidationFoldMaker.this.getSeed());
                                    Messages.getInstance();
                                    StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Fifth")).append(CrossValidationFoldMaker.this.getFolds());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder5.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Sixth")).append(i + 1).toString());
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread != null) {
                                    CrossValidationFoldMaker.this.notifyTestSetProduced(teste);
                                }
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            errorOccurred = true;
                            CrossValidationFoldMaker.this.stop();
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                Logger logger = CrossValidationFoldMaker.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Fifth"))).append(CrossValidationFoldMaker.this.getCustomName());
                                Messages.getInstance();
                                logger.logMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Sixth")).append(ex.getMessage()).toString());
                            }
                            ex.printStackTrace();
                            CrossValidationFoldMaker.this.m_foldThread = null;
                            if (errorOccurred) {
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(CrossValidationFoldMaker.this.getCustomName())).append("$").append(CrossValidationFoldMaker.this.hashCode()).append("|");
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Seventh")).toString());
                                }
                            } else if (this.isInterrupted()) {
                                Messages.getInstance();
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_Msg_Text_First"))).append(CrossValidationFoldMaker.this.getCustomName());
                                Messages.getInstance();
                                String msg = stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_Msg_Text_Second")).toString();
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    Messages.getInstance();
                                    StringBuilder stringBuilder6 = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Fifth"))).append(CrossValidationFoldMaker.this.getCustomName());
                                    Messages.getInstance();
                                    logger.logMessage(stringBuilder6.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Sixth_Alpha")).toString());
                                    Logger logger2 = CrossValidationFoldMaker.this.m_logger;
                                    StringBuilder stringBuilder7 = new StringBuilder(String.valueOf(CrossValidationFoldMaker.this.getCustomName())).append("$").append(CrossValidationFoldMaker.this.hashCode()).append("|");
                                    Messages.getInstance();
                                    logger2.statusMessage(stringBuilder7.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Eighth")).toString());
                                } else {
                                    System.err.println(msg);
                                }
                            } else {
                                String msg = String.valueOf(CrossValidationFoldMaker.this.getCustomName()) + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    Logger logger = CrossValidationFoldMaker.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Nineth")).toString());
                                }
                            }
                            CrossValidationFoldMaker.this.block(false);
                        }
                    }
                    finally {
                        CrossValidationFoldMaker.this.m_foldThread = null;
                        if (errorOccurred) {
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                Logger logger = CrossValidationFoldMaker.this.m_logger;
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(CrossValidationFoldMaker.this.getCustomName())).append("$").append(CrossValidationFoldMaker.this.hashCode()).append("|");
                                Messages.getInstance();
                                logger.statusMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Seventh")).toString());
                            }
                        } else if (this.isInterrupted()) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_Msg_Text_First"))).append(CrossValidationFoldMaker.this.getCustomName());
                            Messages.getInstance();
                            String msg = stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_Msg_Text_Second")).toString();
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                Logger logger = CrossValidationFoldMaker.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder8 = new StringBuilder(String.valueOf(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Fifth"))).append(CrossValidationFoldMaker.this.getCustomName());
                                Messages.getInstance();
                                logger.logMessage(stringBuilder8.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_LogMessage_Text_Sixth_Alpha")).toString());
                                Logger logger3 = CrossValidationFoldMaker.this.m_logger;
                                StringBuilder stringBuilder9 = new StringBuilder(String.valueOf(CrossValidationFoldMaker.this.getCustomName())).append("$").append(CrossValidationFoldMaker.this.hashCode()).append("|");
                                Messages.getInstance();
                                logger3.statusMessage(stringBuilder9.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Eighth")).toString());
                            } else {
                                System.err.println(msg);
                            }
                        } else {
                            String msg = String.valueOf(CrossValidationFoldMaker.this.getCustomName()) + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                Logger logger = CrossValidationFoldMaker.this.m_logger;
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                                Messages.getInstance();
                                logger.statusMessage(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_AcceptDataSet_StatusMessage_Text_Nineth")).toString());
                            }
                        }
                        CrossValidationFoldMaker.this.block(false);
                    }
                }
            };
            this.m_foldThread.setPriority(1);
            this.m_foldThread.start();
            this.block(true);
            this.m_foldThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_foldThread == null) break;
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            l = (Vector)this.m_trainingListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_foldThread == null) break;
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
                ++i;
            }
        }
    }

    public void setFolds(int numFolds) {
        this.m_numFolds = numFolds;
    }

    public int getFolds() {
        return this.m_numFolds;
    }

    public String foldsTipText() {
        Messages.getInstance();
        return Messages.getString("CrossValidationFoldMaker_FoldsTipText_Text");
    }

    public void setSeed(int randomSeed) {
        this.m_randomSeed = randomSeed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String seedTipText() {
        Messages.getInstance();
        return Messages.getString("CrossValidationFoldMaker_SeedTipText_Text");
    }

    @Override
    public boolean isBusy() {
        return this.m_foldThread != null;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_foldThread != null) {
            Thread temp = this.m_foldThread;
            this.m_foldThread = null;
            temp.interrupt();
            temp.stop();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_foldThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_foldThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(request));
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("CrossValidationFoldMaker_PerformRequest_IllegalArgumentException_Text")).toString());
        }
        this.stop();
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }
}

