/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.gui.Logger;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.UserRequestAcceptor;

public class ClustererPerformanceEvaluator
extends AbstractEvaluator
implements BatchClustererListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private static final long serialVersionUID = 8041163601333978584L;
    private transient ClusterEvaluation m_eval;
    private transient Clusterer m_clusterer;
    private transient Thread m_evaluateThread = null;
    private Vector m_textListeners = new Vector();

    public ClustererPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClustererPerformanceEvaluator.gif", "weka/gui/beans/icons/ClustererPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClustererPerformanceEvaluator");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("ClustererPerformanceEvaluator_GlobalInfo_Text");
    }

    @Override
    public void acceptClusterer(final BatchClustererEvent ce) {
        if (ce.getTestSet().isStructureOnly()) {
            return;
        }
        try {
            if (this.m_evaluateThread == null) {
                this.m_evaluateThread = new Thread(){

                    @Override
                    public void run() {
                        boolean numericClass = false;
                        try {
                            try {
                                if (ce.getSetNumber() == 1) {
                                    ClustererPerformanceEvaluator.this.m_eval = new ClusterEvaluation();
                                    ClustererPerformanceEvaluator.this.m_clusterer = ce.getClusterer();
                                    ClustererPerformanceEvaluator.this.m_eval.setClusterer(ClustererPerformanceEvaluator.this.m_clusterer);
                                }
                                if (ce.getSetNumber() <= ce.getMaxSetNumber()) {
                                    if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                        Logger logger = ClustererPerformanceEvaluator.this.m_logger;
                                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(ClustererPerformanceEvaluator.this.statusMessagePrefix()));
                                        Messages.getInstance();
                                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_StatusMessage_Text_First")).append(ce.getSetNumber());
                                        Messages.getInstance();
                                        logger.statusMessage(stringBuilder2.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_StatusMessage_Text_Second")).toString());
                                    }
                                    ClustererPerformanceEvaluator.this.m_visual.setAnimated();
                                    if (ce.getTestSet().getDataSet().classIndex() != -1 && ce.getTestSet().getDataSet().classAttribute().isNumeric()) {
                                        numericClass = true;
                                        ce.getTestSet().getDataSet().setClassIndex(-1);
                                    }
                                    ClustererPerformanceEvaluator.this.m_eval.evaluateClusterer(ce.getTestSet().getDataSet());
                                }
                                if (ce.getSetNumber() == ce.getMaxSetNumber()) {
                                    String test;
                                    String textTitle = ClustererPerformanceEvaluator.this.m_clusterer.getClass().getName();
                                    textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                                    if (ce.getTestOrTrain() == 0) {
                                        Messages.getInstance();
                                        test = Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_Test_Text_First");
                                    } else {
                                        Messages.getInstance();
                                        test = Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_Test_Text_Second");
                                    }
                                    Messages.getInstance();
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_ResultT_Text_First"))).append(test);
                                    Messages.getInstance();
                                    StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_ResultT_Text_Second"));
                                    Messages.getInstance();
                                    StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_ResultT_Text_Third")).append(textTitle);
                                    Messages.getInstance();
                                    String resultT = stringBuilder4.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_ResultT_Text_Fourth")).append(ce.getTestSet().getDataSet().relationName()).append("\n\n").append(ClustererPerformanceEvaluator.this.m_eval.clusterResultsToString()).toString();
                                    if (numericClass) {
                                        StringBuilder stringBuilder5 = new StringBuilder(String.valueOf(resultT));
                                        Messages.getInstance();
                                        resultT = stringBuilder5.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_ResultT_Text_Fifth")).toString();
                                    }
                                    TextEvent te = new TextEvent(ClustererPerformanceEvaluator.this, resultT, textTitle);
                                    ClustererPerformanceEvaluator.this.notifyTextListeners(te);
                                    if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                        Logger logger = ClustererPerformanceEvaluator.this.m_logger;
                                        StringBuilder stringBuilder6 = new StringBuilder(String.valueOf(ClustererPerformanceEvaluator.this.statusMessagePrefix()));
                                        Messages.getInstance();
                                        logger.statusMessage(stringBuilder6.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_StatusMessage_Text_Third")).toString());
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ClustererPerformanceEvaluator.this.stop();
                                if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                    Logger logger = ClustererPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(ClustererPerformanceEvaluator.this.statusMessagePrefix()));
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_StatusMessage_Text_Fourth")).toString());
                                    Logger logger2 = ClustererPerformanceEvaluator.this.m_logger;
                                    Messages.getInstance();
                                    StringBuilder stringBuilder7 = new StringBuilder(String.valueOf(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_First"))).append(ClustererPerformanceEvaluator.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger2.logMessage(stringBuilder7.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Second")).append(ex.getMessage()).toString());
                                }
                                ex.printStackTrace();
                                ClustererPerformanceEvaluator.this.m_visual.setStatic();
                                ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                                if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                    Logger logger = ClustererPerformanceEvaluator.this.m_logger;
                                    Messages.getInstance();
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Third"))).append(ClustererPerformanceEvaluator.this.getCustomName());
                                    Messages.getInstance();
                                    logger.logMessage(stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Fourth")).toString());
                                    Logger logger3 = ClustererPerformanceEvaluator.this.m_logger;
                                    StringBuilder stringBuilder8 = new StringBuilder(String.valueOf(ClustererPerformanceEvaluator.this.statusMessagePrefix()));
                                    Messages.getInstance();
                                    logger3.statusMessage(stringBuilder8.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Fifth")).toString());
                                }
                                ClustererPerformanceEvaluator.this.block(false);
                            }
                        }
                        finally {
                            ClustererPerformanceEvaluator.this.m_visual.setStatic();
                            ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                Logger logger = ClustererPerformanceEvaluator.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Third"))).append(ClustererPerformanceEvaluator.this.getCustomName());
                                Messages.getInstance();
                                logger.logMessage(stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Fourth")).toString());
                                Logger logger4 = ClustererPerformanceEvaluator.this.m_logger;
                                StringBuilder stringBuilder9 = new StringBuilder(String.valueOf(ClustererPerformanceEvaluator.this.statusMessagePrefix()));
                                Messages.getInstance();
                                logger4.statusMessage(stringBuilder9.append(Messages.getString("ClustererPerformanceEvaluator_AcceptClusterer_LogMessage_Text_Fifth")).toString());
                            }
                            ClustererPerformanceEvaluator.this.block(false);
                        }
                    }
                };
                this.m_evaluateThread.setPriority(1);
                this.m_evaluateThread.start();
                this.block(true);
                this.m_evaluateThread = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_evaluateThread != null;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_evaluateThread != null) {
            this.m_evaluateThread.interrupt();
            this.m_evaluateThread.stop();
            this.m_evaluateThread = null;
            this.m_visual.setStatic();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_evaluateThread != null && this.m_evaluateThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_evaluateThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(request));
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("ClustererPerformanceEvaluator_PerformRequest_IllegalArgumentException_Text")).toString());
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        ClustererPerformanceEvaluator clustererPerformanceEvaluator = this;
        synchronized (clustererPerformanceEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((TextListener)l.elementAt(i)).acceptText(te);
                ++i;
            }
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

