/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ConverterUtils;
import weka.gui.ComponentHelper;
import weka.gui.ConverterFileChooser;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffPanel;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.Messages;

public class ArffViewerMainPanel
extends JPanel
implements ActionListener,
ChangeListener {
    static final long serialVersionUID = -8763161167586738753L;
    public static final int DEFAULT_WIDTH = -1;
    public static final int DEFAULT_HEIGHT = -1;
    public static final int DEFAULT_LEFT = -1;
    public static final int DEFAULT_TOP = -1;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 600;
    protected Container parent;
    protected JTabbedPane tabbedPane;
    protected JMenuBar menuBar;
    protected JMenu menuFile;
    protected JMenuItem menuFileOpen;
    protected JMenuItem menuFileSave;
    protected JMenuItem menuFileSaveAs;
    protected JMenuItem menuFileClose;
    protected JMenuItem menuFileCloseAll;
    protected JMenuItem menuFileProperties;
    protected JMenuItem menuFileExit;
    protected JMenu menuEdit;
    protected JMenuItem menuEditUndo;
    protected JMenuItem menuEditCopy;
    protected JMenuItem menuEditSearch;
    protected JMenuItem menuEditClearSearch;
    protected JMenuItem menuEditDeleteAttribute;
    protected JMenuItem menuEditDeleteAttributes;
    protected JMenuItem menuEditRenameAttribute;
    protected JMenuItem menuEditAttributeAsClass;
    protected JMenuItem menuEditDeleteInstance;
    protected JMenuItem menuEditDeleteInstances;
    protected JMenuItem menuEditSortInstances;
    protected JMenu menuView;
    protected JMenuItem menuViewAttributes;
    protected JMenuItem menuViewValues;
    protected JMenuItem menuViewOptimalColWidths;
    protected ConverterFileChooser fileChooser;
    protected String frameTitle;
    protected boolean confirmExit;
    protected int width;
    protected int height;
    protected int top;
    protected int left;
    protected boolean exitOnClose;

    public ArffViewerMainPanel(Container parentFrame) {
        this.parent = parentFrame;
        Messages.getInstance();
        this.frameTitle = Messages.getString("ArffViewerMainPanel_Title_Text");
        this.createPanel();
    }

    protected void createPanel() {
        this.setSize(800, 600);
        this.setConfirmExit(false);
        this.setLayout(new BorderLayout());
        this.fileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setMultiSelectionEnabled(true);
        this.menuBar = new JMenuBar();
        Messages.getInstance();
        this.menuFile = new JMenu(Messages.getString("ArffViewerMainPanel_CreatePanel_File_JMenu_Text"));
        Messages.getInstance();
        this.menuFileOpen = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_FileOpen_JMenuItem_Text"), ComponentHelper.getImageIcon("open.gif"));
        this.menuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuFileOpen.addActionListener(this);
        Messages.getInstance();
        this.menuFileSave = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Save_JMenuItem_Text"), ComponentHelper.getImageIcon("save.gif"));
        this.menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFileSave.addActionListener(this);
        Messages.getInstance();
        this.menuFileSaveAs = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_SaveAs_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuFileSaveAs.addActionListener(this);
        Messages.getInstance();
        this.menuFileClose = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Close_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileClose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.menuFileClose.addActionListener(this);
        Messages.getInstance();
        this.menuFileCloseAll = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_CloseAll_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileCloseAll.addActionListener(this);
        Messages.getInstance();
        this.menuFileProperties = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Properties_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileProperties.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        this.menuFileProperties.addActionListener(this);
        Messages.getInstance();
        this.menuFileExit = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Exit_JMenuItem_Text"), ComponentHelper.getImageIcon("forward.gif"));
        this.menuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.menuFileExit.addActionListener(this);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.add(this.menuFileSaveAs);
        this.menuFile.add(this.menuFileClose);
        this.menuFile.add(this.menuFileCloseAll);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileProperties);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        Messages.getInstance();
        this.menuEdit = new JMenu(Messages.getString("ArffViewerMainPanel_CreatePanel_Edit_JMenuItem_Text"));
        Messages.getInstance();
        this.menuEditUndo = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Undo_JMenuItem_Text"), ComponentHelper.getImageIcon("undo.gif"));
        this.menuEditUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.menuEditUndo.addActionListener(this);
        Messages.getInstance();
        this.menuEditCopy = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Copy_JMenuItem_Text"), ComponentHelper.getImageIcon("copy.gif"));
        this.menuEditCopy.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        this.menuEditCopy.addActionListener(this);
        Messages.getInstance();
        this.menuEditSearch = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_Search_JMenuItem_Text"), ComponentHelper.getImageIcon("find.gif"));
        this.menuEditSearch.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuEditSearch.addActionListener(this);
        Messages.getInstance();
        this.menuEditClearSearch = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_ClearSearch_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditClearSearch.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.menuEditClearSearch.addActionListener(this);
        Messages.getInstance();
        this.menuEditRenameAttribute = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_RenameAttribute_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditRenameAttribute.addActionListener(this);
        Messages.getInstance();
        this.menuEditAttributeAsClass = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_AttributeAsClass_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditAttributeAsClass.addActionListener(this);
        Messages.getInstance();
        this.menuEditDeleteAttribute = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_DeleteAttribute_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteAttribute.addActionListener(this);
        Messages.getInstance();
        this.menuEditDeleteAttributes = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_DeleteAttributes_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteAttributes.addActionListener(this);
        Messages.getInstance();
        this.menuEditDeleteInstance = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_DeleteInstance_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteInstance.addActionListener(this);
        Messages.getInstance();
        this.menuEditDeleteInstances = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_DeleteInstances_JMenuItem_Text"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteInstances.addActionListener(this);
        Messages.getInstance();
        this.menuEditSortInstances = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_SortDataAscending_JMenuItem_Text"), ComponentHelper.getImageIcon("sort.gif"));
        this.menuEditSortInstances.addActionListener(this);
        this.menuEdit.add(this.menuEditUndo);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditSearch);
        this.menuEdit.add(this.menuEditClearSearch);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditRenameAttribute);
        this.menuEdit.add(this.menuEditAttributeAsClass);
        this.menuEdit.add(this.menuEditDeleteAttribute);
        this.menuEdit.add(this.menuEditDeleteAttributes);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditDeleteInstance);
        this.menuEdit.add(this.menuEditDeleteInstances);
        this.menuEdit.add(this.menuEditSortInstances);
        this.menuBar.add(this.menuEdit);
        Messages.getInstance();
        this.menuView = new JMenu(Messages.getString("ArffViewerMainPanel_CreatePanel_View_JMenu_Text"));
        Messages.getInstance();
        this.menuViewAttributes = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_ViewAttributes_JMenuItem_Text"), ComponentHelper.getImageIcon("objects.gif"));
        this.menuViewAttributes.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.menuViewAttributes.addActionListener(this);
        Messages.getInstance();
        this.menuViewValues = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_ViewValues_JMenuItem_Text"), ComponentHelper.getImageIcon("properties.gif"));
        this.menuViewValues.setAccelerator(KeyStroke.getKeyStroke(86, 3));
        this.menuViewValues.addActionListener(this);
        Messages.getInstance();
        this.menuViewOptimalColWidths = new JMenuItem(Messages.getString("ArffViewerMainPanel_CreatePanel_ViewOptimalColWidths_JMenuItem_Text"), ComponentHelper.getImageIcon("resize.gif"));
        this.menuViewOptimalColWidths.addActionListener(this);
        this.menuView.add(this.menuViewAttributes);
        this.menuView.add(this.menuViewValues);
        this.menuView.addSeparator();
        this.menuView.add(this.menuViewOptimalColWidths);
        this.menuBar.add(this.menuView);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.add((Component)this.tabbedPane, "Center");
        this.updateMenu();
        this.updateFrameTitle();
    }

    public JFrame getParentFrame() {
        if (this.parent instanceof JFrame) {
            return (JFrame)this.parent;
        }
        return null;
    }

    public JInternalFrame getParentInternalFrame() {
        if (this.parent instanceof JInternalFrame) {
            return (JInternalFrame)this.parent;
        }
        return null;
    }

    public void setParent(Container value) {
        this.parent = value;
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setConfirmExit(boolean confirm) {
        this.confirmExit = confirm;
    }

    public boolean getConfirmExit() {
        return this.confirmExit;
    }

    public void setExitOnClose(boolean value) {
        this.exitOnClose = value;
    }

    public boolean getExitOnClose() {
        return this.exitOnClose;
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public String getFrameTitle() {
        if (this.getCurrentFilename().equals("")) {
            return this.frameTitle;
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.frameTitle));
        Messages.getInstance();
        return stringBuilder.append(Messages.getString("ArffViewerMainPanel_GetFrameTitle_Text")).append(this.getCurrentFilename()).toString();
    }

    public void updateFrameTitle() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle(this.getFrameTitle());
        }
        if (this.getParentInternalFrame() != null) {
            this.getParentInternalFrame().setTitle(this.getFrameTitle());
        }
    }

    protected void updateMenu() {
        boolean fileOpen = this.getCurrentPanel() != null;
        boolean isChanged = fileOpen && this.getCurrentPanel().isChanged();
        boolean canUndo = fileOpen && this.getCurrentPanel().canUndo();
        this.menuFileOpen.setEnabled(true);
        this.menuFileSave.setEnabled(isChanged);
        this.menuFileSaveAs.setEnabled(fileOpen);
        this.menuFileClose.setEnabled(fileOpen);
        this.menuFileCloseAll.setEnabled(fileOpen);
        this.menuFileProperties.setEnabled(fileOpen);
        this.menuFileExit.setEnabled(true);
        this.menuEditUndo.setEnabled(canUndo);
        this.menuEditCopy.setEnabled(fileOpen);
        this.menuEditSearch.setEnabled(fileOpen);
        this.menuEditClearSearch.setEnabled(fileOpen);
        this.menuEditAttributeAsClass.setEnabled(fileOpen);
        this.menuEditRenameAttribute.setEnabled(fileOpen);
        this.menuEditDeleteAttribute.setEnabled(fileOpen);
        this.menuEditDeleteAttributes.setEnabled(fileOpen);
        this.menuEditDeleteInstance.setEnabled(fileOpen);
        this.menuEditDeleteInstances.setEnabled(fileOpen);
        this.menuEditSortInstances.setEnabled(fileOpen);
        this.menuViewAttributes.setEnabled(fileOpen);
        this.menuViewValues.setEnabled(fileOpen);
        this.menuViewOptimalColWidths.setEnabled(fileOpen);
    }

    protected void setTabTitle(JComponent component) {
        if (!(component instanceof ArffPanel)) {
            return;
        }
        int index = this.tabbedPane.indexOfComponent(component);
        if (index == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(index, ((ArffPanel)component).getTitle());
        this.updateFrameTitle();
    }

    public int getPanelCount() {
        return this.tabbedPane.getTabCount();
    }

    public ArffPanel getPanel(int index) {
        if (index >= 0 && index < this.getPanelCount()) {
            return (ArffPanel)this.tabbedPane.getComponentAt(index);
        }
        return null;
    }

    public int getCurrentIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public ArffPanel getCurrentPanel() {
        return this.getPanel(this.getCurrentIndex());
    }

    public boolean isPanelSelected() {
        return this.getCurrentPanel() != null;
    }

    public String getFilename(int index) {
        String result = "";
        ArffPanel panel = this.getPanel(index);
        if (panel != null) {
            result = panel.getFilename();
        }
        return result;
    }

    public String getCurrentFilename() {
        return this.getFilename(this.getCurrentIndex());
    }

    public void setFilename(int index, String filename) {
        ArffPanel panel = this.getPanel(index);
        if (panel != null) {
            panel.setFilename(filename);
            this.setTabTitle(panel);
        }
    }

    public void setCurrentFilename(String filename) {
        this.setFilename(this.getCurrentIndex(), filename);
    }

    protected boolean saveChanges() {
        return this.saveChanges(true);
    }

    protected boolean saveChanges(boolean showCancel) {
        boolean result;
        if (!this.isPanelSelected()) {
            return true;
        }
        boolean bl = result = !this.getCurrentPanel().isChanged();
        if (this.getCurrentPanel().isChanged()) {
            int button;
            try {
                if (showCancel) {
                    Messages.getInstance();
                    String string = Messages.getString("ArffViewerMainPanel_SaveChanges_ComponentHelperShowMessageBox_Text_First");
                    Messages.getInstance();
                    button = ComponentHelper.showMessageBox(this, string, Messages.getString("ArffViewerMainPanel_SaveChanges_ComponentHelperShowMessageBox_Text_Second"), 1, 3);
                } else {
                    Messages.getInstance();
                    String string = Messages.getString("ArffViewerMainPanel_SaveChanges_ComponentHelperShowMessageBox_Text_Third");
                    Messages.getInstance();
                    button = ComponentHelper.showMessageBox(this, string, Messages.getString("ArffViewerMainPanel_SaveChanges_ComponentHelperShowMessageBox_Text_Fourth"), 0, 3);
                }
            }
            catch (Exception e) {
                button = 2;
            }
            switch (button) {
                case 0: {
                    this.saveFile();
                    result = !this.getCurrentPanel().isChanged();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void loadFile(String filename) {
        ArffPanel panel = new ArffPanel(filename);
        panel.addChangeListener(this);
        this.tabbedPane.addTab(panel.getTitle(), panel);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void loadFile() {
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int i = 0;
        while (i < this.fileChooser.getSelectedFiles().length) {
            String filename = this.fileChooser.getSelectedFiles()[i].getAbsolutePath();
            this.loadFile(filename);
            ++i;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void saveFile() {
        ArffPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        String filename = panel.getFilename();
        if (filename.equals(ArffPanel.TAB_INSTANCES)) {
            this.saveFileAs();
        } else {
            AbstractFileSaver saver = ConverterUtils.getSaverForFile(filename);
            try {
                saver.setInstances(panel.getInstances());
                ((AbstractSaver)saver).setFile(new File(filename));
                saver.writeBatch();
                panel.setChanged(false);
                this.setCurrentFilename(filename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveFileAs() {
        ArffPanel panel = this.getCurrentPanel();
        if (panel == null) {
            Messages.getInstance();
            System.out.println(Messages.getString("ArffViewerMainPanel_SaveFileAs_Text"));
            return;
        }
        if (!this.getCurrentFilename().equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.getCurrentFilename()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.fileChooser.setCapabilitiesFilter(Capabilities.forInstances(panel.getInstances()));
        }
        catch (Exception e) {
            this.fileChooser.setCapabilitiesFilter(null);
        }
        int retVal = this.fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        panel.setChanged(false);
        this.setCurrentFilename(this.fileChooser.getSelectedFile().getAbsolutePath());
        this.saveFile();
    }

    public void closeFile() {
        this.closeFile(true);
    }

    public void closeFile(boolean showCancel) {
        if (this.getCurrentIndex() == -1) {
            return;
        }
        if (!this.saveChanges(showCancel)) {
            return;
        }
        this.tabbedPane.removeTabAt(this.getCurrentIndex());
        this.updateFrameTitle();
        System.gc();
    }

    public void closeAllFiles() {
        while (this.tabbedPane.getTabCount() > 0) {
            if (!this.saveChanges(true)) {
                return;
            }
            this.tabbedPane.removeTabAt(this.getCurrentIndex());
            this.updateFrameTitle();
            System.gc();
        }
    }

    public void showProperties() {
        ArffPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        Instances inst = panel.getInstances();
        if (inst == null) {
            return;
        }
        if (inst.classIndex() < 0) {
            inst.setClassIndex(inst.numAttributes() - 1);
        }
        Vector<String> props = new Vector<String>();
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_Filename_Text")) + panel.getFilename());
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_Filename_Text")) + inst.relationName());
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_Instances_Text")) + inst.numInstances());
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_Attributes_Text")) + inst.numAttributes());
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_ClassAttribute_Text")) + inst.classAttribute().name());
        Messages.getInstance();
        props.add(String.valueOf(Messages.getString("ArffViewerMainPanel_ShowProperties_ClassLabels_Text")) + inst.numClasses());
        ListSelectorDialog dialog = new ListSelectorDialog((Frame)this.getParentFrame(), new JList(props));
        dialog.showDialog();
    }

    public void close() {
        if (this.getParentInternalFrame() != null) {
            this.getParentInternalFrame().doDefaultCloseAction();
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().dispatchEvent(new WindowEvent(this.getParentFrame(), 201));
        }
    }

    public void undo() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().undo();
    }

    public void copyContent() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().copyContent();
    }

    public void search() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().search();
    }

    public void clearSearch() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().clearSearch();
    }

    public void renameAttribute() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().renameAttribute();
    }

    public void attributeAsClass() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().attributeAsClass();
    }

    public void deleteAttribute(boolean multiple) {
        if (!this.isPanelSelected()) {
            return;
        }
        if (multiple) {
            this.getCurrentPanel().deleteAttributes();
        } else {
            this.getCurrentPanel().deleteAttribute();
        }
    }

    public void deleteInstance(boolean multiple) {
        if (!this.isPanelSelected()) {
            return;
        }
        if (multiple) {
            this.getCurrentPanel().deleteInstances();
        } else {
            this.getCurrentPanel().deleteInstance();
        }
    }

    public void sortInstances() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().sortInstances();
    }

    public String showAttributes() {
        if (!this.isPanelSelected()) {
            return null;
        }
        JList list = new JList(this.getCurrentPanel().getAttributes());
        ListSelectorDialog dialog = new ListSelectorDialog((Frame)this.getParentFrame(), list);
        int result = dialog.showDialog();
        if (result == 0) {
            ArffSortedTableModel model = (ArffSortedTableModel)this.getCurrentPanel().getTable().getModel();
            String name = list.getSelectedValue().toString();
            int i = model.getAttributeColumn(name);
            JTableHelper.scrollToVisible(this.getCurrentPanel().getTable(), 0, i);
            this.getCurrentPanel().getTable().setSelectedColumn(i);
            return name;
        }
        return null;
    }

    public void showValues() {
        String attribute = this.showAttributes();
        if (attribute == null) {
            return;
        }
        ArffTable table = this.getCurrentPanel().getTable();
        ArffSortedTableModel model = (ArffSortedTableModel)table.getModel();
        int col = -1;
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getPlainColumnName(i).equals(attribute)) {
                col = i;
                break;
            }
            ++i;
        }
        if (col == -1) {
            return;
        }
        HashSet<String> values = new HashSet<String>();
        Vector items = new Vector();
        i = 0;
        while (i < model.getRowCount()) {
            values.add(model.getValueAt(i, col).toString());
            ++i;
        }
        if (values.isEmpty()) {
            return;
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            items.add(iter.next());
        }
        Collections.sort(items);
        ListSelectorDialog dialog = new ListSelectorDialog((Frame)this.getParentFrame(), new JList(items));
        dialog.showDialog();
    }

    public void setOptimalColWidths() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().setOptimalColWidths();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.menuFileOpen) {
            this.loadFile();
        } else if (o == this.menuFileSave) {
            this.saveFile();
        } else if (o == this.menuFileSaveAs) {
            this.saveFileAs();
        } else if (o == this.menuFileClose) {
            this.closeFile();
        } else if (o == this.menuFileCloseAll) {
            this.closeAllFiles();
        } else if (o == this.menuFileProperties) {
            this.showProperties();
        } else if (o == this.menuFileExit) {
            this.close();
        } else if (o == this.menuEditUndo) {
            this.undo();
        } else if (o == this.menuEditCopy) {
            this.copyContent();
        } else if (o == this.menuEditSearch) {
            this.search();
        } else if (o == this.menuEditClearSearch) {
            this.clearSearch();
        } else if (o == this.menuEditDeleteAttribute) {
            this.deleteAttribute(false);
        } else if (o == this.menuEditDeleteAttributes) {
            this.deleteAttribute(true);
        } else if (o == this.menuEditRenameAttribute) {
            this.renameAttribute();
        } else if (o == this.menuEditAttributeAsClass) {
            this.attributeAsClass();
        } else if (o == this.menuEditDeleteInstance) {
            this.deleteInstance(false);
        } else if (o == this.menuEditDeleteInstances) {
            this.deleteInstance(true);
        } else if (o == this.menuEditSortInstances) {
            this.sortInstances();
        } else if (o == this.menuViewAttributes) {
            this.showAttributes();
        } else if (o == this.menuViewValues) {
            this.showValues();
        } else if (o == this.menuViewOptimalColWidths) {
            this.setOptimalColWidths();
        }
        this.updateMenu();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateFrameTitle();
        this.updateMenu();
        if (e.getSource() instanceof JComponent) {
            this.setTabTitle((JComponent)e.getSource());
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

