/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.Messages;

public class ArffTableCellRenderer
extends DefaultTableCellRenderer {
    static final long serialVersionUID = 9195794493301191171L;
    private Color missingColor;
    private Color missingColorSelected;
    private Color highlightColor;
    private Color highlightColorSelected;

    public ArffTableCellRenderer() {
        this(new Color(223, 223, 223), new Color(192, 192, 192));
    }

    public ArffTableCellRenderer(Color missingColor, Color missingColorSelected) {
        this(missingColor, missingColorSelected, Color.RED, Color.RED.darker());
    }

    public ArffTableCellRenderer(Color missingColor, Color missingColorSelected, Color highlightColor, Color highlightColorSelected) {
        this.missingColor = missingColor;
        this.missingColorSelected = missingColorSelected;
        this.highlightColor = highlightColor;
        this.highlightColorSelected = highlightColorSelected;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String searchString = table instanceof ArffTable ? ((ArffTable)table).getSearchString() : null;
        boolean found = searchString != null && !searchString.equals("") ? searchString.equals(value.toString()) : false;
        if (table.getModel() instanceof ArffSortedTableModel) {
            ArffSortedTableModel model = (ArffSortedTableModel)table.getModel();
            if (row >= 0) {
                if (model.isMissingAt(row, column)) {
                    Messages.getInstance();
                    this.setToolTipText(Messages.getString("ArffTableCellRenderer_GetTableCellRendererComponent_SetToolTipText_Text"));
                    if (found) {
                        if (isSelected) {
                            result.setBackground(this.highlightColorSelected);
                        } else {
                            result.setBackground(this.highlightColor);
                        }
                    } else if (isSelected) {
                        result.setBackground(this.missingColorSelected);
                    } else {
                        result.setBackground(this.missingColor);
                    }
                } else {
                    this.setToolTipText(null);
                    if (found) {
                        if (isSelected) {
                            result.setBackground(this.highlightColorSelected);
                        } else {
                            result.setBackground(this.highlightColor);
                        }
                    } else if (isSelected) {
                        result.setBackground(table.getSelectionBackground());
                    } else {
                        result.setBackground(Color.WHITE);
                    }
                }
                if (model.getType(row, column) == 0) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                if (table.getColumnModel().getSelectionModel().isSelectedIndex(column)) {
                    result.setBackground(UIManager.getColor("TableHeader.background").darker());
                } else {
                    result.setBackground(UIManager.getColor("TableHeader.background"));
                }
            }
        }
        return result;
    }
}

