/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.Messages;
import weka.gui.TaskLogger;

public class WekaTaskMonitor
extends JPanel
implements TaskLogger {
    private static final long serialVersionUID = 508309816292197578L;
    private int m_ActiveTasks = 0;
    private JLabel m_MonitorLabel;
    private ImageIcon m_iconStationary;
    private ImageIcon m_iconAnimated;
    private boolean m_animating = false;

    public WekaTaskMonitor() {
        URL imageURL = this.getClass().getClassLoader().getResource("weka/gui/weka_stationary.gif");
        if (imageURL != null) {
            Image pic = Toolkit.getDefaultToolkit().getImage(imageURL);
            imageURL = this.getClass().getClassLoader().getResource("weka/gui/weka_animated.gif");
            Image pic2 = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.m_iconStationary = new ImageIcon(pic);
            this.m_iconAnimated = new ImageIcon(pic2);
        }
        Messages.getInstance();
        this.m_MonitorLabel = new JLabel(String.valueOf(Messages.getString("WekaTaskMonitor_MonitorLabel_JLabel_Text")) + this.m_ActiveTasks, this.m_iconStationary, 0);
        this.setLayout(new BorderLayout());
        Dimension d = this.m_MonitorLabel.getPreferredSize();
        this.m_MonitorLabel.setPreferredSize(new Dimension(d.width + 15, d.height));
        this.m_MonitorLabel.setMinimumSize(new Dimension(d.width + 15, d.height));
        this.add((Component)this.m_MonitorLabel, "Center");
    }

    @Override
    public synchronized void taskStarted() {
        ++this.m_ActiveTasks;
        this.updateMonitor();
    }

    @Override
    public synchronized void taskFinished() {
        --this.m_ActiveTasks;
        if (this.m_ActiveTasks < 0) {
            this.m_ActiveTasks = 0;
        }
        this.updateMonitor();
    }

    private void updateMonitor() {
        this.m_MonitorLabel.setText(" x " + this.m_ActiveTasks);
        if (this.m_ActiveTasks > 0 && !this.m_animating) {
            this.m_MonitorLabel.setIcon(this.m_iconAnimated);
            this.m_animating = true;
        }
        if (this.m_ActiveTasks == 0 && this.m_animating) {
            this.m_MonitorLabel.setIcon(this.m_iconStationary);
            this.m_animating = false;
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            WekaTaskMonitor tm = new WekaTaskMonitor();
            Messages.getInstance();
            tm.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("WekaTaskMonitor_Main_JFrame_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            jf.getContentPane().add((Component)tm, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            tm.taskStarted();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

