/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.gui.Messages;

public class HierarchyPropertyParser
implements Serializable {
    private static final long serialVersionUID = -4151103338506077544L;
    private TreeNode m_Root = new TreeNode();
    private TreeNode m_Current;
    private String m_Seperator = ".";
    private int m_Depth = 0;

    public HierarchyPropertyParser() {
        this.m_Root.parent = null;
        this.m_Root.children = new Vector();
        this.goToRoot();
    }

    public HierarchyPropertyParser(String p, String delim) throws Exception {
        this();
        this.build(p, delim);
    }

    public void setSeperator(String s) {
        this.m_Seperator = s;
    }

    public String getSeperator() {
        return this.m_Seperator;
    }

    public void build(String p, String delim) throws Exception {
        StringTokenizer st = new StringTokenizer(p, delim);
        while (st.hasMoreTokens()) {
            String property = st.nextToken().trim();
            if (!this.isHierachic(property)) {
                Messages.getInstance();
                throw new Exception(Messages.getString("HierarchyPropertyParser_Build_Exception_Text"));
            }
            this.add(property);
        }
        this.goToRoot();
    }

    public synchronized void add(String property) {
        String[] values = this.tokenize(property);
        if (this.m_Root.value == null) {
            this.m_Root.value = values[0];
        }
        this.buildBranch(this.m_Root, values, 1);
    }

    private void buildBranch(TreeNode parent, String[] values, int lvl) {
        Vector kids;
        int index;
        if (lvl == values.length) {
            parent.children = null;
            return;
        }
        if (lvl > this.m_Depth - 1) {
            this.m_Depth = lvl + 1;
        }
        if ((index = this.search(kids = parent.children, values[lvl])) != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            if (newParent.children == null) {
                newParent.children = new Vector();
            }
            this.buildBranch(newParent, values, lvl + 1);
        } else {
            TreeNode added = new TreeNode();
            added.parent = parent;
            added.value = values[lvl];
            added.children = new Vector();
            added.level = lvl;
            added.context = parent != this.m_Root ? String.valueOf(parent.context) + this.m_Seperator + parent.value : parent.value;
            kids.addElement(added);
            this.buildBranch(added, values, lvl + 1);
        }
    }

    public String[] tokenize(String rawString) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tk = new StringTokenizer(rawString, this.m_Seperator);
        while (tk.hasMoreTokens()) {
            result.addElement(tk.nextToken());
        }
        String[] newStrings = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            newStrings[i] = (String)result.elementAt(i);
            ++i;
        }
        return newStrings;
    }

    public boolean contains(String string) {
        String[] item = this.tokenize(string);
        if (!item[0].equals(this.m_Root.value)) {
            return false;
        }
        return this.isContained(this.m_Root, item, 1);
    }

    private boolean isContained(TreeNode parent, String[] values, int lvl) {
        if (lvl == values.length) {
            return true;
        }
        if (lvl > values.length) {
            return false;
        }
        Vector kids = parent.children;
        int index = this.search(kids, values[lvl]);
        if (index != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            return this.isContained(newParent, values, lvl + 1);
        }
        return false;
    }

    public boolean isHierachic(String string) {
        int index = string.indexOf(this.m_Seperator);
        return index != string.length() - 1 && index != -1;
    }

    public int search(Vector vct, String target) {
        if (vct == null) {
            return -1;
        }
        int i = 0;
        while (i < vct.size()) {
            if (target.equals(((TreeNode)vct.elementAt((int)i)).value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized boolean goTo(String path) {
        if (!this.isHierachic(path)) {
            if (this.m_Root.value.equals(path)) {
                this.goToRoot();
                return true;
            }
            return false;
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        this.goToRoot();
        String[] nodes = this.tokenize(path);
        if (!this.m_Current.value.equals(nodes[0])) {
            return false;
        }
        int i = 1;
        while (i < nodes.length) {
            int pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
            ++i;
        }
        return true;
    }

    public synchronized boolean goDown(String path) {
        if (!this.isHierachic(path)) {
            return this.goToChild(path);
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        String[] nodes = this.tokenize(path);
        int pos = this.search(old.children, nodes[0]);
        if (pos == -1) {
            this.m_Current = old;
            return false;
        }
        this.m_Current = (TreeNode)old.children.elementAt(pos);
        int i = 1;
        while (i < nodes.length) {
            pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
            ++i;
        }
        return true;
    }

    public synchronized void goToRoot() {
        this.m_Current = this.m_Root;
    }

    public synchronized void goToParent() {
        if (this.m_Current.parent != null) {
            this.m_Current = this.m_Current.parent;
        }
    }

    public synchronized boolean goToChild(String value) {
        if (this.m_Current.children == null) {
            return false;
        }
        int pos = this.search(this.m_Current.children, value);
        if (pos == -1) {
            return false;
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        return true;
    }

    public synchronized void goToChild(int pos) throws Exception {
        if (this.m_Current.children == null || pos < 0 || pos >= this.m_Current.children.size()) {
            Messages.getInstance();
            throw new Exception(Messages.getString("HierarchyPropertyParser_GoToChild_Exception_Text"));
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
    }

    public synchronized int numChildren() {
        if (this.m_Current.children == null) {
            return 0;
        }
        return this.m_Current.children.size();
    }

    public synchronized String[] childrenValues() {
        if (this.m_Current.children == null) {
            return null;
        }
        Vector kids = this.m_Current.children;
        String[] values = new String[kids.size()];
        int i = 0;
        while (i < kids.size()) {
            values[i] = ((TreeNode)kids.elementAt((int)i)).value;
            ++i;
        }
        return values;
    }

    public synchronized String parentValue() {
        if (this.m_Current.parent != null) {
            return this.m_Current.parent.value;
        }
        return null;
    }

    public synchronized boolean isLeafReached() {
        return this.m_Current.children == null;
    }

    public synchronized boolean isRootReached() {
        return this.m_Current.parent == null;
    }

    public synchronized String getValue() {
        return this.m_Current.value;
    }

    public synchronized int getLevel() {
        return this.m_Current.level;
    }

    public int depth() {
        return this.m_Depth;
    }

    public synchronized String context() {
        return this.m_Current.context;
    }

    public synchronized String fullValue() {
        if (this.m_Current == this.m_Root) {
            return this.m_Root.value;
        }
        return String.valueOf(this.m_Current.context) + this.m_Seperator + this.m_Current.value;
    }

    public String showTree() {
        return this.showNode(this.m_Root, null);
    }

    private String showNode(TreeNode node, boolean[] hasBar) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < node.level - 1) {
            if (hasBar[i]) {
                text.append("  |       ");
            } else {
                text.append("          ");
            }
            ++i;
        }
        if (node.level != 0) {
            text.append("  |------ ");
        }
        text.append(String.valueOf(node.value) + "(" + node.level + ")" + "[" + node.context + "]\n");
        if (node.children != null) {
            i = 0;
            while (i < node.children.size()) {
                boolean[] newBar = new boolean[node.level + 1];
                int lvl = node.level;
                if (hasBar != null) {
                    int j = 0;
                    while (j < lvl) {
                        newBar[j] = hasBar[j];
                        ++j;
                    }
                }
                newBar[lvl] = i != node.children.size() - 1;
                text.append(this.showNode((TreeNode)node.children.elementAt(i), newBar));
                ++i;
            }
        }
        return text.toString();
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("node1.node1_1.node1_1_1.node1_1_1_1, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_2, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_3, ");
        sb.append("node1.node1_1.node1_1_2.node1_1_2_1, ");
        sb.append("node1.node1_1.node1_1_3.node1_1_3_1, ");
        sb.append("node1.node1_2.node1_2_1.node1_2_1_1, ");
        sb.append("node1.node1_2.node1_2_3.node1_2_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_2, ");
        String p = sb.toString();
        try {
            HierarchyPropertyParser hpp = new HierarchyPropertyParser(p, ", ");
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_First")) + hpp.getSeperator());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Second")) + hpp.depth());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Third")) + hpp.showTree());
            hpp.goToRoot();
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Fourth"))).append(hpp.goTo("node1.node1_2.node1_2_1")).append(": ").append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            System.out.println(stringBuilder.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fifth")).append(hpp.isLeafReached()).toString());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Sixth")) + hpp.goDown("node1"));
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Seventh")) + hpp.getValue());
            Messages.getInstance();
            StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Eighth"))).append(hpp.goToChild("node1_2_1_1")).append(": ").append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("HierarchyPropertyParser_Main_Text_Nineth")).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder3.append(Messages.getString("HierarchyPropertyParser_Main_Text_Tenth")).append(hpp.isRootReached()).toString());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Eleventh")) + hpp.parentValue());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Twelveth")) + hpp.getLevel());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Thirteenth")) + hpp.context());
            hpp.goToRoot();
            Messages.getInstance();
            StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Fourteenth"))).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder4.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fifteenth")).append(hpp.isRootReached()).toString());
            Messages.getInstance();
            StringBuilder stringBuilder5 = new StringBuilder(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_Sixteenth"))).append(hpp.goDown("node1_1.node1_1_1"));
            Messages.getInstance();
            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("HierarchyPropertyParser_Main_Text_Seventeenth")).append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("HierarchyPropertyParser_Main_Text_Eighteenth")).append(hpp.getLevel());
            Messages.getInstance();
            StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("HierarchyPropertyParser_Main_Text_Nineteenth")).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder8.append(Messages.getString("HierarchyPropertyParser_Main_Text_Twenty")).append(hpp.isRootReached()).toString());
            hpp.goToParent();
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFirst")) + hpp.getValue() + " | " + hpp.fullValue());
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySecond")) + hpp.getLevel());
            String[] chd = hpp.childrenValues();
            int i = 0;
            while (i < chd.length) {
                Messages.getInstance();
                System.out.print(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyThird")) + i + ": " + chd[i]);
                hpp.goDown(chd[i]);
                Messages.getInstance();
                StringBuilder stringBuilder9 = new StringBuilder(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFourth"))).append(hpp.getValue()).append(" | ").append(hpp.fullValue());
                Messages.getInstance();
                StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFifth")).append(hpp.getLevel());
                Messages.getInstance();
                System.out.println(stringBuilder10.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySixth")).toString());
                hpp.goToParent();
                ++i;
            }
            Messages.getInstance();
            System.out.println(String.valueOf(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySeventh")) + hpp.goTo("node1") + ": " + hpp.getValue() + " | " + hpp.fullValue());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private class TreeNode {
        public TreeNode parent = null;
        public String value = null;
        public Vector children = null;
        public int level = 0;
        public String context = null;

        private TreeNode() {
        }
    }
}

