/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.SerializedObject;
import weka.filters.Filter;
import weka.gui.GenericObjectEditor;
import weka.gui.JListHelper;
import weka.gui.Messages;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;

public class GenericArrayEditor
extends JPanel
implements PropertyEditor {
    private static final long serialVersionUID = 3914616975334750480L;
    private PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    private JLabel m_Label;
    private JList m_ElementList;
    private Class m_ElementClass;
    private DefaultListModel m_ListModel;
    private PropertyEditor m_ElementEditor;
    private JButton m_DeleteBut;
    private JButton m_EditBut;
    private JButton m_UpBut;
    private JButton m_DownBut;
    private JButton m_AddBut;
    private PropertyEditor m_Editor;
    private PropertyDialog m_PD;
    private ActionListener m_InnerActionListener;
    private ListSelectionListener m_InnerSelectionListener;
    private MouseListener m_InnerMouseListener;

    public GenericArrayEditor() {
        Messages.getInstance();
        this.m_Label = new JLabel(Messages.getString("GenericArrayEditor_Label_JLabel_Text"), 0);
        this.m_ElementList = new JList();
        this.m_ElementClass = String.class;
        Messages.getInstance();
        this.m_DeleteBut = new JButton(Messages.getString("GenericArrayEditor_DeleteBut_JButton_Text"));
        Messages.getInstance();
        this.m_EditBut = new JButton(Messages.getString("GenericArrayEditor_EditBut_JButton_Text"));
        Messages.getInstance();
        this.m_UpBut = new JButton(Messages.getString("GenericArrayEditor_UpBut_JButton_Text"));
        Messages.getInstance();
        this.m_DownBut = new JButton(Messages.getString("GenericArrayEditor_DownBut_JButton_Text"));
        Messages.getInstance();
        this.m_AddBut = new JButton(Messages.getString("GenericArrayEditor_AddBut_JButton_Text"));
        this.m_Editor = new GenericObjectEditor();
        this.m_InnerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == GenericArrayEditor.this.m_DeleteBut) {
                    int[] selected = GenericArrayEditor.this.m_ElementList.getSelectedIndices();
                    if (selected != null) {
                        int i = selected.length - 1;
                        while (i >= 0) {
                            int current = selected[i];
                            GenericArrayEditor.this.m_ListModel.removeElementAt(current);
                            if (GenericArrayEditor.this.m_ListModel.size() > current) {
                                GenericArrayEditor.this.m_ElementList.setSelectedIndex(current);
                            }
                            --i;
                        }
                        GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                    }
                } else if (e.getSource() == GenericArrayEditor.this.m_EditBut) {
                    if (GenericArrayEditor.this.m_Editor instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)GenericArrayEditor.this.m_Editor).setClassType(GenericArrayEditor.this.m_ElementClass);
                    }
                    try {
                        GenericArrayEditor.this.m_Editor.setValue(GenericObjectEditor.makeCopy(GenericArrayEditor.this.m_ElementList.getSelectedValue()));
                    }
                    catch (Exception ex) {
                        GenericArrayEditor.this.m_Editor.setValue(GenericArrayEditor.this.m_ElementList.getSelectedValue());
                    }
                    if (GenericArrayEditor.this.m_Editor.getValue() != null) {
                        int x = GenericArrayEditor.this.getLocationOnScreen().x;
                        int y = GenericArrayEditor.this.getLocationOnScreen().y;
                        if (PropertyDialog.getParentDialog(GenericArrayEditor.this) != null) {
                            GenericArrayEditor.this.m_PD = new PropertyDialog(PropertyDialog.getParentDialog(GenericArrayEditor.this), GenericArrayEditor.this.m_Editor, x, y);
                        } else {
                            GenericArrayEditor.this.m_PD = new PropertyDialog(PropertyDialog.getParentFrame(GenericArrayEditor.this), GenericArrayEditor.this.m_Editor, x, y);
                        }
                        GenericArrayEditor.this.m_PD.setVisible(true);
                        GenericArrayEditor.this.m_ListModel.set(GenericArrayEditor.this.m_ElementList.getSelectedIndex(), GenericArrayEditor.this.m_Editor.getValue());
                        GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                    }
                } else if (e.getSource() == GenericArrayEditor.this.m_UpBut) {
                    JListHelper.moveUp(GenericArrayEditor.this.m_ElementList);
                    GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                } else if (e.getSource() == GenericArrayEditor.this.m_DownBut) {
                    JListHelper.moveDown(GenericArrayEditor.this.m_ElementList);
                    GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                } else if (e.getSource() == GenericArrayEditor.this.m_AddBut) {
                    int selected = GenericArrayEditor.this.m_ElementList.getSelectedIndex();
                    Object addObj = GenericArrayEditor.this.m_ElementEditor.getValue();
                    try {
                        SerializedObject so = new SerializedObject(addObj);
                        addObj = so.getObject();
                        if (selected != -1) {
                            GenericArrayEditor.this.m_ListModel.insertElementAt(addObj, selected);
                        } else {
                            GenericArrayEditor.this.m_ListModel.addElement(addObj);
                        }
                        GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                    }
                    catch (Exception ex) {
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(GenericArrayEditor.this, Messages.getString("GenericArrayEditor_InnerActionListener_JOptionPaneShowMessageDialog_Text"), null, 0);
                    }
                }
            }
        };
        this.m_InnerSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource() == GenericArrayEditor.this.m_ElementList) {
                    if (GenericArrayEditor.this.m_ElementList.getSelectedIndex() != -1) {
                        GenericArrayEditor.this.m_DeleteBut.setEnabled(true);
                        GenericArrayEditor.this.m_EditBut.setEnabled(GenericArrayEditor.this.m_ElementList.getSelectedIndices().length == 1);
                        GenericArrayEditor.this.m_UpBut.setEnabled(JListHelper.canMoveUp(GenericArrayEditor.this.m_ElementList));
                        GenericArrayEditor.this.m_DownBut.setEnabled(JListHelper.canMoveDown(GenericArrayEditor.this.m_ElementList));
                    } else {
                        GenericArrayEditor.this.m_DeleteBut.setEnabled(false);
                        GenericArrayEditor.this.m_EditBut.setEnabled(false);
                        GenericArrayEditor.this.m_UpBut.setEnabled(false);
                        GenericArrayEditor.this.m_DownBut.setEnabled(false);
                    }
                }
            }
        };
        this.m_InnerMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getSource() == GenericArrayEditor.this.m_ElementList && e.getClickCount() == 2 && (index = GenericArrayEditor.this.m_ElementList.locationToIndex(e.getPoint())) > -1) {
                    GenericArrayEditor.this.m_InnerActionListener.actionPerformed(new ActionEvent(GenericArrayEditor.this.m_EditBut, 0, ""));
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Label, "Center");
        this.m_DeleteBut.addActionListener(this.m_InnerActionListener);
        this.m_EditBut.addActionListener(this.m_InnerActionListener);
        this.m_UpBut.addActionListener(this.m_InnerActionListener);
        this.m_DownBut.addActionListener(this.m_InnerActionListener);
        this.m_AddBut.addActionListener(this.m_InnerActionListener);
        this.m_ElementList.addListSelectionListener(this.m_InnerSelectionListener);
        this.m_ElementList.addMouseListener(this.m_InnerMouseListener);
        Messages.getInstance();
        this.m_AddBut.setToolTipText(Messages.getString("GenericArrayEditor_AddBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_DeleteBut.setToolTipText(Messages.getString("GenericArrayEditor_DeleteBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_EditBut.setToolTipText(Messages.getString("GenericArrayEditor_EditBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_UpBut.setToolTipText(Messages.getString("GenericArrayEditor_UpBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_DownBut.setToolTipText(Messages.getString("GenericArrayEditor_DownBut_SetToolTipText_Text"));
    }

    private void updateEditorType(Object o) {
        this.m_ElementEditor = null;
        this.m_ListModel = null;
        this.removeAll();
        if (o != null && o.getClass().isArray()) {
            Class<?> elementClass = o.getClass().getComponentType();
            PropertyEditor editor = PropertyEditorManager.findEditor(elementClass);
            JComponent view = null;
            ListCellRenderer<Object> lcr = new DefaultListCellRenderer();
            if (editor != null) {
                if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setClassType(elementClass);
                }
                if (Array.getLength(o) > 0) {
                    editor.setValue(GenericArrayEditor.makeCopy(Array.get(o, 0)));
                } else if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setDefaultValue();
                } else {
                    try {
                        editor.setValue(elementClass.newInstance());
                    }
                    catch (Exception ex) {
                        this.m_ElementEditor = null;
                        System.err.println(ex.getMessage());
                        this.add((Component)this.m_Label, "Center");
                        this.m_Support.firePropertyChange("", null, null);
                        this.validate();
                        return;
                    }
                }
                if (editor.isPaintable() && editor.supportsCustomEditor()) {
                    view = new PropertyPanel(editor);
                    lcr = new EditorListCellRenderer(editor.getClass(), elementClass);
                } else if (editor.getTags() != null) {
                    view = new PropertyValueSelector(editor);
                } else if (editor.getAsText() != null) {
                    view = new PropertyText(editor);
                }
            }
            if (view == null) {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("GenericArrayEditor_UpdateEditorType_Error_Text")) + elementClass.getName());
            } else {
                this.m_ElementEditor = editor;
                this.m_ListModel = new DefaultListModel();
                this.m_ElementClass = elementClass;
                int i = 0;
                while (i < Array.getLength(o)) {
                    this.m_ListModel.addElement(Array.get(o, i));
                    ++i;
                }
                this.m_ElementList.setCellRenderer(lcr);
                this.m_ElementList.setModel(this.m_ListModel);
                if (this.m_ListModel.getSize() > 0) {
                    this.m_ElementList.setSelectedIndex(0);
                } else {
                    this.m_DeleteBut.setEnabled(false);
                    this.m_EditBut.setEnabled(false);
                }
                this.m_UpBut.setEnabled(JListHelper.canMoveDown(this.m_ElementList));
                this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_ElementList));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)view, "Center");
                panel.add((Component)this.m_AddBut, "East");
                this.add((Component)panel, "North");
                this.add((Component)new JScrollPane(this.m_ElementList), "Center");
                JPanel panel2 = new JPanel();
                panel2.setLayout(new GridLayout(1, 4));
                panel2.add(this.m_DeleteBut);
                panel2.add(this.m_EditBut);
                panel2.add(this.m_UpBut);
                panel2.add(this.m_DownBut);
                this.add((Component)panel2, "South");
                this.m_ElementEditor.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        GenericArrayEditor.this.repaint();
                    }
                });
            }
        }
        if (this.m_ElementEditor == null) {
            this.add((Component)this.m_Label, "Center");
        }
        this.m_Support.firePropertyChange("", null, null);
        this.validate();
    }

    @Override
    public void setValue(Object o) {
        this.updateEditorType(o);
    }

    @Override
    public Object getValue() {
        if (this.m_ListModel == null) {
            return null;
        }
        int length = this.m_ListModel.getSize();
        Object result = Array.newInstance(this.m_ElementClass, length);
        int i = 0;
        while (i < length) {
            Array.set(result, i, this.m_ListModel.elementAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String rep = String.valueOf(this.m_ListModel.getSize()) + " " + this.m_ElementClass.getName();
        gfx.drawString(rep, 2, fm.getAscent() + vpad + 2);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    public static Object makeCopy(Object source) {
        Object result;
        try {
            result = GenericObjectEditor.makeCopy(source);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            GenericArrayEditor ce = new GenericArrayEditor();
            Filter[] initial = new Filter[]{};
            PropertyDialog pd = new PropertyDialog(null, (PropertyEditor)ce, 100, 100);
            pd.setSize(200, 200);
            pd.addWindowListener(new WindowAdapter(){
                private static final long serialVersionUID = -3124434678426673334L;

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ce.setValue(initial);
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    private class EditorListCellRenderer
    implements ListCellRenderer {
        private Class m_EditorClass;
        private Class m_ValueClass;

        public EditorListCellRenderer(Class editorClass, Class valueClass) {
            this.m_EditorClass = editorClass;
            this.m_ValueClass = valueClass;
        }

        public Component getListCellRendererComponent(final JList list, Object value, int index, final boolean isSelected, boolean cellHasFocus) {
            try {
                final PropertyEditor e = (PropertyEditor)this.m_EditorClass.newInstance();
                if (e instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)e).setClassType(this.m_ValueClass);
                }
                e.setValue(value);
                return new JPanel(){
                    private static final long serialVersionUID = -3124434678426673334L;

                    @Override
                    public void paintComponent(Graphics g) {
                        Insets i = this.getInsets();
                        Rectangle box = new Rectangle(i.left, i.top, this.getWidth() - i.right, this.getHeight() - i.bottom);
                        g.setColor(isSelected ? list.getSelectionBackground() : list.getBackground());
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g.setColor(isSelected ? list.getSelectionForeground() : list.getForeground());
                        e.paintValue(g, box);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Font f = this.getFont();
                        FontMetrics fm = this.getFontMetrics(f);
                        return new Dimension(0, fm.getHeight());
                    }
                };
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

