/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.Messages;

public class AttributeSummaryPanel
extends JPanel {
    static final long serialVersionUID = -5434987925737735880L;
    protected static final String NO_SOURCE;
    protected JLabel m_AttributeNameLab = new JLabel(NO_SOURCE);
    protected JLabel m_AttributeTypeLab = new JLabel(NO_SOURCE);
    protected JLabel m_MissingLab = new JLabel(NO_SOURCE);
    protected JLabel m_UniqueLab = new JLabel(NO_SOURCE);
    protected JLabel m_DistinctLab = new JLabel(NO_SOURCE);
    protected JTable m_StatsTable = new JTable(){
        private static final long serialVersionUID = 7165142874670048578L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    protected Instances m_Instances;
    protected AttributeStats[] m_AttributeStats;

    static {
        Messages.getInstance();
        NO_SOURCE = Messages.getString("AttributeSummaryPanel_NO_SOURCE_Text");
    }

    public AttributeSummaryPanel() {
        JPanel simple = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        simple.setLayout(gbL);
        Messages.getInstance();
        JLabel lab = new JLabel(Messages.getString("AttributeSummaryPanel_Lab_JLabel_Text_First"), 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.gridwidth = 3;
        gbL.setConstraints(this.m_AttributeNameLab, gbC);
        simple.add(this.m_AttributeNameLab);
        this.m_AttributeNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        Messages.getInstance();
        lab = new JLabel(Messages.getString("AttributeSummaryPanel_Lab_JLabel_Text_Second"), 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 4;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 5;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_AttributeTypeLab, gbC);
        simple.add(this.m_AttributeTypeLab);
        this.m_AttributeTypeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        Messages.getInstance();
        lab = new JLabel(Messages.getString("AttributeSummaryPanel_Lab_JLabel_Text_Third"), 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_MissingLab, gbC);
        simple.add(this.m_MissingLab);
        this.m_MissingLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        Messages.getInstance();
        lab = new JLabel(Messages.getString("AttributeSummaryPanel_Lab_JLabel_Text_Fourth"), 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 2;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 3;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_DistinctLab, gbC);
        simple.add(this.m_DistinctLab);
        this.m_DistinctLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        Messages.getInstance();
        lab = new JLabel(Messages.getString("AttributeSummaryPanel_Lab_JLabel_Text_Fifth"), 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 4;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 5;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_UniqueLab, gbC);
        simple.add(this.m_UniqueLab);
        this.m_UniqueLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)simple, "North");
        this.add((Component)new JScrollPane(this.m_StatsTable), "Center");
        this.m_StatsTable.getSelectionModel().setSelectionMode(0);
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_AttributeStats = new AttributeStats[inst.numAttributes()];
        this.m_AttributeNameLab.setText(NO_SOURCE);
        this.m_AttributeTypeLab.setText(NO_SOURCE);
        this.m_MissingLab.setText(NO_SOURCE);
        this.m_UniqueLab.setText(NO_SOURCE);
        this.m_DistinctLab.setText(NO_SOURCE);
        this.m_StatsTable.setModel(new DefaultTableModel());
    }

    public void setAttribute(final int index) {
        this.setHeader(index);
        if (this.m_AttributeStats[index] == null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    AttributeSummaryPanel.this.m_AttributeStats[index] = AttributeSummaryPanel.this.m_Instances.attributeStats(index);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AttributeSummaryPanel.this.setDerived(index);
                            (this).AttributeSummaryPanel.this.m_StatsTable.sizeColumnsToFit(-1);
                            (this).AttributeSummaryPanel.this.m_StatsTable.revalidate();
                            (this).AttributeSummaryPanel.this.m_StatsTable.repaint();
                        }
                    });
                }
            };
            t.setPriority(1);
            t.start();
        } else {
            this.setDerived(index);
        }
    }

    protected void setDerived(int index) {
        AttributeStats as = this.m_AttributeStats[index];
        long percent = Math.round(100.0 * (double)as.missingCount / (double)as.totalCount);
        this.m_MissingLab.setText(as.missingCount + " (" + percent + "%)");
        percent = Math.round(100.0 * (double)as.uniqueCount / (double)as.totalCount);
        this.m_UniqueLab.setText(as.uniqueCount + " (" + percent + "%)");
        this.m_DistinctLab.setText("" + as.distinctCount);
        this.setTable(as, index);
    }

    protected void setTable(AttributeStats as, int index) {
        if (as.nominalCounts != null) {
            Attribute att = this.m_Instances.attribute(index);
            Object[] objectArray = new Object[3];
            Messages.getInstance();
            objectArray[0] = Messages.getString("AttributeSummaryPanel_SetTable_ColNames_Text_First");
            Messages.getInstance();
            objectArray[1] = Messages.getString("AttributeSummaryPanel_SetTable_ColNames_Text_Second");
            Messages.getInstance();
            objectArray[2] = Messages.getString("AttributeSummaryPanel_SetTable_ColNames_Text_Third");
            Object[] colNames = objectArray;
            Object[][] data = new Object[as.nominalCounts.length][3];
            int i = 0;
            while (i < as.nominalCounts.length) {
                data[i][0] = new Integer(i + 1);
                data[i][1] = att.value(i);
                data[i][2] = new Integer(as.nominalCounts[i]);
                ++i;
            }
            this.m_StatsTable.setModel(new DefaultTableModel(data, colNames));
            this.m_StatsTable.getColumnModel().getColumn(0).setMaxWidth(60);
            DefaultTableCellRenderer tempR = new DefaultTableCellRenderer();
            tempR.setHorizontalAlignment(4);
            this.m_StatsTable.getColumnModel().getColumn(0).setCellRenderer(tempR);
        } else if (as.numericStats != null) {
            Object[] objectArray = new Object[2];
            Messages.getInstance();
            objectArray[0] = Messages.getString("AttributeSummaryPanel_SetTable_ColNames_Text_Fourth");
            Messages.getInstance();
            objectArray[1] = Messages.getString("AttributeSummaryPanel_SetTable_ColNames_Text_Fifth");
            Object[] colNames = objectArray;
            Object[][] data = new Object[4][2];
            Object[] objectArray2 = data[0];
            Messages.getInstance();
            objectArray2[0] = Messages.getString("AttributeSummaryPanel_SetTable_Data_0_Text");
            data[0][1] = Utils.doubleToString(as.numericStats.min, 3);
            Object[] objectArray3 = data[1];
            Messages.getInstance();
            objectArray3[0] = Messages.getString("AttributeSummaryPanel_SetTable_Data_1_Text");
            data[1][1] = Utils.doubleToString(as.numericStats.max, 3);
            Object[] objectArray4 = data[2];
            Messages.getInstance();
            objectArray4[0] = Messages.getString("AttributeSummaryPanel_SetTable_Data_2_Text");
            data[2][1] = Utils.doubleToString(as.numericStats.mean, 3);
            Object[] objectArray5 = data[3];
            Messages.getInstance();
            objectArray5[0] = Messages.getString("AttributeSummaryPanel_SetTable_Data_3_Text");
            data[3][1] = Utils.doubleToString(as.numericStats.stdDev, 3);
            this.m_StatsTable.setModel(new DefaultTableModel(data, colNames));
        } else {
            this.m_StatsTable.setModel(new DefaultTableModel());
        }
        this.m_StatsTable.getColumnModel().setColumnMargin(4);
    }

    protected void setHeader(int index) {
        Attribute att = this.m_Instances.attribute(index);
        this.m_AttributeNameLab.setText(att.name());
        switch (att.type()) {
            case 1: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeNOMINAL_Text"));
                break;
            }
            case 0: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeNUMERIC_Text"));
                break;
            }
            case 2: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeSTRING_Text"));
                break;
            }
            case 3: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeDATE_Text"));
                break;
            }
            case 4: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeRELATIONAL_Text"));
                break;
            }
            default: {
                Messages.getInstance();
                this.m_AttributeTypeLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_AttributeDEFAULT_TEXT"));
            }
        }
        Messages.getInstance();
        this.m_MissingLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_MissingLab_SetText_Text"));
        Messages.getInstance();
        this.m_UniqueLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_UniqueLab_SetText_Text"));
        Messages.getInstance();
        this.m_DistinctLab.setText(Messages.getString("AttributeSummaryPanel_SetHeader_DistinctLab_SetText_Text"));
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("AttributeSummaryPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            AttributeSummaryPanel p = new AttributeSummaryPanel();
            Messages.getInstance();
            p.setBorder(BorderFactory.createTitledBorder(Messages.getString("AttributeSummaryPanel_Main_P_SetBorder_BorderFactoryCreateTitledBorder")));
            jf.getContentPane().add((Component)p, "Center");
            final JComboBox<String> j = new JComboBox<String>();
            j.setEnabled(false);
            j.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSummaryPanel.this.setAttribute(j.getSelectedIndex());
                }
            });
            jf.getContentPane().add(j, "North");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances inst = new Instances(r);
                p.setInstances(inst);
                p.setAttribute(0);
                String[] names = new String[inst.numAttributes()];
                int i = 0;
                while (i < names.length) {
                    names[i] = inst.attribute(i).name();
                    ++i;
                }
                j.setModel(new DefaultComboBoxModel<String>(names));
                j.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

