/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;

public abstract class RegressionGenerator
extends DataGenerator {
    private static final long serialVersionUID = 3073254041275658221L;
    protected int m_NumExamples;

    public RegressionGenerator() {
        this.setNumExamples(this.defaultNumExamples());
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of examples to generate (default " + this.defaultNumExamples() + ")", "n", 1, "-n <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('n', options);
        if (tmpStr.length() != 0) {
            this.setNumExamples(Integer.parseInt(tmpStr));
        } else {
            this.setNumExamples(this.defaultNumExamples());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-n");
        result.add("" + this.getNumExamples());
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumExamples() {
        return 100;
    }

    public void setNumExamples(int numExamples) {
        this.m_NumExamples = numExamples;
    }

    public int getNumExamples() {
        return this.m_NumExamples;
    }

    public String numExamplesTipText() {
        return "The number of examples to generate.";
    }
}

