/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.ConverterUtils;

public class CSVLoader
extends AbstractFileLoader
implements BatchConverter,
OptionHandler {
    static final long serialVersionUID = 5607529739745491340L;
    public static String FILE_EXTENSION = ".csv";
    protected FastVector m_cumulativeStructure;
    protected FastVector m_cumulativeInstances;
    protected transient BufferedReader m_sourceReader;
    protected transient StreamTokenizer m_st;
    protected Range m_NominalAttributes = new Range();
    protected Range m_StringAttributes = new Range();
    protected Range m_dateAttributes = new Range();
    protected String m_dateFormat = "";
    protected SimpleDateFormat m_formatter;
    protected String m_MissingValue = "?";
    protected boolean m_FirstCheck;
    protected String m_Enclosures = "\"";

    public CSVLoader() {
        this.setRetrieval(0);
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String getFileDescription() {
        return "CSV data files";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String globalInfo() {
        return "Reads a source that is in comma separated or tab separated format. Assumes that the first row in the file determines the number of and names of the attributes.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe range of attributes to force type to be NOMINAL.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "N", 1, "-N <range>"));
        result.addElement(new Option("\tThe range of attribute to force type to be STRING.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "S", 1, "-S <range>"));
        result.add(new Option("\tThe range of attribute to force type to be DATE.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "D", 1, "-D <range>"));
        result.add(new Option("\tThe date formatting string to use to parse date values.\n\t(default: \"yyyy-MM-dd'T'HH:mm:ss\")", "format", 1, "-format <date format>"));
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        result.addElement(new Option("\tThe enclosure character(s) to use for strings.\n\tSpecify as a comma separated list (e.g. \",'(default: '\"')", "E", 1, "-E <enclosures>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNominalAttributes(tmpStr);
        } else {
            this.setNominalAttributes("");
        }
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setStringAttributes(tmpStr);
        } else {
            this.setStringAttributes("");
        }
        tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        } else {
            this.setMissingValue("?");
        }
        tmpStr = Utils.getOption('D', options);
        if (tmpStr.length() > 0) {
            this.setDateAttributes(tmpStr);
        }
        if ((tmpStr = Utils.getOption("format", options)).length() > 0) {
            this.setDateFormat(tmpStr);
        }
        if ((tmpStr = Utils.getOption("E", options)).length() > 0) {
            this.setEnclosureCharacters(tmpStr);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getNominalAttributes().length() > 0) {
            result.add("-N");
            result.add(this.getNominalAttributes());
        }
        if (this.getStringAttributes().length() > 0) {
            result.add("-S");
            result.add(this.getStringAttributes());
        }
        if (this.getDateAttributes().length() > 0) {
            result.add("-D");
            result.add(this.getDateAttributes());
            result.add("-format");
            result.add(this.getDateFormat());
        }
        result.add("-M");
        result.add(this.getMissingValue());
        result.add("-E");
        result.add(this.getEnclosureCharacters());
        return result.toArray(new String[result.size()]);
    }

    public void setNominalAttributes(String value) {
        this.m_NominalAttributes.setRanges(value);
    }

    public String getNominalAttributes() {
        return this.m_NominalAttributes.getRanges();
    }

    public String nominalAttributesTipText() {
        return "The range of attributes to force to be of type NOMINAL, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setStringAttributes(String value) {
        this.m_StringAttributes.setRanges(value);
    }

    public String getStringAttributes() {
        return this.m_StringAttributes.getRanges();
    }

    public String stringAttributesTipText() {
        return "The range of attributes to force to be of type STRING, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setDateAttributes(String value) {
        this.m_dateAttributes.setRanges(value);
    }

    public String getDateAttributes() {
        return this.m_dateAttributes.getRanges();
    }

    public String dateAttributesTipText() {
        return "The range of attributes to force to type STRING, example ranges: 'first-last', '1,4,7-14, 50-last'.";
    }

    public void setDateFormat(String value) {
        this.m_dateFormat = value;
        this.m_formatter = null;
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public String dateFormatTipText() {
        return "The format to use for parsing date values.";
    }

    public String enclosureCharactersTipText() {
        return "The characters to use as enclosures for strings. E.g. \",'";
    }

    public void setEnclosureCharacters(String enclosure) {
        this.m_Enclosures = enclosure;
    }

    public String getEnclosureCharacters() {
        return this.m_Enclosures;
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '?'.";
    }

    @Override
    public void setSource(InputStream input) throws IOException {
        this.m_structure = null;
        this.m_sourceFile = null;
        this.m_File = null;
        this.m_FirstCheck = true;
        this.m_sourceReader = new BufferedReader(new InputStreamReader(input));
    }

    @Override
    public void setSource(File file) throws IOException {
        super.setSource(file);
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_sourceFile == null && this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_st = new StreamTokenizer(this.m_sourceReader);
                this.initTokenizer(this.m_st);
                this.readStructure(this.m_st);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.m_structure;
    }

    private void readStructure(StreamTokenizer st) throws IOException {
        this.readHeader(st);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Instances getDataSet() throws IOException {
        FastVector current;
        if (this.m_sourceFile == null && this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.getStructure();
        }
        if (this.m_st == null) {
            this.m_st = new StreamTokenizer(this.m_sourceReader);
            this.initTokenizer(this.m_st);
        }
        this.m_st.ordinaryChar(44);
        this.m_st.ordinaryChar(9);
        this.m_cumulativeStructure = new FastVector(this.m_structure.numAttributes());
        int i = 0;
        while (i < this.m_structure.numAttributes()) {
            this.m_cumulativeStructure.addElement(new Hashtable());
            ++i;
        }
        this.m_cumulativeInstances = new FastVector();
        while ((current = this.getInstance(this.m_st)) != null) {
            this.m_cumulativeInstances.addElement(current);
        }
        FastVector atts = new FastVector(this.m_structure.numAttributes());
        int i2 = 0;
        while (i2 < this.m_structure.numAttributes()) {
            String attname = this.m_structure.attribute(i2).name();
            Hashtable tempHash = (Hashtable)this.m_cumulativeStructure.elementAt(i2);
            if (tempHash.size() == 0) {
                if (this.m_dateAttributes.isInRange(i2)) {
                    atts.addElement(new Attribute(attname, this.m_dateFormat));
                } else {
                    atts.addElement(new Attribute(attname));
                }
            } else if (this.m_StringAttributes.isInRange(i2)) {
                atts.addElement(new Attribute(attname, null));
            } else {
                FastVector values = new FastVector(tempHash.size());
                int z = 0;
                while (z < tempHash.size()) {
                    values.addElement("dummy");
                    ++z;
                }
                Enumeration e = tempHash.keys();
                while (e.hasMoreElements()) {
                    Object ob = e.nextElement();
                    int index = (Integer)tempHash.get(ob);
                    String s = ob.toString();
                    if (s.startsWith("'") || s.startsWith("\"")) {
                        s = s.substring(1, s.length() - 1);
                    }
                    values.setElementAt(new String(s), index);
                }
                atts.addElement(new Attribute(attname, values));
            }
            ++i2;
        }
        String relationName = this.m_sourceFile != null ? this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "") : "stream";
        Instances dataSet = new Instances(relationName, atts, this.m_cumulativeInstances.size());
        int i3 = 0;
        while (i3 < this.m_cumulativeInstances.size()) {
            current = (FastVector)this.m_cumulativeInstances.elementAt(i3);
            double[] vals = new double[dataSet.numAttributes()];
            int j = 0;
            while (j < current.size()) {
                int index;
                Hashtable lookup;
                Object cval = current.elementAt(j);
                if (cval instanceof String) {
                    if (((String)cval).compareTo(this.m_MissingValue) == 0) {
                        vals[j] = Instance.missingValue();
                    } else if (dataSet.attribute(j).isString()) {
                        vals[j] = dataSet.attribute(j).addStringValue((String)cval);
                    } else {
                        if (!dataSet.attribute(j).isNominal()) throw new IllegalStateException("Wrong attribute type at position " + (i3 + 1) + "!!!");
                        lookup = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                        index = (Integer)lookup.get(cval);
                        vals[j] = index;
                    }
                } else if (dataSet.attribute(j).isNominal()) {
                    lookup = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                    index = (Integer)lookup.get(cval);
                    vals[j] = index;
                } else {
                    vals[j] = dataSet.attribute(j).isString() ? (double)dataSet.attribute(j).addStringValue("" + cval) : (Double)cval;
                }
                ++j;
            }
            dataSet.add(new Instance(1.0, vals));
            ++i3;
        }
        this.m_structure = new Instances(dataSet, 0);
        this.setRetrieval(1);
        this.m_cumulativeStructure = null;
        this.m_sourceReader.close();
        return dataSet;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("CSVLoader can't read data sets incrementally.");
    }

    private FastVector getInstance(StreamTokenizer tokenizer) throws IOException {
        FastVector current = new FastVector();
        ConverterUtils.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return null;
        }
        boolean first = true;
        while (tokenizer.ttype != 10 && tokenizer.ttype != -1) {
            boolean wasSep;
            if (!first) {
                ConverterUtils.getToken(tokenizer);
            }
            if (tokenizer.ttype == 44 || tokenizer.ttype == 9 || tokenizer.ttype == 10) {
                current.addElement(this.m_MissingValue);
                wasSep = true;
            } else {
                wasSep = false;
                if (tokenizer.sval.equals(this.m_MissingValue)) {
                    current.addElement(new String(this.m_MissingValue));
                } else {
                    try {
                        double val = Double.valueOf(tokenizer.sval);
                        current.addElement(new Double(val));
                    }
                    catch (NumberFormatException e) {
                        current.addElement(new String(tokenizer.sval));
                    }
                }
            }
            if (!wasSep) {
                ConverterUtils.getToken(tokenizer);
            }
            first = false;
        }
        if (current.size() != this.m_structure.numAttributes()) {
            ConverterUtils.errms(tokenizer, "wrong number of values. Read " + current.size() + ", expected " + this.m_structure.numAttributes());
        }
        try {
            this.checkStructure(current);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return current;
    }

    private void checkStructure(FastVector current) throws Exception {
        if (current == null) {
            throw new Exception("current shouldn't be null in checkStructure");
        }
        if (this.m_FirstCheck) {
            this.m_NominalAttributes.setUpper(current.size() - 1);
            this.m_StringAttributes.setUpper(current.size() - 1);
            this.m_dateAttributes.setUpper(current.size() - 1);
            this.m_FirstCheck = false;
        }
        int i = 0;
        while (i < current.size()) {
            Object ob = current.elementAt(i);
            if (ob instanceof String || this.m_NominalAttributes.isInRange(i) || this.m_StringAttributes.isInRange(i) || this.m_dateAttributes.isInRange(i)) {
                if (ob.toString().compareTo(this.m_MissingValue) != 0) {
                    Hashtable tempHash;
                    boolean notDate = true;
                    if (this.m_dateAttributes.isInRange(i)) {
                        if (this.m_formatter == null) {
                            this.m_formatter = new SimpleDateFormat(this.m_dateFormat);
                        }
                        try {
                            long time = this.m_formatter.parse(ob.toString()).getTime();
                            Double timeL = new Double(time);
                            current.setElementAt(timeL, i);
                            notDate = false;
                        }
                        catch (ParseException e) {
                            notDate = true;
                        }
                    }
                    if (notDate && !(tempHash = (Hashtable)this.m_cumulativeStructure.elementAt(i)).containsKey(ob)) {
                        if (tempHash.size() == 0) {
                            int j = 0;
                            while (j < this.m_cumulativeInstances.size()) {
                                FastVector tempUpdate = (FastVector)this.m_cumulativeInstances.elementAt(j);
                                Object tempO = tempUpdate.elementAt(i);
                                if (!(tempO instanceof String) && !tempHash.containsKey(tempO)) {
                                    tempHash.put(new Double((Double)tempO), new Integer(tempHash.size()));
                                }
                                ++j;
                            }
                        }
                        int newIndex = tempHash.size();
                        tempHash.put(ob, new Integer(newIndex));
                    }
                }
            } else if (ob instanceof Double) {
                Hashtable tempHash = (Hashtable)this.m_cumulativeStructure.elementAt(i);
                if (tempHash.size() != 0 && !tempHash.containsKey(ob)) {
                    int newIndex = tempHash.size();
                    tempHash.put(new Double((Double)ob), new Integer(newIndex));
                }
            } else {
                throw new Exception("Wrong object type in checkStructure!");
            }
            ++i;
        }
    }

    private void readHeader(StreamTokenizer tokenizer) throws IOException {
        FastVector attribNames = new FastVector();
        ConverterUtils.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            ConverterUtils.errms(tokenizer, "premature end of file");
        }
        while (tokenizer.ttype != 10) {
            attribNames.addElement(new Attribute(tokenizer.sval, null));
            ConverterUtils.getToken(tokenizer);
        }
        String relationName = this.m_sourceFile != null ? this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "") : "stream";
        this.m_structure = new Instances(relationName, attribNames, 0);
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        String[] parts;
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 31);
        tokenizer.wordChars(32, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.commentChar(37);
        String[] stringArray = parts = this.m_Enclosures.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e.length() > 1 || e.length() == 0) {
                throw new IllegalArgumentException("Enclosures can only be single characters");
            }
            tokenizer.quoteChar(e.charAt(0));
            ++n2;
        }
        tokenizer.eolIsSignificant(true);
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.m_st = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9041 $");
    }

    public static void main(String[] args) {
        CSVLoader.runFileLoader(new CSVLoader(), args);
    }
}

