/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.Stats;

public class Instances
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -19412345060742748L;
    public static final String FILE_EXTENSION = ".arff";
    public static final String SERIALIZED_OBJ_FILE_EXTENSION = ".bsi";
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected String m_RelationName;
    protected FastVector m_Attributes;
    protected FastVector m_Instances;
    protected int m_ClassIndex;
    protected int m_Lines = 0;
    private int attIdx4Randomization = -1;
    private double[] attIdxOrigValues;

    public Instances(Reader reader) throws IOException {
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader);
        Instances dataset = arff.getData();
        this.initialize(dataset, dataset.numInstances());
        dataset.copyInstances(0, this, dataset.numInstances());
        this.compactify();
    }

    @Deprecated
    public Instances(Reader reader, int capacity) throws IOException {
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader, 0);
        Instances header = arff.getStructure();
        this.initialize(header, capacity);
        this.m_Lines = arff.getLineNo();
    }

    public Instances(Instances dataset) {
        this(dataset, dataset.numInstances());
        dataset.copyInstances(0, this, dataset.numInstances());
    }

    public Instances(Instances dataset, int capacity) {
        this.initialize(dataset, capacity);
    }

    protected void initialize(Instances dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.m_ClassIndex = dataset.m_ClassIndex;
        this.m_RelationName = dataset.m_RelationName;
        this.m_Attributes = dataset.m_Attributes;
        this.m_Instances = new FastVector(capacity);
    }

    public Instances(Instances source, int first, int toCopy) {
        this(source, toCopy);
        if (first < 0 || first + toCopy > source.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        source.copyInstances(first, this, toCopy);
    }

    public Instances(String name, FastVector attInfo, int capacity) {
        HashSet<String> names = new HashSet<String>();
        StringBuffer nonUniqueNames = new StringBuffer();
        int i = 0;
        while (i < attInfo.size()) {
            if (names.contains(((Attribute)attInfo.elementAt(i)).name())) {
                nonUniqueNames.append("'" + ((Attribute)attInfo.elementAt(i)).name() + "' ");
            }
            names.add(((Attribute)attInfo.elementAt(i)).name());
            ++i;
        }
        if (names.size() != attInfo.size()) {
            throw new IllegalArgumentException("Attribute names are not unique! Causes: " + nonUniqueNames.toString());
        }
        names.clear();
        this.m_RelationName = name;
        this.m_ClassIndex = -1;
        this.m_Attributes = attInfo;
        i = 0;
        while (i < this.numAttributes()) {
            this.attribute(i).setIndex(i);
            ++i;
        }
        this.m_Instances = new FastVector(capacity);
    }

    public Instances stringFreeStructure() {
        FastVector newAtts = new FastVector();
        int i = 0;
        while (i < this.m_Attributes.size()) {
            Attribute att = (Attribute)this.m_Attributes.elementAt(i);
            if (att.type() == 2) {
                newAtts.addElement(new Attribute(att.name(), null, i));
            } else if (att.type() == 4) {
                newAtts.addElement(new Attribute(att.name(), new Instances(att.relation(), 0), i));
            }
            ++i;
        }
        if (newAtts.size() == 0) {
            return new Instances(this, 0);
        }
        FastVector atts = (FastVector)this.m_Attributes.copy();
        int i2 = 0;
        while (i2 < newAtts.size()) {
            atts.setElementAt(newAtts.elementAt(i2), ((Attribute)newAtts.elementAt(i2)).index());
            ++i2;
        }
        Instances result = new Instances(this, 0);
        result.m_Attributes = atts;
        return result;
    }

    public void add(Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this);
        this.m_Instances.addElement(newInstance);
    }

    public Attribute attribute(int index) {
        return (Attribute)this.m_Attributes.elementAt(index);
    }

    public Attribute attribute(String name) {
        int i = 0;
        while (i < this.numAttributes()) {
            if (this.attribute(i).name().equals(name)) {
                return this.attribute(i);
            }
            ++i;
        }
        return null;
    }

    public boolean checkForAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i++).type() != attType) continue;
            return true;
        }
        return false;
    }

    public boolean checkForStringAttributes() {
        return this.checkForAttributeType(2);
    }

    public boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        int i = 0;
        while (i < this.numAttributes()) {
            if (!instance.isMissing(i) && (this.attribute(i).isNominal() || this.attribute(i).isString())) {
                if (!Utils.eq(instance.value(i), (int)instance.value(i))) {
                    return false;
                }
                if (Utils.sm(instance.value(i), 0.0) || Utils.gr(instance.value(i), this.attribute(i).numValues())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public Attribute classAttribute() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        return this.attribute(this.m_ClassIndex);
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public void compactify() {
        this.m_Instances.trimToSize();
    }

    public void delete() {
        this.m_Instances = new FastVector();
    }

    public void delete(int index) {
        this.m_Instances.removeElementAt(index);
    }

    public void deleteAttributeAt(int position) {
        if (position < 0 || position >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (position == this.m_ClassIndex) {
            throw new IllegalArgumentException("Can't delete class attribute");
        }
        this.freshAttributeInfo();
        if (this.m_ClassIndex > position) {
            --this.m_ClassIndex;
        }
        this.m_Attributes.removeElementAt(position);
        int i = position;
        while (i < this.m_Attributes.size()) {
            Attribute current = (Attribute)this.m_Attributes.elementAt(i);
            current.setIndex(current.index() - 1);
            ++i;
        }
        i = 0;
        while (i < this.numInstances()) {
            this.instance(i).forceDeleteAttributeAt(position);
            ++i;
        }
    }

    public void deleteAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i).type() == attType) {
                this.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteStringAttributes() {
        this.deleteAttributeType(2);
    }

    public void deleteWithMissing(int attIndex) {
        FastVector newInstances = new FastVector(this.numInstances());
        int i = 0;
        while (i < this.numInstances()) {
            if (!this.instance(i).isMissing(attIndex)) {
                newInstances.addElement(this.instance(i));
            }
            ++i;
        }
        this.m_Instances = newInstances;
    }

    public void deleteWithMissing(Attribute att) {
        this.deleteWithMissing(att.index());
    }

    public void deleteWithMissingClass() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.m_ClassIndex);
    }

    public Enumeration enumerateAttributes() {
        return this.m_Attributes.elements(this.m_ClassIndex);
    }

    public Enumeration enumerateInstances() {
        return this.m_Instances.elements();
    }

    public boolean equalHeaders(Instances dataset) {
        if (this.m_ClassIndex != dataset.m_ClassIndex) {
            return false;
        }
        if (this.m_Attributes.size() != dataset.m_Attributes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (!this.attribute(i).equals(dataset.attribute(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Instance firstInstance() {
        return (Instance)this.m_Instances.firstElement();
    }

    public Random getRandomNumberGenerator(long seed) {
        Random r = new Random(seed);
        r.setSeed((long)this.instance(r.nextInt(this.numInstances())).toStringNoWeight().hashCode() + seed);
        return r;
    }

    public void insertAttributeAt(Attribute att, int position) {
        if (position < 0 || position > this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (this.attribute(att.name()) != null) {
            throw new IllegalArgumentException("Attribute name '" + att.name() + "' already in use at position #" + this.attribute(att.name()).index());
        }
        att = (Attribute)att.copy();
        this.freshAttributeInfo();
        att.setIndex(position);
        this.m_Attributes.insertElementAt(att, position);
        int i = position + 1;
        while (i < this.m_Attributes.size()) {
            Attribute current = (Attribute)this.m_Attributes.elementAt(i);
            current.setIndex(current.index() + 1);
            ++i;
        }
        i = 0;
        while (i < this.numInstances()) {
            this.instance(i).forceInsertAttributeAt(position);
            ++i;
        }
        if (this.m_ClassIndex >= position) {
            ++this.m_ClassIndex;
        }
    }

    public Instance instance(int index) {
        return (Instance)this.m_Instances.elementAt(index);
    }

    public double kthSmallestValue(Attribute att, int k) {
        return this.kthSmallestValue(att.index(), k);
    }

    public double kthSmallestValue(int attIndex, int k) {
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Instances: attribute must be numeric to compute kth-smallest value.");
        }
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        if (k < 1 || k > j + 1) {
            throw new IllegalArgumentException("Instances: value for k for computing kth-smallest value too large.");
        }
        return this.instance(this.select(attIndex, 0, j, k)).value(attIndex);
    }

    public Instance lastInstance() {
        return (Instance)this.m_Instances.lastElement();
    }

    public double meanOrMode(int attIndex) {
        if (this.attribute(attIndex).isNumeric()) {
            double found = 0.0;
            double result = 0.0;
            int j = 0;
            while (j < this.numInstances()) {
                if (!this.instance(j).isMissing(attIndex)) {
                    found += this.instance(j).weight();
                    result += this.instance(j).weight() * this.instance(j).value(attIndex);
                }
                ++j;
            }
            if (found <= 0.0) {
                return 0.0;
            }
            return result / found;
        }
        if (this.attribute(attIndex).isNominal()) {
            int[] counts = new int[this.attribute(attIndex).numValues()];
            int j = 0;
            while (j < this.numInstances()) {
                if (!this.instance(j).isMissing(attIndex)) {
                    int n = (int)this.instance(j).value(attIndex);
                    counts[n] = (int)((double)counts[n] + this.instance(j).weight());
                }
                ++j;
            }
            return Utils.maxIndex(counts);
        }
        return 0.0;
    }

    public double meanOrMode(Attribute att) {
        return this.meanOrMode(att.index());
    }

    public int numAttributes() {
        return this.m_Attributes.size();
    }

    public int numClasses() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public int numDistinctValues(int attIndex) {
        if (this.attribute(attIndex).isNumeric()) {
            double[] attVals = this.attributeToDoubleArray(attIndex);
            int[] sorted = Utils.sort(attVals);
            double prev = 0.0;
            int counter = 0;
            int i = 0;
            while (i < sorted.length) {
                Instance current = this.instance(sorted[i]);
                if (current.isMissing(attIndex)) break;
                if (i == 0 || current.value(attIndex) > prev) {
                    prev = current.value(attIndex);
                    ++counter;
                }
                ++i;
            }
            return counter;
        }
        return this.attribute(attIndex).numValues();
    }

    public int numDistinctValues(Attribute att) {
        return this.numDistinctValues(att.index());
    }

    public int numInstances() {
        return this.m_Instances.size();
    }

    public void randomize(Random random) {
        int j = this.numInstances() - 1;
        while (j > 0) {
            this.swap(j, random.nextInt(j + 1));
            --j;
        }
    }

    @Deprecated
    public boolean readInstance(Reader reader) throws IOException {
        ArffLoader.ArffReader arff = new ArffLoader.ArffReader(reader, this, this.m_Lines, 1);
        Instance inst = arff.readInstance(arff.getData(), false);
        this.m_Lines = arff.getLineNo();
        if (inst != null) {
            this.add(inst);
            return true;
        }
        return false;
    }

    public String relationName() {
        return this.m_RelationName;
    }

    public void renameAttribute(int att, String name) {
        int i = 0;
        while (i < this.numAttributes()) {
            if (i != att && this.attribute(i).name().equals(name)) {
                throw new IllegalArgumentException("Attribute name '" + name + "' already present at position #" + i);
            }
            ++i;
        }
        Attribute newAtt = this.attribute(att).copy(name);
        FastVector newVec = new FastVector(this.numAttributes());
        int i2 = 0;
        while (i2 < this.numAttributes()) {
            if (i2 == att) {
                newVec.addElement(newAtt);
            } else {
                newVec.addElement(this.attribute(i2));
            }
            ++i2;
        }
        this.m_Attributes = newVec;
    }

    public void renameAttribute(Attribute att, String name) {
        this.renameAttribute(att.index(), name);
    }

    public void renameAttributeValue(int att, int val, String name) {
        Attribute newAtt = (Attribute)this.attribute(att).copy();
        FastVector newVec = new FastVector(this.numAttributes());
        newAtt.setValue(val, name);
        int i = 0;
        while (i < this.numAttributes()) {
            if (i == att) {
                newVec.addElement(newAtt);
            } else {
                newVec.addElement(this.attribute(i));
            }
            ++i;
        }
        this.m_Attributes = newVec;
    }

    public void renameAttributeValue(Attribute att, String val, String name) {
        int v = att.indexOfValue(val);
        if (v == -1) {
            throw new IllegalArgumentException(String.valueOf(val) + " not found");
        }
        this.renameAttributeValue(att.index(), v, name);
    }

    public Instances resample(Random random) {
        Instances newData = new Instances(this, this.numInstances());
        while (newData.numInstances() < this.numInstances()) {
            newData.add(this.instance(random.nextInt(this.numInstances())));
        }
        return newData;
    }

    public Instances resampleWithWeights(Random random) {
        double[] weights = new double[this.numInstances()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = this.instance(i).weight();
            ++i;
        }
        return this.resampleWithWeights(random, weights);
    }

    public Instances resampleWithWeights(Random random, double[] weights) {
        if (weights.length != this.numInstances()) {
            throw new IllegalArgumentException("weights.length != numInstances.");
        }
        Instances newData = new Instances(this, this.numInstances());
        if (this.numInstances() == 0) {
            return newData;
        }
        double[] probabilities = new double[this.numInstances()];
        double sumProbs = 0.0;
        double sumOfWeights = Utils.sum(weights);
        int i = 0;
        while (i < this.numInstances()) {
            probabilities[i] = sumProbs += random.nextDouble();
            ++i;
        }
        Utils.normalize(probabilities, sumProbs / sumOfWeights);
        probabilities[this.numInstances() - 1] = sumOfWeights;
        int k = 0;
        int l = 0;
        sumProbs = 0.0;
        while (k < this.numInstances() && l < this.numInstances()) {
            if (weights[l] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            sumProbs += weights[l];
            while (k < this.numInstances() && probabilities[k] <= sumProbs) {
                newData.add(this.instance(l));
                newData.instance(k).setWeight(1.0);
                ++k;
            }
            ++l;
        }
        return newData;
    }

    public void setClass(Attribute att) {
        this.m_ClassIndex = att.index();
    }

    public void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + classIndex);
        }
        this.m_ClassIndex = classIndex;
    }

    public void setRelationName(String newName) {
        this.m_RelationName = newName;
    }

    public void sort(int attIndex) {
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    public void sort(Attribute att) {
        this.sort(att.index());
    }

    public void stratify(int numFolds) {
        if (numFolds <= 1) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().isNominal()) {
            int index = 1;
            while (index < this.numInstances()) {
                Instance instance1 = this.instance(index - 1);
                int j = index;
                while (j < this.numInstances()) {
                    Instance instance2 = this.instance(j);
                    if (instance1.classValue() == instance2.classValue() || instance1.classIsMissing() && instance2.classIsMissing()) {
                        this.swap(index, j);
                        ++index;
                    }
                    ++j;
                }
                ++index;
            }
            this.stratStep(numFolds);
        }
    }

    public double sumOfWeights() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numInstances()) {
            sum += this.instance(i).weight();
            ++i;
        }
        return sum;
    }

    public Instances testCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances test = new Instances(this, numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(first, test, numInstForFold);
        return test;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.m_RelationName)).append("\n\n");
        int i = 0;
        while (i < this.numAttributes()) {
            text.append(this.attribute(i)).append("\n");
            ++i;
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.stringWithoutHeader());
        return text.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.numInstances()) {
            text.append(this.instance(i));
            if (i < this.numInstances() - 1) {
                text.append('\n');
            }
            ++i;
        }
        return text.toString();
    }

    public Instances trainCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances train = new Instances(this, this.numInstances() - numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(0, train, first);
        this.copyInstances(first + numInstForFold, train, this.numInstances() - first - numInstForFold);
        return train;
    }

    public Instances trainCV(int numFolds, int numFold, Random random) {
        Instances train = this.trainCV(numFolds, numFold);
        train.randomize(random);
        return train;
    }

    public double variance(int attIndex) {
        double sum = 0.0;
        double sumSquared = 0.0;
        double sumOfWeights = 0.0;
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        int i = 0;
        while (i < this.numInstances()) {
            if (!this.instance(i).isMissing(attIndex)) {
                sum += this.instance(i).weight() * this.instance(i).value(attIndex);
                sumSquared += this.instance(i).weight() * this.instance(i).value(attIndex) * this.instance(i).value(attIndex);
                sumOfWeights += this.instance(i).weight();
            }
            ++i;
        }
        if (sumOfWeights <= 1.0) {
            return 0.0;
        }
        double result = (sumSquared - sum * sum / sumOfWeights) / (sumOfWeights - 1.0);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public double variance(Attribute att) {
        return this.variance(att.index());
    }

    public AttributeStats attributeStats(int index) {
        AttributeStats result = new AttributeStats();
        if (this.attribute(index).isNominal()) {
            result.nominalCounts = new int[this.attribute(index).numValues()];
        }
        if (this.attribute(index).isNumeric()) {
            result.numericStats = new Stats();
        }
        result.totalCount = this.numInstances();
        double[] attVals = this.attributeToDoubleArray(index);
        int[] sorted = Utils.sort(attVals);
        int currentCount = 0;
        double prev = Instance.missingValue();
        int j = 0;
        while (j < this.numInstances()) {
            Instance current = this.instance(sorted[j]);
            if (current.isMissing(index)) {
                result.missingCount = this.numInstances() - j;
                break;
            }
            if (current.value(index) == prev) {
                ++currentCount;
            } else {
                result.addDistinct(prev, currentCount);
                currentCount = 1;
                prev = current.value(index);
            }
            ++j;
        }
        result.addDistinct(prev, currentCount);
        --result.distinctCount;
        return result;
    }

    public double[] attributeToDoubleArray(int index) {
        double[] result = new double[this.numInstances()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.instance(i).value(index);
            ++i;
        }
        return result;
    }

    public String toSummaryString() {
        StringBuffer result = new StringBuffer();
        result.append("Relation Name:  ").append(this.relationName()).append('\n');
        result.append("Num Instances:  ").append(this.numInstances()).append('\n');
        result.append("Num Attributes: ").append(this.numAttributes()).append('\n');
        result.append('\n');
        result.append(Utils.padLeft("", 5)).append(Utils.padRight("Name", 25));
        result.append(Utils.padLeft("Type", 5)).append(Utils.padLeft("Nom", 5));
        result.append(Utils.padLeft("Int", 5)).append(Utils.padLeft("Real", 5));
        result.append(Utils.padLeft("Missing", 12));
        result.append(Utils.padLeft("Unique", 12));
        result.append(Utils.padLeft("Dist", 6)).append('\n');
        int i = 0;
        while (i < this.numAttributes()) {
            long percent;
            Attribute a = this.attribute(i);
            AttributeStats as = this.attributeStats(i);
            result.append(Utils.padLeft("" + (i + 1), 4)).append(' ');
            result.append(Utils.padRight(a.name(), 25)).append(' ');
            switch (a.type()) {
                case 1: {
                    result.append(Utils.padLeft("Nom", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 0: {
                    result.append(Utils.padLeft("Num", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 3: {
                    result.append(Utils.padLeft("Dat", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 2: {
                    result.append(Utils.padLeft("Str", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                case 4: {
                    result.append(Utils.padLeft("Rel", 4)).append(' ');
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    break;
                }
                default: {
                    result.append(Utils.padLeft("???", 4)).append(' ');
                    result.append(Utils.padLeft("0", 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.intCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                    percent = Math.round(100.0 * (double)as.realCount / (double)as.totalCount);
                    result.append(Utils.padLeft("" + percent, 3)).append("% ");
                }
            }
            result.append(Utils.padLeft("" + as.missingCount, 5)).append(" /");
            percent = Math.round(100.0 * (double)as.missingCount / (double)as.totalCount);
            result.append(Utils.padLeft("" + percent, 3)).append("% ");
            result.append(Utils.padLeft("" + as.uniqueCount, 5)).append(" /");
            percent = Math.round(100.0 * (double)as.uniqueCount / (double)as.totalCount);
            result.append(Utils.padLeft("" + percent, 3)).append("% ");
            result.append(Utils.padLeft("" + as.distinctCount, 5)).append(' ');
            result.append('\n');
            ++i;
        }
        return result.toString();
    }

    protected void copyInstances(int from, Instances dest, int num) {
        int i = 0;
        while (i < num) {
            dest.add(this.instance(from + i));
            ++i;
        }
    }

    protected void freshAttributeInfo() {
        this.m_Attributes = (FastVector)this.m_Attributes.copyElements();
    }

    protected String instancesAndWeights() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.numInstances()) {
            text.append(this.instance(i) + " " + this.instance(i).weight());
            if (i < this.numInstances() - 1) {
                text.append("\n");
            }
            ++i;
        }
        return text.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected int partition(int attIndex, int l, int r) {
        pivot = this.instance((l + r) / 2).value(attIndex);
        ** GOTO lbl13
        {
            ++l;
            do {
                if (this.instance(l).value(attIndex) < pivot && l < r) continue block0;
                while (this.instance(r).value(attIndex) > pivot && l < r) {
                    --r;
                }
                if (l >= r) continue;
                this.swap(l, r);
                ++l;
                --r;
lbl13:
                // 3 sources

            } while (l < r);
        }
        if (l == r && this.instance(r).value(attIndex) > pivot) {
            --r;
        }
        return r;
    }

    protected void quickSort(int attIndex, int left, int right) {
        if (left < right) {
            int middle = this.partition(attIndex, left, right);
            this.quickSort(attIndex, left, middle);
            this.quickSort(attIndex, middle + 1, right);
        }
    }

    protected int select(int attIndex, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIndex, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIndex, left, middle, k);
        }
        return this.select(attIndex, middle + 1, right, k - (middle - left + 1));
    }

    protected void stratStep(int numFolds) {
        FastVector newVec = new FastVector(this.m_Instances.capacity());
        int start = 0;
        while (newVec.size() < this.numInstances()) {
            int j = start;
            while (j < this.numInstances()) {
                newVec.addElement(this.instance(j));
                j += numFolds;
            }
            ++start;
        }
        this.m_Instances = newVec;
    }

    public void swap(int i, int j) {
        this.m_Instances.swap(i, j);
    }

    public static Instances mergeInstances(Instances first, Instances second) {
        if (first.numInstances() != second.numInstances()) {
            throw new IllegalArgumentException("Instance sets must be of the same size");
        }
        FastVector newAttributes = new FastVector();
        int i = 0;
        while (i < first.numAttributes()) {
            newAttributes.addElement(first.attribute(i));
            ++i;
        }
        i = 0;
        while (i < second.numAttributes()) {
            newAttributes.addElement(second.attribute(i));
            ++i;
        }
        Instances merged = new Instances(String.valueOf(first.relationName()) + '_' + second.relationName(), newAttributes, first.numInstances());
        int i2 = 0;
        while (i2 < first.numInstances()) {
            merged.add(first.instance(i2).mergeInstance(second.instance(i2)));
            ++i2;
        }
        return merged;
    }

    public static void test(String[] argv) {
        Random random = new Random(2L);
        try {
            int j;
            int i;
            if (argv.length > 1) {
                throw new Exception("Usage: Instances [<filename>]");
            }
            FastVector testVals = new FastVector(2);
            testVals.addElement("first_value");
            testVals.addElement("second_value");
            FastVector testAtts = new FastVector(2);
            testAtts.addElement(new Attribute("nominal_attribute", testVals));
            testAtts.addElement(new Attribute("numeric_attribute"));
            Instances instances = new Instances("test_set", testAtts, 10);
            instances.add(new Instance(instances.numAttributes()));
            instances.add(new Instance(instances.numAttributes()));
            instances.add(new Instance(instances.numAttributes()));
            instances.setClassIndex(0);
            System.out.println("\nSet of instances created from scratch:\n");
            System.out.println(instances);
            if (argv.length == 1) {
                String filename = argv[0];
                FileReader reader = new FileReader(filename);
                System.out.println("\nFirst five instances from file:\n");
                instances = new Instances(reader, 1);
                instances.setClassIndex(instances.numAttributes() - 1);
                i = 0;
                while (i < 5 && instances.readInstance(reader)) {
                    ++i;
                }
                System.out.println(instances);
                reader = new FileReader(filename);
                instances = new Instances(reader);
                instances.setClassIndex(instances.numAttributes() - 1);
                System.out.println("\nDataset:\n");
                System.out.println(instances);
                System.out.println("\nClass index: " + instances.classIndex());
            }
            System.out.println("\nClass name: " + instances.classAttribute().name());
            System.out.println("\nClass index: " + instances.classIndex());
            System.out.println("\nClass is nominal: " + instances.classAttribute().isNominal());
            System.out.println("\nClass is numeric: " + instances.classAttribute().isNumeric());
            System.out.println("\nClasses:\n");
            i = 0;
            while (i < instances.numClasses()) {
                System.out.println(instances.classAttribute().value(i));
                ++i;
            }
            System.out.println("\nClass values and labels of instances:\n");
            i = 0;
            while (i < instances.numInstances()) {
                Instance inst = instances.instance(i);
                System.out.print(String.valueOf(inst.classValue()) + "\t");
                System.out.print(inst.toString(inst.classIndex()));
                if (instances.instance(i).classIsMissing()) {
                    System.out.println("\tis missing");
                } else {
                    System.out.println();
                }
                ++i;
            }
            System.out.println("\nCreating random weights for instances.");
            i = 0;
            while (i < instances.numInstances()) {
                instances.instance(i).setWeight(random.nextDouble());
                ++i;
            }
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            Instances secondInstances = new Instances(instances);
            Attribute testAtt = new Attribute("Inserted");
            secondInstances.insertAttributeAt(testAtt, 0);
            System.out.println("\nSet with inserted attribute:\n");
            System.out.println(secondInstances);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            secondInstances.deleteAttributeAt(0);
            System.out.println("\nSet with attribute deleted:\n");
            System.out.println(secondInstances);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            System.out.println("\nHeaders equal: " + instances.equalHeaders(secondInstances) + "\n");
            System.out.println("\nData (internal values):\n");
            i = 0;
            while (i < instances.numInstances()) {
                j = 0;
                while (j < instances.numAttributes()) {
                    if (instances.instance(i).isMissing(j)) {
                        System.out.print("? ");
                    } else {
                        System.out.print(String.valueOf(instances.instance(i).value(j)) + " ");
                    }
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("\nEmpty dataset:\n");
            Instances empty = new Instances(instances, 0);
            System.out.println(empty);
            System.out.println("\nClass name: " + empty.classAttribute().name());
            if (empty.classAttribute().isNominal()) {
                Instances copy = new Instances(empty, 0);
                copy.renameAttribute(copy.classAttribute(), "new_name");
                copy.renameAttributeValue(copy.classAttribute(), copy.classAttribute().value(0), "new_val_name");
                System.out.println("\nDataset with names changed:\n" + copy);
                System.out.println("\nOriginal dataset:\n" + empty);
            }
            int start = instances.numInstances() / 4;
            int num = instances.numInstances() / 2;
            System.out.print("\nSubset of dataset: ");
            System.out.println(String.valueOf(num) + " instances from " + (start + 1) + ". instance");
            secondInstances = new Instances(instances, start, num);
            System.out.println("\nClass name: " + secondInstances.classAttribute().name());
            System.out.println("\nInstances and their weights:\n");
            System.out.println(secondInstances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(secondInstances.sumOfWeights());
            System.out.println("\nTrain and test folds for 3-fold CV:");
            if (instances.classAttribute().isNominal()) {
                instances.stratify(3);
            }
            j = 0;
            while (j < 3) {
                Instances train = instances.trainCV(3, j, new Random(1L));
                Instances test = instances.testCV(3, j);
                System.out.println("\nTrain: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(train.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(train.sumOfWeights());
                System.out.println("\nClass name: " + train.classAttribute().name());
                System.out.println("\nTest: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(test.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(test.sumOfWeights());
                System.out.println("\nClass name: " + test.classAttribute().name());
                ++j;
            }
            System.out.println("\nRandomized dataset:");
            instances.randomize(random);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            System.out.print("\nInstances sorted according to first attribute:\n ");
            instances.sort(0);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(System.in);
                Instances i = source.getDataSet();
                System.out.println(i.toSummaryString());
            } else if (args.length == 1 && !args[0].equals("-h") && !args[0].equals("help")) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(args[0]);
                Instances i = source.getDataSet();
                System.out.println(i.toSummaryString());
            } else if (args.length == 3 && args[0].toLowerCase().equals("merge")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                Instances i = Instances.mergeInstances(source1.getDataSet(), source2.getDataSet());
                System.out.println(i);
            } else if (args.length == 3 && args[0].toLowerCase().equals("append")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                if (!source1.getStructure().equalHeaders(source2.getStructure())) {
                    throw new Exception("The two datasets have different headers!");
                }
                Instances structure = source1.getStructure();
                System.out.println(source1.getStructure());
                while (source1.hasMoreElements(structure)) {
                    System.out.println(source1.nextElement(structure));
                }
                structure = source2.getStructure();
                while (source2.hasMoreElements(structure)) {
                    System.out.println(source2.nextElement(structure));
                }
            } else if (args.length == 3 && args[0].toLowerCase().equals("headers")) {
                ConverterUtils.DataSource source1 = new ConverterUtils.DataSource(args[1]);
                ConverterUtils.DataSource source2 = new ConverterUtils.DataSource(args[2]);
                if (source1.getStructure().equalHeaders(source2.getStructure())) {
                    System.out.println("Headers match");
                } else {
                    System.out.println("Headers don't match");
                }
            } else if (args.length == 3 && args[0].toLowerCase().equals("randomize")) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(args[2]);
                Instances i = source.getDataSet();
                i.randomize(new Random(Integer.parseInt(args[1])));
                System.out.println(i);
            } else {
                System.err.println("\nUsage:\n\tweka.core.Instances help\n\tweka.core.Instances <filename>\n\tweka.core.Instances merge <filename1> <filename2>\n\tweka.core.Instances append <filename1> <filename2>\n\tweka.core.Instances headers <filename1> <filename2>\n\tweka.core.Instances randomize <seed> <filename>\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6996 $");
    }
}

