/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Utils;

import java.util.ArrayList;
import java.util.TreeMap;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueueElement;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class UpdateQueue
implements RevisionHandler {
    private ArrayList queue = new ArrayList();
    private TreeMap objectPositionsInHeap = new TreeMap();

    public void add(double priority, Object o, String objectKey) {
        int objectPosition = 0;
        if (this.objectPositionsInHeap.containsKey(objectKey)) {
            objectPosition = (Integer)this.objectPositionsInHeap.get(objectKey);
            if (((UpdateQueueElement)this.queue.get(objectPosition)).getPriority() <= priority) {
                return;
            }
            this.queue.set(objectPosition++, new UpdateQueueElement(priority, o, objectKey));
        } else {
            this.queue.add(new UpdateQueueElement(priority, o, objectKey));
            objectPosition = this.size();
        }
        this.heapValueUpwards(objectPosition);
    }

    public double getPriority(int index) {
        return ((UpdateQueueElement)this.queue.get(index)).getPriority();
    }

    private void heapValueUpwards(int pos) {
        int a = pos;
        int c = a / 2;
        UpdateQueueElement recentlyInsertedElement = (UpdateQueueElement)this.queue.get(a - 1);
        while (c > 0 && this.getPriority(c - 1) > recentlyInsertedElement.getPriority()) {
            this.queue.set(a - 1, this.queue.get(c - 1));
            this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(a - 1)).getObjectKey(), new Integer(a - 1));
            a = c;
            c = a / 2;
        }
        this.queue.set(a - 1, recentlyInsertedElement);
        this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(a - 1)).getObjectKey(), new Integer(a - 1));
    }

    private void heapValueDownwards() {
        int a = 1;
        int c = 2 * a;
        UpdateQueueElement updateQueueElement = (UpdateQueueElement)this.queue.get(a - 1);
        if (c < this.size() && this.getPriority(c) < this.getPriority(c - 1)) {
            ++c;
        }
        while (c <= this.size() && this.getPriority(c - 1) < updateQueueElement.getPriority()) {
            this.queue.set(a - 1, this.queue.get(c - 1));
            this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(a - 1)).getObjectKey(), new Integer(a - 1));
            a = c;
            c = 2 * a;
            if (c >= this.size() || !(this.getPriority(c) < this.getPriority(c - 1))) continue;
            ++c;
        }
        this.queue.set(a - 1, updateQueueElement);
        this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(a - 1)).getObjectKey(), new Integer(a - 1));
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasNext() {
        return this.queue.size() != 0;
    }

    public UpdateQueueElement next() {
        UpdateQueueElement next = (UpdateQueueElement)this.queue.get(0);
        this.queue.set(0, this.queue.get(this.size() - 1));
        this.queue.remove(this.size() - 1);
        this.objectPositionsInHeap.remove(next.getObjectKey());
        if (this.hasNext()) {
            this.heapValueDownwards();
        }
        return next;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

