/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Utils;

import java.util.ArrayList;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueueElement;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PriorityQueue
implements RevisionHandler {
    private ArrayList queue = new ArrayList();

    public void add(double priority, Object o) {
        this.queue.add(new PriorityQueueElement(priority, o));
        this.heapValueUpwards();
    }

    public double getPriority(int index) {
        return ((PriorityQueueElement)this.queue.get(index)).getPriority();
    }

    private void heapValueUpwards() {
        int a = this.size();
        int c = a / 2;
        PriorityQueueElement recentlyInsertedElement = (PriorityQueueElement)this.queue.get(a - 1);
        while (c > 0 && this.getPriority(c - 1) < recentlyInsertedElement.getPriority()) {
            this.queue.set(a - 1, this.queue.get(c - 1));
            a = c;
            c = a / 2;
        }
        this.queue.set(a - 1, recentlyInsertedElement);
    }

    private void heapValueDownwards() {
        int a = 1;
        int c = 2 * a;
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)this.queue.get(a - 1);
        if (c < this.size() && this.getPriority(c) > this.getPriority(c - 1)) {
            ++c;
        }
        while (c <= this.size() && this.getPriority(c - 1) > priorityQueueElement.getPriority()) {
            this.queue.set(a - 1, this.queue.get(c - 1));
            a = c;
            c = 2 * a;
            if (c >= this.size() || !(this.getPriority(c) > this.getPriority(c - 1))) continue;
            ++c;
        }
        this.queue.set(a - 1, priorityQueueElement);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasNext() {
        return this.size() != 0;
    }

    public PriorityQueueElement next() {
        PriorityQueueElement next = (PriorityQueueElement)this.queue.get(0);
        this.queue.set(0, this.queue.get(this.size() - 1));
        this.queue.remove(this.size() - 1);
        if (this.hasNext()) {
            this.heapValueDownwards();
        }
        return next;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

