/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Databases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.clusterers.forOPTICSAndDBScan.Utils.EpsilonRange_ListElement;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueue;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueueElement;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SequentialDatabase
implements Database,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = 787245523118665778L;
    private TreeMap treeMap;
    private Instances instances;
    private double[] attributeMinValues;
    private double[] attributeMaxValues;

    public SequentialDatabase(Instances instances) {
        this.instances = instances;
        this.treeMap = new TreeMap();
    }

    @Override
    public DataObject getDataObject(String key) {
        return (DataObject)this.treeMap.get(key);
    }

    @Override
    public void setMinMaxValues() {
        this.attributeMinValues = new double[this.getInstances().numAttributes()];
        this.attributeMaxValues = new double[this.getInstances().numAttributes()];
        int i = 0;
        while (i < this.getInstances().numAttributes()) {
            this.attributeMaxValues[i] = Double.NaN;
            this.attributeMinValues[i] = Double.NaN;
            ++i;
        }
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            int j = 0;
            while (j < this.getInstances().numAttributes()) {
                if (Double.isNaN(this.attributeMinValues[j])) {
                    this.attributeMinValues[j] = dataObject.getInstance().value(j);
                    this.attributeMaxValues[j] = dataObject.getInstance().value(j);
                } else {
                    if (dataObject.getInstance().value(j) < this.attributeMinValues[j]) {
                        this.attributeMinValues[j] = dataObject.getInstance().value(j);
                    }
                    if (dataObject.getInstance().value(j) > this.attributeMaxValues[j]) {
                        this.attributeMaxValues[j] = dataObject.getInstance().value(j);
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public double[] getAttributeMinValues() {
        return this.attributeMinValues;
    }

    @Override
    public double[] getAttributeMaxValues() {
        return this.attributeMaxValues;
    }

    @Override
    public List epsilonRangeQuery(double epsilon, DataObject queryDataObject) {
        ArrayList<DataObject> epsilonRange_List = new ArrayList<DataObject>();
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            double distance = queryDataObject.distance(dataObject);
            if (!(distance < epsilon)) continue;
            epsilonRange_List.add(dataObject);
        }
        return epsilonRange_List;
    }

    @Override
    public List k_nextNeighbourQuery(int k, double epsilon, DataObject dataObject) {
        Iterator iterator = this.dataObjectIterator();
        ArrayList return_List = new ArrayList();
        ArrayList<PriorityQueueElement> nextNeighbours_List = new ArrayList<PriorityQueueElement>();
        ArrayList<EpsilonRange_ListElement> epsilonRange_List = new ArrayList<EpsilonRange_ListElement>();
        PriorityQueue priorityQueue = new PriorityQueue();
        while (iterator.hasNext()) {
            DataObject next_dataObject = (DataObject)iterator.next();
            double dist = dataObject.distance(next_dataObject);
            if (dist <= epsilon) {
                epsilonRange_List.add(new EpsilonRange_ListElement(dist, next_dataObject));
            }
            if (priorityQueue.size() < k) {
                priorityQueue.add(dist, next_dataObject);
                continue;
            }
            if (!(dist < priorityQueue.getPriority(0))) continue;
            priorityQueue.next();
            priorityQueue.add(dist, next_dataObject);
        }
        while (priorityQueue.hasNext()) {
            nextNeighbours_List.add(0, priorityQueue.next());
        }
        return_List.add(nextNeighbours_List);
        return_List.add(epsilonRange_List);
        return return_List;
    }

    @Override
    public List coreDistance(int minPoints, double epsilon, DataObject dataObject) {
        List list = this.k_nextNeighbourQuery(minPoints, epsilon, dataObject);
        if (((List)list.get(1)).size() < minPoints) {
            list.add(new Double(2.147483647E9));
            return list;
        }
        List nextNeighbours_List = (List)list.get(0);
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)nextNeighbours_List.get(nextNeighbours_List.size() - 1);
        if (priorityQueueElement.getPriority() <= epsilon) {
            list.add(new Double(priorityQueueElement.getPriority()));
            return list;
        }
        list.add(new Double(2.147483647E9));
        return list;
    }

    @Override
    public int size() {
        return this.treeMap.size();
    }

    @Override
    public Iterator keyIterator() {
        return this.treeMap.keySet().iterator();
    }

    @Override
    public Iterator dataObjectIterator() {
        return this.treeMap.values().iterator();
    }

    @Override
    public boolean contains(DataObject dataObject_Query) {
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            if (!dataObject.equals(dataObject_Query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insert(DataObject dataObject) {
        this.treeMap.put(dataObject.getKey(), dataObject);
    }

    @Override
    public Instances getInstances() {
        return this.instances;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

