/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48Consolidated;

import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.core.Instances;

public class DistributionConsolidated
extends Distribution {
    private static final long serialVersionUID = -6386302948424098805L;

    public DistributionConsolidated(Instances[] samplesVector) throws Exception {
        super(1, samplesVector[0].numClasses());
        int numberSamples = samplesVector.length;
        DistributionConsolidated[] distributionVector = new DistributionConsolidated[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            distributionVector[iSample] = new DistributionConsolidated(samplesVector[iSample]);
            ++iSample;
        }
        this.calculateMeanDistribution(distributionVector);
    }

    public DistributionConsolidated(Instances[] samplesVector, ClassifierSplitModel modelToUse) throws Exception {
        super(modelToUse.numSubsets(), samplesVector[0].numClasses());
        int numberSamples = samplesVector.length;
        int attIndex = ((C45Split)modelToUse).attIndex();
        DistributionConsolidated[] distributionVector = new DistributionConsolidated[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            Instances sampleWithoutMissing = samplesVector[iSample];
            sampleWithoutMissing.deleteWithMissing(attIndex);
            distributionVector[iSample] = new DistributionConsolidated(sampleWithoutMissing, modelToUse);
            distributionVector[iSample].addInstWithUnknown(samplesVector[iSample], attIndex);
            ++iSample;
        }
        this.calculateMeanDistribution(distributionVector);
    }

    public DistributionConsolidated(Instances instances) throws Exception {
        super(instances);
    }

    public DistributionConsolidated(Instances instances, ClassifierSplitModel modelToUse) throws Exception {
        super(instances, modelToUse);
    }

    private void calculateMeanDistribution(DistributionConsolidated[] distributionVector) {
        int numberSamples = distributionVector.length;
        int numberClasses = distributionVector[0].numClasses();
        int iSample = 0;
        while (iSample < numberSamples) {
            this.add(distributionVector[iSample]);
            ++iSample;
        }
        int iBag = 0;
        while (iBag < this.numBags()) {
            int n = iBag;
            this.m_perBag[n] = this.m_perBag[n] / (double)numberSamples;
            int iClass = 0;
            while (iClass < numberClasses) {
                double[] dArray = this.m_perClassPerBag[iBag];
                int n2 = iClass++;
                dArray[n2] = dArray[n2] / (double)numberSamples;
            }
            ++iBag;
        }
        int iClass = 0;
        while (iClass < numberClasses) {
            int n = iClass++;
            this.m_perClass[n] = this.m_perClass[n] / (double)numberSamples;
        }
        this.totaL /= (double)numberSamples;
    }

    private final void add(DistributionConsolidated distribution) {
        int iBag = 0;
        while (iBag < this.numBags()) {
            this.add(iBag, distribution.getPerClassPerBag(iBag));
            ++iBag;
        }
    }

    private final double[] getPerClassPerBag(int bagIndex) {
        return this.m_perClassPerBag[bagIndex];
    }
}

