/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48Consolidated;

import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48Consolidated.C45ConsolidatedSplit;
import weka.classifiers.trees.j48Consolidated.DistributionConsolidated;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.matrix.DoubleVector;

public class C45ConsolidatedModelSelection
extends C45ModelSelection {
    private static final long serialVersionUID = 970984256023901098L;
    protected ModelSelection m_toSelectModelToConsolidate;

    public C45ConsolidatedModelSelection(int minNoObj, Instances allData) {
        super(minNoObj, allData);
        this.m_toSelectModelToConsolidate = new C45ModelSelection(minNoObj, allData);
    }

    public ClassifierSplitModel selectModel(Instances data, Instances[] samplesVector) throws Exception {
        int numberSamples = samplesVector.length;
        int[] attIndexVector = new int[numberSamples];
        double[] splitPointVector = new double[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            ClassifierSplitModel localModel = this.m_toSelectModelToConsolidate.selectModel(samplesVector[iSample]);
            if (localModel.numSubsets() > 1) {
                attIndexVector[iSample] = ((C45Split)localModel).attIndex();
                splitPointVector[iSample] = ((C45Split)localModel).splitPoint();
            } else {
                attIndexVector[iSample] = -1;
                splitPointVector[iSample] = -1.0;
            }
            ++iSample;
        }
        int[] votesCountByAtt = new int[data.numAttributes()];
        int numberVotes = 0;
        int iAtt = 0;
        while (iAtt < data.numAttributes()) {
            votesCountByAtt[iAtt] = 0;
            ++iAtt;
        }
        int iSample2 = 0;
        while (iSample2 < numberSamples) {
            if (attIndexVector[iSample2] != -1) {
                int n = attIndexVector[iSample2];
                votesCountByAtt[n] = votesCountByAtt[n] + 1;
                ++numberVotes;
            }
            ++iSample2;
        }
        int mostVotedAtt = Utils.maxIndex(votesCountByAtt);
        DistributionConsolidated checkDistribution = new DistributionConsolidated(samplesVector);
        NoSplit noSplitModel = new NoSplit(checkDistribution);
        if (numberVotes == 0) {
            return noSplitModel;
        }
        double splitPointConsolidated = this.consolidateSplitPoint(mostVotedAtt, attIndexVector, splitPointVector, data);
        C45ConsolidatedSplit consolidatedModel = new C45ConsolidatedSplit(mostVotedAtt, this.m_minNoObj, checkDistribution.total(), data, samplesVector, splitPointConsolidated);
        if (!consolidatedModel.checkModel()) {
            return noSplitModel;
        }
        return consolidatedModel;
    }

    private final double consolidateSplitPoint(int mostVotedAtt, int[] attIndexVector, double[] splitPointVector, Instances data) {
        int numberSamples = attIndexVector.length;
        double consolidatedSplitPoint = Double.MAX_VALUE;
        if (data.attribute(mostVotedAtt).isNumeric()) {
            DoubleVector splitPointChosenAttVector = new DoubleVector();
            int iSample = 0;
            while (iSample < numberSamples) {
                if (attIndexVector[iSample] == mostVotedAtt) {
                    splitPointChosenAttVector.addElement(splitPointVector[iSample]);
                }
                ++iSample;
            }
            int numberSplitPoints = splitPointChosenAttVector.size();
            splitPointChosenAttVector.sort();
            consolidatedSplitPoint = splitPointChosenAttVector.get((numberSplitPoints + 1) / 2 - 1);
        }
        return consolidatedSplitPoint;
    }
}

