/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Distribution
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = 8526859638230806576L;
    protected double[][] m_perClassPerBag;
    protected double[] m_perBag;
    protected double[] m_perClass;
    protected double totaL;

    public Distribution(int numBags, int numClasses) {
        this.m_perClassPerBag = new double[numBags][0];
        this.m_perBag = new double[numBags];
        this.m_perClass = new double[numClasses];
        int i = 0;
        while (i < numBags) {
            this.m_perClassPerBag[i] = new double[numClasses];
            ++i;
        }
        this.totaL = 0.0;
    }

    public Distribution(double[][] table) {
        this.m_perClassPerBag = table;
        this.m_perBag = new double[table.length];
        this.m_perClass = new double[table[0].length];
        int i = 0;
        while (i < table.length) {
            int j = 0;
            while (j < table[i].length) {
                int n = i;
                this.m_perBag[n] = this.m_perBag[n] + table[i][j];
                int n2 = j;
                this.m_perClass[n2] = this.m_perClass[n2] + table[i][j];
                this.totaL += table[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Distribution(Instances source) throws Exception {
        this.m_perClassPerBag = new double[1][0];
        this.m_perBag = new double[1];
        this.totaL = 0.0;
        this.m_perClass = new double[source.numClasses()];
        this.m_perClassPerBag[0] = new double[source.numClasses()];
        Enumeration enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.add(0, (Instance)enu.nextElement());
        }
    }

    public Distribution(Instances source, ClassifierSplitModel modelToUse) throws Exception {
        this.m_perClassPerBag = new double[modelToUse.numSubsets()][0];
        this.m_perBag = new double[modelToUse.numSubsets()];
        this.totaL = 0.0;
        this.m_perClass = new double[source.numClasses()];
        int i = 0;
        while (i < modelToUse.numSubsets()) {
            this.m_perClassPerBag[i] = new double[source.numClasses()];
            ++i;
        }
        Enumeration enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance instance = (Instance)enu.nextElement();
            int index = modelToUse.whichSubset(instance);
            if (index != -1) {
                this.add(index, instance);
                continue;
            }
            double[] weights = modelToUse.weights(instance);
            this.addWeights(instance, weights);
        }
    }

    public Distribution(Distribution toMerge) {
        this.totaL = toMerge.totaL;
        this.m_perClass = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClass, 0, toMerge.numClasses());
        this.m_perClassPerBag = new double[1][0];
        this.m_perClassPerBag[0] = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClassPerBag[0], 0, toMerge.numClasses());
        this.m_perBag = new double[1];
        this.m_perBag[0] = this.totaL;
    }

    public Distribution(Distribution toMerge, int index) {
        this.totaL = toMerge.totaL;
        this.m_perClass = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClass, 0, this.m_perClass, 0, toMerge.numClasses());
        this.m_perClassPerBag = new double[2][0];
        this.m_perClassPerBag[0] = new double[toMerge.numClasses()];
        System.arraycopy(toMerge.m_perClassPerBag[index], 0, this.m_perClassPerBag[0], 0, toMerge.numClasses());
        this.m_perClassPerBag[1] = new double[toMerge.numClasses()];
        int i = 0;
        while (i < toMerge.numClasses()) {
            this.m_perClassPerBag[1][i] = toMerge.m_perClass[i] - this.m_perClassPerBag[0][i];
            ++i;
        }
        this.m_perBag = new double[2];
        this.m_perBag[0] = toMerge.m_perBag[index];
        this.m_perBag[1] = this.totaL - this.m_perBag[0];
    }

    public final int actualNumBags() {
        int returnValue = 0;
        int i = 0;
        while (i < this.m_perBag.length) {
            if (Utils.gr(this.m_perBag[i], 0.0)) {
                ++returnValue;
            }
            ++i;
        }
        return returnValue;
    }

    public final int actualNumClasses() {
        int returnValue = 0;
        int i = 0;
        while (i < this.m_perClass.length) {
            if (Utils.gr(this.m_perClass[i], 0.0)) {
                ++returnValue;
            }
            ++i;
        }
        return returnValue;
    }

    public final int actualNumClasses(int bagIndex) {
        int returnValue = 0;
        int i = 0;
        while (i < this.m_perClass.length) {
            if (Utils.gr(this.m_perClassPerBag[bagIndex][i], 0.0)) {
                ++returnValue;
            }
            ++i;
        }
        return returnValue;
    }

    public final void add(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] + weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] + weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
        this.totaL += weight;
    }

    public final void sub(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] - weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] - weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] - weight;
        this.totaL -= weight;
    }

    public final void add(int bagIndex, double[] counts) {
        double sum = Utils.sum(counts);
        int i = 0;
        while (i < counts.length) {
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = i;
            dArray[n] = dArray[n] + counts[i];
            ++i;
        }
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] + sum;
        i = 0;
        while (i < counts.length) {
            this.m_perClass[i] = this.m_perClass[i] + counts[i];
            ++i;
        }
        this.totaL += sum;
    }

    public final void addInstWithUnknown(Instances source, int attIndex) throws Exception {
        double[] probs = new double[this.m_perBag.length];
        int j = 0;
        while (j < this.m_perBag.length) {
            probs[j] = Utils.eq(this.totaL, 0.0) ? 1.0 / (double)probs.length : this.m_perBag[j] / this.totaL;
            ++j;
        }
        Enumeration enu = source.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance instance = (Instance)enu.nextElement();
            if (!instance.isMissing(attIndex)) continue;
            int classIndex = (int)instance.classValue();
            double weight = instance.weight();
            this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
            this.totaL += weight;
            j = 0;
            while (j < this.m_perBag.length) {
                double newWeight = probs[j] * weight;
                this.m_perClassPerBag[j][classIndex] = this.m_perClassPerBag[j][classIndex] + newWeight;
                this.m_perBag[j] = this.m_perBag[j] + newWeight;
                ++j;
            }
        }
    }

    public final void addRange(int bagIndex, Instances source, int startIndex, int lastPlusOne) throws Exception {
        double sumOfWeights = 0.0;
        int i = startIndex;
        while (i < lastPlusOne) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            sumOfWeights += instance.weight();
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = classIndex;
            dArray[n] = dArray[n] + instance.weight();
            int n2 = classIndex;
            this.m_perClass[n2] = this.m_perClass[n2] + instance.weight();
            ++i;
        }
        int n = bagIndex;
        this.m_perBag[n] = this.m_perBag[n] + sumOfWeights;
        this.totaL += sumOfWeights;
    }

    public final void addWeights(Instance instance, double[] weights) throws Exception {
        int classIndex = (int)instance.classValue();
        int i = 0;
        while (i < this.m_perBag.length) {
            double weight = instance.weight() * weights[i];
            this.m_perClassPerBag[i][classIndex] = this.m_perClassPerBag[i][classIndex] + weight;
            this.m_perBag[i] = this.m_perBag[i] + weight;
            this.m_perClass[classIndex] = this.m_perClass[classIndex] + weight;
            this.totaL += weight;
            ++i;
        }
    }

    public final boolean check(double minNoObj) {
        int counter = 0;
        int i = 0;
        while (i < this.m_perBag.length) {
            if (Utils.grOrEq(this.m_perBag[i], minNoObj)) {
                ++counter;
            }
            ++i;
        }
        return counter > 1;
    }

    public final Object clone() {
        int j;
        Distribution newDistribution = new Distribution(this.m_perBag.length, this.m_perClass.length);
        int i = 0;
        while (i < this.m_perBag.length) {
            newDistribution.m_perBag[i] = this.m_perBag[i];
            j = 0;
            while (j < this.m_perClass.length) {
                newDistribution.m_perClassPerBag[i][j] = this.m_perClassPerBag[i][j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < this.m_perClass.length) {
            newDistribution.m_perClass[j] = this.m_perClass[j];
            ++j;
        }
        newDistribution.totaL = this.totaL;
        return newDistribution;
    }

    public final void del(int bagIndex, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        this.m_perClassPerBag[bagIndex][classIndex] = this.m_perClassPerBag[bagIndex][classIndex] - weight;
        this.m_perBag[bagIndex] = this.m_perBag[bagIndex] - weight;
        this.m_perClass[classIndex] = this.m_perClass[classIndex] - weight;
        this.totaL -= weight;
    }

    public final void delRange(int bagIndex, Instances source, int startIndex, int lastPlusOne) throws Exception {
        double sumOfWeights = 0.0;
        int i = startIndex;
        while (i < lastPlusOne) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            sumOfWeights += instance.weight();
            double[] dArray = this.m_perClassPerBag[bagIndex];
            int n = classIndex;
            dArray[n] = dArray[n] - instance.weight();
            int n2 = classIndex;
            this.m_perClass[n2] = this.m_perClass[n2] - instance.weight();
            ++i;
        }
        int n = bagIndex;
        this.m_perBag[n] = this.m_perBag[n] - sumOfWeights;
        this.totaL -= sumOfWeights;
    }

    public final String dumpDistribution() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.m_perBag.length) {
            text.append("Bag num " + i + "\n");
            int j = 0;
            while (j < this.m_perClass.length) {
                text.append("Class num " + j + " " + this.m_perClassPerBag[i][j] + "\n");
                ++j;
            }
            ++i;
        }
        return text.toString();
    }

    public final void initialize() {
        int i = 0;
        while (i < this.m_perClass.length) {
            this.m_perClass[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.m_perBag.length) {
            this.m_perBag[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.m_perBag.length) {
            int j = 0;
            while (j < this.m_perClass.length) {
                this.m_perClassPerBag[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.totaL = 0.0;
    }

    public final double[][] matrix() {
        return this.m_perClassPerBag;
    }

    public final int maxBag() {
        double max = 0.0;
        int maxIndex = -1;
        int i = 0;
        while (i < this.m_perBag.length) {
            if (Utils.grOrEq(this.m_perBag[i], max)) {
                max = this.m_perBag[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public final int maxClass() {
        double maxCount = 0.0;
        int maxIndex = 0;
        int i = 0;
        while (i < this.m_perClass.length) {
            if (Utils.gr(this.m_perClass[i], maxCount)) {
                maxCount = this.m_perClass[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public final int maxClass(int index) {
        double maxCount = 0.0;
        int maxIndex = 0;
        if (Utils.gr(this.m_perBag[index], 0.0)) {
            int i = 0;
            while (i < this.m_perClass.length) {
                if (Utils.gr(this.m_perClassPerBag[index][i], maxCount)) {
                    maxCount = this.m_perClassPerBag[index][i];
                    maxIndex = i;
                }
                ++i;
            }
            return maxIndex;
        }
        return this.maxClass();
    }

    public final int numBags() {
        return this.m_perBag.length;
    }

    public final int numClasses() {
        return this.m_perClass.length;
    }

    public final double numCorrect() {
        return this.m_perClass[this.maxClass()];
    }

    public final double numCorrect(int index) {
        return this.m_perClassPerBag[index][this.maxClass(index)];
    }

    public final double numIncorrect() {
        return this.totaL - this.numCorrect();
    }

    public final double numIncorrect(int index) {
        return this.m_perBag[index] - this.numCorrect(index);
    }

    public final double perClassPerBag(int bagIndex, int classIndex) {
        return this.m_perClassPerBag[bagIndex][classIndex];
    }

    public final double perBag(int bagIndex) {
        return this.m_perBag[bagIndex];
    }

    public final double perClass(int classIndex) {
        return this.m_perClass[classIndex];
    }

    public final double laplaceProb(int classIndex) {
        return (this.m_perClass[classIndex] + 1.0) / (this.totaL + (double)this.m_perClass.length);
    }

    public final double laplaceProb(int classIndex, int intIndex) {
        if (Utils.gr(this.m_perBag[intIndex], 0.0)) {
            return (this.m_perClassPerBag[intIndex][classIndex] + 1.0) / (this.m_perBag[intIndex] + (double)this.m_perClass.length);
        }
        return this.laplaceProb(classIndex);
    }

    public final double prob(int classIndex) {
        if (!Utils.eq(this.totaL, 0.0)) {
            return this.m_perClass[classIndex] / this.totaL;
        }
        return 0.0;
    }

    public final double prob(int classIndex, int intIndex) {
        if (Utils.gr(this.m_perBag[intIndex], 0.0)) {
            return this.m_perClassPerBag[intIndex][classIndex] / this.m_perBag[intIndex];
        }
        return this.prob(classIndex);
    }

    public final Distribution subtract(Distribution toSubstract) {
        Distribution newDist = new Distribution(1, this.m_perClass.length);
        newDist.m_perBag[0] = this.totaL - toSubstract.totaL;
        newDist.totaL = newDist.m_perBag[0];
        int i = 0;
        while (i < this.m_perClass.length) {
            newDist.m_perClassPerBag[0][i] = this.m_perClass[i] - toSubstract.m_perClass[i];
            newDist.m_perClass[i] = newDist.m_perClassPerBag[0][i];
            ++i;
        }
        return newDist;
    }

    public final double total() {
        return this.totaL;
    }

    public final void shift(int from, int to, Instance instance) throws Exception {
        int classIndex = (int)instance.classValue();
        double weight = instance.weight();
        double[] dArray = this.m_perClassPerBag[from];
        int n = classIndex;
        dArray[n] = dArray[n] - weight;
        double[] dArray2 = this.m_perClassPerBag[to];
        int n2 = classIndex;
        dArray2[n2] = dArray2[n2] + weight;
        int n3 = from;
        this.m_perBag[n3] = this.m_perBag[n3] - weight;
        int n4 = to;
        this.m_perBag[n4] = this.m_perBag[n4] + weight;
    }

    public final void shiftRange(int from, int to, Instances source, int startIndex, int lastPlusOne) throws Exception {
        int i = startIndex;
        while (i < lastPlusOne) {
            Instance instance = source.instance(i);
            int classIndex = (int)instance.classValue();
            double weight = instance.weight();
            double[] dArray = this.m_perClassPerBag[from];
            int n = classIndex;
            dArray[n] = dArray[n] - weight;
            double[] dArray2 = this.m_perClassPerBag[to];
            int n2 = classIndex;
            dArray2[n2] = dArray2[n2] + weight;
            int n3 = from;
            this.m_perBag[n3] = this.m_perBag[n3] - weight;
            int n4 = to;
            this.m_perBag[n4] = this.m_perBag[n4] + weight;
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.12 $");
    }
}

