/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomTree
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Randomizable,
Drawable {
    static final long serialVersionUID = 8934314652175299374L;
    protected RandomTree[] m_Successors;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected Instances m_Info = null;
    protected double[] m_Prop = null;
    protected double[] m_ClassDistribution = null;
    protected double m_MinNum = 1.0;
    protected int m_KValue = 0;
    protected int m_randomSeed = 1;
    protected int m_MaxDepth = 0;
    protected int m_NumFolds = 0;
    protected boolean m_AllowUnclassifiedInstances = false;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for constructing a tree that considers K randomly  chosen attributes at each node. Performs no pruning. Also has an option to allow estimation of class probabilities based on a hold-out set (backfitting).";
    }

    public String minNumTipText() {
        return "The minimum total weight of the instances in a leaf.";
    }

    public double getMinNum() {
        return this.m_MinNum;
    }

    public void setMinNum(double newMinNum) {
        this.m_MinNum = newMinNum;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes. If 0, log_2(number_of_attributes) + 1 is used.";
    }

    public int getKValue() {
        return this.m_KValue;
    }

    public void setKValue(int k) {
        this.m_KValue = k;
    }

    public String seedTipText() {
        return "The random number seed used for selecting attributes.";
    }

    @Override
    public void setSeed(int seed) {
        this.m_randomSeed = seed;
    }

    @Override
    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the tree, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for backfitting. One fold is used for backfitting, the rest for growing the tree. (Default: 0, no backfitting)";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int newNumFolds) {
        this.m_NumFolds = newNumFolds;
    }

    public String allowUnclassifiedInstancesTipText() {
        return "Whether to allow unclassified instances.";
    }

    public boolean getAllowUnclassifiedInstances() {
        return this.m_AllowUnclassifiedInstances;
    }

    public void setAllowUnclassifiedInstances(boolean newAllowUnclassifiedInstances) {
        this.m_AllowUnclassifiedInstances = newAllowUnclassifiedInstances;
    }

    public void setMaxDepth(int value) {
        this.m_MaxDepth = value;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tNumber of attributes to randomly investigate\n\t(<0 = int(log_2(#attributes)+1)).", "K", 1, "-K <number of attributes>"));
        newVector.addElement(new Option("\tSet minimum number of instances per leaf.", "M", 1, "-M <minimum number of instances>"));
        newVector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S <num>"));
        newVector.addElement(new Option("\tThe maximum depth of the tree, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        newVector.addElement(new Option("\tNumber of folds for backfitting (default 0, no backfitting).", "N", 1, "-N <num>"));
        newVector.addElement(new Option("\tAllow unclassified instances.", "U", 0, "-U"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-K");
        result.add("" + this.getKValue());
        result.add("-M");
        result.add("" + this.getMinNum());
        result.add("-S");
        result.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            result.add("-depth");
            result.add("" + this.getMaxDepth());
        }
        if (this.getNumFolds() > 0) {
            result.add("-N");
            result.add("" + this.getNumFolds());
        }
        if (this.getAllowUnclassifiedInstances()) {
            result.add("-U");
        }
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('K', options);
        this.m_KValue = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 0;
        tmpStr = Utils.getOption('M', options);
        this.m_MinNum = tmpStr.length() != 0 ? Double.parseDouble(tmpStr) : 1.0;
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption("depth", options);
        if (tmpStr.length() != 0) {
            this.setMaxDepth(Integer.parseInt(tmpStr));
        } else {
            this.setMaxDepth(0);
        }
        String numFoldsString = Utils.getOption('N', options);
        this.m_NumFolds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 0;
        this.setAllowUnclassifiedInstances(Utils.getFlag('U', options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_KValue > data.numAttributes() - 1) {
            this.m_KValue = data.numAttributes() - 1;
        }
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(data.numAttributes()) + 1;
        }
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(data);
            return;
        }
        this.m_ZeroR = null;
        Instances train = null;
        Instances backfit = null;
        Random rand = data.getRandomNumberGenerator(this.m_randomSeed);
        if (this.m_NumFolds <= 0) {
            train = data;
        } else {
            data.randomize(rand);
            data.stratify(this.m_NumFolds);
            train = data.trainCV(this.m_NumFolds, 1, rand);
            backfit = data.testCV(this.m_NumFolds, 1);
        }
        int[] attIndicesWindow = new int[data.numAttributes() - 1];
        int j = 0;
        int i = 0;
        while (i < attIndicesWindow.length) {
            if (j == data.classIndex()) {
                // empty if block
            }
            int n = ++j;
            ++j;
            attIndicesWindow[i] = n;
            ++i;
        }
        double[] classProbs = new double[train.numClasses()];
        int i2 = 0;
        while (i2 < train.numInstances()) {
            Instance inst = train.instance(i2);
            int n = (int)inst.classValue();
            classProbs[n] = classProbs[n] + inst.weight();
            ++i2;
        }
        this.buildTree(train, classProbs, new Instances(data, 0), this.m_MinNum, this.m_Debug, attIndicesWindow, rand, 0, this.getAllowUnclassifiedInstances());
        if (backfit != null) {
            this.backfitData(backfit);
        }
    }

    public void backfitData(Instances data) throws Exception {
        double[] classProbs = new double[data.numClasses()];
        int i = 0;
        while (i < data.numInstances()) {
            Instance inst = data.instance(i);
            int n = (int)inst.classValue();
            classProbs[n] = classProbs[n] + inst.weight();
            ++i;
        }
        this.backfitData(data, classProbs);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] returnedDist = null;
        if (this.m_Attribute > -1) {
            if (instance.isMissing(this.m_Attribute)) {
                returnedDist = new double[this.m_Info.numClasses()];
                int i = 0;
                while (i < this.m_Successors.length) {
                    double[] help = this.m_Successors[i].distributionForInstance(instance);
                    if (help != null) {
                        int j = 0;
                        while (j < help.length) {
                            int n = j;
                            returnedDist[n] = returnedDist[n] + this.m_Prop[i] * help[j];
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                returnedDist = this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
            }
        }
        if (this.m_Attribute == -1 || returnedDist == null) {
            if (this.m_ClassDistribution == null) {
                if (this.getAllowUnclassifiedInstances()) {
                    return new double[this.m_Info.numClasses()];
                }
                return null;
            }
            double[] normalizedDistribution = (double[])this.m_ClassDistribution.clone();
            Utils.normalize(normalizedDistribution);
            return normalizedDistribution;
        }
        return returnedDist;
    }

    public String toGraph() {
        try {
            StringBuffer resultBuff = new StringBuffer();
            this.toGraph(resultBuff, 0);
            String result = "digraph Tree {\nedge [style=bold]\n" + resultBuff.toString() + "\n}\n";
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int toGraph(StringBuffer text, int num) throws Exception {
        int maxIndex = Utils.maxIndex(this.m_ClassDistribution);
        String classValue = this.m_Info.classAttribute().value(maxIndex);
        ++num;
        if (this.m_Attribute == -1) {
            text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + classValue + "\"" + "shape=box]\n");
        } else {
            text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + classValue + "\"]\n");
            int i = 0;
            while (i < this.m_Successors.length) {
                text.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"" + this.m_Info.attribute(this.m_Attribute).name());
                if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                    if (i == 0) {
                        text.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    } else {
                        text.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    }
                } else {
                    text.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                }
                text.append("\"]\n");
                num = this.m_Successors[i].toGraph(text, num);
                ++i;
            }
        }
        return num;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "")) + "\n");
            buf.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=")) + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_Successors == null) {
            return "RandomTree: no model has been built yet.";
        }
        return "\nRandomTree\n==========\n" + this.toString(0) + "\n" + "\nSize of the tree : " + this.numNodes() + (this.getMaxDepth() > 0 ? "\nMax depth of tree: " + this.getMaxDepth() : "");
    }

    protected String leafString() throws Exception {
        double sum = 0.0;
        double maxCount = 0.0;
        int maxIndex = 0;
        if (this.m_ClassDistribution != null) {
            sum = Utils.sum(this.m_ClassDistribution);
            maxIndex = Utils.maxIndex(this.m_ClassDistribution);
            maxCount = this.m_ClassDistribution[maxIndex];
        }
        return " : " + this.m_Info.classAttribute().value(maxIndex) + " (" + Utils.doubleToString(sum, 2) + "/" + Utils.doubleToString(sum - maxCount, 2) + ")";
    }

    protected String toString(int level) {
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_Attribute == -1) {
                return this.leafString();
            }
            if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                int i = 0;
                while (i < this.m_Successors.length) {
                    text.append("\n");
                    int j = 0;
                    while (j < level) {
                        text.append("|   ");
                        ++j;
                    }
                    text.append(String.valueOf(this.m_Info.attribute(this.m_Attribute).name()) + " = " + this.m_Info.attribute(this.m_Attribute).value(i));
                    text.append(this.m_Successors[i].toString(level + 1));
                    ++i;
                }
            } else {
                text.append("\n");
                int j = 0;
                while (j < level) {
                    text.append("|   ");
                    ++j;
                }
                text.append(String.valueOf(this.m_Info.attribute(this.m_Attribute).name()) + " < " + Utils.doubleToString(this.m_SplitPoint, 2));
                text.append(this.m_Successors[0].toString(level + 1));
                text.append("\n");
                j = 0;
                while (j < level) {
                    text.append("|   ");
                    ++j;
                }
                text.append(String.valueOf(this.m_Info.attribute(this.m_Attribute).name()) + " >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                text.append(this.m_Successors[1].toString(level + 1));
            }
            return text.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "RandomTree: tree can't be printed";
        }
    }

    protected void backfitData(Instances data, double[] classProbs) throws Exception {
        if (data.numInstances() == 0) {
            this.m_Attribute = -1;
            this.m_ClassDistribution = null;
            this.m_Prop = null;
            return;
        }
        this.m_ClassDistribution = (double[])classProbs.clone();
        if (this.m_Attribute > -1) {
            this.m_Prop = new double[this.m_Successors.length];
            int i = 0;
            while (i < data.numInstances()) {
                Instance inst = data.instance(i);
                if (!inst.isMissing(this.m_Attribute)) {
                    if (data.attribute(this.m_Attribute).isNominal()) {
                        int n = (int)inst.value(this.m_Attribute);
                        this.m_Prop[n] = this.m_Prop[n] + inst.weight();
                    } else {
                        int n = inst.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1;
                        this.m_Prop[n] = this.m_Prop[n] + inst.weight();
                    }
                }
                ++i;
            }
            if (Utils.sum(this.m_Prop) <= 0.0) {
                this.m_Attribute = -1;
                this.m_Prop = null;
                return;
            }
            Utils.normalize(this.m_Prop);
            Instances[] subsets = this.splitData(data);
            int i2 = 0;
            while (i2 < subsets.length) {
                double[] dist = new double[data.numClasses()];
                int j = 0;
                while (j < subsets[i2].numInstances()) {
                    int n = (int)subsets[i2].instance(j).classValue();
                    dist[n] = dist[n] + subsets[i2].instance(j).weight();
                    ++j;
                }
                this.m_Successors[i2].backfitData(subsets[i2], dist);
                ++i2;
            }
            if (this.getAllowUnclassifiedInstances()) {
                this.m_ClassDistribution = null;
                return;
            }
            boolean emptySuccessor = false;
            int i3 = 0;
            while (i3 < subsets.length) {
                if (this.m_Successors[i3].m_ClassDistribution == null) {
                    emptySuccessor = true;
                    return;
                }
                ++i3;
            }
            this.m_ClassDistribution = null;
        }
    }

    protected void buildTree(Instances data, double[] classProbs, Instances header, double minNum, boolean debug, int[] attIndicesWindow, Random random, int depth, boolean allow) throws Exception {
        this.m_Info = header;
        this.m_Debug = debug;
        this.m_MinNum = minNum;
        this.m_AllowUnclassifiedInstances = allow;
        if (data.numInstances() == 0) {
            this.m_Attribute = -1;
            this.m_ClassDistribution = null;
            this.m_Prop = null;
            return;
        }
        this.m_ClassDistribution = (double[])classProbs.clone();
        if (Utils.sum(this.m_ClassDistribution) < 2.0 * this.m_MinNum || Utils.eq(this.m_ClassDistribution[Utils.maxIndex(this.m_ClassDistribution)], Utils.sum(this.m_ClassDistribution)) || this.getMaxDepth() > 0 && depth >= this.getMaxDepth()) {
            this.m_Attribute = -1;
            this.m_Prop = null;
            return;
        }
        double[] vals = new double[data.numAttributes()];
        double[][][] dists = new double[data.numAttributes()][0][0];
        double[][] props = new double[data.numAttributes()][0];
        double[] splits = new double[data.numAttributes()];
        int attIndex = 0;
        int windowSize = attIndicesWindow.length;
        int k = this.m_KValue;
        boolean gainFound = false;
        while (!(windowSize <= 0 || k-- <= 0 && gainFound)) {
            int chosenIndex = random.nextInt(windowSize);
            attIndex = attIndicesWindow[chosenIndex];
            attIndicesWindow[chosenIndex] = attIndicesWindow[windowSize - 1];
            attIndicesWindow[windowSize - 1] = attIndex;
            --windowSize;
            splits[attIndex] = this.distribution(props, dists, attIndex, data);
            vals[attIndex] = this.gain(dists[attIndex], this.priorVal(dists[attIndex]));
            if (!Utils.gr(vals[attIndex], 0.0)) continue;
            gainFound = true;
        }
        this.m_Attribute = Utils.maxIndex(vals);
        double[][] distribution = dists[this.m_Attribute];
        if (Utils.gr(vals[this.m_Attribute], 0.0)) {
            this.m_SplitPoint = splits[this.m_Attribute];
            this.m_Prop = props[this.m_Attribute];
            Instances[] subsets = this.splitData(data);
            this.m_Successors = new RandomTree[distribution.length];
            int i = 0;
            while (i < distribution.length) {
                this.m_Successors[i] = new RandomTree();
                this.m_Successors[i].setKValue(this.m_KValue);
                this.m_Successors[i].setMaxDepth(this.getMaxDepth());
                this.m_Successors[i].buildTree(subsets[i], distribution[i], header, this.m_MinNum, this.m_Debug, attIndicesWindow, random, depth + 1, allow);
                ++i;
            }
            boolean emptySuccessor = false;
            int i2 = 0;
            while (i2 < subsets.length) {
                if (this.m_Successors[i2].m_ClassDistribution == null) {
                    emptySuccessor = true;
                    break;
                }
                ++i2;
            }
            if (!emptySuccessor) {
                this.m_ClassDistribution = null;
            }
        } else {
            this.m_Attribute = -1;
        }
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Successors.length) {
            size += this.m_Successors[i].numNodes();
            ++i;
        }
        return size;
    }

    protected Instances[] splitData(Instances data) throws Exception {
        Instances[] subsets = new Instances[this.m_Prop.length];
        int i = 0;
        while (i < this.m_Prop.length) {
            subsets[i] = new Instances(data, data.numInstances());
            ++i;
        }
        i = 0;
        while (i < data.numInstances()) {
            Instance inst = data.instance(i);
            if (inst.isMissing(this.m_Attribute)) {
                int k = 0;
                while (k < this.m_Prop.length) {
                    if (this.m_Prop[k] > 0.0) {
                        Instance copy = (Instance)inst.copy();
                        copy.setWeight(this.m_Prop[k] * inst.weight());
                        subsets[k].add(copy);
                    }
                    ++k;
                }
            } else if (data.attribute(this.m_Attribute).isNominal()) {
                subsets[(int)inst.value(this.m_Attribute)].add(inst);
            } else if (data.attribute(this.m_Attribute).isNumeric()) {
                subsets[inst.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1].add(inst);
            } else {
                throw new IllegalArgumentException("Unknown attribute type");
            }
            ++i;
        }
        i = 0;
        while (i < this.m_Prop.length) {
            subsets[i].compactify();
            ++i;
        }
        return subsets;
    }

    protected double distribution(double[][] props, double[][][] dists, int att, Instances data) throws Exception {
        Instance inst;
        double splitPoint = Double.NaN;
        Attribute attribute = data.attribute(att);
        double[][] dist = null;
        int indexOfFirstMissingValue = -1;
        if (attribute.isNominal()) {
            dist = new double[attribute.numValues()][data.numClasses()];
            int i = 0;
            while (i < data.numInstances()) {
                inst = data.instance(i);
                if (inst.isMissing(att)) {
                    if (indexOfFirstMissingValue < 0) {
                        indexOfFirstMissingValue = i;
                    }
                } else {
                    double[] dArray = dist[(int)inst.value(att)];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + inst.weight();
                }
                ++i;
            }
        } else {
            double[][] currDist = new double[2][data.numClasses()];
            dist = new double[2][data.numClasses()];
            data.sort(att);
            int j = 0;
            while (j < data.numInstances()) {
                Instance inst2 = data.instance(j);
                if (inst2.isMissing(att)) {
                    indexOfFirstMissingValue = j;
                    break;
                }
                double[] dArray = currDist[1];
                int n = (int)inst2.classValue();
                dArray[n] = dArray[n] + inst2.weight();
                ++j;
            }
            double priorVal = this.priorVal(currDist);
            int j2 = 0;
            while (j2 < currDist.length) {
                System.arraycopy(currDist[j2], 0, dist[j2], 0, dist[j2].length);
                ++j2;
            }
            double currSplit = data.instance(0).value(att);
            double bestVal = -1.7976931348623157E308;
            int i = 0;
            while (i < data.numInstances()) {
                Instance inst3 = data.instance(i);
                if (!inst3.isMissing(att)) {
                    double currVal;
                    if (inst3.value(att) > currSplit && (currVal = this.gain(currDist, priorVal)) > bestVal) {
                        bestVal = currVal;
                        splitPoint = (inst3.value(att) + currSplit) / 2.0;
                        int j3 = 0;
                        while (j3 < currDist.length) {
                            System.arraycopy(currDist[j3], 0, dist[j3], 0, dist[j3].length);
                            ++j3;
                        }
                    }
                    currSplit = inst3.value(att);
                    double[] dArray = currDist[0];
                    int n = (int)inst3.classValue();
                    dArray[n] = dArray[n] + inst3.weight();
                    double[] dArray2 = currDist[1];
                    int n2 = (int)inst3.classValue();
                    dArray2[n2] = dArray2[n2] - inst3.weight();
                    ++i;
                    continue;
                }
                break;
            }
        }
        props[att] = new double[dist.length];
        int k = 0;
        while (k < props[att].length) {
            props[att][k] = Utils.sum(dist[k]);
            ++k;
        }
        if (Utils.eq(Utils.sum(props[att]), 0.0)) {
            k = 0;
            while (k < props[att].length) {
                props[att][k] = 1.0 / (double)props[att].length;
                ++k;
            }
        } else {
            Utils.normalize(props[att]);
        }
        if (indexOfFirstMissingValue > -1) {
            int i = indexOfFirstMissingValue;
            while (i < data.numInstances()) {
                inst = data.instance(i);
                if (attribute.isNominal()) {
                    if (inst.isMissing(att)) {
                        int j = 0;
                        while (j < dist.length) {
                            double[] dArray = dist[j];
                            int n = (int)inst.classValue();
                            dArray[n] = dArray[n] + props[att][j] * inst.weight();
                            ++j;
                        }
                    }
                } else {
                    int j = 0;
                    while (j < dist.length) {
                        double[] dArray = dist[j];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + props[att][j] * inst.weight();
                        ++j;
                    }
                }
                ++i;
            }
        }
        dists[att] = dist;
        return splitPoint;
    }

    protected double priorVal(double[][] dist) {
        return ContingencyTables.entropyOverColumns(dist);
    }

    protected double gain(double[][] dist, double priorVal) {
        return priorVal - ContingencyTables.entropyConditionedOnRows(dist);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] argv) {
        RandomTree.runClassifier(new RandomTree(), argv);
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Successors == null) {
            throw new Exception("RandomTree: No model built yet.");
        }
        StringBuffer resultBuff = new StringBuffer();
        this.toGraph(resultBuff, 0, null);
        String result = "digraph RandomTree {\nedge [style=bold]\n" + resultBuff.toString() + "\n}\n";
        return result;
    }

    @Override
    public int graphType() {
        return 1;
    }

    protected int toGraph(StringBuffer text, int num, RandomTree parent) throws Exception {
        ++num;
        if (this.m_Attribute == -1) {
            text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + this.leafString() + "\"" + " shape=box]\n");
        } else {
            text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + this.m_Info.attribute(this.m_Attribute).name() + "\"]\n");
            int i = 0;
            while (i < this.m_Successors.length) {
                text.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"");
                if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                    if (i == 0) {
                        text.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    } else {
                        text.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    }
                } else {
                    text.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                }
                text.append("\"]\n");
                num = this.m_Successors[i].toGraph(text, num, this);
                ++i;
            }
        }
        return num;
    }
}

