/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Sourcable;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45PruneableClassifierTree;
import weka.classifiers.trees.j48Consolidated.C45ConsolidatedModelSelection;
import weka.classifiers.trees.j48Consolidated.C45ConsolidatedPruneableClassifierTree;
import weka.classifiers.trees.j48Consolidated.InstancesConsolidated;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.Matchable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class J48Consolidated
extends J48
implements OptionHandler,
Drawable,
Matchable,
Sourcable,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -2647522302468491144L;
    private int m_RMnumberSamples = 5;
    private boolean m_RMreplacement = false;
    private int m_RMbagSizePercent = -1;
    private float m_RMnewDistrMinClass = 50.0f;

    @Override
    public String globalInfo() {
        return "Class for generating a pruned or unpruned C45 consolidated tree. Uses the Consolidated Tree Construction (CTC) algorithm: a single tree is built based on a set of subsamples. New options are added to the class J48 to set the Resampling Method (RM) for the generation of samples to use in the consolidation process. For more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jes\u00fas M. P\u00e9rez and Javier Muguerza and Olatz Arbelaitz and Ibai Gurrutxaga and Jos\u00e9 I. Mart\u00ed\u00adn");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining multiple class distribution modified subsamples in a single tree");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recognition Letters");
        result.setValue(TechnicalInformation.Field.VOLUME, "28");
        result.setValue(TechnicalInformation.Field.NUMBER, "4");
        result.setValue(TechnicalInformation.Field.PAGES, "414-422");
        result.setValue(TechnicalInformation.Field.URL, "http://dx.doi.org/10.1016/j.patrec.2006.08.013");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        try {
            result = new C45PruneableClassifierTree(null, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup).getCapabilities();
        }
        catch (Exception e) {
            result = new Capabilities(this);
        }
        result.setOwner(this);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        C45ConsolidatedModelSelection modSelection = new C45ConsolidatedModelSelection(this.m_minNumObj, instances);
        this.m_root = new C45ConsolidatedPruneableClassifierTree(modSelection, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Instances[] samplesVector = this.generateSamples(instances);
        if (this.m_Debug) {
            this.printSamplesVector(samplesVector);
        }
        ((C45ConsolidatedPruneableClassifierTree)this.m_root).buildClassifier(instances, samplesVector);
        ((C45ModelSelection)modSelection).cleanup();
    }

    private Instances[] generateSamples(Instances instances) throws Exception {
        int dataSize;
        Instances[] samplesVector = null;
        this.getCapabilities().testWithFail(instances);
        InstancesConsolidated instancesWMC = new InstancesConsolidated(instances);
        instancesWMC.deleteWithMissingClass();
        if (this.m_Debug) {
            System.out.println("=== Generation of the set of samples ===");
            System.out.println(this.toStringResamplingMethod());
        }
        if ((dataSize = instancesWMC.numInstances()) == 0) {
            System.err.println("Original data size is 0! Handle zero training instances!");
        } else if (this.m_Debug) {
            System.out.println("Original data size: " + dataSize);
        }
        int bagSize = 0;
        if (this.m_RMbagSizePercent >= 0) {
            bagSize = dataSize * this.m_RMbagSizePercent / 100;
            if (bagSize == 0) {
                System.err.println("Size of samples is 0 (" + this.m_RMbagSizePercent + "% of " + dataSize + ")! Handle zero training instances!");
            }
        } else if (this.m_RMnewDistrMinClass < 0.0f) {
            throw new Exception("Size of samples (" + this.m_RMbagSizePercent + "% of " + dataSize + ") has to be greater than 0!");
        }
        Random random = dataSize == 0 ? new Random(this.m_Seed) : instancesWMC.getRandomNumberGenerator(this.m_Seed);
        samplesVector = this.m_RMnewDistrMinClass == -2.0f ? this.generateStratifiedSamples(instancesWMC, dataSize, bagSize, random) : (this.m_RMnewDistrMinClass == -1.0f ? this.generateFreeDistrSamples(instancesWMC, dataSize, bagSize, random) : this.generateSamplesChangingMinClassDistr(instancesWMC, dataSize, bagSize, random));
        return samplesVector;
    }

    private Instances[] generateStratifiedSamples(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        Instances[] samplesVector = new Instances[this.m_RMnumberSamples];
        int numClasses = instances.numClasses();
        int localBagSize = 0;
        InstancesConsolidated[] classesVector = instances.getClasses();
        int[] classSizeVector = new int[numClasses];
        int iClass = 0;
        while (iClass < numClasses) {
            classSizeVector[iClass] = classesVector[iClass].numInstances();
            ++iClass;
        }
        int iMinClass = Utils.minIndex(classSizeVector);
        if (this.m_Debug) {
            System.out.println("Minority class value (" + iMinClass + "): " + instances.classAttribute().value(iMinClass));
            System.out.println("Classes sizes:");
            iClass = 0;
            while (iClass < numClasses) {
                float distrClass = dataSize == 0 ? 0.0f : 100.0f * (float)classSizeVector[iClass] / (float)dataSize;
                System.out.print(String.valueOf(classSizeVector[iClass]) + " (" + distrClass + "%)");
                if (iClass < numClasses - 1) {
                    System.out.print(", ");
                }
                ++iClass;
            }
            System.out.println("");
        }
        int[] newClassSizeVector = new int[numClasses];
        int iClass2 = 0;
        while (iClass2 < numClasses) {
            if (iClass2 != iMinClass) {
                int newClassSize;
                newClassSizeVector[iClass2] = newClassSize = classSizeVector[iClass2] * this.m_RMbagSizePercent / 100;
                localBagSize += newClassSize;
            }
            ++iClass2;
        }
        newClassSizeVector[iMinClass] = bagSize - localBagSize;
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
            System.out.println("Classes sizes of the new bag:");
            iClass2 = 0;
            while (iClass2 < numClasses) {
                System.out.print(newClassSizeVector[iClass2]);
                if (iClass2 < numClasses - 1) {
                    System.out.print(", ");
                }
                ++iClass2;
            }
            System.out.println("");
        }
        int iSample = 0;
        while (iSample < this.m_RMnumberSamples) {
            Instances bagData = null;
            InstancesConsolidated bagClass = null;
            int iClass3 = 0;
            while (iClass3 < numClasses) {
                bagClass = this.m_RMreplacement ? new InstancesConsolidated(classesVector[iClass3].resampleWithWeights(random)) : new InstancesConsolidated(classesVector[iClass3]);
                bagClass.randomize(random);
                if (newClassSizeVector[iClass3] < classSizeVector[iClass3]) {
                    InstancesConsolidated newBagData;
                    bagClass = newBagData = new InstancesConsolidated(bagClass, 0, newClassSizeVector[iClass3]);
                    newBagData = null;
                }
                if (bagData == null) {
                    bagData = bagClass;
                } else {
                    ((InstancesConsolidated)bagData).add(bagClass);
                }
                bagClass = null;
                ++iClass3;
            }
            bagData.randomize(random);
            samplesVector[iSample] = bagData;
            bagData = null;
            bagClass = null;
            ++iSample;
        }
        return samplesVector;
    }

    private Instances[] generateFreeDistrSamples(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        Instances[] samplesVector = new Instances[this.m_RMnumberSamples];
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
        }
        int iSample = 0;
        while (iSample < this.m_RMnumberSamples) {
            Instances bagData = null;
            bagData = this.m_RMreplacement ? new Instances(instances.resampleWithWeights(random)) : new Instances(instances);
            bagData.randomize(random);
            if (bagSize < dataSize) {
                Instances newBagData;
                bagData = newBagData = new Instances(bagData, 0, bagSize);
                newBagData = null;
            }
            samplesVector[iSample] = bagData;
            ++iSample;
        }
        return samplesVector;
    }

    private Instances[] generateSamplesChangingMinClassDistr(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        int newMajClassSize;
        int newMinClassSize;
        int maxMajClassSize;
        int maxMinClassSize;
        Instances[] samplesVector = new Instances[this.m_RMnumberSamples];
        if (instances.classAttribute().numValues() != 2) {
            throw new Exception("Only binary problems (two classes datasets) can be used to change the distribution of classes!!!\nUse 'free' or 'stratified' values in <distribution minority class> for multi-class datasets!!!");
        }
        InstancesConsolidated[] classesVector = instances.getClasses();
        int iMinClass = classesVector[0].numInstances() <= classesVector[1].numInstances() ? 0 : 1;
        int iMajClass = 1 - iMinClass;
        int minClassSize = classesVector[iMinClass].numInstances();
        int majClassSize = classesVector[iMajClass].numInstances();
        float distrMinClass = dataSize == 0 ? 0.0f : 100.0f * (float)minClassSize / (float)dataSize;
        if (this.m_Debug) {
            System.out.println("Minority class value (" + iMinClass + "): " + instances.classAttribute().value(iMinClass));
            System.out.println("Minority class size: " + minClassSize + " (" + distrMinClass + "%)");
            System.out.println("Majority class size: " + majClassSize);
        }
        if (this.m_RMnewDistrMinClass > distrMinClass) {
            maxMinClassSize = minClassSize;
            maxMajClassSize = (int)((float)minClassSize * (100.0f - this.m_RMnewDistrMinClass) / this.m_RMnewDistrMinClass);
        } else {
            maxMajClassSize = majClassSize;
            maxMinClassSize = (int)((float)majClassSize * this.m_RMnewDistrMinClass / (100.0f - this.m_RMnewDistrMinClass));
        }
        if (this.m_RMbagSizePercent == -2) {
            if (this.m_RMnewDistrMinClass == distrMinClass) {
                System.err.println("Doesn't make sense that the original distribution and the distribution to be changed (RMnewDistrMinClass) are the same and the size of samples to be generated is maximum (RMbagSizePercent=-2)!!!");
            }
            newMinClassSize = maxMinClassSize;
            newMajClassSize = maxMajClassSize;
            bagSize = maxMinClassSize + maxMajClassSize;
        } else {
            if (this.m_RMbagSizePercent == -1) {
                bagSize = minClassSize;
                newMinClassSize = (int)(this.m_RMnewDistrMinClass * (float)bagSize / 100.0f);
            } else {
                newMinClassSize = (int)(this.m_RMnewDistrMinClass * (float)bagSize / 100.0f);
            }
            newMajClassSize = bagSize - newMinClassSize;
        }
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
            System.out.println("New minority class size: " + newMinClassSize + " (" + (int)((double)newMinClassSize / (double)bagSize * 100.0) + "%)");
            System.out.println("New majority class size: " + newMajClassSize);
        }
        if (newMinClassSize > minClassSize) {
            throw new Exception("There isn't enough instances of the minority class (" + minClassSize + ") to extract " + newMinClassSize + " for the new samples " + "whithout replacement!!!");
        }
        if (newMajClassSize > majClassSize) {
            throw new Exception("There isn't enough instances of the majority class (" + majClassSize + ") to extract " + newMajClassSize + " for the new samples " + "whithout replacement!!!");
        }
        int iSample = 0;
        while (iSample < this.m_RMnumberSamples) {
            InstancesConsolidated newBagData;
            InstancesConsolidated bagData = null;
            InstancesConsolidated bagClass = null;
            bagClass = new InstancesConsolidated(classesVector[iMinClass]);
            bagClass.randomize(random);
            if (newMinClassSize < minClassSize) {
                bagClass = newBagData = new InstancesConsolidated(bagClass, 0, newMinClassSize);
                newBagData = null;
            }
            bagData = bagClass;
            bagClass = null;
            bagClass = new InstancesConsolidated(classesVector[iMajClass]);
            bagClass.randomize(random);
            if (newMajClassSize < majClassSize) {
                bagClass = newBagData = new InstancesConsolidated(bagClass, 0, newMajClassSize);
                newBagData = null;
            }
            bagData.add(bagClass);
            bagData.randomize(random);
            samplesVector[iSample] = bagData;
            bagData = null;
            bagClass = null;
            ++iSample;
        }
        return samplesVector;
    }

    private void printSamplesVector(Instances[] samplesVector) {
        int iSample = 0;
        while (iSample < samplesVector.length) {
            System.out.println("==== SAMPLE " + iSample + " ====");
            System.out.println(samplesVector[iSample]);
            System.out.println(" ");
            ++iSample;
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            newVector.addElement((Option)en.nextElement());
        }
        newVector.addElement(new Option("\tNumber of samples to be generated for use in the construction of the\n\tconsolidated tree.\n\t(default 5)", "RM-N", 1, "-RM-N <Number of samples>"));
        newVector.addElement(new Option("\tUse replacement to generate the set of samples\n\t(default false)", "RM-R", 0, "-RM-R"));
        newVector.addElement(new Option("\tSize of each sample(bag), as a percentage of the training set size.\n\tCombined with the option <distribution minority class> accepts:\n\t * -1 (sizeOfMinClass): The size of the minority class\n\t * -2 (maxSize): Maximum size taking into account <distribution minority\n\t              class> and using no replacement\n\t(default -1)", "RM-B", 1, "-RM-B <Size of each sample(%)>"));
        newVector.addElement(new Option("\tDetermines the new value of the distribution of the minority class.\n\tIt can be one of the following values:\n\t * A value between 0 and 100 to change the portion of minority class\n\t              instances in the new samples (Only for two-classes datasets)\n\t * -1 (free): Works with the instances without taking into account\n\t              their class\n\t * -2 (stratified): Maintains the original class distribution in the\n\t              new samples\n\t(default 50.0)", "RM-D", 1, "-RM-D <distribution minority class>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String RMnumberSamplesString = Utils.getOption("RM-N", options);
        if (RMnumberSamplesString.length() != 0) {
            this.setRMnumberSamples(Integer.parseInt(RMnumberSamplesString));
        } else {
            this.setRMnumberSamples(5);
        }
        String RMbagSizePercentString = Utils.getOption("RM-B", options);
        if (RMbagSizePercentString.length() != 0) {
            this.setRMbagSizePercent(Integer.parseInt(RMbagSizePercentString), false);
        } else {
            this.setRMbagSizePercent(-1, false);
        }
        String RMnewDistrMinClassString = Utils.getOption("RM-D", options);
        if (RMnewDistrMinClassString.length() != 0) {
            this.setRMnewDistrMinClass(new Float(RMnewDistrMinClassString).floatValue(), false);
        } else {
            this.setRMnewDistrMinClass(50.0f, false);
        }
        this.setRMreplacement(Utils.getFlag("RM-R", options), true);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-Q");
        result.add("" + this.m_Seed);
        result.add("-RM-N");
        result.add("" + this.m_RMnumberSamples);
        if (this.m_RMreplacement) {
            result.add("-RM-R");
        }
        result.add("-RM-B");
        result.add("" + this.m_RMbagSizePercent);
        result.add("-RM-D");
        result.add("" + this.m_RMnewDistrMinClass);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        if (this.m_unpruned) {
            return "J48Consolidated unpruned tree\n" + this.toStringResamplingMethod() + this.m_root.toString();
        }
        return "J48Consolidated pruned tree\n" + this.toStringResamplingMethod() + this.m_root.toString();
    }

    public String toStringResamplingMethod() {
        String st = "[RM] N_S=" + this.m_RMnumberSamples;
        st = this.m_RMnewDistrMinClass == -2.0f ? String.valueOf(st) + " stratified" : (this.m_RMnewDistrMinClass == -1.0f ? String.valueOf(st) + " free distribution" : String.valueOf(st) + " %Min=" + this.m_RMnewDistrMinClass);
        st = String.valueOf(st) + " Size=";
        st = this.m_RMbagSizePercent == -2 ? String.valueOf(st) + "maxSize" : (this.m_RMbagSizePercent == -1 ? String.valueOf(st) + "sizeOfMinClass" : String.valueOf(st) + this.m_RMbagSizePercent + "%");
        st = this.m_RMreplacement ? String.valueOf(st) + " (with replacement)" : String.valueOf(st) + " (without replacement)";
        st = String.valueOf(st) + "\n";
        char[] ch_line = new char[st.length()];
        int i = 0;
        while (i < ch_line.length) {
            ch_line[i] = 45;
            ++i;
        }
        String line = String.valueOf(ch_line);
        line = String.valueOf(line) + "\n";
        st = String.valueOf(st) + line;
        return st;
    }

    public String RMnumberSamplesTipText() {
        return "Number of samples to be generated for use in the consolidation process";
    }

    public int getRMnumberSamples() {
        return this.m_RMnumberSamples;
    }

    public void setRMnumberSamples(int v) {
        this.m_RMnumberSamples = v;
    }

    public String RMreplacementTipText() {
        return "Whether replacement is performed to generate the set of samples.";
    }

    public boolean getRMreplacement() {
        return this.m_RMreplacement;
    }

    public void setRMreplacement(boolean v) throws Exception {
        this.setRMreplacement(v, true);
    }

    public void setRMreplacement(boolean v, boolean checkComb) throws Exception {
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(v, this.m_RMbagSizePercent, this.m_RMnewDistrMinClass);
        }
        this.m_RMreplacement = v;
    }

    public String RMbagSizePercentTipText() {
        return "Size of each sample(bag), as a percentage of the training set size/-1=sizeOfMinClass/-2=maxSize.\nCombined with the option <distribution minority class> accepts:\n * -1 (sizeOfMinClass): The size of the minority class\n * -2 (maxSize): Maximum size taking into account <distribution minority class>\n             and using no replacement.";
    }

    public int getRMbagSizePercent() {
        return this.m_RMbagSizePercent;
    }

    public void setRMbagSizePercent(int v) throws Exception {
        this.setRMbagSizePercent(v, true);
    }

    public void setRMbagSizePercent(int v, boolean checkComb) throws Exception {
        if (v < -2 || v > 100) {
            throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100 (or combining with the option <distribution minority class> -1 for 'sizeOfMinClass' or -2 for 'maxSize')!");
        }
        if (v == 0) {
            throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100!");
        }
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(this.m_RMreplacement, v, this.m_RMnewDistrMinClass);
        }
        this.m_RMbagSizePercent = v;
    }

    private void checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(boolean replacement, int bagSizePercent, float newDistrMinClass) throws Exception {
        if (newDistrMinClass > 0.0f && newDistrMinClass < 100.0f && replacement) {
            throw new Exception("Using replacement isn't contempled to change the distribution of minority class!");
        }
        if (newDistrMinClass == -1.0f || newDistrMinClass == -2.0f) {
            if (bagSizePercent < 0) {
                throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100!");
            }
            if (!replacement && bagSizePercent == 100) {
                System.err.println("Doesn't make sense that size of sample (%) is 100, when replacement is false!");
            }
        }
    }

    public String RMnewDistrMinClassTipText() {
        return "Determines the new value of the distribution of the minority class, if we want to change it/-1=free/-2=stratified.\nIt can be one of the following values:\n * A value between 0 and 100 to change the portion of minority class instances in the new samples\n   (this option can only be used with binary problems (two classes datasets))\n * -1 (free): Works with the instances without taking into account their class.\n * -2 (stratified): Maintains the original class distribution in the new samples.\n (default: 50)";
    }

    public float getRMnewDistrMinClass() {
        return this.m_RMnewDistrMinClass;
    }

    public void setRMnewDistrMinClass(float v) throws Exception {
        this.setRMnewDistrMinClass(v, true);
    }

    public void setRMnewDistrMinClass(float v, boolean checkComb) throws Exception {
        if (v < -2.0f || v == 0.0f || v >= 100.0f) {
            throw new Exception("Distribution minority class has to be greater than zero and smaller than 100 (or -1 for 'sizeOfMinClass' or -2 for 'maxSize')!");
        }
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(this.m_RMreplacement, this.m_RMbagSizePercent, v);
        }
        this.m_RMnewDistrMinClass = v;
    }

    @Override
    public String reducedErrorPruningTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setReducedErrorPruning(boolean v) throws Exception {
        this.m_reducedErrorPruning = false;
        throw new Exception("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String numFoldsTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setNumFolds(int v) throws Exception {
        this.m_numFolds = 3;
        throw new Exception("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String binarySplitsTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setBinarySplits(boolean v) throws Exception {
        this.m_binarySplits = false;
        throw new Exception("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String seedTipText() {
        return "Seed for random data shuffling in the generation of samples";
    }

    public static void main(String[] argv) {
        J48Consolidated.runClassifier(new J48Consolidated(), argv);
    }
}

