/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class SimpleMI
extends SingleClassifierEnhancer
implements OptionHandler,
MultiInstanceCapabilitiesHandler {
    static final long serialVersionUID = 9137795893666592662L;
    public static final int TRANSFORMMETHOD_ARITHMETIC = 1;
    public static final int TRANSFORMMETHOD_GEOMETRIC = 2;
    public static final int TRANSFORMMETHOD_MINIMAX = 3;
    public static final Tag[] TAGS_TRANSFORMMETHOD = new Tag[]{new Tag(1, "arithmetic average"), new Tag(2, "geometric average"), new Tag(3, "using minimax combined features of a bag")};
    protected int m_TransformMethod = 1;

    public String globalInfo() {
        return "Reduces MI data into mono-instance data.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe method used in transformation:\n\t1.arithmatic average; 2.geometric centor;\n\t3.using minimax combined features of a bag (default: 1)\n\n\tMethod 3:\n\tDefine s to be the vector of the coordinate-wise maxima\n\tand minima of X, ie., \n\ts(X)=(minx1, ..., minxm, maxx1, ...,maxxm), transform\n\tthe exemplars into mono-instance which contains attributes\n\ts(X)", "M", 1, "-M [1|2|3]"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement((Option)enu.nextElement());
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String methodString = Utils.getOption('M', options);
        if (methodString.length() != 0) {
            this.setTransformMethod(new SelectedTag(Integer.parseInt(methodString), TAGS_TRANSFORMMETHOD));
        } else {
            this.setTransformMethod(new SelectedTag(1, TAGS_TRANSFORMMETHOD));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-M");
        result.add("" + this.m_TransformMethod);
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public String transformMethodTipText() {
        return "The method used in transformation.";
    }

    public void setTransformMethod(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_TRANSFORMMETHOD) {
            this.m_TransformMethod = newMethod.getSelectedTag().getID();
        }
    }

    public SelectedTag getTransformMethod() {
        return new SelectedTag(this.m_TransformMethod, TAGS_TRANSFORMMETHOD);
    }

    public Instances transform(Instances train) throws Exception {
        Attribute classAttribute = (Attribute)train.classAttribute().copy();
        Attribute bagLabel = train.attribute(0);
        Instances newData = train.attribute(1).relation().stringFreeStructure();
        newData.insertAttributeAt(bagLabel, 0);
        newData.insertAttributeAt(classAttribute, newData.numAttributes());
        newData.setClassIndex(newData.numAttributes() - 1);
        Instances mini_data = newData.stringFreeStructure();
        Instances max_data = newData.stringFreeStructure();
        Instance newInst = new Instance(newData.numAttributes());
        Instance mini_Inst = new Instance(mini_data.numAttributes());
        Instance max_Inst = new Instance(max_data.numAttributes());
        newInst.setDataset(newData);
        mini_Inst.setDataset(mini_data);
        max_Inst.setDataset(max_data);
        double N = train.numInstances();
        int i = 0;
        while ((double)i < N) {
            int attIdx = 1;
            Instance bag = train.instance(i);
            double labelValue = bag.value(0);
            if (this.m_TransformMethod != 3) {
                newInst.setValue(0, labelValue);
            } else {
                mini_Inst.setValue(0, labelValue);
                max_Inst.setValue(0, labelValue);
            }
            Instances data = bag.relationalValue(1);
            int j = 0;
            while (j < data.numAttributes()) {
                double[] minimax;
                double value;
                if (this.m_TransformMethod == 1) {
                    value = data.meanOrMode(j);
                    newInst.setValue(attIdx++, value);
                } else if (this.m_TransformMethod == 2) {
                    minimax = SimpleMI.minimax(data, j);
                    value = (minimax[0] + minimax[1]) / 2.0;
                    newInst.setValue(attIdx++, value);
                } else {
                    minimax = SimpleMI.minimax(data, j);
                    mini_Inst.setValue(attIdx, minimax[0]);
                    max_Inst.setValue(attIdx, minimax[1]);
                    ++attIdx;
                }
                ++j;
            }
            if (this.m_TransformMethod == 3) {
                if (!bag.classIsMissing()) {
                    max_Inst.setClassValue(bag.classValue());
                }
                mini_data.add(mini_Inst);
                max_data.add(max_Inst);
            } else {
                if (!bag.classIsMissing()) {
                    newInst.setClassValue(bag.classValue());
                }
                newData.add(newInst);
            }
            ++i;
        }
        if (this.m_TransformMethod == 3) {
            mini_data.setClassIndex(-1);
            mini_data.deleteAttributeAt(mini_data.numAttributes() - 1);
            max_data.deleteAttributeAt(0);
            newData = Instances.mergeInstances(mini_data, max_data);
            newData.setClassIndex(newData.numAttributes() - 1);
        }
        return newData;
    }

    public static double[] minimax(Instances data, int attIndex) {
        double[] rt = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int i = 0;
        while (i < data.numInstances()) {
            double val = data.instance(i).value(attIndex);
            if (val > rt[1]) {
                rt[1] = val;
            }
            if (val < rt[0]) {
                rt[0] = val;
            }
            ++i;
        }
        int j = 0;
        while (j < 2) {
            if (Double.isInfinite(rt[j])) {
                rt[j] = Double.NaN;
            }
            ++j;
        }
        return rt;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        if (super.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
        }
        if (super.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            result.enable(Capabilities.Capability.BINARY_CLASS);
        }
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (this.getDebug()) {
            System.out.println("Start training ...");
        }
        Instances data = this.transform(train);
        data.deleteAttributeAt(0);
        this.m_Classifier.buildClassifier(data);
        if (this.getDebug()) {
            System.out.println("Finish building model");
        }
    }

    @Override
    public double[] distributionForInstance(Instance newBag) throws Exception {
        double[] distribution = new double[2];
        Instances test = new Instances(newBag.dataset(), 0);
        test.add(newBag);
        test = this.transform(test);
        test.deleteAttributeAt(0);
        Instance newInst = test.firstInstance();
        distribution = this.m_Classifier.distributionForInstance(newInst);
        return distribution;
    }

    public String toString() {
        return "SimpleMI with base classifier: \n" + this.m_Classifier.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] argv) {
        SimpleMI.runClassifier(new SimpleMI(), argv);
    }
}

