/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.DoubleVector;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.PropositionalToMultiInstance;
import weka.filters.unsupervised.attribute.Standardize;

public class MIOptimalBall
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6465750129576777254L;
    protected double[] m_Center;
    protected double m_Radius;
    protected double[][][] m_Distance;
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected MultiInstanceToPropositional m_ConvertToSI = new MultiInstanceToPropositional();
    protected PropositionalToMultiInstance m_ConvertToMI = new PropositionalToMultiInstance();

    public String globalInfo() {
        return "This classifier tries to find a suitable ball in the multiple-instance space, with a certain data point in the instance space as a ball center. The possible ball center is a certain instance in a positive bag. The possible radiuses are those which can achieve the highest classification accuracy. The model selects the maximum radius as the radius of the optimal ball.\n\nFor more information about this algorithm, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Peter Auer and Ronald Ortner");
        result.setValue(TechnicalInformation.Field.TITLE, "A Boosting Approach to Multiple Instance Learning");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "15th European Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PAGES, "63-74");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.NOTE, "LNAI 3201");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        Instances train = new Instances(data);
        train.deleteWithMissingClass();
        int numAttributes = train.attribute(1).relation().numAttributes();
        this.m_Center = new double[numAttributes];
        if (this.getDebug()) {
            System.out.println("Start training ...");
        }
        this.m_ConvertToSI.setInputFormat(train);
        train = Filter.useFilter(train, this.m_ConvertToSI);
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(train);
            train = Filter.useFilter(train, this.m_Filter);
        }
        this.m_ConvertToMI.setInputFormat(train);
        train = Filter.useFilter(train, this.m_ConvertToMI);
        this.calculateDistance(train);
        this.findRadius(train);
        if (this.getDebug()) {
            System.out.println("Finish building optimal ball model");
        }
    }

    public void calculateDistance(Instances train) {
        int numBags = train.numInstances();
        this.m_Distance = new double[numBags][][];
        int i = 0;
        while (i < numBags) {
            if (train.instance(i).classValue() == 1.0) {
                int numInstances = train.instance(i).relationalValue(1).numInstances();
                this.m_Distance[i] = new double[numInstances][];
                int j = 0;
                while (j < numInstances) {
                    Instance tempCenter = train.instance(i).relationalValue(1).instance(j);
                    this.m_Distance[i][j] = new double[numBags];
                    int k = 0;
                    while (k < numBags) {
                        this.m_Distance[i][j][k] = i == k ? 0.0 : this.minBagDistance(tempCenter, train.instance(k));
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public double minBagDistance(Instance center, Instance bag) {
        double minDistance = Double.MAX_VALUE;
        Instances temp = bag.relationalValue(1);
        int i = 0;
        while (i < temp.numInstances()) {
            double distance = 0.0;
            int j = 0;
            while (j < center.numAttributes()) {
                distance += (center.value(j) - temp.instance(i).value(j)) * (center.value(j) - temp.instance(i).value(j));
                ++j;
            }
            if (minDistance > distance) {
                minDistance = distance;
            }
            ++i;
        }
        return Math.sqrt(minDistance);
    }

    public void findRadius(Instances train) {
        int highestCount = 0;
        int numBags = train.numInstances();
        int i = 0;
        while (i < numBags) {
            if (train.instance(i).classValue() == 1.0) {
                int numInstances = train.instance(i).relationalValue(1).numInstances();
                int j = 0;
                while (j < numInstances) {
                    Instance tempCenter = train.instance(i).relationalValue(1).instance(j);
                    double[] sortedDistance = this.sortArray(this.m_Distance[i][j]);
                    int k = 1;
                    while (k < sortedDistance.length) {
                        double radius = sortedDistance[k] - (sortedDistance[k] - sortedDistance[k - 1]) / 2.0;
                        int correctCount = 0;
                        int n = 0;
                        while (n < numBags) {
                            double bagDistance = this.m_Distance[i][j][n];
                            if (bagDistance <= radius && train.instance(n).classValue() == 1.0 || bagDistance > radius && train.instance(n).classValue() == 0.0) {
                                correctCount = (int)((double)correctCount + train.instance(n).weight());
                            }
                            ++n;
                        }
                        if (correctCount > highestCount || correctCount == highestCount && radius > this.m_Radius) {
                            highestCount = correctCount;
                            this.m_Radius = radius;
                            int p = 0;
                            while (p < tempCenter.numAttributes()) {
                                this.m_Center[p] = tempCenter.value(p);
                                ++p;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public double[] sortArray(double[] distance) {
        double[] sorted = new double[distance.length];
        double[] disCopy = new double[distance.length];
        int i = 0;
        while (i < distance.length) {
            disCopy[i] = distance[i];
            ++i;
        }
        DoubleVector sortVector = new DoubleVector(disCopy);
        sortVector.sort();
        sorted = sortVector.getArrayCopy();
        return sorted;
    }

    @Override
    public double[] distributionForInstance(Instance newBag) throws Exception {
        double[] distribution = new double[]{0.0, 0.0};
        Instances insts = new Instances(newBag.dataset(), 0);
        insts.add(newBag);
        insts = Filter.useFilter(insts, this.m_ConvertToSI);
        if (this.m_Filter != null) {
            insts = Filter.useFilter(insts, this.m_Filter);
        }
        int numInsts = insts.numInstances();
        insts.deleteAttributeAt(0);
        int i = 0;
        while (i < numInsts) {
            double distance = 0.0;
            int j = 0;
            while (j < insts.numAttributes() - 1) {
                distance += (insts.instance(i).value(j) - this.m_Center[j]) * (insts.instance(i).value(j) - this.m_Center[j]);
                ++j;
            }
            if (distance <= this.m_Radius * this.m_Radius) {
                distribution[1] = 1.0;
                break;
            }
            ++i;
        }
        distribution[0] = 1.0 - distribution[1];
        return distribution;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. \n\t(default 0=normalize)", "N", 1, "-N <num>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        result.add("-N");
        result.add("" + this.m_filterType);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String nString = Utils.getOption('N', options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5527 $");
    }

    public static void main(String[] argv) {
        MIOptimalBall.runClassifier(new MIOptimalBall(), argv);
    }
}

