/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Optimization;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class MIDD
extends Classifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4263507733600536168L;
    protected int m_ClassIndex;
    protected double[] m_Par;
    protected int m_NumClasses;
    protected int[] m_Classes;
    protected double[][][] m_Data;
    protected Instances m_Attributes;
    protected Filter m_Filter = null;
    protected int m_filterType = 1;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected ReplaceMissingValues m_Missing = new ReplaceMissingValues();

    public String globalInfo() {
        return "Re-implement the Diverse Density algorithm, changes the testing procedure.\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Oded Maron");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Learning from ambiguity");
        result.setValue(TechnicalInformation.Field.SCHOOL, "Massachusetts Institute of Technology");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "O. Maron and T. Lozano-Perez");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "A Framework for Multiple Instance Learning");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Information Processing Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "10");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 1=standardize)", "N", 1, "-N <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String nString = Utils.getOption('N', options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(1, TAGS_FILTER));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        result.add("-N");
        result.add("" + this.m_filterType);
        return result.toArray(new String[result.size()]);
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        int i;
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_ClassIndex = train.classIndex();
        this.m_NumClasses = train.numClasses();
        int nR = train.attribute(1).relation().numAttributes();
        int nC = train.numInstances();
        FastVector maxSzIdx = new FastVector();
        int maxSz = 0;
        int[] bagSize = new int[nC];
        Instances datasets = new Instances(train.attribute(1).relation(), 0);
        this.m_Data = new double[nC][nR][];
        this.m_Classes = new int[nC];
        this.m_Attributes = datasets.stringFreeStructure();
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        int h = 0;
        while (h < nC) {
            int nI;
            Instance current = train.instance(h);
            this.m_Classes[h] = (int)current.classValue();
            Instances currInsts = current.relationalValue(1);
            i = 0;
            while (i < currInsts.numInstances()) {
                Instance inst = currInsts.instance(i);
                datasets.add(inst);
                ++i;
            }
            bagSize[h] = nI = currInsts.numInstances();
            if (this.m_Classes[h] == 1) {
                if (nI > maxSz) {
                    maxSz = nI;
                    maxSzIdx = new FastVector(1);
                    maxSzIdx.addElement(new Integer(h));
                } else if (nI == maxSz) {
                    maxSzIdx.addElement(new Integer(h));
                }
            }
            ++h;
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(datasets);
            datasets = Filter.useFilter(datasets, this.m_Filter);
        }
        this.m_Missing.setInputFormat(datasets);
        datasets = Filter.useFilter(datasets, this.m_Missing);
        int instIndex = 0;
        int start = 0;
        int h2 = 0;
        while (h2 < nC) {
            i = 0;
            while (i < datasets.numAttributes()) {
                this.m_Data[h2][i] = new double[bagSize[h2]];
                instIndex = start;
                int k = 0;
                while (k < bagSize[h2]) {
                    this.m_Data[h2][i][k] = datasets.instance(instIndex).value(i);
                    ++instIndex;
                    ++k;
                }
                ++i;
            }
            start = instIndex;
            ++h2;
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[nR * 2];
        double[] tmp = new double[x.length];
        double[][] b = new double[2][x.length];
        double bestnll = Double.MAX_VALUE;
        int t = 0;
        while (t < x.length) {
            b[0][t] = Double.NaN;
            b[1][t] = Double.NaN;
            ++t;
        }
        int s = 0;
        while (s < maxSzIdx.size()) {
            int exIdx = (Integer)maxSzIdx.elementAt(s);
            int p = 0;
            while (p < this.m_Data[exIdx][0].length) {
                int q = 0;
                while (q < nR) {
                    x[2 * q] = this.m_Data[exIdx][q][p];
                    x[2 * q + 1] = 1.0;
                    ++q;
                }
                OptEng opt = new OptEng();
                tmp = opt.findArgmin(x, b);
                while (tmp == null) {
                    tmp = opt.getVarbValues();
                    if (this.m_Debug) {
                        System.out.println("200 iterations finished, not enough!");
                    }
                    tmp = opt.findArgmin(tmp, b);
                }
                double nll = opt.getMinFunction();
                if (nll < bestnll) {
                    bestnll = nll;
                    this.m_Par = tmp;
                    tmp = new double[x.length];
                    if (this.m_Debug) {
                        System.out.println("!!!!!!!!!!!!!!!!Smaller NLL found: " + nll);
                    }
                }
                if (this.m_Debug) {
                    System.out.println(String.valueOf(exIdx) + ":  -------------<Converged>--------------");
                }
                ++p;
            }
            ++s;
        }
    }

    @Override
    public double[] distributionForInstance(Instance exmp) throws Exception {
        Instances ins = exmp.relationalValue(1);
        if (this.m_Filter != null) {
            ins = Filter.useFilter(ins, this.m_Filter);
        }
        ins = Filter.useFilter(ins, this.m_Missing);
        int nI = ins.numInstances();
        int nA = ins.numAttributes();
        double[][] dat = new double[nI][nA];
        int j = 0;
        while (j < nI) {
            int k = 0;
            while (k < nA) {
                dat[j][k] = ins.instance(j).value(k);
                ++k;
            }
            ++j;
        }
        double[] distribution = new double[2];
        distribution[0] = 0.0;
        int i = 0;
        while (i < nI) {
            double exp = 0.0;
            int r = 0;
            while (r < nA) {
                exp += (this.m_Par[r * 2] - dat[i][r]) * (this.m_Par[r * 2] - dat[i][r]) * this.m_Par[r * 2 + 1] * this.m_Par[r * 2 + 1];
                ++r;
            }
            exp = Math.exp(-exp);
            distribution[0] = distribution[0] + Math.log(1.0 - exp);
            ++i;
        }
        distribution[0] = Math.exp(distribution[0]);
        distribution[1] = 1.0 - distribution[0];
        return distribution;
    }

    public String toString() {
        String result = "Diverse Density";
        if (this.m_Par == null) {
            return String.valueOf(result) + ": No model built yet.";
        }
        result = String.valueOf(result) + "\nCoefficients...\nVariable       Point       Scale\n";
        int j = 0;
        int idx = 0;
        while (j < this.m_Par.length / 2) {
            result = String.valueOf(result) + this.m_Attributes.attribute(idx).name();
            result = String.valueOf(result) + " " + Utils.doubleToString(this.m_Par[j * 2], 12, 4);
            result = String.valueOf(result) + " " + Utils.doubleToString(this.m_Par[j * 2 + 1], 12, 4) + "\n";
            ++j;
            ++idx;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5527 $");
    }

    public static void main(String[] argv) {
        MIDD.runClassifier(new MIDD(), argv);
    }

    private class OptEng
    extends Optimization {
        private OptEng() {
        }

        @Override
        protected double objectiveFunction(double[] x) {
            double nll = 0.0;
            int i = 0;
            while (i < MIDD.this.m_Classes.length) {
                int nI = MIDD.this.m_Data[i][0].length;
                double bag = 0.0;
                int j = 0;
                while (j < nI) {
                    double ins = 0.0;
                    int k = 0;
                    while (k < MIDD.this.m_Data[i].length) {
                        ins += (MIDD.this.m_Data[i][k][j] - x[k * 2]) * (MIDD.this.m_Data[i][k][j] - x[k * 2]) * x[k * 2 + 1] * x[k * 2 + 1];
                        ++k;
                    }
                    ins = Math.exp(-ins);
                    ins = 1.0 - ins;
                    if (MIDD.this.m_Classes[i] == 1) {
                        bag += Math.log(ins);
                    } else {
                        if (ins <= m_Zero) {
                            ins = m_Zero;
                        }
                        nll -= Math.log(ins);
                    }
                    ++j;
                }
                if (MIDD.this.m_Classes[i] == 1) {
                    if ((bag = 1.0 - Math.exp(bag)) <= m_Zero) {
                        bag = m_Zero;
                    }
                    nll -= Math.log(bag);
                }
                ++i;
            }
            return nll;
        }

        @Override
        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            int i = 0;
            while (i < MIDD.this.m_Classes.length) {
                int nI = MIDD.this.m_Data[i][0].length;
                double denom = 0.0;
                double[] numrt = new double[x.length];
                int j = 0;
                while (j < nI) {
                    double exp = 0.0;
                    int k = 0;
                    while (k < MIDD.this.m_Data[i].length) {
                        exp += (MIDD.this.m_Data[i][k][j] - x[k * 2]) * (MIDD.this.m_Data[i][k][j] - x[k * 2]) * x[k * 2 + 1] * x[k * 2 + 1];
                        ++k;
                    }
                    exp = Math.exp(-exp);
                    exp = 1.0 - exp;
                    if (MIDD.this.m_Classes[i] == 1) {
                        denom += Math.log(exp);
                    }
                    if (exp <= m_Zero) {
                        exp = m_Zero;
                    }
                    int p = 0;
                    while (p < MIDD.this.m_Data[i].length) {
                        int n = 2 * p;
                        numrt[n] = numrt[n] + (1.0 - exp) * 2.0 * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * x[p * 2 + 1] * x[p * 2 + 1] / exp;
                        int n2 = 2 * p + 1;
                        numrt[n2] = numrt[n2] + 2.0 * (1.0 - exp) * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * x[p * 2 + 1] / exp;
                        ++p;
                    }
                    ++j;
                }
                if ((denom = 1.0 - Math.exp(denom)) <= m_Zero) {
                    denom = m_Zero;
                }
                int q = 0;
                while (q < MIDD.this.m_Data[i].length) {
                    if (MIDD.this.m_Classes[i] == 1) {
                        int n = 2 * q;
                        grad[n] = grad[n] + numrt[2 * q] * (1.0 - denom) / denom;
                        int n3 = 2 * q + 1;
                        grad[n3] = grad[n3] + numrt[2 * q + 1] * (1.0 - denom) / denom;
                    } else {
                        int n = 2 * q;
                        grad[n] = grad[n] - numrt[2 * q];
                        int n4 = 2 * q + 1;
                        grad[n4] = grad[n4] - numrt[2 * q + 1];
                    }
                    ++q;
                }
                ++i;
            }
            return grad;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5527 $");
        }
    }
}

