/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CitationKNN
extends Classifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8435377743874094852L;
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected int m_IdIndex;
    protected boolean m_Debug;
    protected int[] m_Classes;
    protected Instances m_Attributes;
    protected int m_NumReferences = 1;
    protected int m_NumCiters = 1;
    protected Instances m_TrainBags;
    protected boolean m_CNNDebug = false;
    protected boolean m_CitersDebug = false;
    protected boolean m_ReferencesDebug = false;
    protected boolean m_HDistanceDebug = false;
    protected boolean m_NeighborListDebug = false;
    protected NeighborList[] m_CNN;
    protected int[] m_Citers;
    protected int[] m_References;
    protected int m_HDRank = 1;
    private double[] m_Diffs;
    private double[] m_Min;
    private double m_MinNorm = 0.95;
    private double[] m_Max;
    private double m_MaxNorm = 1.05;

    public String globalInfo() {
        return "Modified version of the Citation kNN multi instance classifier.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jun Wang and Zucker and Jean-Daniel");
        result.setValue(TechnicalInformation.Field.TITLE, "Solving Multiple-Instance Problem: A Lazy Learning Approach");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "17th International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "Pat Langley");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.PAGES, "1119-1125");
        return result;
    }

    public void preprocessData() {
        int i = 0;
        while (i < this.m_Attributes.numAttributes()) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int j = 0;
            while (j < this.m_TrainBags.numInstances()) {
                Instances instances = this.m_TrainBags.instance(j).relationalValue(1);
                int k = 0;
                while (k < instances.numInstances()) {
                    Instance instance = instances.instance(k);
                    if (instance.value(i) < min) {
                        min = instance.value(i);
                    }
                    if (instance.value(i) > max) {
                        max = instance.value(i);
                    }
                    ++k;
                }
                ++j;
            }
            this.m_Min[i] = min * this.m_MinNorm;
            this.m_Max[i] = max * this.m_MaxNorm;
            this.m_Diffs[i] = max * this.m_MaxNorm - min * this.m_MinNorm;
            ++i;
        }
    }

    public String HDRankTipText() {
        return "The rank associated to the Hausdorff distance.";
    }

    public void setHDRank(int hDRank) {
        this.m_HDRank = hDRank;
    }

    public int getHDRank() {
        return this.m_HDRank;
    }

    public String numReferencesTipText() {
        return "The number of references considered to estimate the class prediction of tests bags.";
    }

    public void setNumReferences(int numReferences) {
        this.m_NumReferences = numReferences;
    }

    public int getNumReferences() {
        return this.m_NumReferences;
    }

    public String numCitersTipText() {
        return "The number of citers considered to estimate the class prediction of test bags.";
    }

    public void setNumCiters(int numCiters) {
        this.m_NumCiters = numCiters;
    }

    public int getNumCiters() {
        return this.m_NumCiters;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_TrainBags = train;
        this.m_ClassIndex = train.classIndex();
        this.m_IdIndex = 0;
        this.m_NumClasses = train.numClasses();
        this.m_Classes = new int[train.numInstances()];
        this.m_Attributes = train.instance(0).relationalValue(1).stringFreeStructure();
        this.m_Citers = new int[train.numClasses()];
        this.m_References = new int[train.numClasses()];
        this.m_Diffs = new double[this.m_Attributes.numAttributes()];
        this.m_Min = new double[this.m_Attributes.numAttributes()];
        this.m_Max = new double[this.m_Attributes.numAttributes()];
        this.preprocessData();
        this.buildCNN();
        if (this.m_CNNDebug) {
            System.out.println("########################################### ");
            System.out.println("###########CITATION######################## ");
            System.out.println("########################################### ");
            int i = 0;
            while (i < this.m_CNN.length) {
                System.out.println("Bag: " + i);
                this.m_CNN[i].printReducedList();
                ++i;
            }
        }
    }

    public void buildCNN() throws Exception {
        int numCiters = 0;
        if (this.m_NumCiters >= this.m_TrainBags.numInstances() || this.m_NumCiters < 0) {
            throw new Exception("Number of citers is out of the range [0, numInstances)");
        }
        numCiters = this.m_NumCiters;
        this.m_CNN = new NeighborList[this.m_TrainBags.numInstances()];
        int i = 0;
        while (i < this.m_TrainBags.numInstances()) {
            NeighborList neighborList;
            Instance bag = this.m_TrainBags.instance(i);
            this.m_CNN[i] = neighborList = this.findNeighbors(bag, numCiters, this.m_TrainBags);
            ++i;
        }
    }

    public void countBagCiters(Instance bag) {
        int i = 0;
        while (i < this.m_TrainBags.numClasses()) {
            this.m_Citers[i] = 0;
            ++i;
        }
        if (this.m_CitersDebug) {
            System.out.println("-------CITERS--------");
        }
        boolean stopSearch = false;
        double bagDistance = 0.0;
        int i2 = 0;
        while (i2 < this.m_TrainBags.numInstances()) {
            bagDistance = this.distanceSet(bag, this.m_TrainBags.instance(i2));
            if (this.m_CitersDebug) {
                System.out.print("bag - bag(" + i2 + "): " + bagDistance);
                System.out.println("   <" + this.m_TrainBags.instance(i2).classValue() + ">");
            }
            NeighborList neighborList = this.m_CNN[i2];
            NeighborNode current = neighborList.mFirst;
            while (current != null && !stopSearch) {
                if (this.m_CitersDebug) {
                    System.out.println("\t\tciter Distance: " + current.mDistance);
                }
                if (current.mDistance < bagDistance) {
                    current = current.mNext;
                    continue;
                }
                stopSearch = true;
                if (!this.m_CitersDebug) continue;
                System.out.println("\t***");
            }
            if (stopSearch) {
                int index;
                stopSearch = false;
                int n = index = (int)this.m_TrainBags.instance(i2).classValue();
                this.m_Citers[n] = this.m_Citers[n] + 1;
            }
            ++i2;
        }
        if (this.m_CitersDebug) {
            i2 = 0;
            while (i2 < this.m_Citers.length) {
                System.out.println("[" + i2 + "]: " + this.m_Citers[i2]);
                ++i2;
            }
        }
    }

    public void countBagReferences(Instance bag) {
        int index = 0;
        int referencesIndex = 0;
        referencesIndex = this.m_TrainBags.numInstances() < this.m_NumReferences ? this.m_TrainBags.numInstances() - 1 : this.m_NumReferences;
        if (this.m_CitersDebug) {
            System.out.println("-------References (" + referencesIndex + ")--------");
        }
        int i = 0;
        while (i < this.m_References.length) {
            this.m_References[i] = 0;
            ++i;
        }
        if (referencesIndex > 0) {
            NeighborList neighborList = this.findNeighbors(bag, referencesIndex, this.m_TrainBags);
            if (this.m_ReferencesDebug) {
                System.out.println("Bag: " + bag + " Neighbors: ");
                neighborList.printReducedList();
            }
            NeighborNode current = neighborList.mFirst;
            while (current != null) {
                int n = index = (int)current.mBag.classValue();
                this.m_References[n] = this.m_References[n] + 1;
                current = current.mNext;
            }
        }
        if (this.m_ReferencesDebug) {
            System.out.println("References:");
            int j = 0;
            while (j < this.m_References.length) {
                System.out.println("[" + j + "]: " + this.m_References[j]);
                ++j;
            }
        }
    }

    protected NeighborList findNeighbors(Instance bag, int kNN, Instances bags) {
        int index = 0;
        if (kNN > bags.numInstances()) {
            kNN = bags.numInstances() - 1;
        }
        NeighborList neighborList = new NeighborList(kNN);
        int i = 0;
        while (i < bags.numInstances()) {
            if (bag != bags.instance(i)) {
                double distance = this.distanceSet(bag, bags.instance(i));
                if (this.m_NeighborListDebug) {
                    System.out.println("distance(bag, " + i + "): " + distance);
                }
                if (neighborList.isEmpty() || index < kNN || distance <= neighborList.mLast.mDistance) {
                    neighborList.insertSorted(distance, bags.instance(i), i);
                }
                ++index;
            }
            ++i;
        }
        if (this.m_NeighborListDebug) {
            System.out.println("bag neighbors:");
            neighborList.printReducedList();
        }
        return neighborList;
    }

    public double distanceSet(Instance first, Instance second) {
        int i;
        double[] h_f = new double[first.relationalValue(1).numInstances()];
        int i2 = 0;
        while (i2 < h_f.length) {
            h_f[i2] = Double.MAX_VALUE;
            ++i2;
        }
        int rank = this.m_HDRank >= first.relationalValue(1).numInstances() ? first.relationalValue(1).numInstances() : (this.m_HDRank < 1 ? 1 : this.m_HDRank);
        if (this.m_HDistanceDebug) {
            System.out.println("-------HAUSDORFF DISTANCE--------");
            System.out.println("rank: " + rank + "\nset of instances:");
            System.out.println("\tset 1:");
            i = 0;
            while (i < first.relationalValue(1).numInstances()) {
                System.out.println(first.relationalValue(1).instance(i));
                ++i;
            }
            System.out.println("\n\tset 2:");
            i = 0;
            while (i < second.relationalValue(1).numInstances()) {
                System.out.println(second.relationalValue(1).instance(i));
                ++i;
            }
            System.out.println("\n");
        }
        i = 0;
        while (i < first.relationalValue(1).numInstances()) {
            if (this.m_HDistanceDebug) {
                System.out.println("\nDistances:");
            }
            int j = 0;
            while (j < second.relationalValue(1).numInstances()) {
                double distance = this.distance(first.relationalValue(1).instance(i), second.relationalValue(1).instance(j));
                if (distance < h_f[i]) {
                    h_f[i] = distance;
                }
                if (this.m_HDistanceDebug) {
                    System.out.println("\tdist(" + i + ", " + j + "): " + distance + "  --> h_f[" + i + "]: " + h_f[i]);
                }
                ++j;
            }
            ++i;
        }
        int[] index_f = Utils.stableSort(h_f);
        if (this.m_HDistanceDebug) {
            System.out.println("\nRanks:\n");
            int i3 = 0;
            while (i3 < index_f.length) {
                System.out.println("\trank " + (i3 + 1) + ": " + h_f[index_f[i3]]);
                ++i3;
            }
            System.out.println("\n\t\t>>>>> rank " + rank + ": " + h_f[index_f[rank - 1]] + " <<<<<");
        }
        return h_f[index_f[rank - 1]];
    }

    public double distance(Instance first, Instance second) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_Attributes.numAttributes()) {
            double diff = (first.value(i) - this.m_Min[i]) / this.m_Diffs[i] - (second.value(i) - this.m_Min[i]) / this.m_Diffs[i];
            sum += diff * diff;
            ++i;
        }
        sum = Math.sqrt(sum);
        return sum;
    }

    @Override
    public double[] distributionForInstance(Instance bag) throws Exception {
        if (this.m_TrainBags.numInstances() == 0) {
            throw new Exception("No training bags!");
        }
        this.updateNormalization(bag);
        this.countBagReferences(bag);
        this.countBagCiters(bag);
        return this.makeDistribution();
    }

    public void updateNormalization(Instance bag) {
        int i = 0;
        while (i < this.m_TrainBags.attribute(1).relation().numAttributes()) {
            double min = this.m_Min[i] / this.m_MinNorm;
            double max = this.m_Max[i] / this.m_MaxNorm;
            Instances instances = bag.relationalValue(1);
            int k = 0;
            while (k < instances.numInstances()) {
                Instance instance = instances.instance(k);
                if (instance.value(i) < min) {
                    min = instance.value(i);
                }
                if (instance.value(i) > max) {
                    max = instance.value(i);
                }
                ++k;
            }
            this.m_Min[i] = min * this.m_MinNorm;
            this.m_Max[i] = max * this.m_MaxNorm;
            this.m_Diffs[i] = max * this.m_MaxNorm - min * this.m_MinNorm;
            ++i;
        }
    }

    public boolean equalExemplars(Instance exemplar1, Instance exemplar2) {
        if (exemplar1.relationalValue(1).numInstances() == exemplar2.relationalValue(1).numInstances()) {
            Instances instances1 = exemplar1.relationalValue(1);
            Instances instances2 = exemplar2.relationalValue(1);
            int i = 0;
            while (i < instances1.numInstances()) {
                Instance instance1 = instances1.instance(i);
                Instance instance2 = instances2.instance(i);
                int j = 0;
                while (j < instance1.numAttributes()) {
                    if (instance1.value(j) != instance2.value(j)) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected double[] makeDistribution() throws Exception {
        double total = 0.0;
        double[] distribution = new double[this.m_TrainBags.numClasses()];
        boolean debug = false;
        total = (double)this.m_TrainBags.numClasses() / (double)Math.max(1, this.m_TrainBags.numInstances());
        int i = 0;
        while (i < this.m_TrainBags.numClasses()) {
            distribution[i] = 1.0 / (double)Math.max(1, this.m_TrainBags.numInstances());
            if (debug) {
                System.out.println("distribution[" + i + "]: " + distribution[i]);
            }
            ++i;
        }
        if (debug) {
            System.out.println("total: " + total);
        }
        i = 0;
        while (i < this.m_TrainBags.numClasses()) {
            int n = i;
            distribution[n] = distribution[n] + (double)this.m_References[i];
            int n2 = i;
            distribution[n2] = distribution[n2] + (double)this.m_Citers[i];
            ++i;
        }
        total = 0.0;
        i = 0;
        while (i < this.m_TrainBags.numClasses()) {
            total += distribution[i];
            if (debug) {
                System.out.println("distribution[" + i + "]: " + distribution[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.m_TrainBags.numClasses()) {
            distribution[i] = distribution[i] / total;
            if (debug) {
                System.out.println("distribution[" + i + "]: " + distribution[i]);
            }
            ++i;
        }
        return distribution;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tNumber of Nearest References (default 1)", "R", 0, "-R <number of references>"));
        result.addElement(new Option("\tNumber of Nearest Citers (default 1)", "C", 0, "-C <number of citers>"));
        result.addElement(new Option("\tRank of the Hausdorff Distance (default 1)", "H", 0, "-H <rank>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String option = Utils.getOption('R', options);
        if (option.length() != 0) {
            this.setNumReferences(Integer.parseInt(option));
        } else {
            this.setNumReferences(1);
        }
        option = Utils.getOption('C', options);
        if (option.length() != 0) {
            this.setNumCiters(Integer.parseInt(option));
        } else {
            this.setNumCiters(1);
        }
        option = Utils.getOption('H', options);
        if (option.length() != 0) {
            this.setHDRank(Integer.parseInt(option));
        } else {
            this.setHDRank(1);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        result.add("-R");
        result.add("" + this.getNumReferences());
        result.add("-C");
        result.add("" + this.getNumCiters());
        result.add("-H");
        result.add("" + this.getHDRank());
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "")) + "\n");
        result.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=")) + "\n\n");
        if (this.m_Citers == null) {
            result.append("no model built yet!\n");
        } else {
            result.append("Citers....: " + Utils.arrayToString(this.m_Citers) + "\n");
            result.append("References: " + Utils.arrayToString(this.m_References) + "\n");
            result.append("Min.......: ");
            int i = 0;
            while (i < this.m_Min.length) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(Utils.doubleToString(this.m_Min[i], 3));
                ++i;
            }
            result.append("\n");
            result.append("Max.......: ");
            i = 0;
            while (i < this.m_Max.length) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(Utils.doubleToString(this.m_Max[i], 3));
                ++i;
            }
            result.append("\n");
            result.append("Diffs.....: ");
            i = 0;
            while (i < this.m_Diffs.length) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(Utils.doubleToString(this.m_Diffs[i], 3));
                ++i;
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5527 $");
    }

    public static void main(String[] argv) {
        CitationKNN.runClassifier(new CitationKNN(), argv);
    }

    private class NeighborList
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 3432555644456217394L;
        private NeighborNode mFirst;
        private NeighborNode mLast;
        private int mLength = 1;

        public NeighborList(int length) {
            this.mLength = length;
        }

        public boolean isEmpty() {
            return this.mFirst == null;
        }

        public int currentLength() {
            int i = 0;
            NeighborNode current = this.mFirst;
            while (current != null) {
                ++i;
                current = current.mNext;
            }
            return i;
        }

        /*
         * Unable to fully structure code
         */
        public void insertSorted(double distance, Instance bag, int position) {
            block5: {
                block6: {
                    block4: {
                        if (!this.isEmpty()) break block4;
                        this.mFirst = this.mLast = new NeighborNode(distance, bag, position);
                        break block5;
                    }
                    current = this.mFirst;
                    if (!(distance < NeighborNode.access$1(this.mFirst))) ** GOTO lbl10
                    this.mFirst = new NeighborNode(distance, bag, position, this.mFirst);
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        current = NeighborNode.access$0(current);
lbl10:
                        // 2 sources

                        ** while (NeighborNode.access$0((NeighborNode)current) != null && NeighborNode.access$1((NeighborNode)NeighborNode.access$0((NeighborNode)current)) < distance)
                    }
lbl11:
                    // 1 sources

                    NeighborNode.access$2(current, new NeighborNode(distance, bag, position, NeighborNode.access$0(current)));
                    if (current.equals(this.mLast)) {
                        this.mLast = NeighborNode.access$0(current);
                    }
                }
                valcount = 0;
                current = this.mFirst;
                while (NeighborNode.access$0(current) != null) {
                    if (++valcount >= this.mLength && NeighborNode.access$1(current) != NeighborNode.access$1(NeighborNode.access$0(current))) {
                        this.mLast = current;
                        NeighborNode.access$2(current, null);
                        break;
                    }
                    current = NeighborNode.access$0(current);
                }
            }
        }

        public void pruneToK(int k) {
            if (this.isEmpty()) {
                return;
            }
            if (k < 1) {
                k = 1;
            }
            int currentK = 0;
            double currentDist = this.mFirst.mDistance;
            NeighborNode current = this.mFirst;
            while (current.mNext != null) {
                currentDist = current.mDistance;
                if (++currentK >= k && currentDist != current.mNext.mDistance) {
                    this.mLast = current;
                    current.mNext = null;
                    break;
                }
                current = current.mNext;
            }
        }

        public void printList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode current = this.mFirst;
                while (current != null) {
                    System.out.print("Node: instance " + current.mBagPosition + "\n");
                    System.out.println(current.mBag);
                    System.out.println(", distance " + current.mDistance);
                    current = current.mNext;
                }
                System.out.println();
            }
        }

        public void printReducedList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode current = this.mFirst;
                while (current != null) {
                    System.out.print("Node: bag " + current.mBagPosition + "  (" + current.mBag.relationalValue(1).numInstances() + "): ");
                    System.out.print("   <" + current.mBag.classValue() + ">");
                    System.out.println("  (d: " + current.mDistance + ")");
                    current = current.mNext;
                }
                System.out.println();
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5527 $");
        }
    }

    private class NeighborNode
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -3947320761906511289L;
        private Instance mBag;
        private double mDistance;
        private NeighborNode mNext;
        private int mBagPosition;

        public NeighborNode(double distance, Instance bag, int position, NeighborNode next) {
            this.mDistance = distance;
            this.mBag = bag;
            this.mNext = next;
            this.mBagPosition = position;
        }

        public NeighborNode(double distance, Instance bag, int position) {
            this(distance, bag, position, null);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5527 $");
        }
    }
}

