/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Vote
extends RandomizableMultipleClassifiersCombiner
implements TechnicalInformationHandler {
    static final long serialVersionUID = -637891196294399624L;
    public static final int AVERAGE_RULE = 1;
    public static final int PRODUCT_RULE = 2;
    public static final int MAJORITY_VOTING_RULE = 3;
    public static final int MIN_RULE = 4;
    public static final int MAX_RULE = 5;
    public static final int MEDIAN_RULE = 6;
    public static final Tag[] TAGS_RULES = new Tag[]{new Tag(1, "AVG", "Average of Probabilities"), new Tag(2, "PROD", "Product of Probabilities"), new Tag(3, "MAJ", "Majority Voting"), new Tag(4, "MIN", "Minimum Probability"), new Tag(5, "MAX", "Maximum Probability"), new Tag(6, "MED", "Median")};
    protected int m_CombinationRule = 1;
    protected Random m_Random;

    public String globalInfo() {
        return "Class for combining classifiers. Different combinations of probability estimates for classification are available.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "R", 1, "-R " + Tag.toOptionList(TAGS_RULES)));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-R");
        result.add("" + this.getCombinationRule());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setCombinationRule(new SelectedTag(tmpStr, TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, TAGS_RULES));
        }
        super.setOptions(options);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ludmila I. Kuncheva");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining Pattern Classifiers: Methods and Algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons, Inc.");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "J. Kittler and M. Hatef and Robert P.W. Duin and J. Matas");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "On combining classifiers");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        additional.setValue(TechnicalInformation.Field.VOLUME, "20");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "226-239");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        if (this.m_CombinationRule == 2 || this.m_CombinationRule == 3) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        } else if (this.m_CombinationRule == 6) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        }
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        this.m_Random = new Random(this.getSeed());
        int i = 0;
        while (i < this.m_Classifiers.length) {
            this.getClassifier(i).buildClassifier(newData);
            ++i;
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double result;
        switch (this.m_CombinationRule) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                double[] dist = this.distributionForInstance(instance);
                if (instance.classAttribute().isNominal()) {
                    int index = Utils.maxIndex(dist);
                    if (dist[index] == 0.0) {
                        result = Instance.missingValue();
                        break;
                    }
                    result = index;
                    break;
                }
                if (instance.classAttribute().isNumeric()) {
                    result = dist[0];
                    break;
                }
                result = Instance.missingValue();
                break;
            }
            case 6: {
                result = this.classifyInstanceMedian(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        return result;
    }

    protected double classifyInstanceMedian(Instance instance) throws Exception {
        double[] results = new double[this.m_Classifiers.length];
        int i = 0;
        while (i < results.length) {
            results[i] = this.m_Classifiers[i].classifyInstance(instance);
            ++i;
        }
        double result = results.length == 0 ? 0.0 : (results.length == 1 ? results[0] : Utils.kthSmallestValue(results, results.length / 2));
        return result;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = new double[instance.numClasses()];
        switch (this.m_CombinationRule) {
            case 1: {
                result = this.distributionForInstanceAverage(instance);
                break;
            }
            case 2: {
                result = this.distributionForInstanceProduct(instance);
                break;
            }
            case 3: {
                result = this.distributionForInstanceMajorityVoting(instance);
                break;
            }
            case 4: {
                result = this.distributionForInstanceMin(instance);
                break;
            }
            case 5: {
                result = this.distributionForInstanceMax(instance);
                break;
            }
            case 6: {
                result[0] = this.classifyInstance(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        if (!instance.classAttribute().isNumeric() && Utils.sum(result) > 0.0) {
            Utils.normalize(result);
        }
        return result;
    }

    protected double[] distributionForInstanceAverage(Instance instance) throws Exception {
        double[] probs = this.getClassifier(0).distributionForInstance(instance);
        probs = (double[])probs.clone();
        int i = 1;
        while (i < this.m_Classifiers.length) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            int j = 0;
            while (j < dist.length) {
                int n = j;
                probs[n] = probs[n] + dist[j];
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < probs.length) {
            int n = j++;
            probs[n] = probs[n] / (double)this.m_Classifiers.length;
        }
        return probs;
    }

    protected double[] distributionForInstanceProduct(Instance instance) throws Exception {
        double[] probs = this.getClassifier(0).distributionForInstance(instance);
        probs = (double[])probs.clone();
        int i = 1;
        while (i < this.m_Classifiers.length) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            int j = 0;
            while (j < dist.length) {
                int n = j;
                probs[n] = probs[n] * dist[j];
                ++j;
            }
            ++i;
        }
        return probs;
    }

    protected double[] distributionForInstanceMajorityVoting(Instance instance) throws Exception {
        double[] probs = new double[instance.classAttribute().numValues()];
        double[] votes = new double[probs.length];
        int i = 0;
        while (i < this.m_Classifiers.length) {
            probs = this.getClassifier(i).distributionForInstance(instance);
            int maxIndex = 0;
            int j = 0;
            while (j < probs.length) {
                if (probs[j] > probs[maxIndex]) {
                    maxIndex = j;
                }
                ++j;
            }
            j = 0;
            while (j < probs.length) {
                if (probs[j] == probs[maxIndex]) {
                    int n = j;
                    votes[n] = votes[n] + 1.0;
                }
                ++j;
            }
            ++i;
        }
        int tmpMajorityIndex = 0;
        int k = 1;
        while (k < votes.length) {
            if (votes[k] > votes[tmpMajorityIndex]) {
                tmpMajorityIndex = k;
            }
            ++k;
        }
        Vector<Integer> majorityIndexes = new Vector<Integer>();
        int k2 = 0;
        while (k2 < votes.length) {
            if (votes[k2] == votes[tmpMajorityIndex]) {
                majorityIndexes.add(k2);
            }
            ++k2;
        }
        int majorityIndex = (Integer)majorityIndexes.get(this.m_Random.nextInt(majorityIndexes.size()));
        probs = new double[probs.length];
        probs[majorityIndex] = 1.0;
        return probs;
    }

    protected double[] distributionForInstanceMax(Instance instance) throws Exception {
        double[] max = this.getClassifier(0).distributionForInstance(instance);
        max = (double[])max.clone();
        int i = 1;
        while (i < this.m_Classifiers.length) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            int j = 0;
            while (j < dist.length) {
                if (max[j] < dist[j]) {
                    max[j] = dist[j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    protected double[] distributionForInstanceMin(Instance instance) throws Exception {
        double[] min = this.getClassifier(0).distributionForInstance(instance);
        min = (double[])min.clone();
        int i = 1;
        while (i < this.m_Classifiers.length) {
            double[] dist = this.getClassifier(i).distributionForInstance(instance);
            int j = 0;
            while (j < dist.length) {
                if (dist[j] < min[j]) {
                    min[j] = dist[j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, TAGS_RULES);
    }

    public void setCombinationRule(SelectedTag newRule) {
        if (newRule.getTags() == TAGS_RULES) {
            this.m_CombinationRule = newRule.getSelectedTag().getID();
        }
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Vote: No model built yet.";
        }
        String result = "Vote combines";
        result = String.valueOf(result) + " the probability distributions of these base learners:\n";
        int i = 0;
        while (i < this.m_Classifiers.length) {
            result = String.valueOf(result) + '\t' + this.getClassifierSpec(i) + '\n';
            ++i;
        }
        result = String.valueOf(result) + "using the '";
        switch (this.m_CombinationRule) {
            case 1: {
                result = String.valueOf(result) + "Average of Probabilities";
                break;
            }
            case 2: {
                result = String.valueOf(result) + "Product of Probabilities";
                break;
            }
            case 3: {
                result = String.valueOf(result) + "Majority Voting";
                break;
            }
            case 4: {
                result = String.valueOf(result) + "Minimum Probability";
                break;
            }
            case 5: {
                result = String.valueOf(result) + "Maximum Probability";
                break;
            }
            case 6: {
                result = String.valueOf(result) + "Median Probability";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        result = String.valueOf(result) + "' combination rule \n";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7930 $");
    }

    public static void main(String[] argv) {
        Vote.runClassifier(new Vote(), argv);
    }
}

