/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class GeneticSearch
extends ASSearch
implements StartSetHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1618264232838472679L;
    private int[] m_starting;
    private Range m_startRange;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private GABitSet[] m_population;
    private int m_popSize;
    private GABitSet m_best;
    private int m_bestFeatureCount;
    private int m_lookupTableSize;
    private Hashtable m_lookupTable;
    private Random m_random;
    private int m_seed;
    private double m_pCrossover;
    private double m_pMutation;
    private double m_sumFitness;
    private double m_maxFitness;
    private double m_minFitness;
    private double m_avgFitness;
    private int m_maxGenerations;
    private int m_reportFrequency;
    private StringBuffer m_generationReports;

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.If supplied, the starting set becomes\n\tone member of the initial random\n\tpopulation.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tSet the size of the population (even number).\n\t(default = 20).", "Z", 1, "-Z <population size>"));
        newVector.addElement(new Option("\tSet the number of generations.\n\t(default = 20)", "G", 1, "-G <number of generations>"));
        newVector.addElement(new Option("\tSet the probability of crossover.\n\t(default = 0.6)", "C", 1, "-C <probability of crossover>"));
        newVector.addElement(new Option("\tSet the probability of mutation.\n\t(default = 0.033)", "M", 1, "-M <probability of mutation>"));
        newVector.addElement(new Option("\tSet frequency of generation reports.\n\te.g, setting the value to 5 will \n\treport every 5th generation\n\t(default = number of generations)", "R", 1, "-R <report frequency>"));
        newVector.addElement(new Option("\tSet the random number seed.\n\t(default = 1)", "S", 1, "-S <seed>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('P', options);
        if (optionString.length() != 0) {
            this.setStartSet(optionString);
        }
        if ((optionString = Utils.getOption('Z', options)).length() != 0) {
            this.setPopulationSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('G', options)).length() != 0) {
            this.setMaxGenerations(Integer.parseInt(optionString));
            this.setReportFrequency(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('C', options)).length() != 0) {
            this.setCrossoverProb(new Double(optionString));
        }
        if ((optionString = Utils.getOption('M', options)).length() != 0) {
            this.setMutationProb(new Double(optionString));
        }
        if ((optionString = Utils.getOption('R', options)).length() != 0) {
            this.setReportFrequency(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('S', options)).length() != 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[14];
        int current = 0;
        if (!this.getStartSet().equals("")) {
            options[current++] = "-P";
            options[current++] = this.startSetToString();
        }
        options[current++] = "-Z";
        options[current++] = "" + this.getPopulationSize();
        options[current++] = "-G";
        options[current++] = "" + this.getMaxGenerations();
        options[current++] = "-C";
        options[current++] = "" + this.getCrossoverProb();
        options[current++] = "-M";
        options[current++] = "" + this.getMutationProb();
        options[current++] = "-R";
        options[current++] = "" + this.getReportFrequency();
        options[current++] = "-S";
        options[current++] = "" + this.getSeed();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String startSetTipText() {
        return "Set a start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17. The start set becomes one of the population members of the initial population.";
    }

    @Override
    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    @Override
    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String seedTipText() {
        return "Set the random seed.";
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String reportFrequencyTipText() {
        return "Set how frequently reports are generated. Default is equal to the number of generations meaning that a report will be printed for initial and final generations. Setting the value to 5 will result in a report being printed every 5 generations.";
    }

    public void setReportFrequency(int f) {
        this.m_reportFrequency = f;
    }

    public int getReportFrequency() {
        return this.m_reportFrequency;
    }

    public String mutationProbTipText() {
        return "Set the probability of mutation occuring.";
    }

    public void setMutationProb(double m) {
        this.m_pMutation = m;
    }

    public double getMutationProb() {
        return this.m_pMutation;
    }

    public String crossoverProbTipText() {
        return "Set the probability of crossover. This is the probability that two population members will exchange genetic material.";
    }

    public void setCrossoverProb(double c) {
        this.m_pCrossover = c;
    }

    public double getCrossoverProb() {
        return this.m_pCrossover;
    }

    public String maxGenerationsTipText() {
        return "Set the number of generations to evaluate.";
    }

    public void setMaxGenerations(int m) {
        this.m_maxGenerations = m;
    }

    public int getMaxGenerations() {
        return this.m_maxGenerations;
    }

    public String populationSizeTipText() {
        return "Set the population size (even number), this is the number of individuals (attribute sets) in the population.";
    }

    public void setPopulationSize(int p) {
        if (p % 2 == 0) {
            this.m_popSize = p;
        } else {
            System.out.println("Population size needs to be an even number!");
        }
    }

    public int getPopulationSize() {
        return this.m_popSize;
    }

    public String globalInfo() {
        return "GeneticSearch:\n\nPerforms a search using the simple genetic algorithm described in Goldberg (1989).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David E. Goldberg");
        result.setValue(TechnicalInformation.Field.YEAR, "1989");
        result.setValue(TechnicalInformation.Field.TITLE, "Genetic algorithms in search, optimization and machine learning");
        result.setValue(TechnicalInformation.Field.ISBN, "0201157675");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Addison-Wesley");
        return result;
    }

    public GeneticSearch() {
        this.resetOptions();
    }

    private String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        int i = 0;
        while (i < this.m_starting.length) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
            } else if (didPrint) {
                FString.append(",");
            }
            ++i;
        }
        return FString.toString();
    }

    public String toString() {
        StringBuffer GAString = new StringBuffer();
        GAString.append("\tGenetic search.\n\tStart set: ");
        if (this.m_starting == null) {
            GAString.append("no attributes\n");
        } else {
            GAString.append(String.valueOf(this.startSetToString()) + "\n");
        }
        GAString.append("\tPopulation size: " + this.m_popSize);
        GAString.append("\n\tNumber of generations: " + this.m_maxGenerations);
        GAString.append("\n\tProbability of crossover: " + Utils.doubleToString(this.m_pCrossover, 6, 3));
        GAString.append("\n\tProbability of mutation: " + Utils.doubleToString(this.m_pMutation, 6, 3));
        GAString.append("\n\tReport frequency: " + this.m_reportFrequency);
        GAString.append("\n\tRandom number seed: " + this.m_seed + "\n");
        GAString.append(this.m_generationReports.toString());
        return GAString.toString();
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        this.m_best = null;
        this.m_generationReports = new StringBuffer();
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(String.valueOf(ASEval.getClass().getName()) + " is not a " + "Subset evaluator!");
        }
        if (ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = data.classIndex();
        }
        SubsetEvaluator ASEvaluator = (SubsetEvaluator)((Object)ASEval);
        this.m_numAttribs = data.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        this.m_lookupTable = new Hashtable(this.m_lookupTableSize);
        this.m_random = new Random(this.m_seed);
        this.m_population = new GABitSet[this.m_popSize];
        this.initPopulation();
        this.evaluatePopulation(ASEvaluator);
        this.populationStatistics();
        this.scalePopulation();
        this.checkBest();
        this.m_generationReports.append(this.populationReport(0));
        int i = 1;
        while (i <= this.m_maxGenerations) {
            this.generation();
            this.evaluatePopulation(ASEvaluator);
            this.populationStatistics();
            this.scalePopulation();
            boolean converged = this.checkBest();
            if (i == this.m_maxGenerations || i % this.m_reportFrequency == 0 || converged) {
                this.m_generationReports.append(this.populationReport(i));
                if (converged) break;
            }
            ++i;
        }
        return this.attributeList(this.m_best.getChromosome());
    }

    private int[] attributeList(BitSet group) {
        int count = 0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (group.get(i)) {
                ++count;
            }
            ++i;
        }
        int[] list = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.m_numAttribs) {
            if (group.get(i2)) {
                list[count++] = i2;
            }
            ++i2;
        }
        return list;
    }

    private boolean checkBest() throws Exception {
        BitSet temp;
        int count;
        int lowestCount = this.m_numAttribs;
        double b = -1.7976931348623157E308;
        GABitSet localbest = null;
        boolean converged = false;
        int oldcount = Integer.MAX_VALUE;
        if (this.m_maxFitness - this.m_minFitness > 0.0) {
            int i = 0;
            while (i < this.m_popSize) {
                if (this.m_population[i].getObjective() > b) {
                    b = this.m_population[i].getObjective();
                    localbest = this.m_population[i];
                    oldcount = this.countFeatures(localbest.getChromosome());
                } else if (Utils.eq(this.m_population[i].getObjective(), b) && (count = this.countFeatures(this.m_population[i].getChromosome())) < oldcount) {
                    b = this.m_population[i].getObjective();
                    localbest = this.m_population[i];
                    oldcount = count;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_popSize) {
                temp = this.m_population[i].getChromosome();
                count = this.countFeatures(temp);
                if (count < lowestCount) {
                    lowestCount = count;
                    localbest = this.m_population[i];
                    b = localbest.getObjective();
                }
                ++i;
            }
            converged = true;
        }
        count = 0;
        temp = localbest.getChromosome();
        count = this.countFeatures(temp);
        if (this.m_best == null) {
            this.m_best = (GABitSet)localbest.clone();
            this.m_bestFeatureCount = count;
        } else if (b > this.m_best.getObjective()) {
            this.m_best = (GABitSet)localbest.clone();
            this.m_bestFeatureCount = count;
        } else if (Utils.eq(this.m_best.getObjective(), b) && count < this.m_bestFeatureCount) {
            this.m_best = (GABitSet)localbest.clone();
            this.m_bestFeatureCount = count;
        }
        return converged;
    }

    private int countFeatures(BitSet featureSet) {
        int count = 0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (featureSet.get(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void generation() throws Exception {
        int j = 0;
        double best_fit = -1.7976931348623157E308;
        int old_count = 0;
        GABitSet[] newPop = new GABitSet[this.m_popSize];
        int i = 0;
        while (i < this.m_popSize) {
            int count;
            if (this.m_population[i].getFitness() > best_fit) {
                j = i;
                best_fit = this.m_population[i].getFitness();
                old_count = this.countFeatures(this.m_population[i].getChromosome());
            } else if (Utils.eq(this.m_population[i].getFitness(), best_fit) && (count = this.countFeatures(this.m_population[i].getChromosome())) < old_count) {
                j = i;
                best_fit = this.m_population[i].getFitness();
                old_count = count;
            }
            ++i;
        }
        newPop[0] = (GABitSet)this.m_population[j].clone();
        newPop[1] = newPop[0];
        j = 2;
        while (j < this.m_popSize) {
            int parent1 = this.select();
            int parent2 = this.select();
            newPop[j] = (GABitSet)this.m_population[parent1].clone();
            newPop[j + 1] = (GABitSet)this.m_population[parent2].clone();
            if (parent1 == parent2) {
                int r;
                if (this.m_hasClass) {
                    while ((r = this.m_random.nextInt(this.m_numAttribs)) == this.m_classIndex) {
                    }
                } else {
                    r = this.m_random.nextInt(this.m_numAttribs);
                }
                if (newPop[j].get(r)) {
                    newPop[j].clear(r);
                } else {
                    newPop[j].set(r);
                }
            } else {
                double r = this.m_random.nextDouble();
                if (this.m_numAttribs >= 3 && r < this.m_pCrossover) {
                    int cp = Math.abs(this.m_random.nextInt());
                    cp %= this.m_numAttribs - 2;
                    ++cp;
                    i = 0;
                    while (i < cp) {
                        if (this.m_population[parent1].get(i)) {
                            newPop[j + 1].set(i);
                        } else {
                            newPop[j + 1].clear(i);
                        }
                        if (this.m_population[parent2].get(i)) {
                            newPop[j].set(i);
                        } else {
                            newPop[j].clear(i);
                        }
                        ++i;
                    }
                }
                int k = 0;
                while (k < 2) {
                    i = 0;
                    while (i < this.m_numAttribs) {
                        r = this.m_random.nextDouble();
                        if (r < this.m_pMutation && (!this.m_hasClass || i != this.m_classIndex)) {
                            if (newPop[j + k].get(i)) {
                                newPop[j + k].clear(i);
                            } else {
                                newPop[j + k].set(i);
                            }
                        }
                        ++i;
                    }
                    ++k;
                }
            }
            j += 2;
        }
        this.m_population = newPop;
    }

    private int select() {
        double partsum = 0.0;
        double r = this.m_random.nextDouble() * this.m_sumFitness;
        int i = 0;
        while (i < this.m_popSize) {
            if ((partsum += this.m_population[i].getFitness()) >= r || i == this.m_popSize - 1) break;
            ++i;
        }
        if (i == this.m_popSize) {
            i = 0;
        }
        return i;
    }

    private void evaluatePopulation(SubsetEvaluator ASEvaluator) throws Exception {
        int i = 0;
        while (i < this.m_popSize) {
            if (!this.m_lookupTable.containsKey(this.m_population[i].getChromosome())) {
                double merit = ASEvaluator.evaluateSubset(this.m_population[i].getChromosome());
                this.m_population[i].setObjective(merit);
                this.m_lookupTable.put(this.m_population[i].getChromosome(), this.m_population[i]);
            } else {
                GABitSet temp = (GABitSet)this.m_lookupTable.get(this.m_population[i].getChromosome());
                this.m_population[i].setObjective(temp.getObjective());
            }
            ++i;
        }
    }

    private void initPopulation() throws Exception {
        int i;
        int start = 0;
        if (this.m_starting != null) {
            this.m_population[0] = new GABitSet();
            i = 0;
            while (i < this.m_starting.length) {
                if (this.m_starting[i] != this.m_classIndex) {
                    this.m_population[0].set(this.m_starting[i]);
                }
                ++i;
            }
            start = 1;
        }
        i = start;
        while (i < this.m_popSize) {
            this.m_population[i] = new GABitSet();
            int num_bits = this.m_random.nextInt();
            if ((num_bits = num_bits % this.m_numAttribs - 1) < 0) {
                num_bits *= -1;
            }
            if (num_bits == 0) {
                num_bits = 1;
            }
            int j = 0;
            while (j < num_bits) {
                int bit;
                boolean ok = false;
                do {
                    if ((bit = this.m_random.nextInt()) < 0) {
                        bit *= -1;
                    }
                    bit %= this.m_numAttribs;
                    if (this.m_hasClass) {
                        if (bit == this.m_classIndex) continue;
                        ok = true;
                        continue;
                    }
                    ok = true;
                } while (!ok);
                if (bit > this.m_numAttribs) {
                    throw new Exception("Problem in population init");
                }
                this.m_population[i].set(bit);
                ++j;
            }
            ++i;
        }
    }

    private void populationStatistics() {
        this.m_minFitness = this.m_maxFitness = this.m_population[0].getObjective();
        this.m_sumFitness = this.m_maxFitness;
        int i = 1;
        while (i < this.m_popSize) {
            this.m_sumFitness += this.m_population[i].getObjective();
            if (this.m_population[i].getObjective() > this.m_maxFitness) {
                this.m_maxFitness = this.m_population[i].getObjective();
            } else if (this.m_population[i].getObjective() < this.m_minFitness) {
                this.m_minFitness = this.m_population[i].getObjective();
            }
            ++i;
        }
        this.m_avgFitness = this.m_sumFitness / (double)this.m_popSize;
    }

    private void scalePopulation() {
        double delta;
        double a = 0.0;
        double b = 0.0;
        double fmultiple = 2.0;
        if (this.m_minFitness > (fmultiple * this.m_avgFitness - this.m_maxFitness) / (fmultiple - 1.0)) {
            delta = this.m_maxFitness - this.m_avgFitness;
            a = (fmultiple - 1.0) * this.m_avgFitness / delta;
            b = this.m_avgFitness * (this.m_maxFitness - fmultiple * this.m_avgFitness) / delta;
        } else {
            delta = this.m_avgFitness - this.m_minFitness;
            a = this.m_avgFitness / delta;
            b = -this.m_minFitness * this.m_avgFitness / delta;
        }
        this.m_sumFitness = 0.0;
        int j = 0;
        while (j < this.m_popSize) {
            if (a == Double.POSITIVE_INFINITY || a == Double.NEGATIVE_INFINITY || b == Double.POSITIVE_INFINITY || b == Double.NEGATIVE_INFINITY) {
                this.m_population[j].setFitness(this.m_population[j].getObjective());
            } else {
                this.m_population[j].setFitness(Math.abs(a * this.m_population[j].getObjective() + b));
            }
            this.m_sumFitness += this.m_population[j].getFitness();
            ++j;
        }
    }

    private String populationReport(int genNum) {
        StringBuffer temp = new StringBuffer();
        if (genNum == 0) {
            temp.append("\nInitial population\n");
        } else {
            temp.append("\nGeneration: " + genNum + "\n");
        }
        temp.append("merit   \tscaled  \tsubset\n");
        int i = 0;
        while (i < this.m_popSize) {
            temp.append(String.valueOf(Utils.doubleToString(Math.abs(this.m_population[i].getObjective()), 8, 5)) + "\t" + Utils.doubleToString(this.m_population[i].getFitness(), 8, 5) + "\t");
            temp.append(String.valueOf(this.printPopMember(this.m_population[i].getChromosome())) + "\n");
            ++i;
        }
        return temp.toString();
    }

    private String printPopMember(BitSet temp) {
        StringBuffer text = new StringBuffer();
        int j = 0;
        while (j < this.m_numAttribs) {
            if (temp.get(j)) {
                text.append(String.valueOf(j + 1) + " ");
            }
            ++j;
        }
        return text.toString();
    }

    private String printPopChrom(BitSet temp) {
        StringBuffer text = new StringBuffer();
        int j = 0;
        while (j < this.m_numAttribs) {
            if (temp.get(j)) {
                text.append("1");
            } else {
                text.append("0");
            }
            ++j;
        }
        return text.toString();
    }

    private void resetOptions() {
        this.m_population = null;
        this.m_popSize = 20;
        this.m_lookupTableSize = 1001;
        this.m_pCrossover = 0.6;
        this.m_pMutation = 0.033;
        this.m_reportFrequency = this.m_maxGenerations = 20;
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_seed = 1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6759 $");
    }

    protected class GABitSet
    implements Cloneable,
    Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2930607837482622224L;
        private BitSet m_chromosome = new BitSet();
        private double m_objective = -1.7976931348623157E308;
        private double m_fitness;

        public Object clone() throws CloneNotSupportedException {
            GABitSet temp = new GABitSet();
            temp.setObjective(this.getObjective());
            temp.setFitness(this.getFitness());
            temp.setChromosome((BitSet)this.m_chromosome.clone());
            return temp;
        }

        public void setObjective(double objective) {
            this.m_objective = objective;
        }

        public double getObjective() {
            return this.m_objective;
        }

        public void setFitness(double fitness) {
            this.m_fitness = fitness;
        }

        public double getFitness() {
            return this.m_fitness;
        }

        public BitSet getChromosome() {
            return this.m_chromosome;
        }

        public void setChromosome(BitSet c) {
            this.m_chromosome = c;
        }

        public void clear(int bit) {
            this.m_chromosome.clear(bit);
        }

        public void set(int bit) {
            this.m_chromosome.set(bit);
        }

        public boolean get(int bit) {
            return this.m_chromosome.get(bit);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 6759 $");
        }
    }
}

