/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.gsp;

import java.io.Serializable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Element
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7900701276019516371L;
    protected int[] m_Events;

    public Element() {
    }

    public Element(int size) {
        this.m_Events = new int[size];
    }

    public static FastVector getOneElements(Instances instances) {
        FastVector setOfOneElements = new FastVector();
        int i = 0;
        while (i < instances.numAttributes()) {
            int j = 0;
            while (j < instances.attribute(i).numValues()) {
                Element curElement = new Element();
                curElement.setEvents(new int[instances.numAttributes()]);
                int k = 0;
                while (k < instances.numAttributes()) {
                    curElement.getEvents()[k] = -1;
                    ++k;
                }
                curElement.getEvents()[i] = j++;
                setOfOneElements.addElement(curElement);
            }
            ++i;
        }
        return setOfOneElements;
    }

    public static Element merge(Element element1, Element element2) {
        int[] element1Events = element1.getEvents();
        int[] element2Events = element2.getEvents();
        Element resultElement = new Element(element1Events.length);
        int[] resultEvents = resultElement.getEvents();
        int i = 0;
        while (i < element1Events.length) {
            resultEvents[i] = element2Events[i] > -1 ? element2Events[i] : element1Events[i];
            ++i;
        }
        resultElement.setEvents(resultEvents);
        return resultElement;
    }

    public Element clone() {
        try {
            Element clone = (Element)super.clone();
            int[] cloneEvents = new int[this.m_Events.length];
            int i = 0;
            while (i < this.m_Events.length) {
                cloneEvents[i] = this.m_Events[i];
                ++i;
            }
            clone.setEvents(cloneEvents);
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public boolean containsOverOneEvent() {
        int numEvents = 0;
        int i = 0;
        while (i < this.m_Events.length) {
            if (this.m_Events[i] > -1) {
                ++numEvents;
            }
            if (numEvents == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void deleteEvent(String position) {
        int i;
        if (position.equals("first")) {
            i = 0;
            while (i < this.m_Events.length) {
                if (this.m_Events[i] > -1) {
                    this.m_Events[i] = -1;
                    break;
                }
                ++i;
            }
        }
        if (position.equals("last")) {
            i = this.m_Events.length - 1;
            while (i >= 0) {
                if (this.m_Events[i] > -1) {
                    this.m_Events[i] = -1;
                    break;
                }
                --i;
            }
        }
    }

    public boolean equals(Object obj) {
        Element element2 = (Element)obj;
        int i = 0;
        while (i < this.m_Events.length) {
            if (this.m_Events[i] != element2.getEvents()[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] getEvents() {
        return this.m_Events;
    }

    public boolean isContainedBy(Instance instance) {
        int i = 0;
        while (i < instance.numAttributes()) {
            if (this.m_Events[i] > -1) {
                if (instance.isMissing(i)) {
                    return false;
                }
                if (this.m_Events[i] != (int)instance.value(i)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.m_Events.length) {
            if (this.m_Events[i] > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setEvents(int[] events) {
        this.m_Events = events;
    }

    public String toNominalString(Instances dataSet) {
        StringBuffer result = new StringBuffer();
        int addedValues = 0;
        result.append("{");
        int i = 0;
        while (i < this.m_Events.length) {
            if (this.m_Events[i] > -1) {
                result.append(String.valueOf(dataSet.attribute(i).value(this.m_Events[i])) + ",");
                ++addedValues;
            }
            ++i;
        }
        result.deleteCharAt(result.length() - 1);
        result.append("}");
        return result.toString();
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "{";
        int i = 0;
        while (i < this.m_Events.length) {
            result = String.valueOf(result) + this.m_Events[i];
            if (i + 1 < this.m_Events.length) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

