/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Random;
import weka.associations.ItemSet;
import weka.associations.RuleItem;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SpecialFunctions;
import weka.core.Utils;

public class PriorEstimation
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 5570863216522496271L;
    protected int m_numRandRules;
    protected int m_numIntervals;
    protected static final int SEED = 0;
    protected static final int MAX_N = 1024;
    protected Random m_randNum;
    protected Instances m_instances;
    protected boolean m_CARs;
    protected Hashtable m_distribution;
    protected Hashtable m_priors;
    protected double m_sum;
    protected double[] m_midPoints;

    public PriorEstimation(Instances instances, int numRules, int numIntervals, boolean car) {
        this.m_instances = instances;
        this.m_CARs = car;
        this.m_numRandRules = numRules;
        this.m_numIntervals = numIntervals;
        this.m_randNum = this.m_instances.getRandomNumberGenerator(0L);
    }

    public final void generateDistribution() throws Exception {
        int maxLength = this.m_instances.numAttributes();
        int count = 0;
        boolean count1 = false;
        this.m_distribution = new Hashtable(maxLength * this.m_numIntervals);
        if (this.m_instances.numAttributes() == 0) {
            throw new Exception("Dataset has no attributes!");
        }
        if (this.m_instances.numAttributes() >= 1024) {
            throw new Exception("Dataset has to many attributes for prior estimation!");
        }
        if (this.m_instances.numInstances() == 0) {
            throw new Exception("Dataset has no instances!");
        }
        int h = 0;
        while (h < maxLength) {
            if (this.m_instances.attribute(h).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            ++h;
        }
        if (this.m_numIntervals == 0 || this.m_numRandRules == 0) {
            throw new Exception("Prior initialisation impossible");
        }
        this.midPoints();
        int i = 1;
        while (i <= maxLength) {
            int w;
            this.m_sum = 0.0;
            int j = 0;
            count = 0;
            count1 = false;
            while (j < this.m_numRandRules) {
                RuleItem current;
                int[] itemArray;
                ++count;
                boolean jump = false;
                if (!this.m_CARs) {
                    itemArray = this.randomRule(maxLength, i, this.m_randNum);
                    current = this.splitItemSet(this.m_randNum.nextInt(i), itemArray);
                } else {
                    itemArray = this.randomCARule(maxLength, i, this.m_randNum);
                    current = this.addCons(itemArray);
                }
                int[] ruleItem = new int[maxLength];
                int k = 0;
                while (k < itemArray.length) {
                    ruleItem[k] = current.m_premise.m_items[k] != -1 ? current.m_premise.m_items[k] : (current.m_consequence.m_items[k] != -1 ? current.m_consequence.m_items[k] : -1);
                    ++k;
                }
                ItemSet rule = new ItemSet(ruleItem);
                this.updateCounters(rule);
                int ruleCounter = rule.m_counter;
                if (ruleCounter > 0) {
                    jump = true;
                }
                this.updateCounters(current.m_premise);
                ++j;
                if (!jump) continue;
                this.buildDistribution((double)ruleCounter / (double)current.m_premise.m_counter, i);
            }
            if (this.m_sum > 0.0) {
                w = 0;
                while (w < this.m_midPoints.length) {
                    String key = String.valueOf(this.m_midPoints[w]).concat(String.valueOf((double)i));
                    Double oldValue = (Double)this.m_distribution.remove(key);
                    if (oldValue == null) {
                        this.m_distribution.put(key, new Double(1.0 / (double)this.m_numIntervals));
                        this.m_sum += 1.0 / (double)this.m_numIntervals;
                    } else {
                        this.m_distribution.put(key, oldValue);
                    }
                    ++w;
                }
                w = 0;
                while (w < this.m_midPoints.length) {
                    double conf = 0.0;
                    String key = String.valueOf(this.m_midPoints[w]).concat(String.valueOf((double)i));
                    Double oldValue = (Double)this.m_distribution.remove(key);
                    if (oldValue != null) {
                        conf = oldValue / this.m_sum;
                        this.m_distribution.put(key, new Double(conf));
                    }
                    ++w;
                }
            } else {
                w = 0;
                while (w < this.m_midPoints.length) {
                    String key = String.valueOf(this.m_midPoints[w]).concat(String.valueOf((double)i));
                    this.m_distribution.put(key, new Double(1.0 / (double)this.m_numIntervals));
                    ++w;
                }
            }
            ++i;
        }
    }

    public final int[] randomRule(int maxLength, int actualLength, Random randNum) {
        int[] itemArray = new int[maxLength];
        int k = 0;
        while (k < itemArray.length) {
            itemArray[k] = -1;
            ++k;
        }
        int help = actualLength;
        if (help == maxLength) {
            help = 0;
            int h = 0;
            while (h < itemArray.length) {
                itemArray[h] = this.m_randNum.nextInt(this.m_instances.attribute(h).numValues());
                ++h;
            }
        }
        while (help > 0) {
            int mark = randNum.nextInt(maxLength);
            if (itemArray[mark] != -1) continue;
            --help;
            itemArray[mark] = this.m_randNum.nextInt(this.m_instances.attribute(mark).numValues());
        }
        return itemArray;
    }

    public final int[] randomCARule(int maxLength, int actualLength, Random randNum) {
        int[] itemArray = new int[maxLength];
        int k = 0;
        while (k < itemArray.length) {
            itemArray[k] = -1;
            ++k;
        }
        if (actualLength == 1) {
            return itemArray;
        }
        int help = actualLength - 1;
        if (help == maxLength - 1) {
            help = 0;
            int h = 0;
            while (h < itemArray.length) {
                if (h != this.m_instances.classIndex()) {
                    itemArray[h] = this.m_randNum.nextInt(this.m_instances.attribute(h).numValues());
                }
                ++h;
            }
        }
        while (help > 0) {
            int mark = randNum.nextInt(maxLength);
            if (itemArray[mark] != -1 || mark == this.m_instances.classIndex()) continue;
            --help;
            itemArray[mark] = this.m_randNum.nextInt(this.m_instances.attribute(mark).numValues());
        }
        return itemArray;
    }

    public final void buildDistribution(double conf, double length) {
        double mPoint = this.findIntervall(conf);
        String key = String.valueOf(mPoint).concat(String.valueOf(length));
        this.m_sum += conf;
        Double oldValue = (Double)this.m_distribution.remove(key);
        if (oldValue != null) {
            conf += oldValue.doubleValue();
        }
        this.m_distribution.put(key, new Double(conf));
    }

    public final double findIntervall(double conf) {
        if (conf == 1.0) {
            return this.m_midPoints[this.m_midPoints.length - 1];
        }
        int end = this.m_midPoints.length - 1;
        int start = 0;
        while (Math.abs(end - start) > 1) {
            int mid = (start + end) / 2;
            if (conf > this.m_midPoints[mid]) {
                start = mid + 1;
            }
            if (conf < this.m_midPoints[mid]) {
                end = mid - 1;
            }
            if (conf != this.m_midPoints[mid]) continue;
            return this.m_midPoints[mid];
        }
        if (Math.abs(conf - this.m_midPoints[start]) <= Math.abs(conf - this.m_midPoints[end])) {
            return this.m_midPoints[start];
        }
        return this.m_midPoints[end];
    }

    public final double calculatePriorSum(boolean weighted, double mPoint) {
        double sum = 0.0;
        double max = PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), this.m_instances.numAttributes() / 2);
        int i = 1;
        while (i <= this.m_instances.numAttributes()) {
            if (weighted) {
                String key = String.valueOf(mPoint).concat(String.valueOf((double)i));
                Double hashValue = (Double)this.m_distribution.get(key);
                double distr = hashValue != null ? hashValue : 0.0;
                if (distr != 0.0) {
                    double addend = Utils.log2(distr) - max + Utils.log2(Math.pow(2.0, i) - 1.0) + PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), i);
                    sum += Math.pow(2.0, addend);
                }
            } else {
                double addend = Utils.log2(Math.pow(2.0, i) - 1.0) - max + PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), i);
                sum += Math.pow(2.0, addend);
            }
            ++i;
        }
        return sum;
    }

    public static final double logbinomialCoefficient(int upperIndex, int lowerIndex) {
        double result = 1.0;
        if (upperIndex == lowerIndex || lowerIndex == 0) {
            return result;
        }
        result = SpecialFunctions.log2Binomial(upperIndex, lowerIndex);
        return result;
    }

    public final Hashtable estimatePrior() throws Exception {
        Hashtable<Double, Double> m_priors = new Hashtable<Double, Double>(this.m_numIntervals);
        double denominator = this.calculatePriorSum(false, 1.0);
        this.generateDistribution();
        int i = 0;
        while (i < this.m_numIntervals) {
            double mPoint = this.m_midPoints[i];
            double prior = this.calculatePriorSum(true, mPoint) / denominator;
            m_priors.put(new Double(mPoint), new Double(prior));
            ++i;
        }
        return m_priors;
    }

    public final void midPoints() {
        this.m_midPoints = new double[this.m_numIntervals];
        int i = 0;
        while (i < this.m_numIntervals) {
            this.m_midPoints[i] = this.midPoint(1.0 / (double)this.m_numIntervals, i);
            ++i;
        }
    }

    public double midPoint(double size, int number) {
        return size * (double)number + size / 2.0;
    }

    public final double[] getMidPoints() {
        return this.m_midPoints;
    }

    public final RuleItem splitItemSet(int premiseLength, int[] itemArray) {
        int i;
        int[] cons = new int[this.m_instances.numAttributes()];
        System.arraycopy(itemArray, 0, cons, 0, itemArray.length);
        int help = premiseLength;
        while (help > 0) {
            int mark = this.m_randNum.nextInt(itemArray.length);
            if (cons[mark] == -1) continue;
            --help;
            cons[mark] = -1;
        }
        if (premiseLength == 0) {
            i = 0;
            while (i < itemArray.length) {
                itemArray[i] = -1;
                ++i;
            }
        } else {
            i = 0;
            while (i < itemArray.length) {
                if (cons[i] != -1) {
                    itemArray[i] = -1;
                }
                ++i;
            }
        }
        ItemSet premise = new ItemSet(itemArray);
        ItemSet consequence = new ItemSet(cons);
        RuleItem current = new RuleItem();
        current.m_premise = premise;
        current.m_consequence = consequence;
        return current;
    }

    public final RuleItem addCons(int[] itemArray) {
        ItemSet premise = new ItemSet(itemArray);
        int[] cons = new int[itemArray.length];
        int i = 0;
        while (i < itemArray.length) {
            cons[i] = -1;
            ++i;
        }
        cons[this.m_instances.classIndex()] = this.m_randNum.nextInt(this.m_instances.attribute(this.m_instances.classIndex()).numValues());
        ItemSet consequence = new ItemSet(cons);
        RuleItem current = new RuleItem();
        current.m_premise = premise;
        current.m_consequence = consequence;
        return current;
    }

    public final void updateCounters(ItemSet itemSet) {
        int i = 0;
        while (i < this.m_instances.numInstances()) {
            itemSet.upDateCounter(this.m_instances.instance(i));
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

