/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ItemSet
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 2724000045282835791L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;

    public ItemSet(int totalTrans) {
        this.m_totalTransactions = totalTrans;
    }

    public ItemSet(int totalTrans, int[] array) {
        this.m_totalTransactions = totalTrans;
        this.m_items = array;
        this.m_counter = 1;
    }

    public ItemSet(int[] array) {
        this.m_items = array;
        this.m_counter = 0;
    }

    public boolean containedBy(Instance instance) {
        int i = 0;
        while (i < instance.numAttributes()) {
            if (this.m_items[i] > -1) {
                if (instance.isMissing(i)) {
                    return false;
                }
                if (this.m_items[i] != (int)instance.value(i)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static FastVector deleteItemSets(FastVector itemSets, int minSupport, int maxSupport) {
        FastVector newVector = new FastVector(itemSets.size());
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet current = (ItemSet)itemSets.elementAt(i);
            if (current.m_counter >= minSupport && current.m_counter <= maxSupport) {
                newVector.addElement(current);
            }
            ++i;
        }
        return newVector;
    }

    public boolean equals(Object itemSet) {
        if (itemSet == null || !itemSet.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)itemSet).m_items.length) {
            return false;
        }
        int i = 0;
        while (i < this.m_items.length) {
            if (this.m_items[i] != ((ItemSet)itemSet).m_items[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Hashtable getHashtable(FastVector itemSets, int initialSize) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(initialSize);
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet current = (ItemSet)itemSets.elementAt(i);
            hashtable.put(current, new Integer(current.m_counter));
            ++i;
        }
        return hashtable;
    }

    public int hashCode() {
        long result = 0L;
        int i = this.m_items.length - 1;
        while (i >= 0) {
            result += (long)(i * this.m_items[i]);
            --i;
        }
        return (int)result;
    }

    public static FastVector mergeAllItemSets(FastVector itemSets, int size, int totalTrans) {
        FastVector newVector = new FastVector();
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet first = (ItemSet)itemSets.elementAt(i);
            int j = i + 1;
            block1: while (j < itemSets.size()) {
                ItemSet second = (ItemSet)itemSets.elementAt(j);
                ItemSet result = new ItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) break block1;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length) {
                    if (first.m_items[k] != -1 && second.m_items[k] != -1) break;
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k == first.m_items.length) {
                    result.m_counter = 0;
                    newVector.addElement(result);
                }
                ++j;
            }
            ++i;
        }
        return newVector;
    }

    public static FastVector pruneItemSets(FastVector toPrune, Hashtable kMinusOne) {
        FastVector newVector = new FastVector(toPrune.size());
        int i = 0;
        while (i < toPrune.size()) {
            ItemSet current = (ItemSet)toPrune.elementAt(i);
            int j = 0;
            while (j < current.m_items.length) {
                if (current.m_items[j] != -1) {
                    int help = current.m_items[j];
                    current.m_items[j] = -1;
                    if (kMinusOne.get(current) == null) {
                        current.m_items[j] = help;
                        break;
                    }
                    current.m_items[j] = help;
                }
                ++j;
            }
            if (j == current.m_items.length) {
                newVector.addElement(current);
            }
            ++i;
        }
        return newVector;
    }

    public static void pruneRules(FastVector[] rules, double minConfidence) {
        FastVector newPremises = new FastVector(rules[0].size());
        FastVector newConsequences = new FastVector(rules[1].size());
        FastVector newConf = new FastVector(rules[2].size());
        int i = 0;
        while (i < rules[0].size()) {
            if (!((Double)rules[2].elementAt(i) < minConfidence)) {
                newPremises.addElement(rules[0].elementAt(i));
                newConsequences.addElement(rules[1].elementAt(i));
                newConf.addElement(rules[2].elementAt(i));
            }
            ++i;
        }
        rules[0] = newPremises;
        rules[1] = newConsequences;
        rules[2] = newConf;
    }

    public static FastVector singletons(Instances instances) throws Exception {
        FastVector setOfItemSets = new FastVector();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int j = 0;
            while (j < instances.attribute(i).numValues()) {
                ItemSet current = new ItemSet(instances.numInstances());
                current.m_items = new int[instances.numAttributes()];
                int k = 0;
                while (k < instances.numAttributes()) {
                    current.m_items[k] = -1;
                    ++k;
                }
                current.m_items[i] = j++;
                setOfItemSets.addElement(current);
            }
            ++i;
        }
        return setOfItemSets;
    }

    public int support() {
        return this.m_counter;
    }

    public String toString(Instances instances) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (this.m_items[i] != -1) {
                text.append(String.valueOf(instances.attribute(i).name()) + '=');
                text.append(String.valueOf(instances.attribute(i).value(this.m_items[i])) + ' ');
            }
            ++i;
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public void upDateCounter(Instance instance) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
        }
    }

    public static void upDateCounters(FastVector itemSets, Instances instances) {
        int i = 0;
        while (i < instances.numInstances()) {
            Enumeration enu = itemSets.elements();
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).upDateCounter(instances.instance(i));
            }
            ++i;
        }
    }

    public int counter() {
        return this.m_counter;
    }

    public int[] items() {
        return this.m_items;
    }

    public int itemAt(int k) {
        return this.m_items[k];
    }

    public void setCounter(int count) {
        this.m_counter = count;
    }

    public void setItem(int[] items) {
        this.m_items = items;
    }

    public void setItemAt(int value, int k) {
        this.m_items[k] = value;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }
}

