/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.TreeSet;
import weka.associations.ItemSet;
import weka.associations.RuleGeneration;
import weka.associations.RuleItem;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;

public class CaRuleGeneration
extends RuleGeneration
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 3065752149646517703L;

    public CaRuleGeneration(ItemSet itemSet) {
        super(itemSet);
    }

    @Override
    public TreeSet generateRules(int numRules, double[] midPoints, Hashtable priors, double expectation, Instances instances, TreeSet best, int genTime) {
        boolean redundant = false;
        FastVector consequences = new FastVector();
        RuleItem current = null;
        Object old = null;
        this.m_change = false;
        this.m_midPoints = midPoints;
        this.m_priors = priors;
        this.m_best = best;
        this.m_expectation = expectation;
        this.m_count = genTime;
        this.m_instances = instances;
        ItemSet premise = null;
        premise = new ItemSet(this.m_totalTransactions);
        int[] premiseItems = new int[this.m_items.length];
        System.arraycopy(this.m_items, 0, premiseItems, 0, this.m_items.length);
        premise.setItem(premiseItems);
        premise.setCounter(this.m_counter);
        consequences = CaRuleGeneration.singleConsequence(instances);
        do {
            if (premise == null || consequences.size() == 0) {
                return this.m_best;
            }
            this.m_minRuleCount = 1;
            while (CaRuleGeneration.expectation(this.m_minRuleCount, premise.counter(), this.m_midPoints, this.m_priors) <= this.m_expectation) {
                ++this.m_minRuleCount;
                if (this.m_minRuleCount <= premise.counter()) continue;
                return this.m_best;
            }
            redundant = false;
            FastVector allRuleItems = new FastVector();
            int h = 0;
            while (h < consequences.size()) {
                RuleItem dummie = new RuleItem();
                ++this.m_count;
                current = dummie.generateRuleItem(premise, (ItemSet)consequences.elementAt(h), instances, this.m_count, this.m_minRuleCount, this.m_midPoints, this.m_priors);
                if (current != null) {
                    allRuleItems.addElement(current);
                }
                ++h;
            }
            h = 0;
            while (h < allRuleItems.size()) {
                current = (RuleItem)allRuleItems.elementAt(h);
                if (this.m_best.size() < numRules) {
                    this.m_change = true;
                    redundant = this.removeRedundant(current);
                } else {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    if (current.accuracy() > this.m_expectation) {
                        boolean remove = this.m_best.remove(this.m_best.first());
                        this.m_change = true;
                        redundant = this.removeRedundant(current);
                        this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                        while (CaRuleGeneration.expectation(this.m_minRuleCount, current.premise().counter(), this.m_midPoints, this.m_priors) < this.m_expectation) {
                            ++this.m_minRuleCount;
                            if (this.m_minRuleCount > current.premise().counter()) break;
                        }
                    }
                }
                ++h;
            }
        } while (redundant);
        return this.m_best;
    }

    public static boolean aSubsumesB(RuleItem a, RuleItem b) {
        if (!a.consequence().equals(b.consequence())) {
            return false;
        }
        if (a.accuracy() < b.accuracy()) {
            return false;
        }
        int k = 0;
        while (k < a.premise().items().length) {
            if (a.premise().itemAt(k) != b.premise().itemAt(k) && (a.premise().itemAt(k) != -1 && b.premise().itemAt(k) != -1 || b.premise().itemAt(k) == -1)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static FastVector singletons(Instances instances) throws Exception {
        FastVector setOfItemSets = new FastVector();
        if (instances.classIndex() == -1) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        Attribute att = instances.classAttribute();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            if (i != instances.classIndex()) {
                int j = 0;
                while (j < instances.attribute(i).numValues()) {
                    ItemSet current = new ItemSet(instances.numInstances());
                    int[] currentItems = new int[instances.numAttributes()];
                    int k = 0;
                    while (k < instances.numAttributes()) {
                        currentItems[k] = -1;
                        ++k;
                    }
                    currentItems[i] = j++;
                    current.setItem(currentItems);
                    setOfItemSets.addElement(current);
                }
            }
            ++i;
        }
        return setOfItemSets;
    }

    public static FastVector singleConsequence(Instances instances) {
        FastVector consequences = new FastVector();
        int j = 0;
        while (j < instances.classAttribute().numValues()) {
            ItemSet consequence = new ItemSet(instances.numInstances());
            int[] consequenceItems = new int[instances.numAttributes()];
            consequence.setItem(consequenceItems);
            int k = 0;
            while (k < instances.numAttributes()) {
                consequence.setItemAt(-1, k);
                ++k;
            }
            consequence.setItemAt(j, instances.classIndex());
            consequences.addElement(consequence);
            ++j;
        }
        return consequences;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

