/*
 * Decompiled with CFR 0.152.
 */
package JFlex.tests;

import JFlex.IntCharSet;
import JFlex.Interval;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CharClassesTest
extends TestCase {
    public CharClassesTest(String arg0) {
        super(arg0);
    }

    public void testAdd1() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('h', 'o'));
        Assert.assertEquals("{ ['A'-'Z']['a'-'z'] }", set.toString());
    }

    public void testAdd2() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('i', 'n'));
        Assert.assertEquals("{ ['A'-'Z']['a'-'z'] }", set.toString());
    }

    public void testAdd3() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('a', 'n'));
        Assert.assertEquals("{ ['A'-'Z']['a'-'z'] }", set.toString());
    }

    public void testMergeLast() {
        IntCharSet set = new IntCharSet(new Interval('a', 'k'));
        Assert.assertEquals("{ ['a'-'k'] }", set.toString());
        set.add('l');
        Assert.assertEquals("{ ['a'-'l'] }", set.toString());
    }

    public void testAddChar() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add('n');
        set.add('k');
        Assert.assertEquals("{ ['a'-'h']['k']['n'-'z'] }", set.toString());
        set.add('i');
        Assert.assertEquals("{ ['a'-'i']['k']['n'-'z'] }", set.toString());
        set.add('j');
        Assert.assertEquals("{ ['a'-'k']['n'-'z'] }", set.toString());
        set.add(new Interval('l', 'm'));
        Assert.assertEquals("{ ['a'-'z'] }", set.toString());
    }

    public void testCopy() {
        IntCharSet set = new IntCharSet(new Interval('a', 'z'));
        IntCharSet copy = set.copy();
        Interval i = set.getNext();
        i.end = (char)104;
        Assert.assertEquals("{ ['a'-'h'] }", set.toString());
        Assert.assertEquals("{ ['a'-'z'] }", copy.toString());
    }

    public void testCaseless() {
        IntCharSet set = new IntCharSet(new Interval('a', 'c'));
        set.add(new Interval('h', 'o'));
        Assert.assertEquals("{ ['A'-'C']['H'-'O']['a'-'c']['h'-'o'] }", set.getCaseless().toString());
    }
}

