/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.Messages;

public class JPEGWriter
extends JComponentWriter {
    protected float m_Quality;
    protected Color m_Background;

    public JPEGWriter() {
    }

    public JPEGWriter(JComponent c) {
        super(c);
    }

    public JPEGWriter(JComponent c, File f) {
        super(c, f);
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
        this.setScalingEnabled(false);
    }

    @Override
    public String getDescription() {
        Messages.getInstance();
        return Messages.getString("JPEGWriter_GetDescription_Text");
    }

    @Override
    public String getExtension() {
        return ".jpg";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color c) {
        this.m_Background = c;
    }

    public float getQuality() {
        return this.m_Quality;
    }

    public void setQuality(float q) {
        this.m_Quality = q;
    }

    @Override
    public void generateOutput() throws Exception {
        BufferedImage bi = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.getXScale(), this.getYScale());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(this.getExtension().replace(".", ""));
        if (!iter.hasNext()) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("JPEGWriter_GenerateOutput_Exception_Text_First"))).append(this.getDescription());
            Messages.getInstance();
            throw new Exception(stringBuilder.append(Messages.getString("JPEGWriter_GenerateOutput_Exception_Text_Second")).toString());
        }
        writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(this.getFile());
        writer.setOutput(ios);
        JPEGImageWriteParam param = new JPEGImageWriteParam(Locale.getDefault());
        param.setCompressionMode(2);
        param.setCompressionQuality(this.getQuality());
        writer.write(null, new IIOImage(bi, null, null), param);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static void main(String[] args) throws Exception {
        Messages.getInstance();
        System.out.println(Messages.getString("JPEGWriter_Main_Text_First"));
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Messages.getInstance();
        Node top = builder.create(new StringReader(Messages.getString("JPEGWriter_Main_Text_Second")));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "test.jpg";
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("JPEGWriter_Main_Text_Third"))).append(filename);
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("JPEGWriter_Main_Text_Fourth")).toString());
        JPEGWriter.toOutput(new JPEGWriter(), tv, new File(filename));
        Messages.getInstance();
        System.out.println(Messages.getString("JPEGWriter_Main_Text_Fifth"));
    }
}

