/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.gui.visualize.AttributePanelEvent;
import weka.gui.visualize.AttributePanelListener;
import weka.gui.visualize.Messages;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.VisualizeUtils;

public class AttributePanel
extends JScrollPane {
    private static final long serialVersionUID = 3533330317806757814L;
    protected Instances m_plotInstances = null;
    protected double m_maxC;
    protected double m_minC;
    protected int m_cIndex;
    protected int m_xIndex;
    protected int m_yIndex;
    protected FastVector m_colorList;
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_backgroundColor = null;
    protected FastVector m_Listeners = new FastVector();
    protected int[] m_heights;
    protected JPanel m_span = null;
    protected Color m_barColour = Color.black;

    private void setProperties() {
        String thisClass;
        String barKey;
        String barC;
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null && (barC = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(barKey = String.valueOf(thisClass = this.getClass().getName()) + ".barColour")) != null) {
            this.m_barColour = VisualizeUtils.processColour(barC, this.m_barColour);
        }
    }

    public AttributePanel() {
        this((Color)null);
    }

    public AttributePanel(Color background) {
        this.m_backgroundColor = background;
        this.setProperties();
        this.setBackground(Color.blue);
        this.setVerticalScrollBarPolicy(22);
        this.m_colorList = new FastVector(10);
        int noa = this.m_colorList.size();
        while (noa < 10) {
            Color pc = this.m_DefaultColors[noa % 10];
            int ija = noa / 10;
            ija *= 2;
            int j = 0;
            while (j < ija) {
                pc = pc.darker();
                ++j;
            }
            this.m_colorList.addElement(pc);
            ++noa;
        }
    }

    public void addAttributePanelListener(AttributePanelListener a) {
        this.m_Listeners.addElement(a);
    }

    public void setCindex(int c, double h, double l) {
        this.m_cIndex = c;
        this.m_maxC = h;
        this.m_minC = l;
        if (this.m_span != null) {
            if (this.m_plotInstances.numAttributes() > 0 && this.m_cIndex < this.m_plotInstances.numAttributes() && this.m_plotInstances.attribute(this.m_cIndex).isNominal() && this.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                this.extendColourMap();
            }
            this.repaint();
        }
    }

    public void setCindex(int c) {
        this.m_cIndex = c;
        if (this.m_span != null) {
            if (this.m_cIndex < this.m_plotInstances.numAttributes() && this.m_plotInstances.attribute(this.m_cIndex).isNumeric()) {
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < this.m_plotInstances.numInstances()) {
                    if (!this.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                        double value = this.m_plotInstances.instance(i).value(this.m_cIndex);
                        if (value < min) {
                            min = value;
                        }
                        if (value > max) {
                            max = value;
                        }
                    }
                    ++i;
                }
                this.m_minC = min;
                this.m_maxC = max;
            } else if (this.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                this.extendColourMap();
            }
            this.repaint();
        }
    }

    private void extendColourMap() {
        if (this.m_plotInstances.attribute(this.m_cIndex).isNominal()) {
            int i = this.m_colorList.size();
            while (i < this.m_plotInstances.attribute(this.m_cIndex).numValues()) {
                Color pc = this.m_DefaultColors[i % 10];
                int ija = i / 10;
                ija *= 2;
                int j = 0;
                while (j < ija) {
                    pc = pc.brighter();
                    ++j;
                }
                if (this.m_backgroundColor != null) {
                    pc = Plot2D.checkAgainstBackground(pc, this.m_backgroundColor);
                }
                this.m_colorList.addElement(pc);
                ++i;
            }
        }
    }

    public void setColours(FastVector cols) {
        this.m_colorList = cols;
    }

    protected void setDefaultColourList(Color[] list) {
        this.m_DefaultColors = list;
    }

    public void setInstances(Instances ins) throws Exception {
        if (ins.numAttributes() > 512) {
            Messages.getInstance();
            throw new Exception(Messages.getString("AttributePanel_SetInstances_Exception_Text"));
        }
        if (this.m_span == null) {
            this.m_span = new JPanel(){
                private static final long serialVersionUID = 7107576557995451922L;

                @Override
                public void paintComponent(Graphics gx) {
                    super.paintComponent(gx);
                    gx.setColor(Color.red);
                    if (AttributePanel.this.m_yIndex != AttributePanel.this.m_xIndex) {
                        Messages.getInstance();
                        gx.drawString(Messages.getString("AttributePanel_SetInstances_PaintComponent_DrawString_Text_First"), 5, AttributePanel.this.m_xIndex * 20 + 16);
                        Messages.getInstance();
                        gx.drawString(Messages.getString("AttributePanel_SetInstances_PaintComponent_DrawString_Text_Second"), 5, AttributePanel.this.m_yIndex * 20 + 16);
                    } else {
                        Messages.getInstance();
                        gx.drawString(Messages.getString("AttributePanel_SetInstances_PaintComponent_DrawString_Text_Third"), 5, AttributePanel.this.m_xIndex * 20 + 16);
                    }
                }
            };
        }
        this.m_span.removeAll();
        this.m_plotInstances = ins;
        if (ins.numInstances() > 0 && ins.numAttributes() > 0) {
            JPanel padder = new JPanel();
            JPanel padd2 = new JPanel();
            this.m_heights = new int[ins.numInstances()];
            this.m_cIndex = ins.numAttributes() - 1;
            int noa = 0;
            while (noa < ins.numInstances()) {
                this.m_heights[noa] = (int)(Math.random() * 19.0);
                ++noa;
            }
            this.m_span.setPreferredSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_cIndex + 1) * 20));
            this.m_span.setMaximumSize(new Dimension(this.m_span.getMaximumSize().width, (this.m_cIndex + 1) * 20));
            GridBagLayout gb = new GridBagLayout();
            GridBagLayout gb2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            padder.setLayout(gb);
            this.m_span.setLayout(gb2);
            constraints.anchor = 10;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 5.0;
            constraints.fill = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            padder.add((Component)this.m_span, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 5.0;
            constraints.fill = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weighty = 5.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            padder.add((Component)padd2, constraints);
            constraints.weighty = 0.0;
            this.setViewportView(padder);
            constraints.anchor = 10;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 5.0;
            constraints.fill = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weighty = 5.0;
            constraints.insets = new Insets(2, 20, 2, 4);
            int noa2 = 0;
            while (noa2 < ins.numAttributes()) {
                AttributeSpacing tmp = new AttributeSpacing(ins.attribute(noa2), noa2);
                constraints.gridy = noa2++;
                this.m_span.add((Component)tmp, constraints);
            }
        }
    }

    public void setX(int x) {
        if (this.m_span != null) {
            this.m_xIndex = x;
            this.m_span.repaint();
        }
    }

    public void setY(int y) {
        if (this.m_span != null) {
            this.m_yIndex = y;
            this.m_span.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                Messages.getInstance();
                System.err.println(Messages.getString("AttributePanel_Main_Error_Text_First"));
                System.exit(1);
            }
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("AttributePanel_Main_JFrame_Text"));
            jf.setSize(100, 100);
            jf.getContentPane().setLayout(new BorderLayout());
            AttributePanel p2 = new AttributePanel();
            p2.addAttributePanelListener(new AttributePanelListener(){

                @Override
                public void attributeSelectionChange(AttributePanelEvent e) {
                    if (e.m_xChange) {
                        Messages.getInstance();
                        System.err.println(String.valueOf(Messages.getString("AttributePanel_Main_Error_Text_Second")) + e.m_indexVal);
                    } else {
                        Messages.getInstance();
                        System.err.println(String.valueOf(Messages.getString("AttributePanel_Main_Error_Text_Third")) + e.m_indexVal);
                    }
                }
            });
            jf.getContentPane().add((Component)p2, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            if (args.length >= 1) {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("AttributePanel_Main_Error_Text_Fourth")) + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                i.setClassIndex(i.numAttributes() - 1);
                p2.setInstances(i);
            }
            if (args.length > 1) {
                p2.setCindex(Integer.parseInt(args[1]) - 1);
            } else {
                p2.setCindex(0);
            }
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    protected class AttributeSpacing
    extends JPanel {
        private static final long serialVersionUID = 7220615894321679898L;
        protected double m_maxVal;
        protected double m_minVal;
        protected Attribute m_attrib;
        protected int m_attribIndex;
        protected int[] m_cached;
        protected boolean[][] m_pointDrawn;
        protected int m_oldWidth = -9000;

        public AttributeSpacing(Attribute a, int aind) {
            this.m_attrib = a;
            this.m_attribIndex = aind;
            this.setBackground(AttributePanel.this.m_barColour);
            this.setPreferredSize(new Dimension(0, 20));
            this.setMinimumSize(new Dimension(0, 20));
            this.m_cached = new int[AttributePanel.this.m_plotInstances.numInstances()];
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                this.m_minVal = 0.0;
                this.m_maxVal = AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).numValues() - 1;
            } else {
                int i = 0;
                while (i < AttributePanel.this.m_plotInstances.numInstances()) {
                    if (!AttributePanel.this.m_plotInstances.instance(i).isMissing(this.m_attribIndex)) {
                        double value = AttributePanel.this.m_plotInstances.instance(i).value(this.m_attribIndex);
                        if (value < min) {
                            min = value;
                        }
                        if (value > max) {
                            max = value;
                        }
                    }
                    ++i;
                }
                this.m_minVal = min;
                this.m_maxVal = max;
                if (min == max) {
                    this.m_maxVal += 0.05;
                    this.m_minVal -= 0.05;
                }
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    block4: {
                        block3: {
                            if ((e.getModifiers() & 0x10) != 16) break block3;
                            AttributePanel.this.setX(AttributeSpacing.this.m_attribIndex);
                            if (((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.size() <= 0) break block4;
                            int i = 0;
                            while (i < ((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.size()) {
                                AttributePanelListener l = (AttributePanelListener)((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.elementAt(i);
                                l.attributeSelectionChange(new AttributePanelEvent(true, false, AttributeSpacing.this.m_attribIndex));
                                ++i;
                            }
                            break block4;
                        }
                        AttributePanel.this.setY(AttributeSpacing.this.m_attribIndex);
                        if (((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.size() > 0) {
                            int i = 0;
                            while (i < ((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.size()) {
                                AttributePanelListener l = (AttributePanelListener)((AttributeSpacing)AttributeSpacing.this).AttributePanel.this.m_Listeners.elementAt(i);
                                l.attributeSelectionChange(new AttributePanelEvent(false, true, AttributeSpacing.this.m_attribIndex));
                                ++i;
                            }
                        }
                    }
                }
            });
        }

        private double convertToPanel(double val) {
            double temp = (val - this.m_minVal) / (this.m_maxVal - this.m_minVal);
            double temp2 = temp * (double)(this.getWidth() - 10);
            return temp2 + 4.0;
        }

        @Override
        public void paintComponent(Graphics gx) {
            block14: {
                int noa;
                super.paintComponent(gx);
                int h = this.getWidth();
                if (AttributePanel.this.m_plotInstances == null || AttributePanel.this.m_plotInstances.numAttributes() <= 0 || AttributePanel.this.m_plotInstances.numInstances() <= 0) break block14;
                if (this.m_oldWidth != h) {
                    this.m_pointDrawn = new boolean[h][20];
                    noa = 0;
                    while (noa < AttributePanel.this.m_plotInstances.numInstances()) {
                        if (!AttributePanel.this.m_plotInstances.instance(noa).isMissing(this.m_attribIndex) && !AttributePanel.this.m_plotInstances.instance(noa).isMissing(AttributePanel.this.m_cIndex)) {
                            this.m_cached[noa] = (int)this.convertToPanel(AttributePanel.this.m_plotInstances.instance(noa).value(this.m_attribIndex));
                            if (this.m_pointDrawn[this.m_cached[noa] % h][AttributePanel.this.m_heights[noa]]) {
                                this.m_cached[noa] = -9000;
                            } else {
                                this.m_pointDrawn[this.m_cached[noa] % h][AttributePanel.this.m_heights[noa]] = true;
                            }
                        } else {
                            this.m_cached[noa] = -9000;
                        }
                        ++noa;
                    }
                    this.m_oldWidth = h;
                }
                if (AttributePanel.this.m_plotInstances.attribute(AttributePanel.this.m_cIndex).isNominal()) {
                    noa = 0;
                    while (noa < AttributePanel.this.m_plotInstances.numInstances()) {
                        if (this.m_cached[noa] != -9000) {
                            int xp = this.m_cached[noa];
                            int yp = AttributePanel.this.m_heights[noa];
                            if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                                xp += (int)(Math.random() * 5.0) - 2;
                            }
                            int ci = (int)AttributePanel.this.m_plotInstances.instance(noa).value(AttributePanel.this.m_cIndex);
                            gx.setColor((Color)AttributePanel.this.m_colorList.elementAt(ci % AttributePanel.this.m_colorList.size()));
                            gx.drawRect(xp, yp, 1, 1);
                        }
                        ++noa;
                    }
                } else {
                    int noa2 = 0;
                    while (noa2 < AttributePanel.this.m_plotInstances.numInstances()) {
                        if (this.m_cached[noa2] != -9000) {
                            double r = (AttributePanel.this.m_plotInstances.instance(noa2).value(AttributePanel.this.m_cIndex) - AttributePanel.this.m_minC) / (AttributePanel.this.m_maxC - AttributePanel.this.m_minC);
                            r = r * 240.0 + 15.0;
                            gx.setColor(new Color((int)r, 150, (int)(255.0 - r)));
                            int xp = this.m_cached[noa2];
                            int yp = AttributePanel.this.m_heights[noa2];
                            if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                                xp += (int)(Math.random() * 5.0) - 2;
                            }
                            gx.drawRect(xp, yp, 1, 1);
                        }
                        ++noa2;
                    }
                }
            }
        }
    }
}

