/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.Messages;

public class InstanceViewer
extends JPanel
implements InstanceListener {
    private static final long serialVersionUID = -4925729441294121772L;
    private JTextArea m_OutputTex;
    private boolean m_Debug;
    private boolean m_Clear;
    private String m_UpdateString;

    private void updateOutput() {
        this.m_OutputTex.append(this.m_UpdateString);
        this.m_UpdateString = "";
    }

    private void clearOutput() {
        this.m_UpdateString = "";
        this.m_OutputTex.setText("");
    }

    public void inputFormat(Instances instanceInfo) {
        if (this.m_Debug) {
            Messages.getInstance();
            System.err.println(String.valueOf(Messages.getString("InstanceViewer_InputFormat_Error_Text")) + instanceInfo.toString());
        }
        if (this.m_Clear) {
            this.clearOutput();
        }
        this.m_UpdateString = String.valueOf(this.m_UpdateString) + instanceInfo.toString();
        this.updateOutput();
    }

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("InstanceViewer_Input_Error_Text_First"))).append(instance);
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("InstanceViewer_Input_Error_Text_Second")).toString());
        }
        this.m_UpdateString = String.valueOf(this.m_UpdateString) + instance.toString() + "\n";
        this.updateOutput();
    }

    public void batchFinished() {
        this.updateOutput();
        if (this.m_Debug) {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceViewer_BatchFinished_Error_Text"));
        }
    }

    public InstanceViewer() {
        this.setLayout(new BorderLayout());
        this.m_UpdateString = "";
        this.setClearEachDataset(true);
        this.m_OutputTex = new JTextArea(10, 20);
        this.m_OutputTex.setEditable(false);
        this.add("Center", new JScrollPane(this.m_OutputTex));
    }

    public void setClearEachDataset(boolean clear) {
        this.m_Clear = clear;
    }

    public boolean getClearEachDataset() {
        return this.m_Clear;
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    @Override
    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        this.inputFormat(a.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        Messages.getInstance();
                        System.err.println(Messages.getString("InstanceViewer_InstanceProduced_InstanceEventDEFAULT_Error_Text"));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceViewer_InstanceProduced_Error_Text"));
        }
    }
}

