/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.Messages;

public class InstanceCounter
extends JPanel
implements InstanceListener {
    private static final long serialVersionUID = -6084967152645935934L;
    private JLabel m_Count_Lab;
    private int m_Count = 0;
    private boolean m_Debug;

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("InstanceCounter_Input_Error_Text_First"))).append(instance);
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("InstanceCounter_Input_Error_Text_Second")).toString());
        }
        ++this.m_Count;
        StringBuilder stringBuilder = new StringBuilder().append(this.m_Count);
        Messages.getInstance();
        this.m_Count_Lab.setText(stringBuilder.append(Messages.getString("InstanceCounter_Input_Count_Lab_SetText_Text_Second")).toString());
        this.repaint();
    }

    public void inputFormat(Instances instanceInfo) {
        if (this.m_Debug) {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceCounter_InputFormat_Error_Text_First"));
        }
        Instances inputInstances = new Instances(instanceInfo, 0);
        this.m_Count = 0;
        StringBuilder stringBuilder = new StringBuilder().append(this.m_Count);
        Messages.getInstance();
        this.m_Count_Lab.setText(stringBuilder.append(Messages.getString("InstanceCounter_InputFormat_Count_Lab_SetText_Text_Second")).toString());
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public InstanceCounter() {
        Messages.getInstance();
        this.m_Count_Lab = new JLabel(Messages.getString("InstanceCounter_Count_Lab_JLabel_Text"));
        this.add(this.m_Count_Lab);
        this.setBackground(Color.lightGray);
    }

    @Override
    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        this.inputFormat(a.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.m_Debug) {
                            Messages.getInstance();
                            System.err.println(Messages.getString("InstanceCounter_InstanceProduced_InstanceEventBATCH_FINISHED_Error_Text"));
                        }
                        break;
                    }
                    default: {
                        Messages.getInstance();
                        System.err.println(Messages.getString("InstanceCounter_InstanceProduced_InstanceEventDEFAULT_Error_Text"));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("InstanceCounter_InstanceProduced_Error_Text"));
        }
    }
}

