/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import weka.core.FastVector;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.graphvisualizer.Messages;

public class HierarchicalBCEngine
implements GraphConstants,
LayoutEngine {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected FastVector layoutCompleteListeners;
    protected int[][] graphMatrix;
    protected int[][] nodeLevels;
    protected int m_nodeWidth;
    protected int m_nodeHeight;
    protected JRadioButton m_jRbNaiveLayout;
    protected JRadioButton m_jRbPriorityLayout;
    protected JRadioButton m_jRbTopdown;
    protected JRadioButton m_jRbBottomup;
    protected JCheckBox m_jCbEdgeConcentration;
    protected JPanel m_controlsPanel;
    protected JProgressBar m_progress;
    protected boolean m_completeReLayout = false;
    private int origNodesSize;

    public HierarchicalBCEngine(FastVector nodes, FastVector edges, int nodeWidth, int nodeHeight) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(false);
    }

    public HierarchicalBCEngine(FastVector nodes, FastVector edges, int nodeWidth, int nodeHeight, boolean edgeConcentration) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(edgeConcentration);
    }

    public HierarchicalBCEngine() {
    }

    protected void makeGUIPanel(boolean edgeConc) {
        Messages.getInstance();
        this.m_jRbNaiveLayout = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbTopdown_JRadioButton_Text"));
        Messages.getInstance();
        this.m_jRbPriorityLayout = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbPriorityLayout_JRadioButton_Text"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_jRbNaiveLayout);
        bg.add(this.m_jRbPriorityLayout);
        this.m_jRbPriorityLayout.setSelected(true);
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HierarchicalBCEngine.this.m_completeReLayout = true;
            }
        };
        Messages.getInstance();
        this.m_jRbTopdown = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbTopdown_JRadioButton_Text"));
        Messages.getInstance();
        this.m_jRbBottomup = new JRadioButton(Messages.getString("HierarchicalBCEngine_JRbBottomup_JRadioButton_Text"));
        this.m_jRbTopdown.addActionListener(a);
        this.m_jRbBottomup.addActionListener(a);
        bg = new ButtonGroup();
        bg.add(this.m_jRbTopdown);
        bg.add(this.m_jRbBottomup);
        this.m_jRbBottomup.setSelected(true);
        Messages.getInstance();
        this.m_jCbEdgeConcentration = new JCheckBox(Messages.getString("HierarchicalBCEngine_JP1_JPanel_BorderFactoryCreateTitledBorder_Text"), edgeConc);
        this.m_jCbEdgeConcentration.setSelected(edgeConc);
        this.m_jCbEdgeConcentration.addActionListener(a);
        JPanel jp1 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jp1.add((Component)this.m_jRbNaiveLayout, gbc);
        jp1.add((Component)this.m_jRbPriorityLayout, gbc);
        Messages.getInstance();
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("HierarchicalBCEngine_JP1_SetBorder_Text")));
        JPanel jp2 = new JPanel(new GridBagLayout());
        jp2.add((Component)this.m_jRbTopdown, gbc);
        jp2.add((Component)this.m_jRbBottomup, gbc);
        Messages.getInstance();
        jp2.setBorder(BorderFactory.createTitledBorder(Messages.getString("HierarchicalBCEngine_JP2_BorderFactoryCreateTitledBorder_Text")));
        this.m_progress = new JProgressBar(0, 11);
        this.m_progress.setBorderPainted(false);
        this.m_progress.setStringPainted(true);
        this.m_progress.setString("");
        this.m_progress.setValue(0);
        this.m_controlsPanel = new JPanel(new GridBagLayout());
        this.m_controlsPanel.add((Component)jp1, gbc);
        this.m_controlsPanel.add((Component)jp2, gbc);
        this.m_controlsPanel.add((Component)this.m_jCbEdgeConcentration, gbc);
    }

    @Override
    public FastVector getNodes() {
        return this.m_nodes;
    }

    @Override
    public JPanel getControlPanel() {
        return this.m_controlsPanel;
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.m_progress;
    }

    @Override
    public void setNodesEdges(FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    @Override
    public void setNodeSize(int nodeWidth, int nodeHeight) {
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
    }

    @Override
    public void addLayoutCompleteEventListener(LayoutCompleteEventListener l) {
        if (this.layoutCompleteListeners == null) {
            this.layoutCompleteListeners = new FastVector();
        }
        this.layoutCompleteListeners.addElement(l);
    }

    @Override
    public void removeLayoutCompleteEventListener(LayoutCompleteEventListener e) {
        if (this.layoutCompleteListeners != null) {
            int i = 0;
            while (i < this.layoutCompleteListeners.size()) {
                LayoutCompleteEventListener l = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                if (l == e) {
                    this.layoutCompleteListeners.removeElementAt(i);
                    return;
                }
                ++i;
            }
            Messages.getInstance();
            System.err.println(Messages.getString("HierarchicalBCEngine_RemoveLayoutCompleteEventListener_Error_Text_First"));
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("HierarchicalBCEngine_RemoveLayoutCompleteEventListener_Error_Text_Second"));
        }
    }

    @Override
    public void fireLayoutCompleteEvent(LayoutCompleteEvent e) {
        if (this.layoutCompleteListeners != null && this.layoutCompleteListeners.size() != 0) {
            int i = 0;
            while (i < this.layoutCompleteListeners.size()) {
                LayoutCompleteEventListener l = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                l.layoutCompleted(e);
                ++i;
            }
        }
    }

    @Override
    public void layoutGraph() {
        if (this.m_nodes == null || this.m_edges == null) {
            return;
        }
        Thread th = new Thread(){

            @Override
            public void run() {
                HierarchicalBCEngine.this.m_progress.setBorderPainted(true);
                if (HierarchicalBCEngine.this.nodeLevels == null) {
                    HierarchicalBCEngine.this.makeProperHierarchy();
                } else if (HierarchicalBCEngine.this.m_completeReLayout) {
                    HierarchicalBCEngine.this.clearTemps_and_EdgesFromNodes();
                    HierarchicalBCEngine.this.makeProperHierarchy();
                    HierarchicalBCEngine.this.m_completeReLayout = false;
                }
                if (HierarchicalBCEngine.this.m_jRbTopdown.isSelected()) {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i + 4);
                        JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                        Messages.getInstance();
                        jProgressBar.setString(String.valueOf(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_First")) + (i + 1));
                        if (i != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(false, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i < 6);
                } else {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i + 4);
                        JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                        Messages.getInstance();
                        jProgressBar.setString(String.valueOf(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Second")) + (i + 1));
                        if (i != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(true, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i < 6);
                }
                HierarchicalBCEngine.this.m_progress.setValue(10);
                JProgressBar jProgressBar = HierarchicalBCEngine.this.m_progress;
                Messages.getInstance();
                jProgressBar.setString(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Third"));
                if (HierarchicalBCEngine.this.m_jRbNaiveLayout.isSelected()) {
                    HierarchicalBCEngine.this.naiveLayout();
                } else {
                    HierarchicalBCEngine.this.priorityLayout1();
                }
                HierarchicalBCEngine.this.m_progress.setValue(11);
                JProgressBar jProgressBar2 = HierarchicalBCEngine.this.m_progress;
                Messages.getInstance();
                jProgressBar2.setString(Messages.getString("HierarchicalBCEngine_LayoutGraph_Progress_SetString_Text_Fourth"));
                HierarchicalBCEngine.this.m_progress.repaint();
                HierarchicalBCEngine.this.fireLayoutCompleteEvent(new LayoutCompleteEvent(this));
                HierarchicalBCEngine.this.m_progress.setValue(0);
                HierarchicalBCEngine.this.m_progress.setString("");
                HierarchicalBCEngine.this.m_progress.setBorderPainted(false);
            }
        };
        th.start();
    }

    protected void clearTemps_and_EdgesFromNodes() {
        int curSize = this.m_nodes.size();
        int i = this.origNodesSize;
        while (i < curSize) {
            this.m_nodes.removeElementAt(this.origNodesSize);
            ++i;
        }
        int j = 0;
        while (j < this.m_nodes.size()) {
            ((GraphNode)this.m_nodes.elementAt((int)j)).edges = null;
            ++j;
        }
        this.nodeLevels = null;
    }

    protected void processGraph() {
        this.origNodesSize = this.m_nodes.size();
        this.graphMatrix = new int[this.m_nodes.size()][this.m_nodes.size()];
        int i = 0;
        while (i < this.m_edges.size()) {
            this.graphMatrix[((GraphEdge)this.m_edges.elementAt((int)i)).src][((GraphEdge)this.m_edges.elementAt((int)i)).dest] = ((GraphEdge)this.m_edges.elementAt((int)i)).type;
            ++i;
        }
    }

    protected void makeProperHierarchy() {
        this.processGraph();
        this.m_progress.setValue(1);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_First"));
        this.removeCycles();
        this.m_progress.setValue(2);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_Second"));
        int[] nodesLevel = new int[this.m_nodes.size()];
        int depth = 0;
        int i = 0;
        while (i < this.graphMatrix.length) {
            this.assignLevels(nodesLevel, depth, i, 0);
            ++i;
        }
        i = 0;
        while (i < nodesLevel.length) {
            if (nodesLevel[i] == 0) {
                int min = 65536;
                int j = 0;
                while (j < this.graphMatrix[i].length) {
                    if (this.graphMatrix[i][j] == 1 && min > nodesLevel[j]) {
                        min = nodesLevel[j];
                    }
                    ++j;
                }
                if (min != 65536 && min > 1) {
                    nodesLevel[i] = min - 1;
                }
            }
            ++i;
        }
        int maxLevel = 0;
        int i2 = 0;
        while (i2 < nodesLevel.length) {
            if (nodesLevel[i2] > maxLevel) {
                maxLevel = nodesLevel[i2];
            }
            ++i2;
        }
        int[] levelCounts = new int[maxLevel + 1];
        int i3 = 0;
        while (i3 < nodesLevel.length) {
            int n = nodesLevel[i3];
            levelCounts[n] = levelCounts[n] + 1;
            ++i3;
        }
        int[] levelsCounter = new int[maxLevel + 1];
        this.nodeLevels = new int[maxLevel + 1][];
        int i4 = 0;
        while (i4 < nodesLevel.length) {
            if (this.nodeLevels[nodesLevel[i4]] == null) {
                this.nodeLevels[nodesLevel[i4]] = new int[levelCounts[nodesLevel[i4]]];
            }
            int n = nodesLevel[i4];
            int n2 = levelsCounter[n];
            levelsCounter[n] = n2 + 1;
            this.nodeLevels[nodesLevel[i4]][n2] = i4;
            ++i4;
        }
        this.m_progress.setValue(3);
        Messages.getInstance();
        this.m_progress.setString(Messages.getString("HierarchicalBCEngine_MakeProperHierarchy_Progress_SetString_Text_Third"));
        if (this.m_jCbEdgeConcentration.isSelected()) {
            this.removeGapsWithEdgeConcentration(nodesLevel);
        } else {
            this.removeGaps(nodesLevel);
        }
        i4 = 0;
        while (i4 < this.graphMatrix.length) {
            GraphNode n = (GraphNode)this.m_nodes.elementAt(i4);
            int sum = 0;
            int j = 0;
            while (j < this.graphMatrix[i4].length) {
                if (this.graphMatrix[i4][j] != 0) {
                    ++sum;
                }
                ++j;
            }
            n.edges = new int[sum][2];
            j = 0;
            int k = 0;
            while (j < this.graphMatrix[i4].length) {
                if (this.graphMatrix[i4][j] != 0) {
                    n.edges[k][0] = j;
                    n.edges[k][1] = this.graphMatrix[i4][j];
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
    }

    private void removeGaps(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        int n = 0;
        while (n < temp) {
            int i = 0;
            while (i < temp2) {
                int len = this.graphMatrix.length;
                if (this.graphMatrix[n][i] > 0) {
                    if (nodesLevel[i] > nodesLevel[n] + 1) {
                        int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i] - nodesLevel[n] - 1)][this.graphMatrix.length + (nodesLevel[i] - nodesLevel[n] - 1)];
                        int level = nodesLevel[n] + 1;
                        this.copyMatrix(this.graphMatrix, tempMatrix);
                        String s1 = new String("S" + tempCnt++);
                        this.m_nodes.addElement(new GraphNode(s1, s1, 1));
                        int[] temp3 = new int[this.nodeLevels[level].length + 1];
                        System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                        temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[level] = temp3;
                        ++level;
                        int k = len;
                        while (k < len + nodesLevel[i] - nodesLevel[n] - 1 - 1) {
                            String s2 = new String("S" + tempCnt);
                            this.m_nodes.addElement(new GraphNode(s2, s2, 1));
                            temp3 = new int[this.nodeLevels[level].length + 1];
                            System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                            temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                            this.nodeLevels[level++] = temp3;
                            tempMatrix[k][k + 1] = tempMatrix[n][i];
                            ++tempCnt;
                            if (k > len) {
                                tempMatrix[k][k - 1] = -1 * tempMatrix[n][i];
                            }
                            ++k;
                        }
                        tempMatrix[k][i] = tempMatrix[n][i];
                        tempMatrix[n][len] = tempMatrix[n][i];
                        tempMatrix[len][n] = -1 * tempMatrix[n][i];
                        tempMatrix[i][k] = -1 * tempMatrix[n][i];
                        if (k > len) {
                            tempMatrix[k][k - 1] = -1 * tempMatrix[n][i];
                        }
                        tempMatrix[n][i] = 0;
                        tempMatrix[i][n] = 0;
                        this.graphMatrix = tempMatrix;
                    } else {
                        this.graphMatrix[i][n] = -1 * this.graphMatrix[n][i];
                    }
                }
                ++i;
            }
            ++n;
        }
    }

    private void removeGapsWithEdgeConcentration(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        int n = 0;
        while (n < temp) {
            int i = 0;
            while (i < temp2) {
                if (this.graphMatrix[n][i] > 0) {
                    if (nodesLevel[i] > nodesLevel[n] + 1) {
                        boolean tempNodePresent = false;
                        int k = temp;
                        int tempnode = n;
                        for (int tempLevel = nodesLevel[n]; tempLevel < nodesLevel[i] - 1; ++tempLevel) {
                            tempNodePresent = false;
                            while (k < this.graphMatrix.length) {
                                if (this.graphMatrix[tempnode][k] > 0) {
                                    tempNodePresent = true;
                                    break;
                                }
                                ++k;
                            }
                            if (tempNodePresent) {
                                tempnode = k++;
                                continue;
                            }
                            if (tempnode == n) break;
                            tempnode = k - 1;
                            break;
                        }
                        if (((GraphNode)this.m_nodes.elementAt((int)tempnode)).nodeType == 1) {
                            ((GraphNode)this.m_nodes.elementAt((int)tempnode)).nodeType = 2;
                        }
                        if (tempNodePresent) {
                            this.graphMatrix[tempnode][i] = this.graphMatrix[n][i];
                            this.graphMatrix[i][tempnode] = -this.graphMatrix[n][i];
                            this.graphMatrix[n][i] = 0;
                            this.graphMatrix[i][n] = 0;
                        } else {
                            int len = this.graphMatrix.length;
                            int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i] - nodesLevel[tempnode] - 1)][this.graphMatrix.length + (nodesLevel[i] - nodesLevel[tempnode] - 1)];
                            int level = nodesLevel[tempnode] + 1;
                            this.copyMatrix(this.graphMatrix, tempMatrix);
                            String s1 = new String("S" + tempCnt++);
                            this.m_nodes.addElement(new GraphNode(s1, s1, 1));
                            int[] temp3 = new int[this.nodeLevels[level].length + 1];
                            System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                            temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                            this.nodeLevels[level] = temp3;
                            temp3 = new int[this.m_nodes.size() + 1];
                            System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                            temp3[this.m_nodes.size() - 1] = level++;
                            nodesLevel = temp3;
                            int m = len;
                            while (m < len + nodesLevel[i] - nodesLevel[tempnode] - 1 - 1) {
                                String s2 = new String("S" + tempCnt++);
                                this.m_nodes.addElement(new GraphNode(s2, s2, 1));
                                temp3 = new int[this.nodeLevels[level].length + 1];
                                System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                                temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                                this.nodeLevels[level] = temp3;
                                temp3 = new int[this.m_nodes.size() + 1];
                                System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                                temp3[this.m_nodes.size() - 1] = level++;
                                nodesLevel = temp3;
                                tempMatrix[m][m + 1] = tempMatrix[n][i];
                                if (m > len) {
                                    tempMatrix[m][m - 1] = -1 * tempMatrix[n][i];
                                }
                                ++m;
                            }
                            tempMatrix[m][i] = tempMatrix[n][i];
                            tempMatrix[tempnode][len] = tempMatrix[n][i];
                            tempMatrix[len][tempnode] = -1 * tempMatrix[n][i];
                            tempMatrix[i][m] = -1 * tempMatrix[n][i];
                            if (m > len) {
                                tempMatrix[m][m - 1] = -1 * tempMatrix[n][i];
                            }
                            tempMatrix[n][i] = 0;
                            tempMatrix[i][n] = 0;
                            this.graphMatrix = tempMatrix;
                        }
                    } else {
                        this.graphMatrix[i][n] = -1 * this.graphMatrix[n][i];
                    }
                }
                ++i;
            }
            ++n;
        }
    }

    private int indexOfElementInLevel(int element, int[] level) throws Exception {
        int i = 0;
        while (i < level.length) {
            if (level[i] == element) {
                return i;
            }
            ++i;
        }
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchicalBCEngine_IndexOfElementInLevel_Exception_Text_First"))).append(((GraphNode)this.m_nodes.elementAt((int)element)).ID);
        Messages.getInstance();
        throw new Exception(stringBuilder.append(Messages.getString("HierarchicalBCEngine_IndexOfElementInLevel_Exception_Text_Second")).append("weka.gui.graphvisualizer.HierarchicalBCEngine").toString());
    }

    protected int crossings(int[][] levels) {
        int sum = 0;
        int i = 0;
        while (i < levels.length - 1) {
            MyList upper = new MyList();
            MyList lower = new MyList();
            MyListNode[] lastOcrnce = new MyListNode[this.m_nodes.size()];
            int[] edgeOcrnce = new int[this.m_nodes.size()];
            int j = 0;
            int uidx = 0;
            int lidx = 0;
            while (j < levels[i].length + levels[i + 1].length) {
                MyListNode temp;
                int k;
                GraphNode n;
                int k3;
                int k2;
                int k1;
                if (j % 2 == 0 && uidx < levels[i].length || lidx >= levels[i + 1].length) {
                    k1 = 0;
                    k2 = 0;
                    k3 = 0;
                    n = (GraphNode)this.m_nodes.elementAt(levels[i][uidx]);
                    if (lastOcrnce[levels[i][uidx]] != null) {
                        MyListNode temp2 = new MyListNode(-1);
                        temp2.next = upper.first;
                        try {
                            do {
                                temp2 = temp2.next;
                                if (levels[i][uidx] == temp2.n) {
                                    ++k1;
                                    k3 += k2;
                                    upper.remove(temp2);
                                    continue;
                                }
                                ++k2;
                            } while (temp2 != lastOcrnce[levels[i][uidx]]);
                        }
                        catch (NullPointerException ex) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_First"))).append(levels[i][uidx]);
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Second")).append(((GraphNode)this.m_nodes.elementAt((int)levels[i][uidx])).ID);
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Third")).append(temp2);
                            Messages.getInstance();
                            System.out.println(stringBuilder3.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Fourth")).append(upper.first).toString());
                            ex.printStackTrace();
                            System.exit(-1);
                        }
                        lastOcrnce[levels[i][uidx]] = null;
                        sum = sum + k1 * lower.size() + k3;
                    }
                    k = 0;
                    while (k < n.edges.length) {
                        if (n.edges[k][1] > 0) {
                            try {
                                if (this.indexOfElementInLevel(n.edges[k][0], levels[i + 1]) >= uidx) {
                                    edgeOcrnce[n.edges[k][0]] = 1;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < levels[i + 1].length) {
                        if (edgeOcrnce[levels[i + 1][k]] == 1) {
                            temp = new MyListNode(levels[i + 1][k]);
                            lower.add(temp);
                            lastOcrnce[levels[i + 1][k]] = temp;
                            edgeOcrnce[levels[i + 1][k]] = 0;
                        }
                        ++k;
                    }
                    ++uidx;
                } else {
                    k1 = 0;
                    k2 = 0;
                    k3 = 0;
                    n = (GraphNode)this.m_nodes.elementAt(levels[i + 1][lidx]);
                    if (lastOcrnce[levels[i + 1][lidx]] != null) {
                        MyListNode temp3 = new MyListNode(-1);
                        temp3.next = lower.first;
                        try {
                            do {
                                temp3 = temp3.next;
                                if (levels[i + 1][lidx] == temp3.n) {
                                    ++k1;
                                    k3 += k2;
                                    lower.remove(temp3);
                                    continue;
                                }
                                ++k2;
                            } while (temp3 != lastOcrnce[levels[i + 1][lidx]]);
                        }
                        catch (NullPointerException ex) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Fifth"))).append(levels[i + 1][lidx]);
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Sixth")).append(((GraphNode)this.m_nodes.elementAt((int)levels[i + 1][lidx])).ID);
                            Messages.getInstance();
                            System.out.print(stringBuilder4.append(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Seventh")).append(temp3).toString());
                            Messages.getInstance();
                            System.out.println(String.valueOf(Messages.getString("HierarchicalBCEngine_Crossings_Exception_Text_Eighth")) + lower.first);
                            ex.printStackTrace();
                            System.exit(-1);
                        }
                        lastOcrnce[levels[i + 1][lidx]] = null;
                        sum = sum + k1 * upper.size() + k3;
                    }
                    k = 0;
                    while (k < n.edges.length) {
                        if (n.edges[k][1] < 0) {
                            try {
                                if (this.indexOfElementInLevel(n.edges[k][0], levels[i]) > lidx) {
                                    edgeOcrnce[n.edges[k][0]] = 1;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < levels[i].length) {
                        if (edgeOcrnce[levels[i][k]] == 1) {
                            temp = new MyListNode(levels[i][k]);
                            upper.add(temp);
                            lastOcrnce[levels[i][k]] = temp;
                            edgeOcrnce[levels[i][k]] = 0;
                        }
                        ++k;
                    }
                    ++lidx;
                }
                ++j;
            }
            ++i;
        }
        return sum;
    }

    protected void removeCycles() {
        int[] visited = new int[this.m_nodes.size()];
        int i = 0;
        while (i < this.graphMatrix.length) {
            if (visited[i] == 0) {
                this.removeCycles2(i, visited);
                visited[i] = 1;
            }
            ++i;
        }
    }

    private void removeCycles2(int nindex, int[] visited) {
        visited[nindex] = 2;
        int i = 0;
        while (i < this.graphMatrix[nindex].length) {
            if (this.graphMatrix[nindex][i] == 1) {
                if (visited[i] == 0) {
                    this.removeCycles2(i, visited);
                    visited[i] = 1;
                } else if (visited[i] == 2) {
                    if (nindex == i) {
                        this.graphMatrix[nindex][i] = 0;
                    } else if (this.graphMatrix[i][nindex] == 1) {
                        this.graphMatrix[i][nindex] = 3;
                        this.graphMatrix[nindex][i] = -3;
                    } else {
                        this.graphMatrix[i][nindex] = 2;
                        this.graphMatrix[nindex][i] = -2;
                    }
                }
            }
            ++i;
        }
    }

    protected void assignLevels(int[] levels, int depth, int i, int j) {
        if (i >= this.graphMatrix.length) {
            return;
        }
        if (j >= this.graphMatrix[i].length) {
            return;
        }
        if (this.graphMatrix[i][j] <= 0) {
            this.assignLevels(levels, depth, i, ++j);
        } else if (this.graphMatrix[i][j] == 1 || this.graphMatrix[i][j] == 3) {
            if (depth + 1 > levels[j]) {
                levels[j] = depth + 1;
                this.assignLevels(levels, depth + 1, j, 0);
            }
            this.assignLevels(levels, depth, i, ++j);
        }
    }

    private int[][] minimizeCrossings(boolean reversed, int[][] nodeLevels) {
        if (!reversed) {
            int times = 0;
            while (times < 1) {
                int[][] tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                int i = 0;
                while (i < ((int[][])nodeLevels).length - 1) {
                    this.phaseID(i, tempLevels);
                    ++i;
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                i = ((int[][])nodeLevels).length - 2;
                while (i >= 0) {
                    this.phaseIU(i, tempLevels);
                    --i;
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                i = 0;
                while (i < ((int[][])nodeLevels).length - 1) {
                    this.phaseIID(i, tempLevels);
                    ++i;
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                i = ((int[][])nodeLevels).length - 2;
                while (i >= 0) {
                    this.phaseIIU(i, tempLevels);
                    --i;
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                ++times;
            }
            return nodeLevels;
        }
        int times = 0;
        while (times < 1) {
            int[][] tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            int i = ((int[][])nodeLevels).length - 2;
            while (i >= 0) {
                this.phaseIU(i, tempLevels);
                --i;
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            i = 0;
            while (i < ((int[][])nodeLevels).length - 1) {
                this.phaseID(i, tempLevels);
                ++i;
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            i = ((int[][])nodeLevels).length - 2;
            while (i >= 0) {
                this.phaseIIU(i, tempLevels);
                --i;
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            i = 0;
            while (i < ((int[][])nodeLevels).length - 1) {
                this.phaseIID(i, tempLevels);
                ++i;
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            ++times;
        }
        return nodeLevels;
    }

    protected void phaseID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex + 1], colBC);
    }

    public void phaseIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex], rowBC);
    }

    public void phaseIID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        int i = 0;
        while (i < colBC.length - 1) {
            if (colBC[i] == colBC[i + 1]) {
                int[][] tempLevels = new int[levels.length][];
                this.copy2DArray(levels, tempLevels);
                int node1 = levels[lindex + 1][i];
                int node2 = levels[lindex + 1][i + 1];
                levels[lindex + 1][i + 1] = node1;
                levels[lindex + 1][i] = node2;
                int k = lindex + 1;
                while (k < levels.length - 1) {
                    this.phaseID(k, levels);
                    ++k;
                }
                if (this.crossings(levels) <= this.crossings(tempLevels)) {
                    this.copy2DArray(levels, tempLevels);
                } else {
                    this.copy2DArray(tempLevels, levels);
                    levels[lindex + 1][i + 1] = node1;
                    levels[lindex + 1][i] = node2;
                }
                k = levels.length - 2;
                while (k >= 0) {
                    this.phaseIU(k, levels);
                    --k;
                }
                if (this.crossings(tempLevels) < this.crossings(levels)) {
                    this.copy2DArray(tempLevels, levels);
                }
            }
            ++i;
        }
    }

    public void phaseIIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        int i = 0;
        while (i < rowBC.length - 1) {
            if (rowBC[i] == rowBC[i + 1]) {
                int[][] tempLevels = new int[levels.length][];
                this.copy2DArray(levels, tempLevels);
                int node1 = levels[lindex][i];
                int node2 = levels[lindex][i + 1];
                levels[lindex][i + 1] = node1;
                levels[lindex][i] = node2;
                int k = lindex - 1;
                while (k >= 0) {
                    this.phaseIU(k, levels);
                    --k;
                }
                if (this.crossings(levels) <= this.crossings(tempLevels)) {
                    this.copy2DArray(levels, tempLevels);
                } else {
                    this.copy2DArray(tempLevels, levels);
                    levels[lindex][i + 1] = node1;
                    levels[lindex][i] = node2;
                }
                k = 0;
                while (k < levels.length - 1) {
                    this.phaseID(k, levels);
                    ++k;
                }
                if (this.crossings(tempLevels) <= this.crossings(levels)) {
                    this.copy2DArray(tempLevels, levels);
                }
            }
            ++i;
        }
    }

    protected float[] calcRowBC(int lindex, int[][] levels) {
        float[] rowBC = new float[levels[lindex].length];
        int i = 0;
        while (i < levels[lindex].length) {
            int sum = 0;
            GraphNode n = (GraphNode)this.m_nodes.elementAt(levels[lindex][i]);
            int j = 0;
            while (j < n.edges.length) {
                if (n.edges[j][1] > 0) {
                    ++sum;
                    try {
                        rowBC[i] = rowBC[i] + (float)this.indexOfElementInLevel(n.edges[j][0], levels[lindex + 1]) + 1.0f;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                ++j;
            }
            if (rowBC[i] != 0.0f) {
                rowBC[i] = rowBC[i] / (float)sum;
            }
            ++i;
        }
        return rowBC;
    }

    protected float[] calcColBC(int lindex, int[][] levels) {
        float[] colBC = new float[levels[lindex + 1].length];
        int i = 0;
        while (i < levels[lindex + 1].length) {
            int sum = 0;
            GraphNode n = (GraphNode)this.m_nodes.elementAt(levels[lindex + 1][i]);
            int j = 0;
            while (j < n.edges.length) {
                if (n.edges[j][1] < 1) {
                    ++sum;
                    try {
                        colBC[i] = colBC[i] + (float)this.indexOfElementInLevel(n.edges[j][0], levels[lindex]) + 1.0f;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                ++j;
            }
            if (colBC[i] != 0.0f) {
                colBC[i] = colBC[i] / (float)sum;
            }
            ++i;
        }
        return colBC;
    }

    protected void printMatrices(int[][] levels) {
        int i = 0;
        i = 0;
        while (i < levels.length - 1) {
            float[] rowBC = null;
            float[] colBC = null;
            try {
                rowBC = this.calcRowBC(i, levels);
                colBC = this.calcColBC(i, levels);
            }
            catch (NullPointerException ne) {
                System.out.println("i: " + i + " levels.length: " + levels.length);
                ne.printStackTrace();
                return;
            }
            System.out.print("\nM" + (i + 1) + "\t");
            int j = 0;
            while (j < levels[i + 1].length) {
                System.out.print(String.valueOf(((GraphNode)this.m_nodes.elementAt((int)levels[i + 1][j])).ID) + " ");
                ++j;
            }
            System.out.println("");
            j = 0;
            while (j < levels[i].length) {
                System.out.print(String.valueOf(((GraphNode)this.m_nodes.elementAt((int)levels[i][j])).ID) + "\t");
                int k = 0;
                while (k < levels[i + 1].length) {
                    System.out.print(String.valueOf(this.graphMatrix[levels[i][j]][levels[i + 1][k]]) + " ");
                    ++k;
                }
                System.out.println(rowBC[j]);
                ++j;
            }
            System.out.print("\t");
            int k = 0;
            while (k < levels[i + 1].length) {
                System.out.print(String.valueOf(colBC[k]) + " ");
                ++k;
            }
            ++i;
        }
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchicalBCEngine_PrintMatrices_Text_Second"))).append(i);
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("HierarchicalBCEngine_PrintMatrices_Text_First")).append(levels.length).toString());
    }

    protected static void isort(int[] level, float[] BC) {
        int i = 0;
        while (i < BC.length - 1) {
            int j = i;
            float temp = BC[j + 1];
            int temp2 = level[j + 1];
            if (temp != 0.0f) {
                int prej = j + 1;
                while (j > -1 && (temp < BC[j] || BC[j] == 0.0f)) {
                    if (BC[j] == 0.0f) {
                        --j;
                        continue;
                    }
                    BC[prej] = BC[j];
                    level[prej] = level[j];
                    prej = j--;
                }
                BC[prej] = temp;
                level[prej] = temp2;
            }
            ++i;
        }
    }

    protected void copyMatrix(int[][] from, int[][] to) {
        int i = 0;
        while (i < from.length) {
            int j = 0;
            while (j < from[i].length) {
                to[i][j] = from[i][j];
                ++j;
            }
            ++i;
        }
    }

    protected void copy2DArray(int[][] from, int[][] to) {
        int i = 0;
        while (i < from.length) {
            to[i] = new int[from[i].length];
            System.arraycopy(from[i], 0, to[i], 0, from[i].length);
            ++i;
        }
    }

    protected void naiveLayout() {
        if (this.nodeLevels == null) {
            this.makeProperHierarchy();
        }
        int i = 0;
        int temp = 0;
        while (i < this.nodeLevels.length) {
            int j = 0;
            while (j < this.nodeLevels[i].length) {
                temp = this.nodeLevels[i][j];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = j * this.m_nodeWidth;
                n.y = i * 3 * this.m_nodeHeight;
                ++j;
            }
            ++i;
        }
    }

    protected int uConnectivity(int lindex, int eindex) {
        int n = 0;
        int i = 0;
        while (i < this.nodeLevels[lindex - 1].length) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i]][this.nodeLevels[lindex][eindex]] > 0) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    protected int lConnectivity(int lindex, int eindex) {
        int n = 0;
        int i = 0;
        while (i < this.nodeLevels[lindex + 1].length) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i]] > 0) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    protected int uBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        int i = 0;
        while (i < this.nodeLevels[lindex - 1].length) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i]][this.nodeLevels[lindex][eindex]] > 0) {
                sum += horPositions[this.nodeLevels[lindex - 1][i]];
            }
            ++i;
        }
        if (sum != 0) {
            sum /= this.uConnectivity(lindex, eindex);
        }
        return sum;
    }

    protected int lBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        int i = 0;
        while (i < this.nodeLevels[lindex + 1].length) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i]] > 0) {
                sum += horPositions[this.nodeLevels[lindex + 1][i]];
            }
            ++i;
        }
        if (sum != 0) {
            sum /= this.lConnectivity(lindex, eindex);
        }
        return sum;
    }

    private void tempMethod(int[] horPositions) {
        int minPosition = horPositions[0];
        int i = 0;
        while (i < horPositions.length) {
            if (horPositions[i] < minPosition) {
                minPosition = horPositions[i];
            }
            ++i;
        }
        if (minPosition < 0) {
            minPosition *= -1;
            i = 0;
            while (i < horPositions.length) {
                int n = i++;
                horPositions[n] = horPositions[n] + minPosition;
            }
        }
        i = 0;
        int temp = 0;
        while (i < this.nodeLevels.length) {
            int j = 0;
            while (j < this.nodeLevels[i].length) {
                temp = this.nodeLevels[i][j];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = horPositions[temp] * this.m_nodeWidth;
                n.y = i * 3 * this.m_nodeHeight;
                ++j;
            }
            ++i;
        }
    }

    protected void priorityLayout1() {
        int j;
        int[] horPositions = new int[this.m_nodes.size()];
        int maxCount = 0;
        int i = 0;
        while (i < this.nodeLevels.length) {
            int count = 0;
            int j2 = 0;
            while (j2 < this.nodeLevels[i].length) {
                horPositions[this.nodeLevels[i][j2]] = j2;
                ++count;
                ++j2;
            }
            if (count > maxCount) {
                maxCount = count;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < this.nodeLevels.length) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            j = 0;
            while (j < this.nodeLevels[i2].length) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
                ++j;
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
            ++i2;
        }
        i2 = this.nodeLevels.length - 2;
        while (i2 >= 0) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            j = 0;
            while (j < this.nodeLevels[i2].length) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.lConnectivity(i2, j);
                BC[j] = this.lBCenter(i2, j, horPositions);
                ++j;
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
            --i2;
        }
        i2 = 2;
        while (i2 < this.nodeLevels.length) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            j = 0;
            while (j < this.nodeLevels[i2].length) {
                priorities[j] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[i2][j])).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
                ++j;
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
            ++i2;
        }
        int minPosition = horPositions[0];
        int i3 = 0;
        while (i3 < horPositions.length) {
            if (horPositions[i3] < minPosition) {
                minPosition = horPositions[i3];
            }
            ++i3;
        }
        if (minPosition < 0) {
            minPosition *= -1;
            i3 = 0;
            while (i3 < horPositions.length) {
                int n = i3++;
                horPositions[n] = horPositions[n] + minPosition;
            }
        }
        i3 = 0;
        int temp = 0;
        while (i3 < this.nodeLevels.length) {
            int j3 = 0;
            while (j3 < this.nodeLevels[i3].length) {
                temp = this.nodeLevels[i3][j3];
                GraphNode n = (GraphNode)this.m_nodes.elementAt(temp);
                n.x = horPositions[temp] * this.m_nodeWidth;
                n.y = i3 * 3 * this.m_nodeHeight;
                ++j3;
            }
            ++i3;
        }
    }

    private void priorityLayout2(int[] level, int[] priorities, int[] bCenters, int[] horPositions) {
        int[] descOrder = new int[priorities.length];
        descOrder[0] = 0;
        int i = 0;
        while (i < priorities.length - 1) {
            int j = i;
            int temp = i + 1;
            while (j > -1 && priorities[descOrder[j]] < priorities[temp]) {
                descOrder[j + 1] = descOrder[j];
                --j;
            }
            descOrder[++j] = temp;
            ++i;
        }
        int k = 0;
        while (k < descOrder.length) {
            int i2 = 0;
            while (i2 < descOrder.length) {
                int j;
                boolean cantMove;
                int temp;
                int leftCount = 0;
                int rightCount = 0;
                int j2 = 0;
                while (j2 < priorities.length) {
                    if (horPositions[level[descOrder[i2]]] > horPositions[level[j2]]) {
                        ++leftCount;
                    } else if (horPositions[level[descOrder[i2]]] < horPositions[level[j2]]) {
                        ++rightCount;
                    }
                    ++j2;
                }
                int[] leftNodes = new int[leftCount];
                int[] rightNodes = new int[rightCount];
                j2 = 0;
                int l = 0;
                int r = 0;
                while (j2 < priorities.length) {
                    if (horPositions[level[descOrder[i2]]] > horPositions[level[j2]]) {
                        leftNodes[l++] = j2;
                    } else if (horPositions[level[descOrder[i2]]] < horPositions[level[j2]]) {
                        rightNodes[r++] = j2;
                    }
                    ++j2;
                }
                while (Math.abs(horPositions[level[descOrder[i2]]] - 1 - bCenters[descOrder[i2]]) < Math.abs(horPositions[level[descOrder[i2]]] - bCenters[descOrder[i2]])) {
                    temp = horPositions[level[descOrder[i2]]];
                    cantMove = false;
                    j = leftNodes.length - 1;
                    while (j >= 0) {
                        if (temp - horPositions[level[leftNodes[j]]] > 1) break;
                        if (priorities[descOrder[i2]] <= priorities[leftNodes[j]]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[leftNodes[j]]];
                        --j;
                    }
                    if (cantMove) break;
                    temp = horPositions[level[descOrder[i2]]] - 1;
                    j = leftNodes.length - 1;
                    while (j >= 0) {
                        if (temp == horPositions[level[leftNodes[j]]]) {
                            horPositions[level[leftNodes[j]]] = temp = horPositions[level[leftNodes[j]]] - 1;
                        }
                        --j;
                    }
                    horPositions[level[descOrder[i2]]] = horPositions[level[descOrder[i2]]] - 1;
                }
                while (Math.abs(horPositions[level[descOrder[i2]]] + 1 - bCenters[descOrder[i2]]) < Math.abs(horPositions[level[descOrder[i2]]] - bCenters[descOrder[i2]])) {
                    temp = horPositions[level[descOrder[i2]]];
                    cantMove = false;
                    j = 0;
                    while (j < rightNodes.length) {
                        if (horPositions[level[rightNodes[j]]] - temp > 1) break;
                        if (priorities[descOrder[i2]] <= priorities[rightNodes[j]]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[rightNodes[j]]];
                        ++j;
                    }
                    if (cantMove) break;
                    temp = horPositions[level[descOrder[i2]]] + 1;
                    j = 0;
                    while (j < rightNodes.length) {
                        if (temp == horPositions[level[rightNodes[j]]]) {
                            horPositions[level[rightNodes[j]]] = temp = horPositions[level[rightNodes[j]]] + 1;
                        }
                        ++j;
                    }
                    horPositions[level[descOrder[i2]]] = horPositions[level[descOrder[i2]]] + 1;
                }
                ++i2;
            }
            ++k;
        }
    }

    private class MyList {
        int size;
        MyListNode first = null;
        MyListNode last = null;

        private MyList() {
        }

        public void add(int i) {
            if (this.first == null) {
                this.first = this.last = new MyListNode(i);
            } else if (this.last.next == null) {
                this.last.next = new MyListNode(i);
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("HierarchicalBCEngine_MyList_Add_Error_Text_First"));
                --this.size;
            }
            ++this.size;
        }

        public void add(MyListNode n) {
            if (this.first == null) {
                this.first = this.last = n;
            } else if (this.last.next == null) {
                this.last.next = n;
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("HierarchicalBCEngine_MyList_Add_Error_Text_Second"));
                --this.size;
            }
            ++this.size;
        }

        public void remove(MyListNode n) {
            if (n.previous != null) {
                n.previous.next = n.next;
            }
            if (n.next != null) {
                n.next.previous = n.previous;
            }
            if (this.last == n) {
                this.last = n.previous;
            }
            if (this.first == n) {
                this.first = n.next;
            }
            --this.size;
        }

        public void remove(int i) {
            MyListNode temp = this.first;
            while (temp != null && temp.n != i) {
                temp = temp.next;
            }
            if (temp == null) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("HierarchicalBCEngine_MyList_Remove_Error_Text_First"))).append(i);
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("HierarchicalBCEngine_MyList_Remove_Error_Text_Second")).toString());
                return;
            }
            if (temp.previous != null) {
                temp.previous.next = temp.next;
            }
            if (temp.next != null) {
                temp.next.previous = temp.previous;
            }
            if (this.last == temp) {
                this.last = temp.previous;
            }
            if (this.first == temp) {
                this.first = temp.next;
            }
            --this.size;
        }

        public int size() {
            return this.size;
        }
    }

    private class MyListNode {
        int n;
        MyListNode next;
        MyListNode previous;

        public MyListNode(int i) {
            this.n = i;
            this.next = null;
            this.previous = null;
        }
    }
}

