/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import weka.core.Capabilities;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.LookAndFeel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.Messages;
import weka.gui.explorer.PreprocessPanel;

public class Explorer
extends JPanel {
    private static final long serialVersionUID = -7674003708867909578L;
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected Vector<ExplorerPanel> m_Panels = new Vector();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    protected HashSet<CapabilitiesFilterChangeListener> m_CapabilitiesFilterChangeListeners = new HashSet();
    private static Explorer m_explorer;
    protected static Memory m_Memory;

    static {
        m_Memory = new Memory(true);
    }

    public Explorer() {
        String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        Messages.getInstance();
        this.m_LogPanel.logMessage(Messages.getString("Explorer_LogPanel_LogMessage_Text_First"));
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Explorer_LogPanel_LogMessage_Text_Second"))).append(Copyright.getFromYear());
        Messages.getInstance();
        this.m_LogPanel.logMessage(stringBuilder.append(Messages.getString("Explorer_LogPanel_LogMessage_Text_Third")).append(Copyright.getToYear()).append(" ").append(Copyright.getOwner()).append(", ").append(Copyright.getAddress()).toString());
        Messages.getInstance();
        this.m_LogPanel.logMessage(String.valueOf(Messages.getString("Explorer_LogPanel_LogMessage_Text_Fourth")) + Copyright.getURL());
        Messages.getInstance();
        this.m_LogPanel.logMessage(String.valueOf(Messages.getString("Explorer_LogPanel_LogMessage_Text_Fifth")) + date);
        Messages.getInstance();
        this.m_LogPanel.statusMessage(Messages.getString("Explorer_LogPanel_StatusMessage_Text_First"));
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab(this.m_PreprocessPanel.getTabTitle(), null, this.m_PreprocessPanel, this.m_PreprocessPanel.getTabTitleToolTip());
        String[] tabs = ExplorerDefaults.getTabs();
        Hashtable tabOptions = new Hashtable();
        String[] stringArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            String tab = stringArray[n2];
            try {
                String[] optionsStr = tab.split(":");
                String classname = optionsStr[0];
                HashSet<String> options = new HashSet<String>();
                tabOptions.put(classname, options);
                int n3 = 1;
                while (n3 < optionsStr.length) {
                    options.add(optionsStr[n3]);
                    ++n3;
                }
                ExplorerPanel panel = (ExplorerPanel)Class.forName(classname).newInstance();
                panel.setExplorer(this);
                this.m_Panels.add(panel);
                if (panel instanceof LogHandler) {
                    ((LogHandler)((Object)panel)).setLog(this.m_LogPanel);
                }
                this.m_TabbedPane.addTab(panel.getTabTitle(), null, (JPanel)((Object)panel), panel.getTabTitleToolTip());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.m_TabbedPane.setSelectedIndex(0);
        int i = 0;
        while (i < this.m_Panels.size()) {
            HashSet options = (HashSet)tabOptions.get(this.m_Panels.get(i).getClass().getName());
            this.m_TabbedPane.setEnabledAt(i + 1, options.contains("standalone"));
            ++i;
        }
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int i = 0;
                while (i < Explorer.this.m_Panels.size()) {
                    Explorer.this.m_Panels.get(i).setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                    Explorer.this.m_TabbedPane.setEnabledAt(i + 1, true);
                    ++i;
                }
            }
        });
        this.m_PreprocessPanel.setExplorer(this);
        this.addCapabilitiesFilterListener(this.m_PreprocessPanel);
        i = 0;
        while (i < this.m_Panels.size()) {
            if (this.m_Panels.get(i) instanceof CapabilitiesFilterChangeListener) {
                this.addCapabilitiesFilterListener((CapabilitiesFilterChangeListener)((Object)this.m_Panels.get(i)));
            }
            ++i;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
    }

    public Vector<ExplorerPanel> getPanels() {
        return this.m_Panels;
    }

    public PreprocessPanel getPreprocessPanel() {
        return this.m_PreprocessPanel;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public void addCapabilitiesFilterListener(CapabilitiesFilterChangeListener l) {
        this.m_CapabilitiesFilterChangeListeners.add(l);
    }

    public boolean removeCapabilitiesFilterListener(CapabilitiesFilterChangeListener l) {
        return this.m_CapabilitiesFilterChangeListeners.remove(l);
    }

    public void notifyCapabilitiesFilterListener(Capabilities filter) {
        for (CapabilitiesFilterChangeListener l : this.m_CapabilitiesFilterChangeListeners) {
            if (l == this) continue;
            l.capabilitiesFilterChanged(new CapabilitiesFilterChangeEvent(this, filter));
        }
    }

    public static void main(String[] args) {
        Messages.getInstance();
        weka.core.logging.Logger.log(Logger.Level.INFO, Messages.getString("Explorer_Main_Logger_Text"));
        LookAndFeel.setLookAndFeel();
        try {
            m_explorer = new Explorer();
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("Explorer_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)m_explorer, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            Image icon = Toolkit.getDefaultToolkit().getImage(m_explorer.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            if (args.length == 1) {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("Explorer_Main_Run_Error_Text")) + args[0]);
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile(args[0]);
                loader.setFile(new File(args[0]));
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile(loader);
            }
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        jf.dispose();
                        m_explorer = null;
                        System.gc();
                        Messages.getInstance();
                        System.err.println(Messages.getString("Explorer_Main_Run_Error_Text_First"));
                        m_Memory.showOutOfMemory();
                        Messages.getInstance();
                        System.err.println(Messages.getString("Explorer_Main_Run_Error_Text_Second"));
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class CapabilitiesFilterChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1194260517270385559L;
        protected Capabilities m_Filter;

        public CapabilitiesFilterChangeEvent(Object source, Capabilities filter) {
            super(source);
            this.m_Filter = filter;
        }

        public Capabilities getFilter() {
            return this.m_Filter;
        }
    }

    public static interface CapabilitiesFilterChangeListener
    extends EventListener {
        public void capabilitiesFilterChanged(CapabilitiesFilterChangeEvent var1);
    }

    public static interface ExplorerPanel {
        public void setExplorer(Explorer var1);

        public Explorer getExplorer();

        public void setInstances(Instances var1);

        public String getTabTitle();

        public String getTabTitleToolTip();
    }

    public static interface LogHandler {
        public void setLog(Logger var1);
    }
}

