/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.Messages;

public class HostListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7182791134585882197L;
    protected RemoteExperiment m_Exp;
    protected JList m_List;
    protected JButton m_DeleteBut;
    protected JTextField m_HostField;

    public HostListPanel(RemoteExperiment exp) {
        this();
        this.setExperiment(exp);
    }

    public HostListPanel() {
        Messages.getInstance();
        this.m_DeleteBut = new JButton(Messages.getString("HostListPanel_DeleteBut_JButton_Text"));
        this.m_HostField = new JTextField(25);
        this.m_List = new JList();
        this.m_List.setModel(new DefaultListModel());
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_HostField.addActionListener(this);
        this.setLayout(new BorderLayout());
        Messages.getInstance();
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("HostListPanel_BorderFactoryCreateTitledBorder_Text")));
        JPanel topLab = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        topLab.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        topLab.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        topLab.add((Component)this.m_DeleteBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        topLab.add((Component)this.m_HostField, constraints);
        this.add((Component)topLab, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
    }

    public void setExperiment(RemoteExperiment exp) {
        this.m_Exp = exp;
        this.m_List.setModel(this.m_Exp.getRemoteHosts());
        if (((DefaultListModel)this.m_List.getModel()).size() > 0) {
            this.m_DeleteBut.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_HostField) {
            ((DefaultListModel)this.m_List.getModel()).addElement(this.m_HostField.getText());
            this.m_DeleteBut.setEnabled(true);
        } else if (e.getSource() == this.m_DeleteBut) {
            int[] selected = this.m_List.getSelectedIndices();
            if (selected != null) {
                int i = selected.length - 1;
                while (i >= 0) {
                    int current = selected[i];
                    ((DefaultListModel)this.m_List.getModel()).removeElementAt(current);
                    if (((DefaultListModel)this.m_List.getModel()).size() > current) {
                        this.m_List.setSelectedIndex(current);
                    } else {
                        this.m_List.setSelectedIndex(current - 1);
                    }
                    --i;
                }
            }
            if (((DefaultListModel)this.m_List.getModel()).size() == 0) {
                this.m_DeleteBut.setEnabled(false);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("HostListPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            HostListPanel dp = new HostListPanel();
            jf.getContentPane().add((Component)dp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

