/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class TrainTestSplitMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable {
    private static final long serialVersionUID = 7390064039444605943L;
    private double m_trainPercentage = 66.0;
    private int m_randomSeed = 1;
    private Thread m_splitThread = null;

    public TrainTestSplitMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TrainTestSplitMaker.gif", "weka/gui/beans/icons/TrainTestSplittMaker_animated.gif");
        this.m_visual.setText("TrainTestSplitMaker");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("TrainTestSplitMaker_GlobalInfo_Text");
    }

    public String trainPercentTipText() {
        Messages.getInstance();
        return Messages.getString("TrainTestSplitMaker_TrainPercentTipText_Text");
    }

    public void setTrainPercent(double newTrainPercent) {
        this.m_trainPercentage = newTrainPercent;
    }

    public double getTrainPercent() {
        return this.m_trainPercentage;
    }

    public String seedTipText() {
        Messages.getInstance();
        return Messages.getString("TrainTestSplitMaker_SeedTipText_Text");
    }

    public void setSeed(int newSeed) {
        this.m_randomSeed = newSeed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        if (this.m_splitThread == null) {
            final Instances dataSet = new Instances(e.getDataSet());
            this.m_splitThread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            dataSet.randomize(new Random(TrainTestSplitMaker.this.m_randomSeed));
                            int trainSize = (int)Math.round((double)dataSet.numInstances() * TrainTestSplitMaker.this.m_trainPercentage / 100.0);
                            int testSize = dataSet.numInstances() - trainSize;
                            Instances train = new Instances(dataSet, 0, trainSize);
                            Instances test = new Instances(dataSet, trainSize, testSize);
                            TrainingSetEvent tse = new TrainingSetEvent(TrainTestSplitMaker.this, train);
                            tse.m_setNumber = 1;
                            tse.m_maxSetNumber = 1;
                            if (TrainTestSplitMaker.this.m_splitThread != null) {
                                TrainTestSplitMaker.this.notifyTrainingSetProduced(tse);
                            }
                            TestSetEvent teste = new TestSetEvent(TrainTestSplitMaker.this, test);
                            teste.m_setNumber = 1;
                            teste.m_maxSetNumber = 1;
                            if (TrainTestSplitMaker.this.m_splitThread != null) {
                                TrainTestSplitMaker.this.notifyTestSetProduced(teste);
                            } else if (TrainTestSplitMaker.this.m_logger != null) {
                                Logger logger = TrainTestSplitMaker.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_First"))).append(TrainTestSplitMaker.this.statusMessagePrefix());
                                Messages.getInstance();
                                logger.logMessage(stringBuilder.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Second")).toString());
                                Logger logger2 = TrainTestSplitMaker.this.m_logger;
                                StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(TrainTestSplitMaker.this.statusMessagePrefix()));
                                Messages.getInstance();
                                logger2.statusMessage(stringBuilder2.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Third")).toString());
                            }
                        }
                        catch (Exception ex) {
                            this.stop();
                            if (TrainTestSplitMaker.this.m_logger != null) {
                                Logger logger = TrainTestSplitMaker.this.m_logger;
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(TrainTestSplitMaker.this.statusMessagePrefix()));
                                Messages.getInstance();
                                logger.statusMessage(stringBuilder.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Fourth")).toString());
                                Logger logger3 = TrainTestSplitMaker.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Fifth"))).append(TrainTestSplitMaker.this.statusMessagePrefix());
                                Messages.getInstance();
                                logger3.logMessage(stringBuilder3.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Sixth")).append(ex.getMessage()).toString());
                            }
                            ex.printStackTrace();
                            if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                                Logger logger = TrainTestSplitMaker.this.m_logger;
                                Messages.getInstance();
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Sixth_Alpha"))).append(TrainTestSplitMaker.this.statusMessagePrefix());
                                Messages.getInstance();
                                logger.logMessage(stringBuilder.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Seventh")).toString());
                                Logger logger4 = TrainTestSplitMaker.this.m_logger;
                                StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(TrainTestSplitMaker.this.statusMessagePrefix()));
                                Messages.getInstance();
                                logger4.statusMessage(stringBuilder4.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Eighth")).toString());
                            }
                            TrainTestSplitMaker.this.block(false);
                        }
                    }
                    finally {
                        if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                            Logger logger = TrainTestSplitMaker.this.m_logger;
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Sixth_Alpha"))).append(TrainTestSplitMaker.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger.logMessage(stringBuilder.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Seventh")).toString());
                            Logger logger5 = TrainTestSplitMaker.this.m_logger;
                            StringBuilder stringBuilder5 = new StringBuilder(String.valueOf(TrainTestSplitMaker.this.statusMessagePrefix()));
                            Messages.getInstance();
                            logger5.statusMessage(stringBuilder5.append(Messages.getString("TrainTestSplitMaker_AcceptDataSet_Run_LogMessage_Text_Eighth")).toString());
                        }
                        TrainTestSplitMaker.this.block(false);
                    }
                }
            };
            this.m_splitThread.setPriority(1);
            this.m_splitThread.start();
            this.block(true);
            this.m_splitThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_splitThread == null) break;
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            l = (Vector)this.m_trainingListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_splitThread == null) break;
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
                ++i;
            }
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_splitThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_splitThread != null) {
            Thread temp = this.m_splitThread;
            this.m_splitThread = null;
            temp.interrupt();
            temp.stop();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_splitThread != null;
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_splitThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(String.valueOf(request) + " not supported (TrainTestSplitMaker)");
        }
        this.stop();
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

