/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Vector;
import weka.gui.beans.AbstractTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;

public class TestSetMaker
extends AbstractTestSetProducer
implements DataSourceListener,
TrainingSetListener,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -8473882857628061841L;
    protected boolean m_receivedStopNotification = false;

    public TestSetMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TestSetMaker.gif", "weka/gui/beans/icons/TestSetMaker_animated.gif");
        this.m_visual.setText("TestSetMaker");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("TestSetMaker_GlobalInfo_Text");
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_receivedStopNotification = false;
        TestSetEvent tse = new TestSetEvent(this, e.getDataSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTestSetProduced(tse);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        this.m_receivedStopNotification = false;
        TestSetEvent tse = new TestSetEvent(this, e.getTrainingSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTestSetProduced(tse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        TestSetMaker testSetMaker = this;
        synchronized (testSetMaker) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                if (this.m_receivedStopNotification) {
                    if (this.m_logger != null) {
                        Messages.getInstance();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("TestSetMaker_NotifyTestSetProduced_LogMessage_Text_First"))).append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_logger.logMessage(stringBuilder.append(Messages.getString("TestSetMaker_NotifyTestSetProduced_LogMessage_Text_Second")).toString());
                        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                        Messages.getInstance();
                        this.m_logger.statusMessage(stringBuilder2.append(Messages.getString("TestSetMaker_NotifyTestSetProduced_LogMessage_Text_Third")).toString());
                    }
                    this.m_receivedStopNotification = false;
                    break;
                }
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
                ++i;
            }
        }
    }

    @Override
    public void stop() {
        this.m_receivedStopNotification = true;
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("dataSet");
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

