/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JPanel;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

public class PredictionAppender
extends JPanel
implements DataSource,
TrainingSetProducer,
TestSetProducer,
Visible,
BeanCommon,
EventConstraints,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
Serializable {
    private static final long serialVersionUID = -2987740065058976673L;
    protected Vector m_dataSourceListeners = new Vector();
    protected Vector m_instanceListeners = new Vector();
    protected Vector m_trainingSetListeners = new Vector();
    protected Vector m_testSetListeners = new Vector();
    protected Object m_listenee = null;
    protected Instances m_format;
    protected BeanVisual m_visual = new BeanVisual("PredictionAppender", "weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    protected boolean m_appendProbabilities;
    protected transient Logger m_logger;
    protected InstanceEvent m_instanceEvent;

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("PredictionAppender_GlobalInfo_Text");
    }

    public PredictionAppender() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String appendPredictedProbabilitiesTipText() {
        Messages.getInstance();
        return Messages.getString("PredictionAppender_AppendPredictedProbabilitiesTipText_Text");
    }

    public boolean getAppendPredictedProbabilities() {
        return this.m_appendProbabilities;
    }

    public void setAppendPredictedProbabilities(boolean ap) {
        this.m_appendProbabilities = ap;
    }

    @Override
    public void addTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingSetListeners.addElement(tsl);
        if (this.m_format != null) {
            TrainingSetEvent e = new TrainingSetEvent(this, this.m_format);
            tsl.acceptTrainingSet(e);
        }
    }

    @Override
    public void removeTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingSetListeners.removeElement(tsl);
    }

    @Override
    public void addTestSetListener(TestSetListener tsl) {
        this.m_testSetListeners.addElement(tsl);
        if (this.m_format != null) {
            TestSetEvent e = new TestSetEvent(this, this.m_format);
            tsl.acceptTestSet(e);
        }
    }

    @Override
    public void removeTestSetListener(TestSetListener tsl) {
        this.m_testSetListeners.removeElement(tsl);
    }

    @Override
    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataSourceListeners.addElement(dsl);
        if (this.m_format != null) {
            DataSetEvent e = new DataSetEvent(this, this.m_format);
            dsl.acceptDataSet(e);
        }
    }

    @Override
    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataSourceListeners.remove(dsl);
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.addElement(dsl);
        if (this.m_format != null) {
            InstanceEvent e = new InstanceEvent(this, this.m_format);
            dsl.acceptInstance(e);
        }
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    }

    @Override
    public void acceptClassifier(IncrementalClassifierEvent e) {
        Classifier classifier = e.getClassifier();
        Instance currentI = e.getCurrentInstance();
        int status = e.getStatus();
        int oldNumAtts = 0;
        oldNumAtts = status == 0 ? e.getStructure().numAttributes() : currentI.dataset().numAttributes();
        if (status == 0) {
            this.m_instanceEvent = new InstanceEvent(this, null, 0);
            Instances oldStructure = new Instances(e.getStructure(), 0);
            String relationNameModifier = "_with predictions";
            if (!this.m_appendProbabilities || oldStructure.classAttribute().isNumeric()) {
                try {
                    this.m_format = this.makeDataSetClass(oldStructure, classifier, relationNameModifier);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    this.m_format = this.makeDataSetProbabilities(oldStructure, classifier, relationNameModifier);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            this.m_instanceEvent.setStructure(this.m_format);
            this.notifyInstanceAvailable(this.m_instanceEvent);
            return;
        }
        double[] instanceVals = new double[this.m_format.numAttributes()];
        try {
            try {
                int i = 0;
                while (i < oldNumAtts) {
                    instanceVals[i] = currentI.value(i);
                    ++i;
                }
                if (!this.m_appendProbabilities || currentI.dataset().classAttribute().isNumeric()) {
                    double predClass;
                    instanceVals[instanceVals.length - 1] = predClass = classifier.classifyInstance(currentI);
                } else if (this.m_appendProbabilities) {
                    double[] preds = classifier.distributionForInstance(currentI);
                    int i2 = oldNumAtts;
                    while (i2 < instanceVals.length) {
                        instanceVals[i2] = preds[i2 - oldNumAtts];
                        ++i2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Instance newInst = new Instance(currentI.weight(), instanceVals);
                newInst.setDataset(this.m_format);
                this.m_instanceEvent.setInstance(newInst);
                this.m_instanceEvent.setStatus(status);
                this.notifyInstanceAvailable(this.m_instanceEvent);
                return;
            }
        }
        finally {
            Instance newInst = new Instance(currentI.weight(), instanceVals);
            newInst.setDataset(this.m_format);
            this.m_instanceEvent.setInstance(newInst);
            this.m_instanceEvent.setStatus(status);
            this.notifyInstanceAvailable(this.m_instanceEvent);
        }
        if (status == 2) {
            this.m_instanceEvent = null;
        }
    }

    @Override
    public void acceptClassifier(BatchClassifierEvent e) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (e.getTestSet() == null) {
                return;
            }
            Instances testSet = e.getTestSet().getDataSet();
            Instances trainSet = e.getTrainSet().getDataSet();
            int setNum = e.getSetNumber();
            int maxNum = e.getMaxSetNumber();
            Classifier classifier = e.getClassifier();
            String relationNameModifier = "_set_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber();
            if (!this.m_appendProbabilities || testSet.classAttribute().isNumeric()) {
                try {
                    EventObject tse;
                    Instances newTestSetInstances = this.makeDataSetClass(testSet, classifier, relationNameModifier);
                    Instances newTrainingSetInstances = this.makeDataSetClass(trainSet, classifier, relationNameModifier);
                    if (this.m_trainingSetListeners.size() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newTrainingSetInstances, 0));
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                        int i = 0;
                        while (i < trainSet.numInstances()) {
                            double predClass = classifier.classifyInstance(trainSet.instance(i));
                            newTrainingSetInstances.instance(i).setValue(newTrainingSetInstances.numAttributes() - 1, predClass);
                            ++i;
                        }
                        tse = new TrainingSetEvent(this, newTrainingSetInstances);
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        tse = new TestSetEvent(this, new Instances(newTestSetInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = setNum;
                        ((TestSetEvent)tse).m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newTestSetInstances, 0)));
                    }
                    if (e.getTestSet().isStructureOnly()) {
                        this.m_format = newTestSetInstances;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        int i = 0;
                        while (i < testSet.numInstances()) {
                            double predClass = classifier.classifyInstance(testSet.instance(i));
                            newTestSetInstances.instance(i).setValue(newTestSetInstances.numAttributes() - 1, predClass);
                            ++i;
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent tse2 = new TestSetEvent(this, newTestSetInstances);
                        tse2.m_setNumber = setNum;
                        tse2.m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable(tse2);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newTestSetInstances));
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    EventObject tse;
                    Instances newTestSetInstances = this.makeDataSetProbabilities(testSet, classifier, relationNameModifier);
                    Instances newTrainingSetInstances = this.makeDataSetProbabilities(trainSet, classifier, relationNameModifier);
                    if (this.m_trainingSetListeners.size() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newTrainingSetInstances, 0));
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                        int i = 0;
                        while (i < trainSet.numInstances()) {
                            double[] preds = classifier.distributionForInstance(trainSet.instance(i));
                            int j = 0;
                            while (j < trainSet.classAttribute().numValues()) {
                                newTrainingSetInstances.instance(i).setValue(trainSet.numAttributes() + j, preds[j]);
                                ++j;
                            }
                            ++i;
                        }
                        tse = new TrainingSetEvent(this, newTrainingSetInstances);
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        tse = new TestSetEvent(this, new Instances(newTestSetInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = setNum;
                        ((TestSetEvent)tse).m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newTestSetInstances, 0)));
                    }
                    if (e.getTestSet().isStructureOnly()) {
                        this.m_format = newTestSetInstances;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        int i = 0;
                        while (i < testSet.numInstances()) {
                            double[] preds = classifier.distributionForInstance(testSet.instance(i));
                            int j = 0;
                            while (j < testSet.classAttribute().numValues()) {
                                newTestSetInstances.instance(i).setValue(testSet.numAttributes() + j, preds[j]);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent tse3 = new TestSetEvent(this, newTestSetInstances);
                        tse3.m_setNumber = setNum;
                        tse3.m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable(tse3);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newTestSetInstances));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void acceptClusterer(BatchClustererEvent e) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (e.getTestSet().isStructureOnly()) {
                return;
            }
            Instances testSet = e.getTestSet().getDataSet();
            Clusterer clusterer = e.getClusterer();
            String test = e.getTestOrTrain() == 0 ? "test" : "training";
            String relationNameModifier = "_" + test + "_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber();
            if (!this.m_appendProbabilities || !(clusterer instanceof DensityBasedClusterer)) {
                if (this.m_appendProbabilities && !(clusterer instanceof DensityBasedClusterer)) {
                    Messages.getInstance();
                    System.err.println(Messages.getString("PredictionAppender_AcceptClusterer_Error_Text_First"));
                    if (this.m_logger != null) {
                        Messages.getInstance();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("PredictionAppender_AcceptClusterer_LogMessage_Text_First"))).append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_logger.logMessage(stringBuilder.append(Messages.getString("PredictionAppender_AcceptClusterer_LogMessage_Text_Second")).toString());
                        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                        Messages.getInstance();
                        this.m_logger.statusMessage(stringBuilder2.append(Messages.getString("PredictionAppender_AcceptClusterer_StatusMessage_Text_First")).toString());
                    }
                }
                try {
                    EventObject tse;
                    Instances newInstances = this.makeClusterDataSetClass(testSet, clusterer, relationNameModifier);
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newInstances, 0)));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && e.getTestOrTrain() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newInstances, 0));
                        tse.m_setNumber = e.getSetNumber();
                        tse.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0 && e.getTestOrTrain() == 0) {
                        tse = new TestSetEvent(this, new Instances(newInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = e.getSetNumber();
                        ((TestSetEvent)tse).m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    int i = 0;
                    while (i < testSet.numInstances()) {
                        double predCluster = clusterer.clusterInstance(testSet.instance(i));
                        newInstances.instance(i).setValue(newInstances.numAttributes() - 1, predCluster);
                        ++i;
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newInstances));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && e.getTestOrTrain() > 0) {
                        TrainingSetEvent tse2 = new TrainingSetEvent(this, newInstances);
                        tse2.m_setNumber = e.getSetNumber();
                        tse2.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTrainingSetAvailable(tse2);
                    }
                    if (this.m_testSetListeners.size() > 0 && e.getTestOrTrain() == 0) {
                        TestSetEvent tse3 = new TestSetEvent(this, newInstances);
                        tse3.m_setNumber = e.getSetNumber();
                        tse3.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTestSetAvailable(tse3);
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    Instances newInstances = this.makeClusterDataSetProbabilities(testSet, clusterer, relationNameModifier);
                    this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newInstances, 0)));
                    int i = 0;
                    while (i < testSet.numInstances()) {
                        double[] probs = clusterer.distributionForInstance(testSet.instance(i));
                        int j = 0;
                        while (j < clusterer.numberOfClusters()) {
                            newInstances.instance(i).setValue(testSet.numAttributes() + j, probs[j]);
                            ++j;
                        }
                        ++i;
                    }
                    this.notifyDataSetAvailable(new DataSetEvent(this, newInstances));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private Instances makeDataSetProbabilities(Instances format, Classifier classifier, String relationNameModifier) throws Exception {
        String classifierName = classifier.getClass().getName();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        int numOrigAtts = format.numAttributes();
        Instances newInstances = new Instances(format);
        int i = 0;
        while (i < format.classAttribute().numValues()) {
            Add addF = new Add();
            addF.setAttributeIndex("last");
            addF.setAttributeName(String.valueOf(classifierName) + "_prob_" + format.classAttribute().value(i));
            addF.setInputFormat(newInstances);
            newInstances = Filter.useFilter(newInstances, addF);
            ++i;
        }
        newInstances.setRelationName(String.valueOf(format.relationName()) + relationNameModifier);
        return newInstances;
    }

    private Instances makeDataSetClass(Instances format, Classifier classifier, String relationNameModifier) throws Exception {
        Add addF = new Add();
        addF.setAttributeIndex("last");
        String classifierName = classifier.getClass().getName();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        addF.setAttributeName("class_predicted_by: " + classifierName);
        if (format.classAttribute().isNominal()) {
            String classLabels = "";
            Enumeration enu = format.classAttribute().enumerateValues();
            classLabels = String.valueOf(classLabels) + (String)enu.nextElement();
            while (enu.hasMoreElements()) {
                classLabels = String.valueOf(classLabels) + "," + (String)enu.nextElement();
            }
            addF.setNominalLabels(classLabels);
        }
        addF.setInputFormat(format);
        Instances newInstances = Filter.useFilter(format, addF);
        newInstances.setRelationName(String.valueOf(format.relationName()) + relationNameModifier);
        return newInstances;
    }

    private Instances makeClusterDataSetProbabilities(Instances format, Clusterer clusterer, String relationNameModifier) throws Exception {
        int numOrigAtts = format.numAttributes();
        Instances newInstances = new Instances(format);
        int i = 0;
        while (i < clusterer.numberOfClusters()) {
            Add addF = new Add();
            addF.setAttributeIndex("last");
            addF.setAttributeName("prob_cluster" + i);
            addF.setInputFormat(newInstances);
            newInstances = Filter.useFilter(newInstances, addF);
            ++i;
        }
        newInstances.setRelationName(String.valueOf(format.relationName()) + relationNameModifier);
        return newInstances;
    }

    private Instances makeClusterDataSetClass(Instances format, Clusterer clusterer, String relationNameModifier) throws Exception {
        Add addF = new Add();
        addF.setAttributeIndex("last");
        String clustererName = clusterer.getClass().getName();
        clustererName = clustererName.substring(clustererName.lastIndexOf(46) + 1, clustererName.length());
        addF.setAttributeName("assigned_cluster: " + clustererName);
        String clusterLabels = "0";
        int i = 1;
        while (i <= clusterer.numberOfClusters() - 1) {
            clusterLabels = String.valueOf(clusterLabels) + "," + i;
            ++i;
        }
        addF.setNominalLabels(clusterLabels);
        addF.setInputFormat(format);
        Instances newInstances = Filter.useFilter(format, addF);
        newInstances.setRelationName(String.valueOf(format.relationName()) + relationNameModifier);
        return newInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceAvailable(InstanceEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((InstanceListener)l.elementAt(i)).acceptInstance(e);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetAvailable(DataSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_dataSourceListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(e);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetAvailable(TestSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_testSetListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((TestSetListener)l.elementAt(i)).acceptTestSet(e);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetAvailable(TrainingSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_trainingSetListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(e);
                ++i;
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (this.m_listenee == source) {
            this.m_listenee = null;
            this.m_format = null;
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            if (eventName.equals("instance") && !((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier")) {
                return false;
            }
            if (eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet")) {
                if (((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier")) {
                    return true;
                }
                return ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

